<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Detil_eksekusi extends CI_Controller {
	function index(){
		#prevent direct access to page
		#the user should only access the page through menu
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}
		$sec = $this->nativesession->get_flash_session('security');

		if($this->session->userdata('is_logged_in')===FALSE){
			redirect('login');
		}

		$perkara_id = $this->nativesession->get_flash_session('perkara_id');
		if(!is_numeric($perkara_id)){
			show_404();
		}

		$view = $this->nativesession->get_flash_session('view');
		if($view==TRUE){
			$this->show_data_detil($perkara_id);
		}else{
			$this->show_data($perkara_id);
		}
	}


	function show_data_detil($perkara_id){
		$this->load->model('perkara/new_eksekusi','eksekusi');
		$data = $this->parseData($this->eksekusi->get_detil_eksekusi($perkara_id));
		$data['pihak_eksekusi'] = $this->eksekusi->get_pihak_eksekusi($perkara_id);
		$data['idperkara']=base64_encode($this->encrypt->encode($perkara_id));
		$data['page_title'] = 'INFORMASI DETIL PERMOHONAN EKSEKUSI';
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['main_body'] = 'perkara/detil_eksekusi';
		$data['tgl_sekarang'] = date('d/m/Y');
		$this->load->vars($data);
		$this->load->view('perkara_tab/detil_eksekusi');
	}

	function show_data($perkara_id){
		$this->load->model('perkara/new_eksekusi','eksekusi');
		$data = $this->parseData($this->eksekusi->get_detil_eksekusi($perkara_id));
		$data['pihak_eksekusi'] = $this->eksekusi->get_pihak_eksekusi($perkara_id);
		$data['idperkara']=base64_encode($this->encrypt->encode($perkara_id));
		$data['page_title'] = 'INFORMASI DETIL PERMOHONAN EKSEKUSI';
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['main_body'] = 'perkara/detil_eksekusi';
		$data['main_history']=$this->nativesession->get('main_url_requested');
		

		$dataperkara = $this->eksekusi->getNomorPerkara($perkara_id);
		if($dataperkara->num_rows>0){ 
			$data['alur_perkara_id'] = $dataperkara->row()->alur_perkara_id;
		}
		$data['tgl_sekarang'] = date('d/m/Y');
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}


	function edit_eksekusi(){
		#prevent direct access to page
		#the user should only access the page through menu
		if($this->nativesession->get_flash_session('security')===FALSE){
			redirect('main');
		}
		$sec = $this->nativesession->get_flash_session('security');

		if($this->session->userdata('is_logged_in')===FALSE){
			redirect('login');
		}

		$perkara_id = $this->nativesession->get_flash_session('perkara_id');
		if(!is_numeric($perkara_id)){
			show_404();
		}
		$this->edit_data_eksekusi($perkara_id);
	}


	function edit_data_eksekusi($perkara_id){
		$this->load->model('perkara/new_eksekusi','eksekusi');
		$data = $this->parseData($this->eksekusi->get_detil_eksekusi($perkara_id));
		$data['pihak_eksekusi'] = $this->eksekusi->get_pihak_eksekusi($perkara_id);
		$data['jurusita']= $this->eksekusi->get_jurusita();
		$data['idperkara']=base64_encode($this->encrypt->encode($perkara_id));
		$data['alur_perkara_id']=$this->tanggalhelper->getIDAlurPerkara($perkara_id);
		$data['page_title'] = 'EDIT PERMOHONAN EKSEKUSI';
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['main_body'] = 'perkara/edit_eksekusi';
		$data['main_history']=$this->nativesession->get('main_url_requested');
		$data['previous']=$this->nativesession->get_flash_session('url_requested');
		$data['tgl_sekarang'] = date('d/m/Y');

		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '800px';
		$this->ckeditor->config['height'] = '200px';


		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}


	function edit_eksekusi_data_umum(){
		#prevent direct access to page
		#the user should only access the page through menu
		if($this->nativesession->is_flash_session('security')===FALSE){
			redirect('main');
		}
		$sec = $this->nativesession->get_flash_session('security');

		if($this->session->userdata('is_logged_in')===FALSE){
			redirect('login');
		}

		$perkara_id = $this->nativesession->get_flash_session('perkara_id');
		if(!is_numeric($perkara_id)){
			show_404();
		}
		$this->edit_data_umum_eks($perkara_id);
	}


	function edit_data_umum_eks($perkara_id){
		$this->load->model('perkara/new_eksekusi','eksekusi');
		$data = $this->parseData($this->eksekusi->get_detil_eksekusi($perkara_id));
		$data['pihak_eksekusi'] = $this->eksekusi->get_pihak_eksekusi($perkara_id);
		$data['jurusita']= $this->eksekusi->get_jurusita();
		$data['idperkara']=base64_encode($this->encrypt->encode($perkara_id));
		$data['parapenggugat']=$this->eksekusi->data_penggugat($perkara_id);
		$data['paratergugat']=$this->eksekusi->data_tergugat($perkara_id);

		$data['page_title'] = 'EDIT PERMOHONAN EKSEKUSI';
		$data['enc'] = $this->nativesession->get_flash_session('enc');

		$data['tgl_sekarang'] = date('d/m/Y');
		$data['main_history']=$this->nativesession->get('main_url_requested');
		$data['previous']=$this->nativesession->get_flash_session('url_requested');

		$datapemohon=$this->eksekusi->data_para_pemohon($perkara_id);
		$data['parapemohon']=$datapemohon->row()->para_pemohon;

		$dataperkara = $this->eksekusi->getNomorPerkara($perkara_id);
		if($dataperkara->num_rows>0){ 
			$data['nomor_perkara'] = $dataperkara->row()->nomor_perkara;
			$data['idalurperkara'] = base64_encode($this->encrypt->encode($dataperkara->row()->alur_perkara_id));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak ditemukan'));
			return;
		}

		$putusan_pn = $this->eksekusi->data_putusan_pn($perkara_id);
		if($putusan_pn->num_rows>0){
			$data['amar_pn'] = $putusan_pn->row()->amar_putusan;
			$data['tgl_putusan_pn'] = $this->tanggalhelper->convertToInputDate($putusan_pn->row()->tanggal_putusan);
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Perkara Belum Tersebut Putus'));
			return;
		}

		$putusan_banding = $this->eksekusi->data_banding($perkara_id);
		if($putusan_banding->num_rows>0){
			$data['nomor_perkara_banding'] = $putusan_banding->row()->nomor_perkara_banding;
			$data['tgl_putusan_banding'] = $this->tanggalhelper->convertToInputDate($putusan_banding->row()->putusan_banding);
			$data['amar_banding'] = $putusan_banding->row()->amar_putusan_banding;
		} else {
			$data['nomor_perkara_banding'] = "";
			$data['tgl_putusan_banding'] = "";
			$data['amar_banding']="";
		}
				
		$putusan_kasasi = $this->eksekusi->data_kasasi($perkara_id);
		if($putusan_kasasi->num_rows>0){
			$data['nomor_perkara_kasasi'] = $putusan_kasasi->row()->nomor_perkara_kasasi;
			$data['tgl_putusan_kasasi'] = $this->tanggalhelper->convertToInputDate($putusan_kasasi->row()->putusan_kasasi);
			$data['amar_kasasi'] = $putusan_kasasi->row()->amar_putusan_kasasi;
		} else {
			$data['nomor_perkara_kasasi'] = "";
			$data['tgl_putusan_kasasi']= "";
			$data['amar_kasasi']="";
		}


		$putusan_pk = $this->eksekusi->data_pk($perkara_id);
		if($putusan_pk->num_rows>0){
			$data['nomor_perkara_pk'] = $putusan_pk->row()->nomor_perkara_pk;
			$data['tgl_putusan_pk'] =$this->tanggalhelper->convertToInputDate($putusan_pk->row()->putusan_pk);
			$data['amar_pk'] = $putusan_pk->row()->amar_putusan_pk;
		} else {
			$data['nomor_perkara_pk'] = "";
			$data['tgl_putusan_pk'] = "";
			$data['amar_pk']="";
		}
		$data['main_body'] = 'perkara/edit_data_umum_eksekusi';
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}


	function validateInput(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$this->form_validation->set_rules('tgl_penetapan_teguran', 'Tanggal Penetapan Teguran', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('nomor_penetapan_teguran', 'Nomor Penetapan Teguran', 'trim|xss_clean');
		$this->form_validation->set_rules('tgl_pelaksanaan_teguran', 'Tanggal Pelaksanaan Teguran', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('tgl_penetapan_sita', 'Tanggal Penetapan Sita Eksekusi', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('nomor_penetapan_sita', 'Nomor Penetapan Sita Eksekusi', 'trim|xss_clean');
		$this->form_validation->set_rules('tgl_pelaksanaan_eksekusi', 'Tanggal Pelaksanaan Eksekusi', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('jurusita', 'Jurusita', 'trim|xss_clean');
		$this->form_validation->set_rules('tgl_penetapan_eksekusi_lelang', 'Tanggal Penetapan Eksekusi Lelang', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('tgl_pelaksanaan_eksekusi_lelang', 'Tanggal Pelaksanaan Eksekusi Lelang', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('tgl_penyerahan_hasil_lelang', 'Tanggal Penyerahan Hasil Lelang', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('tgl_penetapan_eksekusi_riil', 'Tanggal Penetapan Eksekusi Riil', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('tgl_pelaksanaan_eksekusi_riil', 'Tanggal Pelaksanaan Eksekusi Riil', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('tgl_penetapan_non_eksekusi', 'Tanggal Penetapan Non-Eksekusi', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('alasan_eksekusi_text', 'Alasan Eksekusi', 'trim|xss_clean|min_length[5]');
		$this->form_validation->set_rules('catatan_eksekusi', 'Keterangan', 'trim|xss_clean|min_length[5]');
		#TUN
		if($this->session->userdata('jenis_pengadilan')==3){
			$this->form_validation->set_rules('diterima_permohonan', 'Tanggal diterima permohonan', 'trim|xss_clean|required|exact_length[10]');	
			$this->form_validation->set_rules('panggilan_parapihak', 'Panggilan Para Pihak', 'trim|xss_clean|required|exact_length[10]');
			$this->form_validation->set_rules('penetapan_ketua', 'Penetapan Ketua', 'trim|xss_clean|required|exact_length[10]');
			$this->form_validation->set_rules('sk_objek_tidak_punya_kekuatan_hukum','Tanggal Surat Ketua Bahwa Objek Sengketa Tidak Mempunyai Kekuatan Hukum Lagi' , 'trim|xss_clean|required|exact_length[10]');
		}				
		$this->form_validation->set_rules('surat_tergugat_objek_non_executable','' , 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('panggilan_pihak_non_executable', '', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('upaya_kesepakatan_kompensasi', '', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('penetapan_ketua_kompensasi', '', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('upaya_hukum_kma', '', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('penetapan_kma_kompensasi', '', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('uangpaksa_putusan_hakim', '', 'trim|xss_clean');
		$this->form_validation->set_rules('uangpaksa_penetapan_ketua', '', 'trim|xss_clean');
		$this->form_validation->set_rules('surat_ketua_tergugat_uangpaksa', '', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('surat_peringatan_uangpaksa', '', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('perintah_ketua_saksi_administratif', '', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('sanksi_administratif_dari_pejabat', '', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('pengumuman_ketua_panitera_js', '', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('pengumuman_media', '', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('surat_presiden', '', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('surat_lembaga_perwakilan_rakyat', '', 'trim|xss_clean|exact_length[10]');
		#END TUN#

		$d_jurusita=$this->input->post('jurusita',TRUE);
		
		if($d_jurusita!=''){
			$p_jurusita=explode(';',$d_jurusita);
			$id_jurusita=$p_jurusita[0];
			$nama_jurusita=$p_jurusita[1];
		}else{
			$id_jurusita='';
			$nama_jurusita='';
		}

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('idperkara',TRUE)));
			
			$alasan_eksekusi = trim($this->input->post('alasan_eksekusi_text',TRUE));
			$alasan_eksekusi = str_replace("&nbsp;", " ", $alasan_eksekusi);
			if(!is_numeric($idperkara)){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Perkara Tidak ditemukan. Code Error = 194.'));
				return;
			}else{

				$this->load->model('perkara/new_eksekusi','eksekusi');
				$curr_date = date('Y-m-d');
				$todayDate = date('m/d/Y');

				$tgl_permohonan_eksekusi = $this->input->post('tgl_permohonan_eksekusi',TRUE);
				
				$tgl_penetapan_teguran = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_penetapan_teguran',TRUE));
				$tgl_pelaksanaan_teguran = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pelaksanaan_teguran',TRUE));						
				$tgl_penetapan_sita = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_penetapan_sita',TRUE));						
				$tgl_pelaksanaan_sita = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pelaksanaan_eksekusi',TRUE));					
				$tgl_penetapan_eksekusi_lelang = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_penetapan_eksekusi_lelang',TRUE));						
				$tgl_pelaksanaan_eksekusi_lelang = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pelaksanaan_eksekusi_lelang',TRUE));						
				$tgl_penyerahan_hasil_lelang = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_penyerahan_hasil_lelang',TRUE));						
				$tgl_penetapan_eksekusi_riil = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pelaksanaan_eksekusi_riil',TRUE));						
				$tgl_pelaksanaan_eksekusi_riil = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pelaksanaan_eksekusi_riil',TRUE));						
				$tgl_penetapan_non_eksekusi = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_penetapan_non_eksekusi',TRUE));						
				#TUN

				$diterima_permohonan = $this->input->post('diterima_permohonan',TRUE);
				$panggilan_parapihak = $this->input->post('panggilan_parapihak',TRUE);
				$penetapan_ketua = $this->input->post('penetapan_ketua',TRUE);
				$sk_objek_tidak_punya_kekuatan_hukum = $this->input->post('sk_objek_tidak_punya_kekuatan_hukum',TRUE);
				$surat_tergugat_objek_non_executable = $this->input->post('surat_tergugat_objek_non_executable',TRUE);
				$panggilan_pihak_non_executable = $this->input->post('panggilan_pihak_non_executable',TRUE);
				$upaya_kesepakatan_kompensasi = $this->input->post('upaya_kesepakatan_kompensasi',TRUE);
				$penetapan_ketua_kompensasi = $this->input->post('penetapan_ketua_kompensasi',TRUE);
				$upaya_hukum_kma = $this->input->post('upaya_hukum_kma',TRUE);
				$penetapan_kma_kompensasi = $this->input->post('penetapan_kma_kompensasi',TRUE);
				$uangpaksa_putusan_hakim = $this->input->post('uangpaksa_putusan_hakim',TRUE);
				$uangpaksa_penetapan_ketua = $this->input->post('uangpaksa_penetapan_ketua',TRUE);
				$surat_ketua_tergugat_uangpaksa = $this->input->post('surat_ketua_tergugat_uangpaksa',TRUE);
				$surat_peringatan_uangpaksa = $this->input->post('surat_peringatan_uangpaksa',TRUE);
				$perintah_ketua_saksi_administratif = $this->input->post('perintah_ketua_saksi_administratif',TRUE);
				$sanksi_administratif_dari_pejabat = $this->input->post('sanksi_administratif_dari_pejabat',TRUE);
				$pengumuman_ketua_panitera_js = $this->input->post('pengumuman_ketua_panitera_js',TRUE);
				$pengumuman_media = $this->input->post('pengumuman_media',TRUE);
				$surat_presiden = $this->input->post('surat_presiden',TRUE);
				$surat_lembaga_perwakilan_rakyat = $this->input->post('surat_lembaga_perwakilan_rakyat',TRUE);
				$catatan_eksekusi = $this->input->post('catatan_eksekusi',TRUE);


				if(!empty($diterima_permohonan)){ 
					$dataTUN['diterima_permohonan'] = $this->tanggalhelper->convertToMysqlDate($diterima_permohonan); 
				}
				if(!empty($panggilan_parapihak)){ 
					$dataTUN['panggilan_parapihak'] = $this->tanggalhelper->convertToMysqlDate($panggilan_parapihak); 
				}
				if(!empty($penetapan_ketua)){ 
					$dataTUN['penetapan_ketua'] = $this->tanggalhelper->convertToMysqlDate($penetapan_ketua); 
				}
				if(!empty($sk_objek_tidak_punya_kekuatan_hukum)){ 
					$dataTUN['sk_objek_tidak_punya_kekuatan_hukum'] = $this->tanggalhelper->convertToMysqlDate($sk_objek_tidak_punya_kekuatan_hukum); 
				}
				if(!empty($surat_tergugat_objek_non_executable)){ 
					$dataTUN['surat_tergugat_objek_non_executable'] = $this->tanggalhelper->convertToMysqlDate($surat_tergugat_objek_non_executable); 
				}
				if(!empty($panggilan_pihak_non_executable)){ 
					$dataTUN['panggilan_pihak_non_executable'] = $this->tanggalhelper->convertToMysqlDate($panggilan_pihak_non_executable); 
				}
				if(!empty($upaya_kesepakatan_kompensasi)){ 
					$dataTUN['upaya_kesepakatan_kompensasi'] = $this->tanggalhelper->convertToMysqlDate($upaya_kesepakatan_kompensasi); 
				}
				if(!empty($penetapan_ketua_kompensasi)){ 
					$dataTUN['penetapan_ketua_kompensasi'] = $this->tanggalhelper->convertToMysqlDate($penetapan_ketua_kompensasi); 
				}
				if(!empty($upaya_hukum_kma)){ 
					$dataTUN['upaya_hukum_kma'] = $this->tanggalhelper->convertToMysqlDate($upaya_hukum_kma); 
				}
				if(!empty($penetapan_kma_kompensasi)){ 
					$dataTUN['penetapan_kma_kompensasi'] = $this->tanggalhelper->convertToMysqlDate($penetapan_kma_kompensasi); 
				}
				if(!empty($surat_ketua_tergugat_uangpaksa)){ 
					$dataTUN['surat_ketua_tergugat_uangpaksa'] = $this->tanggalhelper->convertToMysqlDate($surat_ketua_tergugat_uangpaksa); 
				}
				if(!empty($surat_peringatan_uangpaksa)){ 
					$dataTUN['surat_peringatan_uangpaksa'] = $this->tanggalhelper->convertToMysqlDate($surat_peringatan_uangpaksa); 
				}
				if(!empty($perintah_ketua_saksi_administratif)){ 
					$dataTUN['perintah_ketua_saksi_administratif'] = $this->tanggalhelper->convertToMysqlDate($perintah_ketua_saksi_administratif); 
				}
				if(!empty($sanksi_administratif_dari_pejabat)){ 
					$dataTUN['sanksi_administratif_dari_pejabat'] = $this->tanggalhelper->convertToMysqlDate($sanksi_administratif_dari_pejabat); 
				}
				if(!empty($pengumuman_ketua_panitera_js)){ 
					$dataTUN['pengumuman_ketua_panitera_js'] = $this->tanggalhelper->convertToMysqlDate($pengumuman_ketua_panitera_js); 
				}
				if(!empty($pengumuman_media)){ 
					$dataTUN['pengumuman_media'] = $this->tanggalhelper->convertToMysqlDate($pengumuman_media); 
				}
				if(!empty($surat_presiden)){ 
					$dataTUN['surat_presiden'] = $this->tanggalhelper->convertToMysqlDate($surat_presiden); 
				}
				if(!empty($surat_lembaga_perwakilan_rakyat)){ 
					$dataTUN['surat_lembaga_perwakilan_rakyat'] = $this->tanggalhelper->convertToMysqlDate($surat_lembaga_perwakilan_rakyat); 
				}
				if(!empty($uangpaksa_putusan_hakim)){ 
					$dataTUN['uangpaksa_putusan_hakim'] = $uangpaksa_putusan_hakim; 
				}
				if(!empty($uangpaksa_penetapan_ketua)){ 
					$dataTUN['uangpaksa_penetapan_ketua'] = $uangpaksa_penetapan_ketua; 
				}
				if(!empty($catatan_eksekusi)){ 
					$dataTUN['catatan_eksekusi'] = $catatan_eksekusi; 
				}
				
			
				#END TUN#


				$selisih1 = $this->tanggalhelper->getSelisihHari($tgl_penetapan_teguran,$curr_date);
				$selisih2 = $this->tanggalhelper->getSelisihHari($tgl_pelaksanaan_teguran,$curr_date);				
				$selisih3 = $this->tanggalhelper->getSelisihHari($tgl_penetapan_sita,$curr_date);				
				$selisih4 = $this->tanggalhelper->getSelisihHari($tgl_pelaksanaan_sita,$curr_date);				
				$selisih5 = $this->tanggalhelper->getSelisihHari($tgl_penetapan_eksekusi_lelang,$curr_date);				
				$selisih6 = $this->tanggalhelper->getSelisihHari($tgl_pelaksanaan_eksekusi_lelang,$curr_date);				
				$selisih7 = $this->tanggalhelper->getSelisihHari($tgl_penyerahan_hasil_lelang,$curr_date);				
				$selisih8 = $this->tanggalhelper->getSelisihHari($tgl_penetapan_eksekusi_riil,$curr_date);				
				$selisih9 = $this->tanggalhelper->getSelisihHari($tgl_pelaksanaan_eksekusi_riil,$curr_date);				
				$selisih10 = $this->tanggalhelper->getSelisihHari($tgl_penetapan_non_eksekusi,$curr_date);				

				$selisih_1 = $this->tanggalhelper->getSelisihHari($tgl_permohonan_eksekusi,$tgl_penetapan_teguran);
				$selisih_2 = $this->tanggalhelper->getSelisihHari($tgl_permohonan_eksekusi,$tgl_pelaksanaan_teguran);				
				$selisih_3 = $this->tanggalhelper->getSelisihHari($tgl_permohonan_eksekusi,$tgl_penetapan_sita);				
				$selisih_4 = $this->tanggalhelper->getSelisihHari($tgl_permohonan_eksekusi,$tgl_pelaksanaan_sita);				
				$selisih_5 = $this->tanggalhelper->getSelisihHari($tgl_permohonan_eksekusi,$tgl_penetapan_eksekusi_lelang);				
				$selisih_6 = $this->tanggalhelper->getSelisihHari($tgl_permohonan_eksekusi,$tgl_pelaksanaan_eksekusi_lelang);				
				$selisih_7 = $this->tanggalhelper->getSelisihHari($tgl_permohonan_eksekusi,$tgl_penyerahan_hasil_lelang);				
				$selisih_8 = $this->tanggalhelper->getSelisihHari($tgl_permohonan_eksekusi,$tgl_penetapan_eksekusi_riil);				
				$selisih_9 = $this->tanggalhelper->getSelisihHari($tgl_permohonan_eksekusi,$tgl_pelaksanaan_eksekusi_riil);				
				$selisih_10 = $this->tanggalhelper->getSelisihHari($tgl_permohonan_eksekusi,$tgl_penetapan_non_eksekusi);				


				if($tgl_penetapan_teguran!=''){
					if($selisih1<0 || $selisih_1<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Cek Tanggal Penetapan Teguran, tidak boleh lebih dari hari ini atau kurang dari permohonan eksekusi'));
						return;
					}
				}

				if($tgl_pelaksanaan_teguran!=''){
					if($selisih2<0 || $selisih_2<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Cek Tanggal Pelaksanaan Teguran, tidak boleh lebih dari hari ini atau kurang dari permohonan eksekusi'));
						return;
					}
				}
				
				if($tgl_penetapan_sita!=''){
					if($selisih3<0 || $selisih_3<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Cek Tanggal Penetapan Sita, tidak boleh lebih dari hari ini atau kurang dari permohonan eksekusi'));
						return;
					}
				}

				if($tgl_pelaksanaan_sita!=''){
					if($selisih4<0 || $selisih_4<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Cek Tanggal Pelaksanaan Eksekusi, tidak boleh lebih dari hari ini atau kurang dari permohonan eksekusi'));
						return;
					}
				}

				if($tgl_penetapan_eksekusi_lelang!=''){
					if($selisih5<0 || $selisih_5<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Cek Tanggal Penetapan Perintah Eksekusi Lelang, tidak boleh lebih dari hari ini atau kurang dari permohonan eksekusi'));
						return;
					}
				}

				if($tgl_pelaksanaan_eksekusi_lelang!=''){
					if($selisih6<0 || $selisih_6<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Cek Tanggal Pelaksanaan Eksekusi Lelang, tidak boleh lebih dari hari ini atau kurang dari permohonan eksekusi'));
						return;
					}
				}

				if($tgl_penyerahan_hasil_lelang!=''){
					if($selisih7<0 || $selisih_7<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Cek Tanggal Penyerahan Hasil Lelang, tidak boleh lebih dari hari ini atau kurang dari permohonan eksekusi'));
						return;
					}
				}

				if($tgl_penetapan_eksekusi_riil!=''){
					if($selisih8<0 || $selisih_8<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Cek Tanggal Penetapan Perintah Eksekusi Riil, tidak boleh lebih dari hari ini atau kurang dari permohonan eksekusi'));
						return;
					}
				}

				if($tgl_pelaksanaan_eksekusi_riil!=''){
					if($selisih9<0 || $selisih_9<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Cek Tanggal Pelaksanaan Eksekusi Riil, tidak boleh lebih dari hari ini atau kurang dari permohonan eksekusi'));
						return;
					}
				}

				if($tgl_penetapan_non_eksekusi!=''){
					if($selisih10<0 || $selisih_10<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Cek Tanggal Penetapan Non-Eksekusi, tidak boleh lebih dari hari ini atau kurang dari permohonan eksekusi'));
						return;
					}
				}

				/*
				$dataTUN = array(
						'diperbaharui_oleh' => $this->session->userdata('username'),
						'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);
	*/

				$data = array(
						'penetapan_teguran_eksekusi' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_penetapan_teguran',TRUE)),
						'nomor_penetapan_teguran_eksekusi' => $this->input->post('nomor_penetapan_teguran',TRUE),
						'pelaksanaan_teguran_eksekusi' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pelaksanaan_teguran',TRUE)),						
						'penetapan_sita_eksekusi' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_penetapan_sita',TRUE)),						
						'nomor_penetapan_sita_eksekusi' => $this->input->post('nomor_penetapan_sita',TRUE),
						'pelaksanaan_sita_eksekusi' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pelaksanaan_eksekusi',TRUE)),						
						'jurusita_id' => $id_jurusita,
						'jurusita_nama' => $nama_jurusita,
						'penetapan_perintah_eksekusi_lelang' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_penetapan_eksekusi_lelang',TRUE)),						
						'pelaksanaan_eksekusi_lelang' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pelaksanaan_eksekusi_lelang',TRUE)),						
						'penyerahan_hasil_lelang' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_penyerahan_hasil_lelang',TRUE)),						
						'penetapan_perintah_eksekusi_rill' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_penetapan_eksekusi_riil',TRUE)),						
						'pelaksanaan_eksekusi_rill' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pelaksanaan_eksekusi_riil',TRUE)),						
						'penetapan_noneksekusi' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_penetapan_non_eksekusi',TRUE)),						
						'alasan_eksekusi' => $alasan_eksekusi,
						'catatan_eksekusi' => $this->input->post('catatan_eksekusi',TRUE),
						'diinput_oleh' => $this->session->userdata('username'),
						'diinput_tanggal' => date("Y-m-d h:i:s",time())
					);

				if($this->session->userdata('jenis_pengadilan')==3){
					$result = $this->eksekusi->edit_perkara_eksekusi($dataTUN,$idperkara);
					if($result===FALSE){
						echo json_encode(array('st'=>0,'msg'=>'GAGAL Menyimpan'));
						return;
					}
					echo json_encode(array('st'=>1,'msg'=>'Berhasil Disimpan'));
					return;
				} else {
					$result = $this->eksekusi->edit_perkara_eksekusi($data,$idperkara);
					if($result===FALSE){
						echo json_encode(array('st'=>0,'msg'=>'GAGAL Menyimpan'));
						return;
					}
					echo json_encode(array('st'=>1,'msg'=>'Berhasil Disimpan'));
					return;
				}
				
			}
		}
	}


	function parseData($info_perkara_eksekusi){
		if($info_perkara_eksekusi!=''){
			if($info_perkara_eksekusi->num_rows>0){
				foreach ($info_perkara_eksekusi->result() as $row) {
					$data['nomor_perkara_pn'] = $row->nomor_perkara_pn;
					$data['putusan_pn'] = $this->tanggalhelper->convertDayDate($row->putusan_pn);
					$data['nomor_perkara_banding'] = $row->nomor_perkara_banding;
					$data['putusan_banding'] = $this->tanggalhelper->convertDayDate($row->putusan_banding);
					$data['nomor_perkara_kasasi'] = $row->nomor_perkara_kasasi;
					$data['putusan_kasasi'] = $this->tanggalhelper->convertDayDate($row->putusan_kasasi);
					$data['nomor_perkara_pk'] = $row->nomor_perkara_pk;
					$data['putusan_pk'] = $this->tanggalhelper->convertDayDate($row->putusan_pk);
					$data['tgl_permohonan_eksekusi'] = $row->permohonan_eksekusi;
					$data['pemohon_id'] = $row->pemohon_id;
					$data['pemohon_eksekusi'] = $row->pemohon_eksekusi;
					$data['pekerjaan'] = $row->pekerjaan_pemohon;
					$data['alamat'] = $row->alamat_pemohon;
					$data['tgl_surat_kuasa'] = $row->tanggal_surat_kuasa;
					$data['nomor_surat_kuasa'] = $row->nomor_surat_kuasa;
					$data['pihak_yg_dimohonkan'] = $row->pihak_dimohonkan;
					$data['eksekusi_putusan_id'] = $row->eksekusi_putusan_id;
					$data['nomor_register_eksekusi'] = $row->nomor_register_eksekusi;
					$data['eksekusi_nomor_perkara'] = $row->eksekusi_nomor_perkara;
					$data['eksekusi_amar_putusan'] = $row->eksekusi_amar_putusan;
					$data['penetapan_teguran_eksekusi'] = $row->penetapan_teguran_eksekusi;
					$data['nomor_penetapan_teguran_eksekusi'] = $row->nomor_penetapan_teguran_eksekusi;
					$data['pelaksanaan_teguran_eksekusi'] = $row->pelaksanaan_teguran_eksekusi;
					$data['penetapan_sita_eksekusi'] = $row->penetapan_sita_eksekusi;
					$data['nomor_penetapan_sita_eksekusi'] = $row->nomor_penetapan_sita_eksekusi;
					$data['pelaksanaan_sita_eksekusi'] = $row->pelaksanaan_sita_eksekusi;
					$data['jurusita_id'] = $row->jurusita_id;
					$data['jurusita_nama'] = $row->jurusita_nama;
					$data['penetapan_perintah_eksekusi_lelang'] = $row->penetapan_perintah_eksekusi_lelang;
					$data['pelaksanaan_eksekusi_lelang'] = $row->pelaksanaan_eksekusi_lelang;
					$data['penyerahan_hasil_lelang'] = $row->penyerahan_hasil_lelang;
					$data['penetapan_perintah_eksekusi_rill'] = $row->penetapan_perintah_eksekusi_rill;
					$data['pelaksanaan_eksekusi_rill'] = $row->pelaksanaan_eksekusi_rill;
					$data['penetapan_noneksekusi'] = $row->penetapan_noneksekusi;
					$data['alasan_eksekusi'] = $row->alasan_eksekusi;

					$data['diterima_permohonan'] = $row->diterima_permohonan;
					$data['panggilan_parapihak'] = $row->panggilan_parapihak;
					$data['penetapan_ketua'] = $row->penetapan_ketua;
					$data['sk_objek_tidak_punya_kekuatan_hukum'] = $row->sk_objek_tidak_punya_kekuatan_hukum;
					$data['surat_tergugat_objek_non_executable'] = $row->surat_tergugat_objek_non_executable;
					$data['panggilan_pihak_non_executable'] = $row->panggilan_pihak_non_executable;
					$data['upaya_kesepakatan_kompensasi'] = $row->upaya_kesepakatan_kompensasi;
					$data['penetapan_ketua_kompensasi'] = $row->penetapan_ketua_kompensasi;
					$data['upaya_hukum_kma'] = $row->upaya_hukum_kma;
					$data['penetapan_kma_kompensasi'] = $row->penetapan_kma_kompensasi;
					$data['uangpaksa_putusan_hakim'] = $row->uangpaksa_putusan_hakim;
					$data['uangpaksa_penetapan_ketua'] = $row->uangpaksa_penetapan_ketua;
					$data['surat_ketua_tergugat_uangpaksa'] = $row->surat_ketua_tergugat_uangpaksa;
					$data['surat_peringatan_uangpaksa'] = $row->surat_peringatan_uangpaksa;
					$data['perintah_ketua_saksi_administratif'] = $row->perintah_ketua_saksi_administratif;
					$data['sanksi_administratif_dari_pejabat'] = $row->sanksi_administratif_dari_pejabat;
					$data['pengumuman_ketua_panitera_js'] = $row->pengumuman_ketua_panitera_js;
					$data['pengumuman_media'] = $row->pengumuman_media;
					$data['surat_presiden'] = $row->surat_presiden;
					$data['surat_lembaga_perwakilan_rakyat'] = $row->surat_lembaga_perwakilan_rakyat;
					$data['catatan_eksekusi'] = $row->catatan_eksekusi;
				}
				return $data;
			}
		}
		
	}

	function confirmationhapusperkara(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$data['enc'] = $segment[2];
		$idperkara = $this->encrypt->decode(base64_decode($segment[2]));
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}

		$this->load->vars($data);
		$this->load->view('perkara/hapus_perkara_eksekusi');
	}

	function del_perkara_eksekusi(){
		try {
			if(empty($_POST)){
				show_404();
			}

			if($this->session->userdata('is_logged_in')==FALSE){
				echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
				return;
			}

			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			if(!is_numeric($idperkara) OR intval($idperkara)<1){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
				return;
			}
			$this->load->model('perkara/new_eksekusi','eksekusi');
			$result = $this->eksekusi->hapus_perkara_eks($idperkara);
			if($result){
				$this->eksekusi->deletePerkaraProses($idperkara,600);
			}
			
			if($result==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DIHAPUS.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN DISIMPAN.'));
				return;
			}
		} catch (Exception $e) {
			
		}
	}

}