<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class jadwal_sidang_m extends CI_Model{
	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}

	function add_audittrail($action,$title,$descrip,$tablename){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => 'Add Pihak',
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
		}
	}

	function get_data_jadwal($perkara_id){
		try {
			$qry="SELECT a.alur_perkara_id, b.* 
					FROM perkara AS a, perkara_jadwal_sidang AS b 
					WHERE b.perkara_id=$perkara_id and b.perkara_id=a.perkara_id ORDER BY tanggal_sidang ASC";
			$query=$this->db->query($qry);
			return $query->result();
		} 
			catch (Exception $e) {
			log_message('error', $e);
		}
	}
	#10-12-2016 V315
	function getInfoMediasi($perkara_id){
		try {
			$this->db->where('perkara_id',$perkara_id);
			$this->db->select('perkara_id');
			$this->db->from('perkara_mediasi');
			return $this->db->get()->num_rows()>0;
		} catch (Exception $e) {
			return '';
		}
	}

	function get_detil_jadwal($jadwal_id){
		if(empty($jadwal_id)) {
			return '';
		}
		try {
			$this->db->where('id',$jadwal_id);
			$query=$this->db->get('perkara_jadwal_sidang');
			return $query->result();
		}catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_ruangan_sidang(){
		$this->db->where('aktif','y');
		$query=$this->db->get('ruangan_sidang');
		return $query->result();
	}

	function update_jadwal_sidang($id_jadwal,$data_diupdate,$idperkara){
		try {
			$this->db->where('id',$id_jadwal);
			$this->db->update('perkara_jadwal_sidang',$data_diupdate);

			#update status perkara
			$cekproses = $this->db->query("SELECT tahapan_id,tahapan_nama,proses_id,proses_nama FROM perkara_proses WHERE perkara_id = ".$idperkara." ORDER BY proses_id DESC LIMIT 1 ;");			
			if($cekproses->num_rows>0){
				foreach ($cekproses->result() as $row) {					
					$update_status['tahapan_terakhir_id']	=$row->tahapan_id;
					$update_status['tahapan_terakhir_text']	=$row->tahapan_nama;
					$update_status['proses_terakhir_id']	=$row->proses_id;
					$update_status['proses_terakhir_text']	=$row->proses_nama;
				}				
				$this->db->where('perkara_id',$idperkara);
				$this->db->update('perkara',$update_status);
			}		

			$title = "UPDATE Jadwal Sidang <br /> UPDATE table <b>perkara_jadwal_sidang</b> dari halaman <b>EDIT JADWAL SIDANG</b> dengan Primary Key [id=".$id_jadwal."]";
			$descrip = $this->fetch_description($title,$data_diupdate);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_jadwal_sidang');

			return TRUE;
		}catch (Exception $e) {
			return FALSE;
		}
	}		

	function get_id_jadwal_terakhir_all(){
		$query = $this->db->query('SELECT IFNULL(MAX(id)+1,1) AS nextid FROM perkara_jadwal_sidang');
		return $query->row()->nextid;
	}

	function get_urutan_jadwal_terakhir($id_perkara){
		$this->db->select_max('urutan');
		$this->db->where('perkara_id',$id_perkara);
		$result=$this->db->get('perkara_jadwal_sidang');
		return $result;
	}

	function get_id_jadwal_terakhir_satu_perkara($id_perkara){
		$this->db->select_max('id','idjadwalsidang','urutan');
		$this->db->where('perkara_id',$id_perkara);
		$result=$this->db->get('perkara_jadwal_sidang')->row();
		return $result->idjadwalsidang;
	}

	function tunda_sidang($datainsert,$dataupdate,$id){
		try {
			$this->db->where('id',$id);
			$this->db->update('perkara_jadwal_sidang',$dataupdate);

			$title = "UPDATE Jadwal Sidang <br /> UPDATE table <b>perkara_jadwal_sidang</b> dari halaman <b>PENUNDAAN JADWAL SIDANG</b> dengan Primary Key [id=".$id."]";
			$descrip = $this->fetch_description($title,$dataupdate);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_jadwal_sidang');

			$nextid=$this->get_id_jadwal_terakhir_all();
			$datainsert['id']=$nextid;
			$this->db->insert('perkara_jadwal_sidang', $datainsert);

			$title = "INSERT Jadwal Sidang <br /> INSERT table <b>perkara_jadwal_sidang</b> dari halaman <b>PENUNDAAN JADWAL SIDANG</b> dengan Primary Key [id=".$datainsert['id']."]";
			$descrip = $this->fetch_description($title,$datainsert);
			$this->add_audittrail("INSERT",$title,$descrip,'perkara_jadwal_sidang');
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}
	
	function hapus_jadwal_sidang($id_jadwal_sidang){
		try {
			$this->db->where('id',$id_jadwal_sidang);
			$this->db->delete('perkara_jadwal_sidang');

			$title = "DELETE Jadwal Sidang <br /> DELETE table <b>perkara_jadwal_sidang</b> dari halaman <b>EDIT JADWAL SIDANG</b> dengan Primary Key [id=".$id_jadwal_sidang."]";
			$descrip = '';
			$this->add_audittrail("DELETE",$title,$descrip,'perkara_jadwal_sidang');
			
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function cari_jadwal_sidang_terakhir($perkara_id){
		$qry="SELECT * 
				FROM perkara_jadwal_sidang 
				WHERE tanggal_sidang = (SELECT MAX(tanggal_sidang) FROM perkara_jadwal_sidang WHERE perkara_id = $perkara_id) 
				AND perkara_id = $perkara_id;";
		$query=$this->db->query($qry);
		return $query;
	}

	function cek_apakah_verzet($idperkara){
		$qry="SELECT COUNT(*) AS jumlahdata FROM perkara_verzet WHERE perkara_id='$idperkara';";
		$hasil=$this->db->query($qry)->row()->jumlahdata;
		return $hasil;
	}

	function cek_jumlah_sidang_verzet($idperkara){
		$qry="SELECT COUNT(*) AS jumlahdata FROM perkara_jadwal_sidang WHERE perkara_id='$idperkara' AND verzet='Y';";
		$hasil=$this->db->query($qry)->row()->jumlahdata;
		return $hasil;
	}

	function cek_apakah_keberatan($idperkara){
		$qry="SELECT COUNT(*) AS jumlahdata FROM perkara_keberatan WHERE perkara_id='$idperkara';";
		$hasil=$this->db->query($qry)->row()->jumlahdata;
		return $hasil;
	}

	function cek_apakah_ikrar_talak($idperkara){
		$qry="SELECT COUNT(*) AS jumlahdata FROM perkara_ikrar_talak WHERE perkara_id='$idperkara';";
		$hasil=$this->db->query($qry)->row()->jumlahdata;
		return $hasil;
	}
	
	function cek_status_verzet_jadwalsidang_terakhir($idperkara){
		$qry="SELECT verzet FROM perkara_jadwal_sidang WHERE perkara_id='$idperkara' ORDER BY id DESC;";
		$hasil=$this->db->query($qry)->row()->verzet;
		return $hasil;
	}

	function get_jadwal_sidang_sebelum($idperkara){
		try {
			$qry="SELECT tanggal_sidang FROM perkara_jadwal_sidang 
					WHERE perkara_id='$idperkara' AND urutan=(SELECT MAX(IF(urutan=0,1,urutan))-1 FROM perkara_jadwal_sidang WHERE perkara_id='$idperkara');";
			$tgljsidangsebelum=$this->db->query($qry);
			$jumhasil=$tgljsidangsebelum->num_rows();
			if ($jumhasil>0){
				$tgljsidangsebelum=$tgljsidangsebelum->row()->tanggal_sidang;
				return $tgljsidangsebelum;
			}
		} catch (Exception $e) {
			return null;
		}
	}

	/*function updateproses($idperkara,$idproses,$tanggal,$namahalaman){
		try {
			$qry="SELECT A.id AS tahapan_id, A.nama as tahapan_text, B.id AS proses_id, B.nama AS proses_text FROM tahapan_proses A, proses B WHERE A.id=B.tahapan_id AND B.id='$idproses';";
			$hasil=$this->db->query($qry);

			$data_update['tahapan_terakhir_id']=$hasil->row()->tahapan_id;
			$data_update['tahapan_terakhir_text']=$hasil->row()->tahapan_text;
			$data_update['proses_terakhir_id']=$hasil->row()->proses_id;
			$data_update['proses_terakhir_text']=$hasil->row()->proses_text;

			$this->db->simple_query("CALL perkara_proses_update('".$idperkara."', '".$data_update['tahapan_terakhir_id']."', '".$data_update['tahapan_terakhir_text']."', '".$data_update['proses_terakhir_id']."', '".$data_update['proses_terakhir_text']."', '".$tanggal."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");

			$this->db->where('perkara_id',$idperkara);
			$this->db->update('perkara',$data_update);

			$table="perkara";
			$title = "Update table <b>".$table."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$descrip = $this->fetch_description($title,$data_update);
			$this->add_audittrail("UPDATE",$title,$descrip,$table);

		} catch (Exception $e) {
			return FALSE;
		}
	}*/

	function updateproses($idperkara,$idproses,$tanggal,$namahalaman){
		try {
			$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
			$qry="SELECT A.id AS tahapan_id, A.nama as tahapan_text, B.id AS proses_id, B.nama AS proses_text FROM tahapan_proses A, proses B WHERE A.id=B.tahapan_id AND B.id='$idproses' AND jenis_pengadilan = '$jenis_pengadilan';";			
			$hasil=$this->db->query($qry);

			$data_update['tahapan_terakhir_id']=$hasil->row()->tahapan_id;
			$data_update['tahapan_terakhir_text']=$hasil->row()->tahapan_text;
			$data_update['proses_terakhir_id']=$hasil->row()->proses_id;
			$data_update['proses_terakhir_text']=$hasil->row()->proses_text;

			$this->db->simple_query("CALL perkara_proses_update('".$idperkara."', '".$data_update['tahapan_terakhir_id']."', '".$data_update['tahapan_terakhir_text']."', '".$data_update['proses_terakhir_id']."', '".$data_update['proses_terakhir_text']."', '".$tanggal."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");

			$cekproses = $this->db->query("SELECT tahapan_id,tahapan_nama,proses_id,proses_nama FROM perkara_proses WHERE perkara_id = ".$idperkara." ORDER BY proses_id DESC LIMIT 1 ;");			
			if($cekproses->num_rows>0){
				foreach ($cekproses->result() as $row) {					
					$update_status['tahapan_terakhir_id']	=$row->tahapan_id;
					$update_status['tahapan_terakhir_text']	=$row->tahapan_nama;
					$update_status['proses_terakhir_id']	=$row->proses_id;
					$update_status['proses_terakhir_text']	=$row->proses_nama;
				}				
				$this->db->where('perkara_id',$idperkara);
				$this->db->update('perkara',$update_status);
			}			

			$table="perkara";
			$title = "Update table <b>".$table."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$descrip = $this->fetch_description($title,$update_status);
			$this->add_audittrail("UPDATE",$title,$descrip,$table);

		} catch (Exception $e) {
			return FALSE;
		}
	}

	function cancelproses($idperkara,$idtahapan,$idproses,$namahalaman){
		try
		{
			$this->db->where('tahapan_id',$idtahapan);
			$this->db->where('perkara_id',$idperkara);
			$this->db->where('proses_id',$idproses);
			$this->db->delete('perkara_proses');

			$qry="SELECT tahapan_id,tahapan_nama,proses_id,proses_nama FROM perkara_proses WHERE perkara_id='$idperkara' AND proses_id=(SELECT MAX(proses_id) FROM perkara_proses WHERE perkara_id='$idperkara');";
			$hasil=$this->db->query($qry);

			$data_update['tahapan_terakhir_id']=$hasil->row()->tahapan_id;
			$data_update['tahapan_terakhir_text']=$hasil->row()->tahapan_nama;
			$data_update['proses_terakhir_id']=$hasil->row()->proses_id;
			$data_update['proses_terakhir_text']=$hasil->row()->proses_nama;

			$this->db->where('perkara_id',$idperkara);
			$this->db->update('perkara',$data_update);

			$table="perkara";
			$title = "Update table <b>".$table."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$descrip = $this->fetch_description($title,$data_update);
			$this->add_audittrail("UPDATE",$title,$descrip,$table);

		} catch (Exception $e) {
			return FALSE;
		}
	}
	
	function getDataPenetapanSidang($idperkara){
		try{
			if(!is_numeric($idperkara)){ return '';	}
			$sql = "SELECT a.penetapan_hari_sidang, a.sidang_pertama, b.tanggal_sidang,  b.jam_sidang
					FROM perkara_penetapan AS a, perkara_jadwal_sidang AS b
					WHERE a.perkara_id=b.perkara_id AND b.urutan=1 AND a.perkara_id=$idperkara";
			$query=$this->db->query($sql);
			return $query;
		}catch(Exception $e){ return false; }
	}

	function getDataPenetapanPanitera($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT * FROM 
						(SELECT perkara_id, panitera_id, tanggal_penetapan 
							FROM perkara_panitera_pn 
							WHERE perkara_id = $idperkara AND aktif='Y'
							GROUP BY panitera_id) AS ph
					LEFT JOIN
						(SELECT id, nama_gelar FROM panitera_pn) AS h
					ON ph.panitera_id = h.id";
			$query=$this->db->query($sql);
			return $query;
		}catch(Exception $e) { return false; }
	}

	function getRefJenisTahanan(){
		try{
			$sql = "SELECT * 
					FROM jenis_tahanan";
			$query=$this->db->query($sql);
			return $query;
		}catch(Exception $e) { return false; }
	}

	function getDataPerkara($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT nomor_perkara,nomor_surat,tanggal_surat, tanggal_pendaftaran, dakwaan 
					FROM perkara 
					WHERE perkara_id =$idperkara";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getJenisPerkara($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT nama 
					FROM jenis_perkara 
					WHERE id=(SELECT jenis_perkara_id 
								FROM perkara 
								WHERE perkara_id=$idperkara)";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataPA(){
		try{
			$sql = "SELECT * FROM 
					(SELECT value AS NamaPN FROM sys_config WHERE id = 62) AS T1,
					(SELECT value AS KetuaPNNama FROM sys_config WHERE id = 64) AS T2,
					(SELECT value AS AlamatPN FROM sys_config WHERE id = 63) AS T3,
					(SELECT value AS WakilKetuaPNNama FROM sys_config WHERE id = 66) AS T4,
					(SELECT value AS PansekPNNama FROM sys_config WHERE id = 68) AS T5,
					(SELECT value AS WaPanNama FROM sys_config WHERE id = 70) AS T6, 
					(SELECT value AS ZonaWaktu FROM sys_config WHERE id = 75) AS T7";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getAllHakim(){
		try{
			$sql = "SELECT * FROM hakim_pn";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataPihak($pihak_id){
		try{
			if(!is_numeric($pihak_id)) { return ''; }
			$sql = "SELECT * 
					FROM pihak 
					WHERE id=$pihak_id";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataPanitera($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT DISTINCT perkara_id,urutan,panitera_id,panitera_nama,tanggal_penetapan 
					FROM perkara_panitera_pn 
					WHERE perkara_id=$idperkara";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataTerdakwa($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			 $sql="SELECT 		a.*
								,b.tempat_lahir
								,b.tanggal_lahir
								,b.jenis_kelamin
								,d.nama AS warga_negara
								,c.nama AS agama_nama
								,b.pekerjaan
							FROM perkara_pihak2 AS a
							LEFT JOIN pihak AS b
							ON b.id=a.pihak_id
							LEFT JOIN agama AS c
							ON c.id=b.agama_id
							LEFT JOIN negara AS d
							ON d.id=b.warga_negara_id
							
							WHERE a.perkara_id=$idperkara
							ORDER BY a.urutan";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataPihakTerdakwa1($idperkara, $idpihak){
		try{
			if(!is_numeric($idperkara) OR !is_numeric($idpihak)) { return ''; }
			$sql = "SELECT 	a.pihak_id, a.urutan, 
						b.nama, b.alamat, b.tempat_lahir, b.tanggal_lahir, b.jenis_kelamin, a.pangkat, a.nrp, a.jabatan, a.kesatuan,
						c.`nama` AS agama_nama, d.`nama` AS warga_negara, b.pekerjaan 
					FROM 		perkara_pihak2 a
					LEFT JOIN pihak AS b ON a.pihak_id=b.id
					LEFT JOIN agama AS c ON  b.`agama_id`=c.`id`
					LEFT JOIN negara AS d ON b.`warga_negara_id`=d.`id`
					WHERE a.perkara_id = $idperkara AND a.pihak_id=$idpihak
					ORDER BY urutan ASC";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataPenahananTerdakwa($idperkara,$idpihak){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT 	pihak_id,
							jp.id AS idjns_penahanan,
							jp.nama AS oleh, 
							sp.nama AS status_penahanan, 
							jt.nama AS jenis_tahanan,
							pt.mulai AS sejak, 
							pt.sampai, 
							pt.lama_penahanan,
							pt.tanggal_surat as tglPenetapan,
							pt.id ,
							pt.tanggal_surat, pt.nomor_surat 
					FROM (SELECT * FROM penahanan_terdakwa WHERE perkara_id = $idperkara AND pihak_id = $idpihak ORDER BY jenis_penahanan_id, mulai ASC) pt 
					LEFT JOIN jenis_penahanan jp ON pt.jenis_penahanan_id=jp.id
					LEFT JOIN status_penahanan sp ON pt.status_penahanan_id=sp.id
					LEFT JOIN jenis_tahanan jt ON pt.jenis_tahanan_id=jt.id
					ORDER BY jp.id" ;
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}
	
	function getDataPenahanan($idpenahanan){
		try{
		$sql= "SELECT 	A.id,
						A.perkara_id,
						A.pihak_id,
						B.nama AS jenis_penahanan,
						C.nama AS status_penahanan,
						D.nama AS jenis_tahanan,
						A.tanggal_surat,
						A.nomor_surat,
						A.mulai,
						A.sampai,
						A.waktu_penahanan,
						A.lama_penahanan,
						A.rutan_id,
						E.nama
				FROM penahanan_terdakwa A 
				LEFT JOIN jenis_penahanan B ON A.jenis_penahanan_id=B.id 
				LEFT JOIN status_penahanan C ON A.status_penahanan_id=C.id
				LEFT JOIN jenis_tahanan D ON A.jenis_tahanan_id=D.id
				LEFT JOIN lembaga_pemasyarakatan AS E ON A.rutan_id = E.id
				WHERE A.id=$idpenahanan ";				
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataHakim($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT * 
					FROM (SELECT perkara_id,urutan,jabatan_hakim_id, jabatan_hakim_nama, hakim_id, tanggal_penetapan 
							FROM perkara_hakim_pn 
							WHERE perkara_id = $idperkara AND aktif='Y'
							GROUP BY hakim_id) AS ph
					LEFT JOIN (SELECT id, nama_gelar FROM hakim_pn) AS h
					ON ph.hakim_id = h.id
					ORDER BY jabatan_hakim_id ASC";		
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false;	}
	}

	function getDataPenetapanHakim($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT * 
					FROM (SELECT perkara_id,urutan,jabatan_hakim_id, jabatan_hakim_nama, hakim_nama, hakim_id,tanggal_penetapan,aktif
							FROM perkara_hakim_pn 
							WHERE perkara_id = $idperkara AND aktif='Y'
							GROUP BY hakim_id) AS ph
					LEFT JOIN (SELECT id, nama_gelar FROM hakim_pn) AS h
					ON ph.hakim_id = h.id
					ORDER BY urutan ASC";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataJurusita($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT B.nama_gelar,A.tanggal_penetapan FROM perkara_jurusita AS A LEFT JOIN jurusita AS B ON A.jurusita_id=B.id WHERE A.perkara_id='$idperkara'";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataPP($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT B.nama_gelar,A.tanggal_penetapan FROM perkara_panitera_pn AS A LEFT JOIN panitera_pn AS B ON A.panitera_id=B.id WHERE A.perkara_id='$idperkara'";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getAmar($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT amar_putusan FROM perkara AS 
			A LEFT JOIN perkara_putusan AS B ON A.perkara_id=B.perkara_id 
			WHERE A.perkara_id='$idperkara'";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getPenahananBefore($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT * FROM penahanan_terdakwa WHERE id = ";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getKejaksaan($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT IF(a.alamat <> '',a.alamat, b.kejaksaan) AS kejaksaan  FROM 
					perkara_pihak1 AS a
					LEFT JOIN  pihak_jaksa AS b ON a.pihak_id=b.pihak_id
					WHERE a.perkara_id='".$idperkara."' ";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_data_pihak_loop($idperkara,$jenispihak){
		try {
			if(!is_numeric($idperkara)){
				return '';
			}
			return $this->db->query('SELECT b.*,  a.*,c.nama AS kewarganegaraan, d.nama as agama,
											group_concat(e.pengacara_id) as pengacara_id 
											FROM pihak AS a
											LEFT JOIN
											(SELECT * FROM perkara_pihak'.$jenispihak.') AS b
											ON a.id=b.pihak_id
											LEFT JOIN
											(SELECT id,nama FROM negara) AS c
											ON a.warga_negara_id=c.id
											LEFT JOIN
											(SELECT id,nama FROM agama) AS d
											ON a.agama_id=d.id
											LEFT JOIN
											(SELECT pengacara_id, pihak_id, perkara_id FROM perkara_pengacara) AS e
											ON b.pihak_id=e.pihak_id and e.perkara_id=b.perkara_id
											WHERE b.perkara_id='.$idperkara.' GROUP BY b.id ORDER BY b.id ASC');
			} catch (Exception $e) {
				return '';
			}
	}

	function getTanggalPersidangan($idjadwal){
		try{
			if(!is_numeric($idjadwal)){
				return '';
		}
		return $this->db->query('SELECT * FROM perkara_jadwal_sidang WHERE id='.$idjadwal);
	}catch (Exception $e){
		}
	}

	function getTanggalPersidanganTKPertama($idperkara){
		try{
			if(!is_numeric($idperkara)){
				return '';
		}
		return $this->db->query("SELECT * FROM perkara_jadwal_sidang WHERE verzet='T' AND keberatan='T' AND ikrar_talak='T' AND perkara_id=".$idperkara);
	}catch (Exception $e){
		}
	}
	
	function getSidangTerakhir($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT * FROM perkara AS 
			A LEFT JOIN perkara_jadwal_sidang AS B ON A.perkara_id=B.perkara_id 
			WHERE A.perkara_id='$idperkara' ORDER BY B.urutan DESC";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

    function getMediasiTerakhir($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT * FROM perkara AS A
			LEFT JOIN perkara_mediasi AS B ON A.perkara_id=B.perkara_id
			LEFT JOIN perkara_mediator AS C ON A.perkara_id=C.perkara_id
			WHERE A.perkara_id='$idperkara' ORDER BY B.mediasi_id DESC";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getMeditor($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT * FROM perkara AS A
			LEFT JOIN perkara_mediator AS C ON A.perkara_id=C.perkara_id
			WHERE A.perkara_id='$idperkara' ORDER BY C.id DESC";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataSidangTunda($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT id,urutan, tanggal_sidang
					FROM perkara_jadwal_sidang
					WHERE perkara_id =$idperkara AND verzet='T' AND keberatan='T' AND ikrar_talak='T' ";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getVerzet($idperkara){
		try {
			$result = $this->db->query('SELECT verzet FROM perkara_jadwal_sidang WHERE perkara_id ='.$idperkara);
			if($result->num_rows>0){
				return $result->row()->verzet;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return '';
		}
	}
}
?>