<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Tab_ikrar_akta_cerai_c extends CI_Controller {

	function index(){
		$data=$this->load_data();
		$this->load->view('perkara_tab/ikrar_talak/tab_akta_cerai_v', $data);
	}

	function load_data(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		$data['idperkara'] = $data['perkara_id'];
		
		$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
		$row=$this->ikrar->get_info_akta_cerai($data['perkara_id']);
		$data['enc_ac'] = $row->nomor_akta_cerai;
		$data['no_seri_akta_cerai'] = $row->no_seri_akta_cerai;
		$data['status_penetapan'] = $row->jenis_cerai;
		$data['faktor_penyebab'] = $row->faktor_penyebab;
		$data['qobla'] = $row->qobla_bada==0?'Qobla Dukhul':'Ba\'da Dukhul';
		switch ($row->keadaan_istri) {
			case 1:
				$data['keadaan_istri'] = 'Suci';
			break;
			case 2:
				$data['keadaan_istri'] = 'Haid';
			break;
			case 3:
				$data['keadaan_istri'] = 'Hamil';
			break;
			case 4:
				$data['keadaan_istri'] = 'Tidak Diketahui';
			break;
		}
		$data['perceraian_ke'] = $row->perceraian_ke;
		$data['tgl_penyerahan_akta_cerai'] = $row->tgl_penyerahan_akta_cerai;
		$data['tgl_akta_cerai'] = $row->tgl_akta_cerai;
		$data['tanggal_akta_cerai'] = $row->tgl_akta_cerai;
		$data['akta_cerai_dok'] = $row->akta_cerai_dok;
		$data['blangko'] = $row->blangko;
		$data['current_date'] = date('d/m/Y');		
		return $data;
	}

	function edit_ikrar_talak_akta_cerai(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		if(empty($data['perkara_id']) OR intval($data['perkara_id'])<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
		$jenisperkara=$this->ikrar->getJenisPerkara($data['perkara_id']);
		if (!empty($jenisperkara)){
			if ($jenisperkara->num_rows>0){
				foreach ($jenisperkara->result() as $row) {
					$data['jenis_perkara'] = $this->templatehelper->standradnaming($row->jenis_perkara_nama);
				}
			}
		}
		$row=$this->ikrar->get_info_akta_cerai($data['perkara_id']);
		$data['nomor_ac'] = 'Auto Generate (pilih tanggal akta cerai)';
		$data['enc_ac'] = '';
		if ($row->nomor_urut_akta_cerai!='' || !empty($row->nomor_urut_akta_cerai)){
			$data['enc_ac'] = $row->nomor_urut_akta_cerai;
			$data['nomor_ac'] = $row->nomor_akta_cerai;
		}
		$data['no_seri_akta_cerai'] = $row->no_seri_akta_cerai;
		/*$data['jenis_cerai'] = $row->jenis_cerai;
		if ((empty($data['jenis_cerai']) AND $data['jenis_cerai']!=0) OR ($data['jenis_cerai']=='')){
			$data['jenis_cerai']=-1;
		}*/
		$data['faktor_penyebab'] = $row->faktor_penyebab;
		$data['qobla'] = $row->qobla_bada;
		if ((empty($data['qobla']) AND $data['qobla']!=0) OR ($data['qobla']=='')){
			$data['qobla']=-1;
		}
		switch ($row->keadaan_istri) {
			case 1:
				$data['keadaan_istri'] = 'Suci';
			break;
			case 2:
				$data['keadaan_istri'] = 'Haid';
			break;
			case 3:
				$data['keadaan_istri'] = 'Hamil';
			break;
			case 4:
				$data['keadaan_istri'] = 'Tidak Diketahui';
			break;
		}
		$data['perceraian_ke'] = $row->perceraian_ke;
		$data['tgl_penyerahan_akta_cerai'] = $row->tgl_penyerahan_akta_cerai;
		$data['tanggal_akta_cerai'] = $row->tgl_akta_cerai;
		$data['tgl_penyerahan_akta_cerai'] = $row->tgl_penyerahan_akta_cerai;
		
		$data['current_date'] = date('d/m/Y');
		$this->load->view('perkara_tab/ikrar_talak/form_ikrar_akta_cerai', $data);
	}

	function get_no_urut_akta_cerai(){ 
		$tgl = $this->input->post('tanggal',true);
		$tmp=explode('/', $tgl);
		$year='';
		if (count($tmp)==3){
			$year=$tmp[2];	
		}
		$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
		$no = $this->ikrar->getnomoraktacerai($year);
		$kode=$this->ikrar->getkodesatker();
		if ($no!=0){
			$digit = strlen($no);
		}
		for ($i=1;$i<=4;$i++){
			if($digit<$i){
				$no='0'.$no;
			}
		}
		echo $no."/AC/".$year.'/'.$kode;
	}

	function validateInputAktaCerai(){
		if(empty($_POST)){
			show_404();
		}
		$no_ac=$this->input->post('enc_ac', true);
		$noUrutReg='';
		$year='';
		if (!empty($no_ac)){
			$temp=explode('/', $no_ac);
			if (count($temp)==3){
				$noUrutReg=$temp[0];
				$year=$temp[2];
			}
		}
		$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
		$isNoUrutRegisterExists = $this->ikrar->isNomorUrutRegisterExists($noUrutReg, $year);
		if($isNoUrutRegisterExists==TRUE OR $isNoUrutRegisterExists==-2){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Nomor Urut Akta Cerai Sudah Ada '.$no_ac));
			return;
		}
		$this->form_validation->set_rules('nomor_ac', 'Nomor Akta Cerai', 'trim|required|xss_clean');		
		$this->form_validation->set_rules('tgl_akta_cerai', 'Tanggal Akta Cerai', 'trim|required|xss_clean');		
		$this->form_validation->set_rules('qobla', 'Qobla/Ba\'da', 'trim|required|xss_clean|callback_f_dropdown_id_check');		
		$this->form_validation->set_rules('perceraian_ke', 'Perceraian ke', 'trim|numeric|required|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$tgl_akta_cerai = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_akta_cerai', TRUE));
			if($tgl_akta_cerai==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}
			$enc=$this->input->post('enc',true);
			$perkara_id=$this->encrypt->decode(base64_decode($enc));
			$perkara=$this->ikrar->get_no_perkara($perkara_id);
			$tgl_putusan=($perkara->tanggal_putusan);
			$tgl_bht=($perkara->tanggal_bht);
			$tgl_ikrar=($perkara->tgl_ikrar_talak);
			$jenis_perkara_id=($perkara->jenis_perkara_id);
			/*$selisih = $this->tanggalhelper->getSelisihHari($tgl_putusan,$tgl_akta_cerai);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Akta Cerai Tidak Boleh Melebihi Tanggal Putusan. Tanggal putusan '.$this->tanggalhelper->convertDayDate($tgl_putusan)));
				return;
			}*/
			if($jenis_perkara_id==346){
				$selisih=$this->tanggalhelper->getSelisihHari($tgl_ikrar,$tgl_akta_cerai);
				$pesan='<strong>Peringatan:</strong><br /> Tanggal Akta Cerai Tidak Boleh Sebelum Tanggal Ikrar Talak. Tanggal Ikrar Talak '.$this->tanggalhelper->convertDayDate($tgl_ikrar);
			}
			elseif($jenis_perkara_id==347){
				$selisih=$this->tanggalhelper->getSelisihHari($tgl_bht,$tgl_akta_cerai);
				$pesan='<strong>Peringatan:</strong><br /> Tanggal Akta Cerai Tidak Boleh Sebelum Tanggal BHT. Tanggal BHT '.$this->tanggalhelper->convertDayDate($tgl_bht);
			}
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>$pesan));
				return;
			}
			$temp=explode('-', $tgl_akta_cerai);
			$tahun=$temp[0];
			
			/*$jenisperkara = $this->input->post('jenis_perkara',true);
			
			if ($jenisperkara=='Cerai Gugat'){
				$data['jenis_cerai']=1;
			}elseif ($jenisperkara=='Cerai Talak'){
				$data['jenis_cerai']=0;
			}*/
			$data = array(
               'tgl_akta_cerai' => $tgl_akta_cerai,
               'tahun_akta_cerai' => $tahun,
               'nomor_urut_akta_cerai' => $no_ac,
               'nomor_akta_cerai' => $this->input->post('nomor_ac',true),
               'no_seri_akta_cerai' => $this->input->post('no_seri_akta_cerai',true),
               'jenis_cerai' => $this->input->post('jenis_perkara',true),
               'qobla_bada' => $this->input->post('qobla',true),
               'perceraian_ke' => $this->input->post('perceraian_ke',true),
               'diperbaharui_oleh' => $this->session->userdata('username'),
               'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
            );
            $tgl_penyerahan_akta_cerai=$this->input->post('tgl_penyerahan_akta_cerai', TRUE);
            if (!empty($tgl_penyerahan_akta_cerai) OR $tgl_penyerahan_akta_cerai!=''){
            	$data['tgl_penyerahan_akta_cerai']=$this->tanggalhelper->convertToMysqlDate($tgl_penyerahan_akta_cerai);
            }
			
			if ($this->ikrar->update_perkara_akta_cerai($perkara_id, $data)){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
				return;
			}
		}
	}
	
	function f_dropdown_id_check($str){
		if (intval($str)==-1){
			$this->form_validation->set_message('f_dropdown_id_check', '%s - Tidak Boleh Kosong');
			return FALSE;
		}else{
			return TRUE;
		}
	}
	function validateDeleteAktaCerai(){
		if(empty($_POST)){
			show_404();
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
		$delData = $this->ikrar->deleteDataAktaCerai($idperkara);
		if($delData){
			echo json_encode(array('st'=>1,'msg'=>'Data Akta Cerai Berhasil DiHapus.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Penghapusan Data Akta Cerai Gagal.'));
			return;
		}
	}
}












