<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class detil_perkara extends CI_Controller {
	function index(){
		#prevent direct access to page
		#the user should only access the page through menu
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$idperkara = $this->nativesession->get_flash_session('perkara_id');
		if(!is_numeric($idperkara)){
			redirect('main');
		}
		$isDataUmum = $this->nativesession->get_flash_session('open_dataumum');
		if($isDataUmum=="No"){
			$this->show_data($idperkara);
		}elseif($isDataUmum=="Yes"){
			$this->show_dataumum($idperkara);
		}
	}

	function show_data($idperkara){
		$this->load->model('perkara/info_perkara','perkara');
		$this->perkara->repair_riwayat_perkara_sidang_pertama($idperkara);
		$data = $this->parseData($this->perkara->getInfoPerkara($idperkara));
		$data['ada_barang_bukti']=$this->perkara->get_barang_bukti($idperkara);
		$data['alur_perkara_id']=$data['idalurperkara'];
		$data['perkaraid']=$idperkara;
		$data['pihak_pertama'] = $this->perkara->getInfoPihakPertama($idperkara);
		$data["ada_data_verzet"] = 0;
		$data["ada_data_intervensi"] = 0;
		$data["ada_data_diversi"] = 0;
		$data["ada_data_eksekusi"] = 0;
		$data['terdakwa_tidak_hadir'] = 0;
		$data['ada_data_rekonvensi'] = 0;
		$data["ada_data_banding"] = $this->perkara->getInfoBanding($idperkara);
		$data["ada_data_kasasi"] = $this->perkara->getInfoKasasi($idperkara);
		$data["ada_data_PK"] = $this->perkara->getInfoPK($idperkara);
		$data["ada_data_grasi"] = '';
		$data['isVerstek'] = '';
		$data["ada_data_dismissal"] = 0;
		$data["ada_data_gugur"] = 0;
		$data["kehadiran_pihak"] = 0;
		$data['cekStatusPihakHadir'] = 0;
		$data['ada_jadwal_sidang'] = 0;
		$data["ada_jadwal_sidang"] = $this->perkara->getInfoJadwalSidang($idperkara);
		$data['is_keberatan_diterima'] = 0;
		if($data['idalurperkara']==111){
			$data['is_keberatan_diterima'] = $this->perkara->getHasilPutusanSela($idperkara);
		}
		if($data['idalurperkara']==114){
			$query = $this->perkara->getInfoPerkaraTilang($idperkara);
			$data['nomor_tilang'] = $query->row()->nomor_tilang;
			$data['ditilang_oleh'] = $query->row()->ditilang_oleh;
			$data['nama_kendaraan'] = $query->row()->nama_kendaraan;
			$data['nomor_polisi'] = $query->row()->nomor_polisi;
			$data['nama_bukti'] = $query->row()->nama_bukti;
			$data['kejaksaan'] = $query->row()->kejaksaan;
			$data['jenis_tilang'] = $query->row()->jenis_tilang;
			$data['tanggal_penindakan'] = $query->row()->tanggal_penindakan;
			$data['nomor_pembayaran'] = $query->row()->nomor_pembayaran;
		}
		
		if($data['idalurperkara']==118){
			$data['pihak_kedua'] = $this->perkara->getInfoPerkaraAnak($idperkara);
			$data['pihak_korban'] = $this->perkara->getInfoKorbanAnak($idperkara);
		}else{
			$data['pihak_kedua'] = $this->perkara->getInfoPihakKedua($idperkara);
		}
		if($data['idalurperkara']<100){
			$data["kehadiran_pihak"] = $this->perkara->getInfoKehadiranPihak($idperkara);
			$data['pihak_keempat'] = $this->perkara->getInfoPihakKeempat($idperkara);
			$data["ada_data_verzet"] = $this->perkara->getInfoVerzet($idperkara);
			$data["ada_data_intervensi"] = $this->perkara->getInfoIntervensi($idperkara);
			$data["ada_data_eksekusi"] = $this->perkara->getInfoEksekusi($idperkara);
			if($data['idProses']>=210){
				$data['isVerstek'] = $this->perkara->getInfoVerstek($idperkara);
			}
			if($data['idalurperkara']==8){
				$data["ada_data_keberatan"] = $this->perkara->getInfoKeberatan($idperkara);
				$infos = $this->perkara->getInfoPutusan($idperkara);
				
				if($infos==28){
					$data["ada_data_dismissal"] = 1;
				}elseif ($infos==29) {
					$data["ada_data_gugur"] = 1;
				}
			}
			//$data['terdakwa_tidak_hadir'] = $this->perkara->getInfoTerdakwaTidakHadir($idperkara,1);
			$data['ada_data_rekonvensi'] = $this->perkara->getInfoRekonvensi($idperkara);			
		}else{
			$data["is_dibuka_kembali"] = 0;
			$data["ada_data_diversi"] = $this->perkara->getInfoDiversi($idperkara);
			if($data["ada_data_diversi"]>0){
				$data["is_dibuka_kembali"] = $this->perkara->getStatusDiversi($idperkara);;
			}			
			$data["ada_data_grasi"] = $this->perkara->getInfoGrasi($idperkara);
		}
		$statusPihakHadir = $this->perkara->cekStatusPihakHadir($idperkara);			
		$lasStatusPihak = $statusPihakHadir->row(($statusPihakHadir->num_rows())-1);
		if(!empty($lasStatusPihak)){
			$data['cekStatusPihakHadir'] = $lasStatusPihak->dihadiri_oleh;								
		}
		$data['terdakwa_tidak_hadir'] = $this->perkara->getInfoTerdakwaTidakHadir($idperkara);		
		$data["pengacara_pihak_pertama"] = $this->perkara->getInfoPengacara($idperkara,1,$data['idalurperkara']);
		$data["pengacara_pihak_kedua"] = $this->perkara->getInfoPengacara($idperkara,2,$data['idalurperkara']);
		$data["pengacara_pihak_keempat"] = $this->perkara->getInfoPengacara($idperkara,4,$data['idalurperkara']);
		$data["ada_data_saksi"] = $this->perkara->get_jumlah_saksi($idperkara);
		
		$data['page_title'] = 'INFORMASI DETAIL PERKARA';
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		if($this->session->userdata('jenis_pengadilan')==1){
			$data['main_body'] = 'perkara/detil_perkara';
		} else if($this->session->userdata('jenis_pengadilan')==2){
			$data['main_body'] = 'perkara/detil_perkara_mil';
		} else if($this->session->userdata('jenis_pengadilan')==3){
			$data['main_body'] = 'perkara/detil_perkara_tun';
		} else {
			$data['main_body'] = 'perkara/detil_perkara';
		}
		$data['main_history'] = $this->nativesession->get('main_url_requested');
		$data['history'] = $this->nativesession->get_flash_session('url_requested');
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}

	function show_dataumum($idperkara){
		$data['history'] = $this->nativesession->get_flash_session('url_requested');
		$this->load->model('perkara/info_perkara','perkara');

		$data = $this->parseData($this->perkara->getInfoPerkara($idperkara));
		$data['ada_barang_bukti']=$this->perkara->get_barang_bukti($idperkara);
		$data['perkaraid']=$idperkara;
		$data['pihak_pertama'] = $this->perkara->getInfoPihakPertama($idperkara);
		if($data['idalurperkara']==118){
			$data['pihak_kedua'] = $this->perkara->getInfoPerkaraAnak($idperkara);
			$data['pihak_korban'] = $this->perkara->getInfoKorbanAnak($idperkara);
		}else{
			$data['pihak_kedua'] = $this->perkara->getInfoPihakKedua($idperkara);
		}
		
		if($data['idalurperkara']<100){
			$data['pihak_keempat'] = $this->perkara->getInfoPihakKeempat($idperkara);
		}

		if($data['idalurperkara']==114){
			$query = $this->perkara->getInfoPerkaraTilang($idperkara);
			$data['nomor_tilang'] = $query->row()->nomor_tilang;
			$data['ditilang_oleh'] = $query->row()->ditilang_oleh;
			$data['nama_kendaraan'] = $query->row()->nama_kendaraan;
			$data['nomor_polisi'] = $query->row()->nomor_polisi;
			$data['nama_bukti'] = $query->row()->nama_bukti;
		}



		$data["pengacara_pihak_pertama"] = $this->perkara->getInfoPengacara($idperkara,1,$data['idalurperkara']);
		$data["pengacara_pihak_kedua"] = $this->perkara->getInfoPengacara($idperkara,2,$data['idalurperkara']);
		$data["pengacara_pihak_keempat"] = $this->perkara->getInfoPengacara($idperkara,4,$data['idalurperkara']);
		$data["ada_data_intervensi"] = $this->perkara->getInfoIntervensi($idperkara);
		$data["ada_data_diversi"] = $this->perkara->getInfoDiversi($idperkara);
		
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['alur_perkara_id']=$data['idalurperkara'];
		$this->load->vars($data);
		$this->load->view('perkara_tab/data_umum');
	}

	function parseData($info_perkara){
		if($info_perkara!=''){
			if($info_perkara->num_rows>0){
				foreach ($info_perkara->result() as $row) {
					$data['idalurperkara'] = $row->alur_perkara_id;
					$data['noPerkara'] = $row->nomor_perkara;
					$data['noUrut'] = $row->nomor_urut_register;
					$data['tglSurat'] = $row->tanggal_surat;
					$data['noSurat'] = $row->nomor_surat;
					$data['idProses'] = $row->proses_terakhir_id;
					$data['prosesText'] = $row->proses_terakhir_text;
					$data['idTahapan'] = $row->tahapan_terakhir_id;
					$data['tahapanText'] = $row->tahapan_terakhir_text;
					$data['pihak1'] = $row->pihak1_text;
					$data['pihak2'] = $row->pihak2_text;
					$data['tglPendaftaran'] = $row->tanggal_pendaftaran;
					$data['statuTerakhir'] = $row->proses_terakhir_text;
					$data['tglPutusan'] = $row->tanggal_putusan;
					$data['jenisPerkara'] = $row->jenis_perkara_nama;
					$data['idjenisPerkara'] = $row->jenis_perkara_id;
					$data['isPublish'] = ($row->pihak_dipublikasikan=='Y')? 'Ya':'Tidak';
					$data['petitum'] = $row->petitum;
					$data['nilai_sengketa'] = number_format($row->nilai_sengketa,2,",",".");
					$data['petitum_dok'] = $row->petitum_dok;
					$data['dakwaan'] = $row->dakwaan;
					$data['dakwaan_dok'] = $row->dakwaan_dok;
					$data['prodeo'] = ($row->prodeo=='1')? 'Ya':'Tidak';
					$data['ada_data_penuntutan'] = !empty($row->tanggal_penuntutan)?1:0;
					$data['ada_data_putusan_sela'] = !empty($row->tanggal_putusan_sela)?1:0;
					$data['sudah_putusan'] =0;
					$data['ada_data_mediasi'] = !empty($row->is_mediasi)?1:0;
					$data['hasil_mediasi'] = !empty($row->keputusan_mediasi)?1:0;
					$data['ada_data_umum']=0;

					

					
					if(!empty($row->tanggal_putusan) && $row->amar_putusan!=''){
						$data['sudah_putusan']=1;
					}
					if (!empty($row->pihak1_text) && !empty($row->pihak2_text)){
						if ($row->alur_perkara_id<100){
							if (!empty($row->petitum)){
								$data['ada_data_umum']=1;
							}
						}else if ($row->alur_perkara_id==119 ){
							if (!empty($row->dakwaan)){
								$data['ada_data_umum']=1;
							}
						}else if ($row->alur_perkara_id>100){
							if (!empty($row->dakwaan) && !empty($row->tanggal_surat) && !empty($row->nomor_surat)){
								$data['ada_data_umum']=1;
							}
						}
					}else if($row->alur_perkara_id==2){
						if (!empty($row->petitum)){
								$data['ada_data_umum']=1;
							}
					}
					if ($row->tanggal_bht!=''){
						$data['tgl_bht']=$this->tanggalhelper->convertDayDate($row->tanggal_bht);
					}else{
						$data['tgl_bht']='';
					}
				}
			}
		}
		return $data;
	}
	function manage_bht($enc){
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$data['enc']=$enc;
		$data['perkara_id']=$this->encrypt->decode(base64_decode($enc));
		$this->load->model('perkara/info_perkara','perkara');
		$result = $this->perkara->getInfoPerkara($data['perkara_id'])->result();
		$tgl_bht=($result[0]->tanggal_bht);
		if ($tgl_bht!=''){
			$data['act']='edit';
			$data['tgl_bht']=$tgl_bht;
		}else{
			$data['act']='add';
			$data['tgl_bht']='';
		}
		$this->load->view('perkara/edit_bht', $data);
	}
}
/* End of file detil_perkara.php */
/* Location: ./application/controllers/detil_perkara.php */