<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Dismissal extends CI_Model{
	
	function get_data_perkara($idperkara){
		if(empty($idperkara)) 
			{ 
				return '';
			}
		try {

			$this->db->where('perkara_id',$idperkara);
			return $this->db->get('perkara');

		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_data_dismissal($idperkara){
		try {
			$this->db->select('tanggal_putusan,amar_putusan,amar_putusan_dok,tanggal_minutasi');
			$this->db->where('perkara_id',$idperkara);
			return $this->db->get('perkara_putusan');

		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	
	function get_data_perlawanan($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->select('perkara_id');
			$result = $this->db->get('perkara_verzet');
			if($result->num_rows>0){
				return $result->row()->perkara_id;
			}else{
				return 0;
			}
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_maxid_perkara_putusan(){
		
		try {

			$query = $this->db->query('SELECT MAX(perkara_id)+1 AS maxidput  FROM perkara_putusan');
			return $query;
			
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function add_dismissal($data_add){
		try {
				$this->db->replace('perkara_putusan', $data_add);
				$title = "Tambah Data Dismissal <br />Tambah table <b>perkara_putusan</b> dari halaman <b>Dismissal</b> dengan Primary Key [perkara_id=".$data_add['perkara_id']."]";
				$descrip = $this->fetch_description($title,$data_add);
				$this->add_audittrail("INSERT",$title,$descrip,'perkara_putusan');
				$this->db->simple_query("CALL perkara_proses_update(".$data_add['perkara_id'].", 15, 'Dismissal', 214, 'Dismissal', '".$data_add['tanggal_putusan']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
				$this->db->simple_query("CALL perkara_update_status(".$data_add['perkara_id'].");");
				return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function update_dismissal($idperkara,$data_add){
		try {
				$this->db->where('perkara_id',$idperkara);
				$this->db->update('perkara_putusan',$data_add);
				$title = "UPDATE Data Dismissal <br />Tambah table <b>perkara_putusan</b> dari halaman <b>Dismissal</b> dengan Primary Key [perkara_id=".$data_add['perkara_id']."]";
				$descrip = $this->fetch_description($title,$data_add);
				$this->add_audittrail("UPDATE",$title,$descrip,'perkara_putusan');
				$this->db->simple_query("CALL perkara_proses_update(".$data_add['perkara_id'].", 15, 'Dismissal', 214, 'Dismissal', '".$data_add['tanggal_putusan']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
				$this->db->simple_query("CALL perkara_update_status(".$data_add['perkara_id'].");");
				return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}

	function add_audittrail($action,$title,$descrip,$tablename){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => 'Add Mediasi',
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			
		}
	}

	function deleteData($idperkara){
		try {			
			$this->db->where('perkara_id',$idperkara);
			$this->db->delete('perkara_putusan');
			$title = "DELETE DATA PENETAPAN DISMISSAL dari halaman <b>EDIT DATA PENETAPAN DISMISSAL</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$this->add_audittrail("DELETE",$title,'DELETE DATA PENETAPAN DISMISSAL','perkara_putusan');

			$this->db->where('perkara_id',$idperkara);
			$this->db->where('tahapan_id',15);
			$this->db->delete('perkara_proses');

			$qry = "SELECT *, IFNULL(diperbaharui_tanggal,diinput_tanggal) AS disp_diinput_tanggal 
					FROM perkara_proses WHERE perkara_id='".$idperkara."'
					ORDER BY tahapan_id DESC, proses_id DESC,  tanggal DESC,urutan DESC,  disp_diinput_tanggal DESC LIMIT 1;";
			$proses_alur_perkara=$this->db->query($qry)->result();				
			$this->db->simple_query("UPDATE perkara SET tahapan_terakhir_id='".$proses_alur_perkara[0]->tahapan_id."', tahapan_terakhir_text='".$proses_alur_perkara[0]->tahapan_nama."', proses_terakhir_id='".$proses_alur_perkara[0]->proses_id."', proses_terakhir_text='".$proses_alur_perkara[0]->proses_nama."' WHERE perkara_id=".$idperkara);			
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function getPihak($idperkara,$pihakke){
		try {
			$table_name = " perkara_pihak".$pihakke;
			return $this->db->query(' SELECT pp.perkara_id, pp.pihak_id,pp.id,ppp.pihak,urutan,nama,
				tanggal_pemberitahuan_putusan,tanggal_menerima_putusan,tanggal_kirim_salinan_putusan 
				FROM '.$table_name.' AS pp 
				LEFT JOIN (SELECT * FROM perkara_putusan_pemberitahuan_putusan WHERE pihak = '.$pihakke.') AS ppp
				ON ppp.perkara_id = pp.perkara_id AND ppp.pihak_id = pp.id
				WHERE pp.perkara_id = '.$idperkara.' ORDER BY urutan;');
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function add_pemberitahuan_dismissal($data){
		try {
			foreach ($data as $data_add) {
				$this->db->replace('perkara_putusan_pemberitahuan_putusan', $data_add);
				$title = "Tambah Data Pemberitahuan Dismissal <br />Tambah table <b>perkara_putusan_pemberitahuan_putusan</b> dari halaman <b>Pemberitahuan Dismissal</b> dengan Primary Key [perkara_id=".$data_add['perkara_id']."]";
				$descrip = $this->fetch_description($title,$data_add);
				$this->add_audittrail("INSERT",$title,$descrip,'perkara_putusan_pemberitahuan_putusan');
			}	
			
			$this->db->simple_query("CALL perkara_proses_update(".$data_add['perkara_id'].", 15, 'Putusan', 218, 'Pemberitahuan Putusan', '".$data_add['tanggal_pemberitahuan_putusan']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			$this->db->simple_query("CALL perkara_update_status(".$data_add['perkara_id'].");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function update_minutasi($idperkara,$data_add){
		try {
			if(!empty($data_add['tanggal_minutasi'])){				
				$title = "UPDATE Data Minutasi Penetapan Dismissal <br />Tambah table <b>perkara_putusan</b> dari halaman <b>Pemberitahuan Dismissal</b> dengan Primary Key [perkara_id=".$data_add['perkara_id']."]";
				$descrip = $this->fetch_description($title,$data_add);
				$this->add_audittrail("UPDATE",$title,$descrip,'perkara_putusan');
				$this->db->simple_query("CALL perkara_proses_update(".$data_add['perkara_id'].", 15, 'Putusan', 220, 'Minutasi', '".$data_add['tanggal_minutasi']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			}else{
				$this->db->simple_query("DELETE FROM `perkara_proses` WHERE `perkara_id` =".$data_add['perkara_id']." AND`proses_id` = '220'; ");
			}
				$this->db->where('perkara_id',$idperkara);
				$this->db->update('perkara_putusan',$data_add);
				$this->db->simple_query("CALL perkara_update_status(".$data_add['perkara_id'].");");
				return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function get_data_jadwal_dismissal($idperkara){
		try {

			$this->db->where('perkara_id',$idperkara);
			$this->db->order_by("id", "ASC"); 
			$result=$this->db->get('musyawarah_dismissal');#->result_array();
			return $result->result();

		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_urutan_jadwal_dismissal_terakhir($idperkara){
		$this->db->select_max('urutan');
		$this->db->where('perkara_id',$idperkara);
		$result=$this->db->get('musyawarah_dismissal');
		return $result;
	}	

	function get_maxid_dismissal(){
		try {
			$query = $this->db->query('SELECT IFNULL(MAX(id)+1,1) AS maxid FROM perkara_panggilan_dismissal');
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	
	function add_data_perkara_dismissal($add_data){
		try {
			$this->db->insert('perkara_dismissal', $add_data);
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}
	function add_data_minutasi_dismissal_tun($add_data){
		try {
			$this->db->insert('perkara_putusan', $add_data);
			$this->db->simple_query("CALL perkara_proses_update(".$add_data['perkara_id'].", 15, 'Putusan', 220, 'Minutasi','".$add_data['tanggal_minutasi']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			$this->db->simple_query("CALL perkara_update_status(".$add_data['perkara_id'].");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function add_data_panggilan_dismissal($jadwal){
		try {
			$this->db->insert('perkara_panggilan_dismissal', $jadwal);
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function dell_data_panggilan_dismissal($id){
		try {
			$this->db->where('id',$id);
			$this->db->delete('perkara_panggilan_dismissal');
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}
	function dell_data_pemberitahuan_dismissal($idperkara){
		try {			
			$this->db->where('perkara_id',$idperkara);
			$this->db->delete('perkara_putusan');					
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}
	function update_proses_setelah_hapus_minut($data_add){
		try {	
			$this->db->query('DELETE FROM perkara_proses WHERE proses_id = 220 AND perkara_id = '.$data_add['perkara_id']);			
			$this->db->simple_query("CALL perkara_proses_update(".$data_add['perkara_id'].", 15, 'Putusan', 214, 'Dismissal Ditolak','".$data_add['tanggal_putusan']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			$this->db->simple_query("CALL perkara_update_status(".$data_add['perkara_id'].");");
				return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function update_pemberitahuan_dismissal($idperkara,$data_add){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->update('perkara_dismissal', $data_add);
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function update_perkara_dismissal($idperkara,$add_data){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->update('perkara_dismissal', $add_data);
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function update_panggilan_dismissal($id,$data_add){
		try {
			$this->db->where('id',$id);
			$this->db->update('perkara_panggilan_dismissal', $data_add);
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function insert_panggilan_dismissal($add_data){
		try {
			$this->db->insert('perkara_panggilan_dismissal', $add_data);
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}
	
	function add_tgl_penetapan_dis($idperkara){
		try {
			$this->db->select('tanggal_penetapan');
			$this->db->where('perkara_id',$idperkara);
			return $this->db->get('perkara_dismissal');

		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function add_panggil_dismissal($data_add){
		try {				
				$this->db->simple_query("CALL perkara_proses_update(".$data_add['perkara_id'].", 12, 'Penetapan', 15, 'Panggilan Para Pihak','".$data_add['tanggal_panggilan']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
				$this->db->simple_query("CALL perkara_update_status(".$data_add['perkara_id'].");");
				return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function add_panggil_hapus($data_add){
		try {				
				$this->db->simple_query('DELETE FROM perkara_proses WHERE '.$data_add['perkara_id'].' AND tahapan_id=12 AND proses_id=15;');				
				$this->db->simple_query("CALL perkara_update_status(".$data_add['perkara_id'].");");
				return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function add_proses_dis_hapus($data_add){
		try {				
				$this->db->simple_query('DELETE FROM perkara_proses WHERE '.$data_add['perkara_id'].' AND tahapan_id=15 AND proses_id=214;');				
				$this->db->simple_query("CALL perkara_update_status(".$data_add['perkara_id'].");");
				return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function add_penetapan_dismissal_diterima($data_add){
		try {
			//bila data pemberitahuan di isi kemudian dirubah menjadi dismissal lolos
			$this->db->query("UPDATE `perkara_dismissal` SET `pemberitahuan_penggugat` = NULL ,`pemberitahuan_tergugat` = NULL WHERE `perkara_id` =".$data_add['perkara_id']);
			$this->db->query("DELETE FROM perkara_putusan WHERE perkara_id=".$data_add['perkara_id']);
			$this->db->query('DELETE FROM perkara_proses WHERE proses_id = 220 AND perkara_id = '.$data_add['perkara_id']);
			//end
			$this->db->query('DELETE FROM perkara_proses WHERE proses_id = 214 AND perkara_id = '.$data_add['perkara_id']);
			$this->db->simple_query("CALL perkara_proses_update(".$data_add['perkara_id'].", 12, 'Penetapan', 16, 'Penetapan Dismissal Diterima','".$data_add['tanggal_penetapan']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			$this->db->simple_query("CALL perkara_update_status(".$data_add['perkara_id'].");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function add_penetapan_dismissal_ditolak($data_add){
		try {
			$this->db->query('DELETE FROM perkara_proses WHERE proses_id = 16 AND perkara_id = '.$data_add['perkara_id']);									
			$this->db->simple_query("CALL perkara_proses_update(".$data_add['perkara_id'].", 15, 'Putusan', 214, 'Dismissal Ditolak','".$data_add['tanggal_penetapan']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			$this->db->simple_query("CALL perkara_update_status(".$data_add['perkara_id'].");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	/*function get_data_dismissal_tun($idperkara){
		try {
			$this->db->select('tanggal_penetapan,amar,hasil,pemberitahuan_tergugat,pemberitahuan_penggugat');
			$this->db->where('perkara_id',$idperkara);
			return $this->db->get('perkara_dismissal');

		} catch (Exception $e) {
			log_message('error', $e);
		}
	}*/
	function get_data_dismissal_tun($idperkara){		
		try {
			$query = $this->db->query('SELECT pd.tanggal_penetapan,pd.amar,pd.hasil,pd.pemberitahuan_tergugat,pd.pemberitahuan_penggugat,ptus.tanggal_putusan,ptus.tanggal_minutasi
						FROM perkara_dismissal AS pd
						LEFT JOIN perkara_putusan AS ptus ON pd.perkara_id=ptus.perkara_id
						WHERE pd.perkara_id='.$idperkara);
			return $query;			
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_panggilan_dismissal_tun($idperkara){
		try {
			$this->db->select('id,tanggal_panggilan,waktu,status,status_text');
			$this->db->where('perkara_id',$idperkara);
			return $this->db->get('perkara_panggilan_dismissal');

		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_panggilan_tun($id){
		try {
			$this->db->select('id,perkara_id,tanggal_panggilan,waktu,status,status_text');
			$this->db->where('id',$id);
			return $this->db->get('perkara_panggilan_dismissal');

		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	
}

?>