<?php 
if (!defined('BASEPATH')) exit('No direct script access allowed');
class m_template_relaas_agama extends CI_Model {

	function getDataPenetapanSidang($idperkara){
		try{
			if(!is_numeric($idperkara)){ return '';	}
			$sql = "SELECT a.penetapan_hari_sidang, a.sidang_pertama, b.tanggal_sidang,  b.jam_sidang
					FROM perkara_penetapan AS a, perkara_jadwal_sidang AS b
					WHERE a.perkara_id=b.perkara_id AND b.urutan=1 AND a.perkara_id=$idperkara";
			$query=$this->db->query($sql);
			return $query;
		}catch(Exception $e){ return false; }
	}

	function getDataPutusan($idperkara){
		try{
			if(!is_numeric($idperkara)){ return '';	}
			$sql = "SELECT * FROM perkara_putusan WHERE perkara_id=$idperkara";
			$query=$this->db->query($sql);
			return $query;
		}catch(Exception $e){ return false; }
	}
	
	function getDataPenetapanPanitera($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT * FROM 
						(SELECT perkara_id, panitera_id, tanggal_penetapan 
							FROM perkara_panitera_pn 
							WHERE perkara_id = $idperkara AND aktif='Y'
							GROUP BY panitera_id) AS ph
					LEFT JOIN
						(SELECT id, nama_gelar FROM panitera_pn) AS h
					ON ph.panitera_id = h.id";
			$query=$this->db->query($sql);
			return $query;
		}catch(Exception $e) { return false; }
	}

	function getRefJenisTahanan(){
		try{
			$sql = "SELECT * 
					FROM jenis_tahanan";
			$query=$this->db->query($sql);
			return $query;
		}catch(Exception $e) { return false; }
	}

	function getDataPerkara($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT A.nomor_perkara,A.nomor_surat,A.tanggal_surat, A.tanggal_pendaftaran, A.dakwaan,B.nama,B.id as id_jenis_perkara,A.jenis_perkara_text
					FROM perkara A LEFT JOIN jenis_perkara B ON A.jenis_perkara_id=B.id
					WHERE A.perkara_id =$idperkara";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getJenisPerkara($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT nama 
					FROM jenis_perkara 
					WHERE id=(SELECT jenis_perkara_id 
								FROM perkara 
								WHERE perkara_id=$idperkara)";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}
	function getDetailTanggalPersidangan($perkara_id){
		try{
			if(!is_numeric($perkara_id))
				{
					return '';
				}
			return $this->db->query('SELECT * FROM perkara_jadwal_sidang WHERE perkara_id='.$perkara_id);
			}catch(Exception $e) { return false; }
	}
	function getTanggalPersidangan($idjadwal){
		try{
			if(!is_numeric($idjadwal))
				{
					return '';
				}
			return $this->db->query('SELECT * FROM perkara_jadwal_sidang WHERE id='.$idjadwal);
			}catch(Exception $e) { return false; }
	}

	function getTanggalPersidanganikrar($idperkara){
		try{
				if(!is_numeric($idjadwal)){
				return '';
				}
			$sql = 'SELECT * FROM perkara_jadwal_sidang WHERE perkara_id= $idperkara order by id desc limit 1';
			//$query=$this->db->query($sql);
			//return $query;

			}catch(Exception $e) { return false; }
	}
	function getDataPA(){
		try{
			$sql = "SELECT * FROM 
					(SELECT value AS NamaPN FROM sys_config WHERE id = 62) AS T1,
					(SELECT value AS KetuaPNNama FROM sys_config WHERE id = 64) AS T2,
					(SELECT value AS AlamatPN FROM sys_config WHERE id = 63) AS T3,
					(SELECT value AS WakilKetuaPNNama FROM sys_config WHERE id = 66) AS T4,
					(SELECT value AS PansekPNNama FROM sys_config WHERE id = 68) AS T5,
					(SELECT value AS WaPanNama FROM sys_config WHERE id = 70) AS T6, 
					(SELECT value AS ZonaWaktu FROM sys_config WHERE id = 75) AS T7
					";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getAlurPerkaraId($idperkara){
		try {
			return $this->db->query('SELECT alur_perkara_id FROM perkara WHERE perkara_id = '.$idperkara.';')->row()->alur_perkara_id;
		} catch (Exception $e) {
			return FALSE;
		}
	}
	function getPengacaraPihak($idperkara){
		try{
			if(!is_numeric($idperkara))
				{
					return '';
				}
			return $this->db->query('SELECT id AS id_pihak,nama FROM perkara_pengacara WHERE perkara_id='.$idperkara);
			}catch(Exception $e) { return false; }
	}
	function getIDPengacaraPihak($idperkara,$pihakID){
		try{
			if(!is_numeric($idperkara) OR !is_numeric($pihakID)) { return ''; }
			$sql = "SELECT 	b.nomor_perkara,a.nama,a.urutan,a.pengacara_id AS id_pihak
					FROM perkara_pengacara a
					left join perkara b ON a.perkara_id=b.perkara_id
					WHERE a.perkara_id = $idperkara AND a.id=$pihakID
					ORDER BY a.id ASC";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}
	function get_data_pihak_loop($idperkara,$jenispihak){
		try {
			if(!is_numeric($idperkara)){
				return '';
			}
			// $sql="SELECT a.nomor_perkara, b.urutan, b.pihak_id as id_pihak,c.pengacara_id as id_kuasa,
			// 		d.nama, (year(now()) - year(d.tanggal_lahir)) as umur, e.nama as agama, 
			// 		d.pekerjaan, f.nama as pendidikan, d.alamat, c.nama as nama_kuasa, c.alamat as alamat_kuasa, c.aktif_mulai as tgl_kuasa
			// 		FROM perkara a 
			// 		join perkara_pihak".$jenispihak." b on a.perkara_id = b.perkara_id
			// 		left join perkara_pengacara c on a.perkara_id = c.perkara_id and b.pihak_id = c.pihak_id
			// 		join pihak d on b.pihak_id = d.id
			// 		join agama e on d.agama_id = e.id
			// 		join tingkat_pendidikan f on d.pendidikan_id = f.id
			// 		where a.perkara_id = ".$idperkara." 
			// 		order by b.urutan";
			$sql = "SELECT a.nomor_perkara, b.urutan, b.pihak_id as id_pihak,c.pengacara_id as id_kuasa,
					d.nama, (year(now()) - year(d.tanggal_lahir)) as umur, e.nama as agama, 
					d.pekerjaan, f.nama as pendidikan, d.alamat, c.nama as nama_kuasa, c.alamat as alamat_kuasa, c.aktif_mulai as tgl_kuasa
					FROM perkara a 
					left join perkara_pihak$jenispihak b on a.perkara_id = b.perkara_id
					left join 
						(select 
						case
							when (ca.jumlah = 1) then cb.nama 
							else concat(cb.nama, ' dan kawan-kawan')
							end as nama,
							cb.pengacara_id, cb.alamat, cb.aktif, cb.perkara_id, cb.pihak_id,cb.aktif_mulai
						from 
						(select COUNT(1) AS jumlah, id from perkara_pengacara caa 
						group by caa.pihak_id) ca
						left join perkara_pengacara cb on ca.id = cb.id) as c 
					on a.perkara_id = c.perkara_id and b.pihak_id = c.pihak_id
					left join pihak d on b.pihak_id = d.id
					left join agama e on d.agama_id = e.id
					left join tingkat_pendidikan f on d.pendidikan_id = f.id
					where a.perkara_id = $idperkara order by b.urutan";
			return $this->db->query($sql);
			} catch (Exception $e) {
				return '';
			}	
	}

	function get_data_pihak($idperkara,$jenispihak,$idpihak){
		try {
			if(!is_numeric($idperkara)){
				return '';
			}
			$sql="SELECT a.nomor_perkara, b.urutan, b.pihak_id as id_pihak,c.pengacara_id as id_kuasa,
					d.nama, (year(now()) - year(d.tanggal_lahir)) as umur, e.nama as agama, 
					d.pekerjaan, f.nama as pendidikan, d.alamat, c.nama as nama_kuasa, c.alamat as alamat_kuasa, c.aktif_mulai as tgl_kuasa
					FROM perkara a 
					join perkara_pihak".$jenispihak." b on a.perkara_id = b.perkara_id
					left join perkara_pengacara c on a.perkara_id = c.perkara_id and b.pihak_id = c.pihak_id
					join pihak d on b.pihak_id = d.id
					join agama e on d.agama_id = e.id
					left join tingkat_pendidikan f on d.pendidikan_id = f.id
					where a.perkara_id = ".$idperkara." and b.pihak_id = ".$idpihak." 
					order by b.urutan";
			return $this->db->query($sql);
			} catch (Exception $e) {
				return '';
			}	
	}
	function get_data_biaya_pihak($idperkara,$penggugat){
		try {
			if(!is_numeric($idperkara)){
				return '';
			}
			$sql="SELECT * FROM perkara_biaya 
					where perkara_id = ".$idperkara." and jenis_biaya_id = ".$penggugat." 
					LIMIT 1";
			return $this->db->query($sql);
			} catch (Exception $e) {
				return '';
			}	
	}
	function getAllPihak($idperkara){
		try{
			$sql = "SELECT * FROM hakim_pn";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getAllHakim(){
		try{
			$sql = "SELECT * FROM hakim_pn";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataPihak($pihak_id){
		try{
			if(!is_numeric($pihak_id)) { return ''; }
			$sql = "SELECT * 
					FROM pihak 
					WHERE id=$pihak_id";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataPanitera($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT DISTINCT perkara_id,urutan,panitera_id,panitera_nama,tanggal_penetapan 
					FROM perkara_panitera_pn 
					WHERE perkara_id=$idperkara";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataTerdakwa($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			 $sql="SELECT 		a.*
								,b.tempat_lahir
								,b.tanggal_lahir
								,b.jenis_kelamin
								,d.nama AS warga_negara
								,c.nama AS agama_nama
								,b.pekerjaan
							FROM perkara_pihak2 AS a
							LEFT JOIN pihak AS b
							ON b.id=a.pihak_id
							LEFT JOIN agama AS c
							ON c.id=b.agama_id
							LEFT JOIN negara AS d
							ON d.id=b.warga_negara_id
							
							WHERE a.perkara_id=$idperkara
							ORDER BY a.urutan";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataPihakTerdakwa1($idperkara, $idpihak){
		try{
			if(!is_numeric($idperkara) OR !is_numeric($idpihak)) { return ''; }
			$sql = "SELECT 	a.pihak_id, a.urutan, 
						b.nama, b.alamat, b.tempat_lahir, b.tanggal_lahir, b.jenis_kelamin, a.pangkat, a.nrp, a.jabatan, a.kesatuan,
						c.`nama` AS agama_nama, d.`nama` AS warga_negara, b.pekerjaan 
					FROM 		perkara_pihak2 a
					LEFT JOIN pihak AS b ON a.pihak_id=b.id
					LEFT JOIN agama AS c ON  b.`agama_id`=c.`id`
					LEFT JOIN negara AS d ON b.`warga_negara_id`=d.`id`
					WHERE a.perkara_id = $idperkara AND a.pihak_id=$idpihak
					ORDER BY urutan ASC";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataPenahananTerdakwa($idperkara,$idpihak){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT 	pihak_id,
							jp.id AS idjns_penahanan,
							jp.nama AS oleh, 
							sp.nama AS status_penahanan, 
							jt.nama AS jenis_tahanan,
							pt.mulai AS sejak, 
							pt.sampai, 
							pt.lama_penahanan,
							pt.tanggal_surat as tglPenetapan,
							pt.id ,
							pt.tanggal_surat, pt.nomor_surat 
					FROM (SELECT * FROM penahanan_terdakwa WHERE perkara_id = $idperkara AND pihak_id = $idpihak ORDER BY jenis_penahanan_id, mulai ASC) pt 
					LEFT JOIN jenis_penahanan jp ON pt.jenis_penahanan_id=jp.id
					LEFT JOIN status_penahanan sp ON pt.status_penahanan_id=sp.id
					LEFT JOIN jenis_tahanan jt ON pt.jenis_tahanan_id=jt.id
					ORDER BY jp.id" ;
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}
	
	function getDataPenahanan($idpenahanan){
		try{
		$sql= "SELECT 	A.id,
						A.perkara_id,
						A.pihak_id,
						B.nama AS jenis_penahanan,
						C.nama AS status_penahanan,
						D.nama AS jenis_tahanan,
						A.tanggal_surat,
						A.nomor_surat,
						A.mulai,
						A.sampai,
						A.waktu_penahanan,
						A.lama_penahanan,
						A.rutan_id,
						E.nama
				FROM penahanan_terdakwa A 
				LEFT JOIN jenis_penahanan B ON A.jenis_penahanan_id=B.id 
				LEFT JOIN status_penahanan C ON A.status_penahanan_id=C.id
				LEFT JOIN jenis_tahanan D ON A.jenis_tahanan_id=D.id
				LEFT JOIN lembaga_pemasyarakatan AS E ON A.rutan_id = E.id
				WHERE A.id=$idpenahanan ";				
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataHakim($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT * 
					FROM (SELECT perkara_id,urutan,jabatan_hakim_id, jabatan_hakim_nama, hakim_id, tanggal_penetapan 
							FROM perkara_hakim_pn 
							WHERE perkara_id = $idperkara AND aktif='Y'
							GROUP BY hakim_id) AS ph
					LEFT JOIN (SELECT id, nama_gelar FROM hakim_pn) AS h
					ON ph.hakim_id = h.id
					ORDER BY jabatan_hakim_id ASC";		
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false;	}
	}
	function getDataHakim_ketua($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT * 
					FROM (SELECT perkara_id,urutan,jabatan_hakim_id, jabatan_hakim_nama, hakim_id, tanggal_penetapan 
							FROM perkara_hakim_pn 
							WHERE perkara_id = $idperkara AND aktif='Y'
							GROUP BY hakim_id) AS ph
					LEFT JOIN (SELECT id, nama_gelar FROM hakim_pn) AS h
					ON ph.hakim_id = h.id
					WHERE jabatan_hakim_id ='1'
					ORDER BY jabatan_hakim_id ASC";		
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false;	}
	}
	function getDataPenetapanHakim($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT * 
					FROM (SELECT perkara_id,urutan,jabatan_hakim_id, jabatan_hakim_nama, hakim_nama, hakim_id,tanggal_penetapan,aktif
							FROM perkara_hakim_pn 
							WHERE perkara_id = $idperkara AND aktif='Y'
							GROUP BY hakim_id) AS ph
					LEFT JOIN (SELECT id, nama_gelar FROM hakim_pn) AS h
					ON ph.hakim_id = h.id
					ORDER BY urutan ASC";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}
 	function getDataJurusita($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT nama_gelar, jabatan, jurusita_id 
					FROM (SELECT *
							FROM perkara_jurusita
							WHERE perkara_id = $idperkara AND aktif='Y'
							GROUP BY jurusita_id) AS ph
					LEFT JOIN (SELECT id, nama_gelar, jabatan FROM jurusita) AS h
					ON ph.jurusita_id = h.id
					ORDER BY urutan ASC";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	} 
	function getIDJurusita($jurusitaID){
		try{
			if(!is_numeric($jurusitaID)) { return ''; }
			$sql = "SELECT B.nama_gelar AS jurusita_nama,B.keterangan AS jabatan
							FROM perkara_jurusita A
							LEFT JOIN jurusita B ON A.jurusita_id=B.id
							WHERE A.jurusita_id = $jurusitaID AND A.aktif='Y'
							ORDER BY A.id ASC";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	} 
	function getListJurusita(){
		try{
			$sql = "SELECT id, nama_gelar FROM jurusita";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	} 
	
	function getDataPP($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT B.nama_gelar,A.tanggal_penetapan FROM perkara_panitera_pn AS A LEFT JOIN panitera_pn AS B ON A.perkara_id=B.id WHERE A.perkara_id='$idperkara'";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}
	function getPenahananBefore($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT * FROM penahanan_terdakwa WHERE id = ";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getKejaksaan($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT IF(a.alamat <> '',a.alamat, b.kejaksaan) AS kejaksaan  FROM 
					perkara_pihak1 AS a
					LEFT JOIN  pihak_jaksa AS b ON a.pihak_id=b.pihak_id
					WHERE a.perkara_id='".$idperkara."' ";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}
	
	//PERADILAN AGAMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
	function blangko_relaas($alur){
		try{
			$sql = "SELECT kode,nama,nomor 
					FROM template_dokumen 
					WHERE 
					alur_perkara_id=".$alur." AND tahapan_id='14' AND proses_id='200' AND nomor >= 200 and nomor <= 350";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}
	function blangko_relaas_global(){
		try{
			$sql = "SELECT kode,nama,nomor 
					FROM template_dokumen 
					WHERE tahapan_id='14' AND proses_id='200' AND nomor >= 280 and nomor <= 290";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}
	function blangko_relaas_ikrar(){
		try{
			$sql = "SELECT kode,nama FROM template_dokumen 
						WHERE 
							alur_perkara_id='15' AND tahapan_id='18' AND proses_id='294' ORDER BY nama ASC";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	//PERADILAN AGAMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
}
?>