<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Perkara_tab_jurnal_keuangan_list extends CI_Controller {

	function index(){
		$functions = $this->nativesession->get_flash_session('function');
		$enc = $this->nativesession->get_flash_session('enc');
		$tmp = $this->encrypt->decode(base64_decode($enc));
		$tmp1 = explode('/', $tmp);
		if(count($tmp1)!=3){
			show_404();
		}
		$this->nativesession->set_flash_session('alur_id', $tmp1[0]);
		$this->nativesession->set_flash_session('colx', $tmp1[1]);
		$this->nativesession->set_flash_session('tahapan_id', $tmp1[2]);
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('dashboard');
		}
		$idalurperkara = $this->encrypt->decode(base64_decode($enc));
		if($functions == 'sort'){
			$col = $this->nativesession->get_flash_session('col');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->sort($col,$enc,$keyword);
		}elseif($functions == 'type'){
			$this->session->set_userdata('asc_desc','DESC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc,$idalurperkara);
		}elseif($functions == 'page'){
			$page = $this->nativesession->get_flash_session('page');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$column_sorted = $this->nativesession->get_flash_session('col');
			$this->showData($enc,$idalurperkara,$column_sorted,$page,$keyword);
		}elseif($functions == 'search'){
			$keyword ='';
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->session->set_userdata('keyword',$keyword);
			$page = $this->nativesession->get_flash_session('page');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc,$idalurperkara,2,$page,$keyword);

		}else{
			$this->session->set_userdata('asc_desc','DESC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData();
		}
	}

	function sort($col=null,$enc=null,$keyword=null){
		if($this->session->userdata('asc_desc')){
			if($this->session->userdata('asc_desc')=="DESC"){
				$this->session->set_userdata('asc_desc','ASC');
			}else{
				$this->session->set_userdata('asc_desc','DESC');
			}
		}else{
			$this->session->set_userdata('asc_desc','ASC');
		}
		$idalurperkara = $this->encrypt->decode(base64_decode($enc));
		$this->showData($enc,$idalurperkara,$col,0,$keyword);
	}

	function showData($enc=0,$idalurperkara='',$col=2,$start_page=0,$keyword=''){
		$asc_desc = $this->session->userdata('asc_desc');
		$this->load->model('dashboard/data_dashboard');
		if($start_page>0){
			$begin_limit = ($start_page-1)*50;
		}else{
			$begin_limit = 0;
			$start_page = 1;
		}
		$colx =  $this->nativesession->get_flash_session('colx');
		$tahapan_id =  $this->nativesession->get_flash_session('tahapan_id');
		$alur_id =  $this->nativesession->get_flash_session('alur_id');
		$mainurl = $alur_id.'/'.$colx.'/'.$tahapan_id;
		$enc = base64_encode($this->encrypt->encode($mainurl));
		if($colx<=4){
			if($colx==1){
				$tahapan=10;
				$sign='>';
			}elseif ($colx==2) {
				$tahapan=20;
				$sign='>';
			}elseif ($colx==3) {
				$tahapan=30;
				$sign='>';
			}elseif ($colx==4) {
				$tahapan=40;
				$sign='>';
			}
			$check_sql2 = "SELECT perkara_id FROM v_biaya_reminder WHERE alur_perkara_id='".$alur_id."' AND tahapan_id='".$tahapan."' ";
		//echo $check_sql2;
		}
		if($colx>=5){
			if($colx==5) {
				$tahapan=10;
				$sign='<';
			}elseif ($colx==6) {
				$tahapan=20;
				$sign='<';
			}elseif ($colx==7) {
				$tahapan=30;
				$sign='<';
			}elseif ($colx==8) {
				$tahapan=40;
				$sign='<';
			}
			$check_sql2 = "SELECT perkara_id FROM v_biaya_reminder_minus WHERE alur_perkara_id='".$alur_id."' AND tahapan_id='".$tahapan."' ";
		// echo $check_sql2;
		}
		$where="perkara_id IN (".$check_sql2.")";
		$query = $this->data_dashboard->getPerkaraTaskList($enc,$idalurperkara,$col,$asc_desc,$begin_limit,$keyword, $where);
		$data['list_perkara'] = $query;
		if($this->session->userdata('total_rows')){
			if($this->session->userdata('total_rows')==-1){
				$data['total_rows'] = $this->data_dashboard->fecth_data_num($idalurperkara,$keyword);
				$this->session->set_userdata('total_rows',$data['total_rows']);
			}else{
				$data['total_rows'] = $this->session->userdata('total_rows');
			}
		}else{
			$data['total_rows'] = $this->data_dashboard->fecth_data_num($idalurperkara,$keyword);
			$this->session->set_userdata('total_rows',$data['total_rows']);
		}
		$data['page_active'] = $begin_limit;
		if($colx<=4){
			$data['page_title'] = 'DAFTAR PERKARA YANG SISA PANJAR BELUM DIKEMBALIKAN';	
		}else{
			$data['page_title'] = 'DAFTAR PERKARA YANG PANJAR PERKARANYA HAMPIR HABIS (KURANG DARI RP100.000)';
		}
		
		$data['main_body'] = 'perkara_list/perkara_tab_jurnal_keuangan_list';
		$data['enc'] = $enc;
		$data['idalurperkara'] = $idalurperkara;
		$data['page_number'] = $start_page;
		$data['page_url'] = 'perkara_tab_jurnal_keuangan';
		$data['keyword'] = $keyword;
		$data['column_sorted'] = $col;
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body');
	}
}