<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Detil_banding extends CI_Controller {
	function index(){
		#prevent direct access to page
		#the user should only access the page through menu
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$idperkara = $this->nativesession->get_flash_session('perkara_id');		
		
		if(!is_numeric($idperkara)){
			show_404();
		}
		$view = $this->nativesession->get_flash_session('view');
		if($view==TRUE){
			$this->show_data_detil($idperkara);
		}else{
			$this->show_data($idperkara);
		}	
	}

	
        
        
       function show_data_detil($idperkara){
		$data['page_title'] = 'INFORMASI DETIL - PERMOHONAN BANDING';
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['main_history'] = $this->nativesession->get('main_url_requested');
		$data['history'] = $this->nativesession->get_flash_session('url_requested');		
		$this->load->model('perkara/banding','banding');
		$data['infobanding'] = $this->banding->fetchBanding($idperkara);
		$data['infobandingdetil'] = $this->banding->fetchBandingDetil($idperkara);
		$data['infomediasi'] = $this->banding->getDataMediasiBanding($idperkara);		
		$data['alur_perkara_id']=$this->tanggalhelper->getIDAlurPerkara($idperkara);
		$data['idjenisperkara'] = $this->tanggalhelper->getIDJenisPerkara($idperkara);
		
		$this->load->vars($data);
		$this->load->view('perkara_tab/banding');
	}

	function show_data($idperkara){		
		$data['page_title'] = 'INFORMASI DETIL - PERMOHONAN BANDING';
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['main_body'] = 'perkara/detil_banding';
		$data['main_history'] = $this->nativesession->get('main_url_requested');
		$data['history'] = $this->nativesession->get_flash_session('url_requested');		
		$this->load->model('perkara/banding','banding');
		$data['infobanding'] = $this->banding->fetchBanding($idperkara);
		$data['infobandingdetil'] = $this->banding->fetchBandingDetil($idperkara);
		$data['infomediasi'] = $this->banding->getDataMediasiBanding($idperkara);		
		#integrasi 22/04/2017
                $this->load->model('api/dirput_model','dirput');
                $put_dirput = $this->dirput->putusan_dirput($idperkara,'perkara_banding','amar_putusan_banding_dok');
                $this->session->set_userdata('perkaraid',$idperkara);
                $alurperdatakhusus=array(3,4,5,6,7,8);		
	        if (in_array($this->tanggalhelper->getIDAlurPerkara($idperkara), $alurperdatakhusus))
			  {
			  $data['alur_perkara_id']=3;
			  } else {
			  $data['alur_perkara_id']=$this->tanggalhelper->getIDAlurPerkara($idperkara);
			  }
		$data['perkaraid']=$idperkara;		
                $data['dirput'] = $this->dirput->create_dirput($idperkara);			
		$data['doc_referensi'] = $this->dirput->doc_ref($this->session->userdata('jenis_pengadilan'),2,$data['alur_perkara_id']);			
                $data['putusanbanding'] = $put_dirput[0]['file_id'];
                $data['surat_pengantar'] = $this->dirput->ambil_pengantar($idperkara,2);
                $data['pengajuan'] = $this->dirput->ambil_pengajuan($idperkara,2);		
		$data['perkaraid_banding']=$idperkara;
		$data['jenispengadilan_banding']=$this->session->userdata('jenis_pengadilan');
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '850px';
		$this->ckeditor->config['height'] = '150px';	
                $this->ckeditor->config['readOnly'] ='true';
		#-----------------------------------------------------------------------------
                $this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}
	/*27-11-2016*/
	function mediasi(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();							
		$data['enc'] = $segment[2];
		$data['idperkara'] = $this->encrypt->decode(base64_decode($segment[2]));						
		if(empty($data['idperkara']) OR intval($data['idperkara'])<1){
			show_404();
		}
		$data['enc_tahapan'] = $segment[3];
		$tahapan = $this->encrypt->decode(base64_decode($segment[3]));
		if(empty($tahapan) OR intval($tahapan)<1){
			show_404();
		}

		$func = $segment[4];	
		if($func!='tambah' AND $func!='edit'){
			show_404();
		}
		$data['enc_id'] = '';
		if($func=='edit'){
			$data['enc_id'] = $segment[5];
		}		
		$data['enc_act'] = base64_encode($this->encrypt->encode($func));		
		$data['history'] = base_url(uri_string());
		$data['current_date'] =date('d/m/Y');
		$this->load->model('perkara/banding','banding');
		$data['listmediator'] = $this->banding->getDataMediator();
		$data['infomediasi'] = $this->banding->getDataMediasi($data['idperkara'],$tahapan);

		if($tahapan==20){
			$table 				= 'perkara_banding';
			$data['permohonan'] = 'Banding';
			$data['kirim_ke'] 	= 'Tingkat Banding';
		}elseif($tahapan==30){
			$table 				= 'perkara_kasasi';
			$data['permohonan'] = 'Kasasi';
			$data['kirim_ke'] 	= 'MA';
		}elseif($tahapan==40){
			$table 				= 'perkara_pk';
			$data['permohonan'] = 'Peninjauan Kembali';
			$data['kirim_ke'] 	= 'MA';
		}

		$dataperkara = $this->banding->getDataUpayaHukum($data['idperkara'],$table);
		if($dataperkara!=''){
			if($dataperkara->num_rows>0){
				foreach ($dataperkara->result() as $row) {
					$data['noperkarapn'] = $row->nomor_perkara_pn;
					if($tahapan==20)
						$data['tglpermohonan'] = $this->tanggalhelper->convertDayDate($row->permohonan_banding);
					elseif($tahapan==30)
						$data['tglpermohonan'] = $this->tanggalhelper->convertDayDate($row->permohonan_kasasi);
					elseif($tahapan==40)
						$data['tglpermohonan'] = $this->tanggalhelper->convertDayDate($row->permohonan_pk);
				}
			}else{
				show_404();
			}
		}else{
			show_404();
		}
		
		if($func=='edit'){
			if(($data['infomediasi'])!=''){
				if($data['infomediasi']->num_rows>0){
					foreach ($data['infomediasi']->result() as $row) {					
						$data['idperkara'] 		= base64_encode($this->encrypt->encode($row->perkara_id));
						$data['idmediasi'] 		= base64_encode($this->encrypt->encode($row->mediasi_id));						
						$data['tanggal_kesepakatan'] 	= $this->tanggalhelper->convertToInputDate($row->tgl_kesepakatan_perdamaian);
						$data['tanggal_pengajuan'] 	= $this->tanggalhelper->convertToInputDate($row->tgl_pengajuan_kesepakatan);						
						$data['idmediator'] 			= $row->mediator_id;
						$data['status_mediator'] 		= $row->status_mediator;
						$data['mediator_text'] 			= $row->mediator_text;
						$data['tanggal_pengiriman'] 	= $this->tanggalhelper->convertToInputDate($row->tgl_kirim_kesepakatan_ke_ptma);
						$data['isi_kesepakatan'] 		= $row->isi_kesepakatan_perdamaian;
						$data['keterangan']		 		= $row->catatan_mediasi;
					}
				}else{
					show_404();
				}
			}else{
				show_404();
			}			 
		}
		$this->load_ckeditor();
		$this->load->vars($data);
		$this->load->view('perkara/banding/edit_mediasi_banding');
	}

	function load_ckeditor(){
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = 'aut0';
		$this->ckeditor->config['height'] = '150%';
	}	

	function savemediasi(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$tahapanid = $this->encrypt->decode(base64_decode($this->input->post('enc_tahapan',TRUE)));
		if(!is_numeric($tahapanid) OR intval($tahapanid)<1){
			echo json_encode(array('st'=>0,'msg'=>'Tahapan Perkara Tidak Ditemukan.'));
			return;
		}

		$act = $this->encrypt->decode(base64_decode($this->input->post('enc_act',TRUE)));
		if($act !='tambah' AND $act !='edit'){
			echo json_encode(array('st'=>0,'msg'=>'Something Wrong With Your Data.'));
			return;
		}

		if($act=='edit'){
			$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
			if(!is_numeric($id) OR intval($id)<1){
				echo json_encode(array('st'=>0,'msg'=>'Something Wrong With Your Data.'));
				return;
			}
			$mediasi_id = $this->encrypt->decode(base64_decode($this->input->post('mediasi_id',TRUE)));
			if(!is_numeric($mediasi_id) OR intval($mediasi_id)<1){
				echo json_encode(array('st'=>0,'msg'=>'Something Wrong With Your Data.'));
				return;
			}
		}	
		$jml_mediator = count($_POST["mediator"]);
		for($i=0; $i<$jml_mediator; $i++){
			$this->form_validation->set_rules('mediator['.$i.']', 'Nama Mediator', 'trim|xss_clean');
		}
		
		$this->form_validation->set_rules('tgl_kesepakatan', 'Tanggal Kesepakatan Perdamaian', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('tgl_pengajuan', 'Tanggal Pengajuan Kesepakatan Perdamaian', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('isi_kesepakatan_text', 'Isi Kesepakatan Perdamaian', 'trim|xss_clean|min_length[50]');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$curr_date 			= date('Y-m-d');
			$todayDate			= date('d/m/Y');			
			$tgl_kesepakatan 	= $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_kesepakatan',TRUE));
			$tgl_pengajuan 		= $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pengajuan',TRUE));			
			$tgl_pengiriman 	= $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pengiriman',TRUE));
			
			if(!empty($tgl_kesepakatan) AND $tgl_kesepakatan==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Kesepakatan Perdamaian Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			if(!empty($tgl_pengajuan) AND $tgl_pengajuan==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Pengajuan Kesepakatan Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			if(!empty($tgl_pengiriman) AND $tgl_pengiriman==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Pengiriman Kesepakatan Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}
						
			$selisihPermohonan = $this->tanggalhelper->getSelisihHari($tgl_kesepakatan,$curr_date);
			if($selisihPermohonan<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Kesepakatan Perdamaian Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}
			$selisihPenetapan = $this->tanggalhelper->getSelisihHari($tgl_pengajuan,$curr_date);
			if($selisihPenetapan<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pengajuan Kesepakatan Perdamaian Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}
			$selisihPenetapan = $this->tanggalhelper->getSelisihHari($tgl_pengiriman,$curr_date);
			if($selisihPenetapan<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pengiriman Kesepakatan Perdamaian Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}
			$dayname = $this->tanggalhelper->getDayName($tgl_pengajuan);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Di Dihari Libur, Sabtu dan Minggu.'));
				return;
			}
			$dayname = $this->tanggalhelper->getDayName($tgl_pengiriman);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Di Dihari Libur, Sabtu dan Minggu.'));
				return;
			}
			if(!empty($tgl_pengajuan) AND $tgl_pengajuan<$tgl_kesepakatan){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pengajuan Kesepakatan Perdamaian Tidak Boleh Kurang dari Tanggal Kesepakatan Perdamaian'));
				return;
			}
			if(!empty($tgl_pengiriman) AND $tgl_pengiriman<$tgl_pengajuan){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pengiriman Kesepakatan Perdamaian Tidak Boleh Kurang dari Tanggal Pengajuan Perdamaian'));
				return;
			}

			$amar = trim($this->input->post('isi_kesepakatan_text',TRUE));
			$amar = strip_tags($amar);
			$amar = htmlentities($amar, null, 'utf-8');
			$amar = str_replace("&nbsp;", " ", $amar);
			if(strlen($amar)<50){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Isi Kesepakatan Tidak Boleh kurang dari 50 Karakter'));
				return;
			}
			
			$this->load->model('perkara/banding','banding');				
			$arr_mediator_id 	= array();
			foreach($this->input->post('mediatorid') as $val){
				$arr_mediator_id[] = $this->encrypt->decode(base64_decode($val,TRUE));
			}
			$arr 				= $this->input->post('mediator');
			$arr_status			= $this->input->post('status');
			$mediator_text		= implode("<br/>", $arr);
			$status 			= implode(",",$arr_status);
			$mediator_id 		= implode(',',$arr_mediator_id);
			
			$datamediasi = array(
				'perkara_id' 					=> $idperkara,
				'tahapan_id' 					=> $tahapanid,
				'jenis_mediasi' 				=> 2,
				'is_mediasi'					=> 1,  
				'mediator_id' 					=> $mediator_id,
				'status_mediator' 				=> $status,
				'mediator_text'					=> $mediator_text,
				'tgl_kesepakatan_perdamaian' 	=> $tgl_kesepakatan,
				'tgl_pengajuan_kesepakatan' 	=> $tgl_pengajuan,
				'isi_kesepakatan_perdamaian' 	=> $amar,
				'tgl_kirim_kesepakatan_ke_ptma' => $tgl_pengiriman,
				'catatan_mediasi' 				=> $this->input->post('keterangan',TRUE)
			);																
			if($act=='edit'){
				$datamediasi['diperbaharui_oleh'] 		= $this->session->userdata('username');
				$datamediasi['diperbaharui_tanggal'] 	= date("Y-m-d h:i:s",time());
				$result = $this->banding->update_data_mediasi($datamediasi,$id);				
			}else if($act=='tambah'){
				$maxid=$this->banding->get_maxid_mediasi();
				foreach ($maxid->result() as $row){
					$maxid_mediasi=$row->maxid;
				}
				$id_mediasi_akhir				= intval($maxid_mediasi)+1;
				$datamediasi['mediasi_id'] 		= $id_mediasi_akhir;
				$datamediasi['diinput_oleh'] 	= $this->session->userdata('username');
				$datamediasi['diinput_tanggal'] = date("Y-m-d h:i:s",time());
				$result = $this->banding->add_data_mediasi($datamediasi);						
			}
			
			if($result==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Gagal Melakukan Penyimpanan.'));
				return;
			}
		}
	}	

	function hapus_mediasi(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$tahapanid = $this->encrypt->decode(base64_decode($this->input->post('enc_tahapan',TRUE)));
		if(!is_numeric($tahapanid) OR intval($tahapanid)<1){
			echo json_encode(array('st'=>0,'msg'=>'Tahapan Perkara Tidak Ditemukan.'));
			return;
		}
		
		$this->load->model('perkara/banding','banding');
		if($this->banding->hapus_mediasi($idperkara,$tahapanid)){			
			echo json_encode(array('st'=>1,'msg'=>'Penghapusan Data Mediasi Berhasil'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'));
			return;
		}
	}

	function hapus_putusan_banding(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$jenis_form = $this->input->post('jenis_form',TRUE);
		if($jenis_form==1){
			$databanding = array(
					'putusan_banding' => NULL,
					'nomor_perkara_banding' => NULL,
					'nomor_putusan_banding' => NULL,
					'status_putusan_banding_id' => NULL,
					'status_putusan_banding_text' => NULL,
					'amar_putusan_banding' => NULL,
					'hakim1_banding_id' => NULL,
					'hakim1_banding' => NULL,
					'hakim2_banding_id' => NULL,
					'hakim2_banding' => NULL,
					'hakim3_banding_id' => NULL,
					'hakim3_banding' => NULL,
					'hakim4_banding_id' => NULL,
					'hakim4_banding' => NULL,
					'hakim5_banding_id' => NULL,
					'hakim5_banding' => NULL,
					'majelis_hakim_banding' => NULL,
					'panitera_pengganti_banding_id' => NULL,
					'panitera_pengganti_banding' => NULL,
					'minutasi_banding' => NULL,
					'penerimaan_kembali_berkas_banding' => NULL,
					'diperbaharui_oleh' => $this->session->userdata('username'),
					'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())				
				);
		}else{
			$databanding = array(					
					'minutasi_banding' => NULL,
					'penerimaan_kembali_berkas_banding' => NULL,
					'diperbaharui_oleh' => $this->session->userdata('username'),
					'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())				
				);
		}

		$this->load->model('perkara/banding','banding');
		if($this->banding->hapus_putusan($idperkara,$databanding)){	
			if($jenis_form==1){		
				echo json_encode(array('st'=>1,'msg'=>'Penghapusan Data Putusan Banding Berhasil'));
			}else{
				echo json_encode(array('st'=>1,'msg'=>'Penghapusan Data Penerimaan Berkas Berhasil'));
			}
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'));
			return;
		}
	}


	/*27-11-2016*/

	function parapihak(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$data['enc_id'] = $segment[3];
		$data['id'] = $this->encrypt->decode(base64_decode($segment[3]));
		if(empty($data['id']) OR intval($data['id'])<1){
			show_404();
		}
		$data['current_date'] =date('d/m/Y');
		$data['history'] = base_url(uri_string());
		$this->load->model('perkara/banding','banding');
		$data['infopihak'] = $this->banding->getPihakBanding($data['id']);
		$this->load->vars($data);
		$this->load->view('perkara/banding/edit_para_pihak');
	}

	function saveparapihak(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}
		$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
		if(empty($id) OR intval($id)<1){
			echo json_encode(array('st'=>0,'msg'=>'Permohonan Banding Tidak Ditemukan.'));
			return;
		}

		$diwakilkan = $this->input->post('diwakilkan',TRUE);
		if(empty($diwakilkan) OR !is_numeric($diwakilkan)){
			echo json_encode(array('st'=>0,'msg'=>'Something Not Right With The Data.'));
			return;
		}
		if($diwakilkan==1){
			$diwakilkan = 'Y';
			$this->form_validation->set_rules('fullname', 'Nama Pemohon', 'trim|required|xss_clean');
			$this->form_validation->set_rules('tgl_surat_kuasa', 'Tanggal Surat Kuasa', 'required|trim|xss_clean|exact_length[10]');
		}else{
			$diwakilkan = 'T';
		}
		$this->form_validation->set_rules('diwakilkan', 'Status Diwakilkan', 'trim|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$datapihak = array(
				'id' => $id,
				'pihak_diwakili' => $diwakilkan,
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);
			$idpihak = $this->encrypt->decode(base64_decode($this->input->post('enc_pihak',TRUE)));
			
			if(empty($idpihak) OR intval($idpihak)<1){
				echo json_encode(array('st'=>0,'msg'=>'Something Not Right With Your Data.'));
				return;
			}
			$this->load->model('perkara/banding',"banding");
			$pihak = $this->banding->getDataPihak($idpihak);
			if($pihak!=''){
				if($pihak->num_rows>0){
					foreach ($pihak->result() as $row) {
						$datapihak['pemohon_id'] = $row->id;
						$datapihak['pemohon_nama'] = $row->nama;
						$datapihak['pemohon_alamat'] = $row->alamat;
						$datapihak['pemohon_pekerjaan'] = $row->pekerjaan;
					}
				}
			}

			if($diwakilkan=='Y'){
				$infopihak = $this->banding->getPihakBanding($id);
				if($infopihak!=''){
					if($infopihak->num_rows>0){
						foreach ($infopihak->result() as $row) {
							$namapihak = $row->pihak_nama;
							$statusasal = $row->pihak_asal_text;
						}
					}
					$datapihak['pemohon_banding'] = $datapihak['pemohon_nama'].' Kuasa Dari '.$statusasal.':<br>'.$namapihak;
					$tglsuratkuasa = $this->input->post('tgl_surat_kuasa',TRUE);
					if(!empty($tglsuratkuasa)){
						$datapihak['pemohon_tanggal_surat'] = $this->tanggalhelper->convertToMysqlDate($tglsuratkuasa);
					}
					if($this->input->post('no_kuasa',TRUE))
						$datapihak['pemohon_nomor_surat'] = $this->input->post('no_kuasa',TRUE);
				}	
			}
			$result = $this->banding->update_data($datapihak,$id);
			if($result==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DISIMPAN.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL Melakukan Penyimpanan.'));
				return;
			}
		}
	}

	function permohonan(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$data['enc_id'] = $segment[3];
		$data['id'] = $this->encrypt->decode(base64_decode($segment[3]));
		$data['enc'] = $segment[2];
		$idperkara = $this->encrypt->decode(base64_decode($segment[2]));
		if(empty($data['id']) OR intval($data['id'])<1){
			show_404();
		}
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}

		$data['history'] = base_url(uri_string());
		$data['current_date'] =date('d/m/Y'); 
		$this->load->model('perkara/banding','banding');

		$data['infopihak'] = $this->banding->getPihakBanding($data['id']);
		$idalurperkara = $this->banding->getAlurPerkara($idperkara);
		$data['enc_alur']=base64_encode($this->encrypt->encode($idalurperkara));
		
		$stpihak = $this->banding->getStatusPihak($idalurperkara);
		if($stpihak!=''){
			if($stpihak->num_rows>0){
				foreach ($stpihak->result() as $row) {
					$statuspihak[$row->pihak_ke] = $row->nama;
				}
			}
		}
		$data['statuspihak'] = $statuspihak;
		$data['idalurperkara'] = $idalurperkara;
		$this->load->vars($data);
		$this->load->view('perkara/banding/edit_permohonan_banding');
	}

	function savepermohonan(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}
		$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
		if(empty($id) OR intval($id)<1){
			echo json_encode(array('st'=>0,'msg'=>'Permohonan Banding Tidak Ditemukan.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->form_validation->set_rules('tgl_pendaftaran', 'Tanggal Pendaftaran', 'trim|required|xss_clean|exact_length[10]');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$tglPendaftaran = $this->input->post('tgl_pendaftaran',TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tglPendaftaran = $this->tanggalhelper->convertToMysqlDate($tglPendaftaran);
			if($tglPendaftaran==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPendaftaran,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pendaftaran Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglPendaftaran);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pendaftaran Dihari Libur, Sabtu dan Minggu.'));
				return;
			}
 
			$tglcabut = '';
			$tglPutusanPN = '';
			$this->load->model('perkara/banding','banding');
			$dataputusan = $this->banding->getTanggalPutusan($idperkara);
			if($dataputusan->num_rows>0){
				foreach ($dataputusan->result() as $row) {
					$tglPutusanPN = $row->tanggal_putusan;
					$tglcabut = $row->tanggal_cabut;
				}
			}
			if(!empty($tglcabut)){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Dapat Dimohonkan Banding Karena Telah Dicabut.'));
				return;
			}

			if(empty($tglPutusanPN)){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Dapat Dimohonkan Banding Karena Belum Putus.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusanPN,$tglPendaftaran);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Permohonan Tidak Boleh Kurang Dari Tanggal Putusan'));
				return;
			}

			
			$datapihak = array(
				'permohonan_banding' => $tglPendaftaran,
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);
			$result = $this->banding->update_data($datapihak,$id);

			$databanding = $this->banding->getPihakBanding($id);
			$idstatus = '';
			$urutan ='';
			if($databanding->num_rows>0){
				foreach ($databanding->result() as $row) {
					$idstatus = $row->status_pihak_id;
					$urutan = $row->urutan_banding;
				}
			}
			if(!empty($idstatus) AND !empty($urutan)){
				if($idstatus==1 AND $urutan==1){
					$datapihak = array(
						'permohonan_banding' => $tglPendaftaran,
						'diperbaharui_oleh' => $this->session->userdata('username'),
						'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);
					$result = $this->banding->update_data_banding($datapihak,$idperkara);
				}
			}
			if($result==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DISIMPAN.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN PENYIMPANAN.'));
				return;
			}
		}
	}

	function cabut(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$data['enc_id'] = $segment[3];
		$data['id'] = $this->encrypt->decode(base64_decode($segment[3]));
		$data['enc'] = $segment[2];
		$idperkara = $this->encrypt->decode(base64_decode($segment[2]));
		if(empty($data['id']) OR intval($data['id'])<1){
			show_404();
		}
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}

		$data['history'] = base_url(uri_string());
		$data['current_date'] =date('d/m/Y'); 
		$this->load->model('perkara/banding','banding');
		$data['infopihak'] = $this->banding->getPihakBanding($data['id']);
		$this->load->vars($data);
		$this->load->view('perkara/banding/cabut_permohonan_banding');
	}

	function savecabut(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}

		$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
		if(empty($id) OR intval($id)<1){
			echo json_encode(array('st'=>0,'msg'=>'Permohonan Banding Tidak Ditemukan.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->form_validation->set_rules('tgl_cabut', 'Tanggal Pencabutan Perkara', 'trim|required|xss_clean|exact_length[10]');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$tglCabut = $this->input->post('tgl_cabut',TRUE);
			$tglCabut = $this->tanggalhelper->convertToMysqlDate($tglCabut);
			if($tglCabut==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			//$curr_date = date('d/m/Y');
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$selisih = $this->tanggalhelper->getSelisihHari($tglCabut,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pencabutan Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglCabut);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pencabutan Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusanPN = '';
			$this->load->model('perkara/banding','banding');
			$dataputusan = $this->banding->getTanggalPutusan($idperkara);
			if($dataputusan->num_rows>0){
				foreach ($dataputusan->result() as $row) {
					$tglPutusanPN = $row->tanggal_putusan;
				}
			}
			
			//echo $tglPutusanPN;
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusanPN,$tglCabut);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pencabutan Tidak Boleh Kurang Dari Tanggal Putusan PN'));
				return;
			}

			
			$datapihak = array(
				'tanggal_cabut' => $tglCabut,
				'keterangan' => $this->input->post('keterangan',TRUE),
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);
			$result = $this->banding->update_data($datapihak,$id);
			$databanding = $this->banding->getPihakBanding($id);
			$idstatus = '';
			$urutan ='';
			if($databanding->num_rows>0){
				foreach ($databanding->result() as $row) {
					$idstatus = $row->status_pihak_id;
					$urutan = $row->urutan_banding;
				}
			}
			$pihakbanding = $this->banding->getListPihakBanding($idperkara);
			if(!empty($pihakbanding)){
				if($pihakbanding->num_rows>0){
					foreach ($pihakbanding->result() as $row) {
						$idstatus = $row->status_pihak_id;
						$urutan = $row->urutan_banding;
					}
				}
			}

			$isAllCabut = $this->banding->isAllCabut($idperkara);

			if($isAllCabut->num_rows>0){
				$datapihak = array(
						'tanggal_cabut' => $tglCabut,
						'status_banding_id' => 391,
						'minutasi_banding' => $tglCabut,
						'status_banding_text' => 'Pencabutan Perkara Banding',
						'diperbaharui_oleh' => $this->session->userdata('username'),
						'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);
				$result = $this->banding->update_data_banding($datapihak,$idperkara);
				
			}
			$result = $this->banding->addPerkaraProses($idperkara,'391','Pencabutan Perkara Banding',$tglCabut);
			$result = $this->banding->updatePerkaraProses($idperkara);
			if($result==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DISIMPAN.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN PENYIMPANAN.'));
				return;
			}
		}
	}

	function edittanggal(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$data['enc_id'] = $segment[3];
		$data['id'] = $this->encrypt->decode(base64_decode($segment[3]));
		$data['enc'] = $segment[2];
		$idperkara = $this->encrypt->decode(base64_decode($segment[3]));
		if(empty($data['id']) OR intval($data['id'])<1){
			show_404();
		}
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}
		$func = $segment[4];
		if(empty($func) OR intval($func)<1){
			show_404();
		}
		$data['enc_func'] = base64_encode($this->encrypt->encode($segment[4]));
		$data['openinput'] = 2;
		$this->load->model('perkara/banding','banding');
		$infopihaks = $this->banding->getPihakBanding($data['id']);
		if($infopihaks!=''){
			if($infopihaks->num_rows>0){
				foreach ($infopihaks->result() as $row) {
					$data['namapihak'] = $row->pihak_nama;
					$data['statusbanding'] = $row->status_pihak_text.' Ke-'.$row->urutan_banding;
					$data['noperkarapn'] = $row->nomor_perkara_pn;
					$data['tglpermohonan'] = $this->tanggalhelper->convertToInputDate($row->permohonan_banding);
					$data['idpihak'] = base64_encode($this->encrypt->encode($row->pihak_id));
					$data['idperkara'] = base64_encode($this->encrypt->encode($row->perkara_id));
				}
			}
		}else{
			show_404();
		}
		if($func==1){
			$data['title'] = "EDIT - TANGGAL PEMBERITAHUAN PERMOHONAN BANDING";
			$data['subtitle'] = 'Tanggal Pemberitahuan Permohonan';
			$data['tanggal'] = $this->tanggalhelper->convertToInputDate($infopihaks->row()->pemberitahuan);
		}elseif($func==2){
			$data['title'] = "EDIT - TANGGAL PENERIMAAN MEMORI BANDING";
			$data['subtitle'] = 'Tanggal Penerimaan Memori';
			$data['tanggal'] = $this->tanggalhelper->convertToInputDate($infopihaks->row()->pen_memori);
		}elseif($func==3){
			$data['title'] = "EDIT - TANGGAL PENYERAHAN MEMORI BANDING";
			$data['subtitle'] = 'Tanggal Penyerahan Memori';
			$data['tanggal'] = $this->tanggalhelper->convertToInputDate($infopihaks->row()->peny_memori);
		}elseif($func==4){
			$data['title'] = "EDIT - TANGGAL PENERIMAAN KONTRA MEMORI BANDING";
			$data['subtitle'] = 'Tanggal Penerimaan Kontra';
			$data['tanggal'] = $this->tanggalhelper->convertToInputDate($infopihaks->row()->pen_kontra);
		}elseif($func==5){
			$data['title'] = "EDIT - TANGGAL PENYERAHAN KONTRA MEMORI BANDING";
			$data['subtitle'] = 'Tanggal Penyerahan Kontra';
			$data['tanggal'] = $this->tanggalhelper->convertToInputDate($infopihaks->row()->peny_kontra);
		}elseif($func==6){
			$data['title'] = "EDIT - TANGGAL PEMBERITAHUAN INZAGE";
			$data['subtitle'] = 'Tanggal Pemberitahuan Inzage';
			$data['tanggal'] = $this->tanggalhelper->convertToInputDate($infopihaks->row()->pen_inzage);
		}elseif($func==8){
			$data['title'] = "EDIT - TANGGAL PEMBERITAHUAN PUTUSAN BANDING";
			$data['subtitle'] = 'Tanggal Pemberitahuan Putusan';
			$data['tanggal'] = $this->tanggalhelper->convertToInputDate($infopihaks->row()->pen_putus);
		}elseif($func==7){
			$result = $this->banding->getDataBanding($idperkara);
			if($result!=''){
				if($result->num_rows>0){
					foreach ($result->result() as $row) {
						$data['idperkara'] = base64_encode($this->encrypt->encode($row->perkara_id));
						$data['tanggal'] = $this->tanggalhelper->convertToInputDate($row->pengiriman_berkas_banding);
						$data['input_area'] = $row->nomor_surat_pengiriman_berkas_banding;
					}
				}else{
					show_404();
				}
			}else{
				show_404();
			}
			$data['title'] = "EDIT - TANGGAL PENGIRIMAN BERKAS BANDING";
			$data['subtitle'] = 'Tanggal Pengiriman Berkas';
			$data['openinput'] = 1;
			$data['inputsubtitle'] = 'Nomor Surat Pengiriman Berkas Banding';
		}else{
			show_404();
		}
		$data['history'] = base_url(uri_string());
		$data['current_date'] =date('d/m/Y'); 
		
		$this->load->vars($data);
		$this->load->view('perkara/banding/edit_tanggal');
	}

	function savetanggal(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}

		$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
		if(empty($id) OR intval($id)<1){
			echo json_encode(array('st'=>0,'msg'=>'Permohonan Banding Tidak Ditemukan.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$func = $this->encrypt->decode(base64_decode($this->input->post('enc_func',TRUE)));
		if(empty($func) OR intval($func)<1){
			echo json_encode(array('st'=>0,'msg'=>'Something Wrong With Your Data.'));
			return;
		}

		$this->form_validation->set_rules('tanggal', 'Tanggal', 'trim|required|xss_clean|exact_length[10]');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$tanggal = $this->input->post('tanggal',TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tanggal = $this->tanggalhelper->convertToMysqlDate($tanggal);
			if($tanggal==FALSE){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tanggal);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusanPN = '';
			$this->load->model('perkara/banding','banding');
			$dataputusan = $this->banding->getTanggalPutusan($idperkara);
			if($dataputusan->num_rows>0){
				foreach ($dataputusan->result() as $row) {
					$tglPutusanPN = $row->tanggal_putusan;
				}
			}
		
			if(empty($tglPutusanPN)){
				echo json_encode(array('st'=>0,'msg'=>'Tanggal Putusan Tingkat Pertama Tidak Diketemukan.'));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusanPN,$tanggal);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Tidak Boleh Kurang Dari Tanggal Putusan PN'));
				return;
			}

			$tgl_permohonan_banding =$this->banding->getDataBanding($idperkara);
			if($tgl_permohonan_banding->num_rows>0){
				foreach ($tgl_permohonan_banding->result() as $row) {
					$tgl_mohon_banding = $row->permohonan_banding;
				}
			}
			if(empty($tgl_mohon_banding)){
				echo json_encode(array('st'=>0,'msg'=>'Tanggal Permohonan Banding Tidak Diketemukan.'));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($tgl_mohon_banding,$tanggal);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Tidak Boleh Kurang Dari Tanggal Permohonan Banding'));
				return;
			}

			$datapihak = array(
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);
			$databanding = $datapihak;
			$tglputusanbanding = $this->banding->getTanggalPutusanBanding($idperkara);
			if($func==1){
				if(!empty($tglputusanbanding)){
					$selisih = $this->tanggalhelper->getSelisihHari($tglputusanbanding,$tanggal);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Permohonan Banding Tidak Boleh Kurang Dari Tanggal Putusan Banding'));
						return;
					}
				}
				$datapihak['pemberitahuan_permohonan_banding'] = $tanggal;
				$databanding['pemberitahuan_permohonan_banding'] = $tanggal;
				$dataproses['status_banding_id'] = 301;
				$dataproses['status_banding_text'] = 'Pemberitahuan Permohonan Banding';
			}elseif($func==2){
				if(!empty($tglputusanbanding)){
					$selisih = $this->tanggalhelper->getSelisihHari($tglputusanbanding,$tanggal);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penerimaan Memori Banding Tidak Boleh Kurang Dari Tanggal Putusan Banding'));
						return;
					}
				}
				$datapihak['penerimaan_memori_banding'] = $tanggal;
				$databanding['penerimaan_memori_banding'] = $tanggal;
				$dataproses['status_banding_id'] = 310;
				$dataproses['status_banding_text'] = 'Penerimaan Memori Banding';
			}elseif($func==3){
				if(!empty($tglputusanbanding)){
					$selisih = $this->tanggalhelper->getSelisihHari($tglputusanbanding,$tanggal);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penyerahan Memori Banding Tidak Boleh Kurang Dari Tanggal Putusan Banding'));
						return;
					}
				}
				$datapihak['penyerahan_memori_banding'] = $tanggal;
				$databanding['penyerahan_memori_banding'] = $tanggal;
				$dataproses['status_banding_id'] = 320;
				$dataproses['status_banding_text'] = 'Penyerahan Memori Banding';
			}elseif($func==4){
				if(!empty($tglputusanbanding)){
					$selisih = $this->tanggalhelper->getSelisihHari($tglputusanbanding,$tanggal);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penerimaan Kontra Banding Tidak Boleh Kurang Dari Tanggal Putusan Banding'));
						return;
					}
				}
				$datapihak['penerimaan_kontra_banding'] = $tanggal;
				$databanding['penerimaan_kontra_banding'] = $tanggal;
				$dataproses['status_banding_id'] = 330;
				$dataproses['status_banding_text'] = 'Penerimaan Kontra Memori Banding';
			}elseif($func==5){
				if(!empty($tglputusanbanding)){
					$selisih = $this->tanggalhelper->getSelisihHari($tglputusanbanding,$tanggal);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penyerahan Kontra Banding Tidak Boleh Kurang Dari Tanggal Putusan Banding'));
						return;
					}
				}
				$datapihak['penyerahan_kontra_banding'] = $tanggal;
				$databanding['penyerahan_kontra_banding'] = $tanggal;
				$dataproses['status_banding_id'] = 340;
				$dataproses['status_banding_text'] = 'Penyerahan Kontra Memori Banding';
			}elseif($func==6){
				if(!empty($tglputusanbanding)){
					$selisih = $this->tanggalhelper->getSelisihHari($tglputusanbanding,$tanggal);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Inzage Banding Tidak Boleh Kurang Dari Tanggal Putusan Banding'));
						return;
					}
				}
				$datapihak['pemberitahuan_inzage'] = $tanggal;
				$datapihak['pemberitahuan_inzage'] = $tanggal;
				$dataproses['status_banding_id'] = 350;
				$dataproses['status_banding_text'] = 'Permberitahuan Untuk Memeriksa Berkas(Inzage)';
			}elseif($func==8){
				if(empty($tglputusanbanding)){
					echo json_encode(array('st'=>0,'msg'=>'Perkara Belum dinyatakan Putus.'));
					return;
				}
				$selisih = $this->tanggalhelper->getSelisihHari($tglputusanbanding,$tanggal);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Putusan Banding Tidak Boleh Kurang Dari Tanggal Putusan Banding'));
					return;
				}
				$datapihak['pemberitahuan_putusan_banding'] = $tanggal;
				$databanding['pemberitahuan_putusan_banding'] = $tanggal;
				$dataproses['status_banding_id'] = 400;
				$dataproses['status_banding_text'] = 'Pemberitahuan Putusan Banding';
			}else{
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Permintaan Tidak Diketahui.'));
				return;
			}
			$result = $this->banding->update_data($datapihak,$id);
			$result = $this->banding->update_data_banding($databanding,$idperkara);
			if($result==TRUE){
				$this->banding->update_proses($idperkara,$dataproses['status_banding_id'],$dataproses['status_banding_text']);
				$this->banding->addPerkaraProses($idperkara,$dataproses['status_banding_id'],$dataproses['status_banding_text'],$tanggal);
				$this->banding->updatePerkaraProses($idperkara);
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DISIMPAN.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN PENYIMPANAN.'));
				return;
			}
		}
	}

	function hapus_tanggal_banding(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
		if(empty($id) OR intval($id)<1){
			echo json_encode(array('st'=>0,'msg'=>'Permohonan Banding Tidak Ditemukan.'));
			return;
		}				

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$func = $this->encrypt->decode(base64_decode($this->input->post('enc_func',TRUE)));
		if(empty($func) OR intval($func)<1){
			echo json_encode(array('st'=>0,'msg'=>'Something Wrong With Your Data.'));
			return;
		}

		if($func==1){
				$yang_dihapus = 'Pemberitahuan Permohonan Banding';						
				$dataproses['status_banding_id'] = 301;
				$kolom = 'pemberitahuan_permohonan_banding';
			}elseif($func==2){
				$yang_dihapus = 'Penerimaan Memori Banding';							
				$dataproses['status_banding_id'] = 310;
				$kolom = 'penerimaan_memori_banding';
			}elseif($func==3){
				$yang_dihapus = 'Penyerahan Memori Banding';								
				$dataproses['status_banding_id'] = 320;
				$kolom = 'penyerahan_memori_banding';
			}elseif($func==4){
				$yang_dihapus = 'Penerimaan Kontra Banding';								
				$dataproses['status_banding_id'] = 330;
				$kolom = 'penerimaan_kontra_banding';
			}elseif($func==5){
				$yang_dihapus = 'Penyerahan Kontra Banding';								
				$dataproses['status_banding_id'] = 340;
				$kolom = 'penyerahan_kontra_banding';
			}elseif($func==6){
				$yang_dihapus = 'Pemberitahuan Inzage';								
				$dataproses['status_banding_id'] = 350;
				$kolom = 'pemberitahuan_inzage';
			}elseif($func==7){
				$yang_dihapus = 'Pengiriman Berkas Banding';								
				$dataproses['status_banding_id'] = 370;
				$kolom = 'pengiriman_berkas_banding';
			}elseif($func==8){
				$yang_dihapus = 'Pemberitahuan Putusan Banding';								
				$dataproses['status_banding_id'] = 400;
				$kolom = 'pemberitahuan_putusan_banding';
			}else{
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Permintaan Tidak Diketahui.'));
				return;
			}		
		
		$diperbaharui = array(
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())	
			);		

		$this->load->model('perkara/banding','banding');
		if($this->banding->hapus_tgl_banding($id,$idperkara,$kolom,$dataproses,$diperbaharui,$func)){			
			echo json_encode(array('st'=>1,'msg'=>'Penghapusan Tanggal '.$yang_dihapus.'  Berhasil'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'));
			return;
		}
	}

	function saveberkas(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$func = $this->encrypt->decode(base64_decode($this->input->post('enc_func',TRUE)));
		if(empty($func) OR intval($func)<1){
			echo json_encode(array('st'=>0,'msg'=>'Something Wrong With Your Data.'));
			return;
		}

		$this->form_validation->set_rules('tanggal', 'Tanggal', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('input_area', 'Nomor Pengiriman Berkas Banding', 'trim|required|xss_clean|min_length[5]');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$tanggal = $this->input->post('tanggal',TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');
			
			$tanggal = $this->tanggalhelper->convertToMysqlDate($tanggal);			
			if($tanggal==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$curr_date);			
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}			

			$dayname = $this->tanggalhelper->getDayName($tanggal);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusanPN = '';
			$this->load->model('perkara/banding','banding');
			$dataputusan = $this->banding->getTanggalPutusan($idperkara);
			if($dataputusan->num_rows>0){
				foreach ($dataputusan->result() as $row) {
					$tglPutusanPN = $row->tanggal_putusan;
				}
			}
		
			if(empty($tglPutusanPN)){
				echo json_encode(array('st'=>0,'msg'=>'Tanggal Putusan Tingkat Pertama Tidak Diketemukan.'));
				return;
			}
			
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusanPN,$tanggal);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Tidak Boleh Kurang Dari Tanggal Putusan PN'));
				return;
			}

			
			$datapihak = array(
				'pengiriman_berkas_banding' => $tanggal,
				'nomor_surat_pengiriman_berkas_banding' => $this->input->post('input_area',TRUE),
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);

			$result = $this->banding->update_data_banding($datapihak,$idperkara);
			if($result==TRUE){
				$this->banding->update_proses($idperkara,370,'Pengiriman Berkas Banding');
				$this->banding->addPerkaraProses($idperkara,370,'Pengiriman Berkas Banding',$tanggal);
				$this->banding->updatePerkaraProses($idperkara);
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DISIMPAN.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN PENYIMPANAN.'));
				return;
			}
		}
	}

	function putusan(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$data['enc'] = $segment[2];
		$idperkara = $this->encrypt->decode(base64_decode($segment[2]));
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}
		$data['jenis_form'] = $segment[3];
		$data['history'] = base_url(uri_string());
		$data['current_date'] =date('d/m/Y'); 
		$data['amar'] = '';
		$data['perkaraid'] = $idperkara;

		$this->load->model('perkara/banding','banding');
		$data['listHakim'] = $this->banding->getDataHakimPT();
		$data['listPanitera'] = $this->banding->getDataPaniteraPT();
		$databanding = $this->banding->getDataBanding($idperkara);
		if($databanding!=''){
			if($databanding->num_rows>0){
				foreach ($databanding->result() as $row) {
					$data['idperkara'] = base64_encode($this->encrypt->encode($row->perkara_id));
					$data['noperkarapn'] = $row->nomor_perkara_pn;
					$data['input_area'] = $row->nomor_putusan_banding;
					$data['tglpermohonan'] = $this->tanggalhelper->convertDayDate($row->permohonan_banding);
					$data['amar'] = $row->amar_putusan_banding;
					$data['tgl_pts_banding'] = $row->putusan_banding;
					$data['tanggal_pts_banding'] = $this->tanggalhelper->convertDayDate($row->putusan_banding);
					$data['tanggal'] = $this->tanggalhelper->convertToInputDate($row->putusan_banding);
					$data['tgl_arsip'] = $this->tanggalhelper->convertToInputDate($row->minutasi_banding);
					$data['tgl_berkas'] = $this->tanggalhelper->convertToInputDate($row->penerimaan_kembali_berkas_banding);
					$data['tglputusan'] = $this->tanggalhelper->convertToInputDate($row->putusan_pn);
					$data['hakim1'] =$row->hakim1_banding_id;
					$data['hakim2'] =$row->hakim2_banding_id;
					$data['hakim3'] =$row->hakim3_banding_id;
					$data['hakim4'] =$row->hakim4_banding_id;
					$data['hakim5'] =$row->hakim5_banding_id;
					$data['panitera'] =$row->panitera_pengganti_banding_id;
					$data['statusputusan'] =$row->status_putusan_banding_id;
				}
			}else{
				show_404();
			}
		}else{
			show_404();
		}
		
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '850px';
		$this->ckeditor->config['height'] = '250px';
		$this->load->vars($data);
		if($data['jenis_form']==1){
			$this->load->view('perkara/banding/edit_putusan');	
		}elseif($data['jenis_form']==2){
			$this->load->view('perkara/banding/edit_penerimaan_berkas');	
		}
		
	}

	function saveputusan(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$jenis_form = $this->input->post('jenis_form',TRUE);
		if($jenis_form==1){
			$this->form_validation->set_rules('tanggal', 'Tanggal Putusan Banding', 'trim|required|xss_clean|exact_length[10]');
			$this->form_validation->set_rules('input_area', 'Nomor Pengiriman Berkas Banding', 'trim|required|xss_clean|min_length[5]');		
			$this->form_validation->set_rules('amar_text', 'Amar Putusan', 'trim|required|xss_clean|min_length[50]');
			$this->form_validation->set_rules('st_putusan', 'Status Putusan', 'trim|required|numeric|xss_clean|');				
			$this->form_validation->set_rules('hakim_ketua', 'Hakim Ketua', 'trim|required|xss_clean|');				
			$this->form_validation->set_rules('panitera', 'Panitera Pengganti', 'trim|required|xss_clean|');
		}elseif($jenis_form==2){			
			$this->form_validation->set_rules('tgl_berkas', 'Tanggal Penerimaan Berkas', 'trim|required|xss_clean|exact_length[10]');
		}
		$this->form_validation->set_rules('tgl_arsip', 'Tanggal Pengarsipan', 'trim|xss_clean|exact_length[10]');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			//$tanggal = $this->input->post('tanggal',TRUE);
			$this->load->model('perkara/banding','banding');
			if($jenis_form==1){
				$tanggal = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal',TRUE));
				$curr_date = date('Y-m-d');
				$todayDate = date('d/m/Y');

				$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$curr_date);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan Banding Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
					return;
				}
				//$tanggal = $this->tanggalhelper->convertToMysqlDate($tanggal);
				if($tanggal==false){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
					return;
				}

				$dayname = $this->tanggalhelper->getDayName($tanggal);
				if($dayname=='Saturday' OR $dayname=='Sunday'){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Putusan Banding Dihari Libur, Sabtu dan Minggu.'));
					return;
				}

				$tglPutusanPN = '';				
				$dataputusan = $this->banding->getTanggalPutusan($idperkara);
				if($dataputusan->num_rows>0){
					foreach ($dataputusan->result() as $row) {
						$tglPutusanPN = $row->tanggal_putusan;
					}
				}
			
				if(empty($tglPutusanPN)){
					echo json_encode(array('st'=>0,'msg'=>'Tanggal Putusan Tingkat Pertama Tidak Diketemukan.'));
					return;
				}
				$selisih = $this->tanggalhelper->getSelisihHari($tglPutusanPN,$tanggal);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan Banding Tidak Boleh Kurang Dari Tanggal Putusan PN'));
					return;
				}


				$amar = trim($this->input->post('amar_text',TRUE));
				$amar = strip_tags($amar);
				$amar = htmlentities($amar, null, 'utf-8');
				$amar = str_replace("&nbsp;", " ", $amar);
				if(strlen($amar)<50){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Amar Putusan Tidak Boleh kurang dari 50 Karakter'));
					return;
				}

				$st_putusan = trim($this->input->post('st_putusan',TRUE));
				if(!is_numeric($st_putusan) OR intval($st_putusan)<1){
					echo json_encode(array('st'=>0,'msg'=>'Status Putusan Tidak Ditemukan.'));
					return;
				}
				if($st_putusan==1){
					$st_putusan_text = 'Diperbaiki';
				}elseif($st_putusan==2){
					$st_putusan_text = 'Dikuatkan';
				}elseif($st_putusan==3){
					$st_putusan_text = 'Dibatalkan';
				}elseif($st_putusan==4){
					$st_putusan_text = 'Tidak Diterima';
				}elseif($st_putusan==5){
					$st_putusan_text = 'Dicabut';
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Status Putusan Tidak Ditemukan.'));
					return;
				}
				
				$databanding = array(
					'amar_putusan_banding' => $amar,
					'putusan_banding' => $tanggal,
					'status_putusan_banding_id' => $st_putusan,
					'status_putusan_banding_text' => $st_putusan_text,
					'nomor_putusan_banding' => $this->input->post('input_area',TRUE),
					'nomor_perkara_banding' => $this->input->post('input_area',TRUE),
					'diperbaharui_oleh' => $this->session->userdata('username'),
					'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
				);
			}

			$tgl_pts_banding = $this->input->post('tgl_pts_banding',TRUE);
			$tglArsip = $this->input->post('tgl_arsip',TRUE);
			if(!empty($tglArsip)){
				$tglArsip = $this->tanggalhelper->convertToMysqlDate($tglArsip);
				if($tglArsip==false){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
					return;
				}

				$dayname = $this->tanggalhelper->getDayName($tglArsip);
				if($dayname=='Saturday' OR $dayname=='Sunday'){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pengarsipan Berkas Banding Dihari Libur, Sabtu dan Minggu.'));
					return;
				}

				$selisih = $this->tanggalhelper->getSelisihHari($tgl_pts_banding,$tglArsip);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pengarsipan Berkas Banding Tidak Boleh Kurang Dari Tanggal Putusan Banding'));
					return;
				}
				$databanding['minutasi_banding'] = $tglArsip;
			}
			$tglTerimaBerkas = $this->input->post('tgl_berkas',TRUE);
			if(!empty($tglTerimaBerkas)){
				$tglTerimaBerkas = $this->tanggalhelper->convertToMysqlDate($tglTerimaBerkas);
				if($tglTerimaBerkas==false){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
					return;
				}

				$dayname = $this->tanggalhelper->getDayName($tglTerimaBerkas);
				if($dayname=='Saturday' OR $dayname=='Sunday'){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penerimaan Kembali Berkas Banding Dihari Libur, Sabtu dan Minggu.'));
					return;
				}

				$selisih = $this->tanggalhelper->getSelisihHari($tgl_pts_banding,$tglTerimaBerkas);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penerimaan Kembali Berkas Banding Tidak Boleh Kurang Dari Tanggal Putusan Banding'));
					return;
				}
				$databanding['penerimaan_kembali_berkas_banding'] = $tglTerimaBerkas;
			}

			if($jenis_form==1){
				$tmpid = '';
				$listHakim = $this->banding->getDataHakimPT();
				$hakimtunggal = $this->input->post('hakim_tunggal',TRUE);
				if(!empty($hakimtunggal)){
					$idhakimketua = $this->encrypt->decode(base64_decode($hakimtunggal));
					if(!is_numeric($idhakimketua) OR intval($idhakimketua)<1){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Tunggal Tidak Ditemukan.'));
						return;
					}
					$databanding['hakim1_banding_id'] = $idhakimketua;
					$nama = $this->parseName($listHakim,$idhakimketua);
					if(empty($nama)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Tunggal Tidak Ditemukan.'));
						return;
					}
					$databanding['hakim1_banding'] = $nama;
					$databanding['majelis_hakim_banding'] = 'Hakim Tunggal : '.$nama;
					$tmpid[0] = $idhakimketua;
				}else{
					$hakim = $this->input->post('hakim_ketua',TRUE);
					if(!empty($hakim)){
						$idhakimketua = $this->encrypt->decode(base64_decode($hakim));
						if(!is_numeric($idhakimketua) OR intval($idhakimketua)<1){
							echo json_encode(array('st'=>0,'msg'=>'Hakim Ketua Tidak Ditemukan.'));
							return;
						}
						$databanding['hakim1_banding_id'] = $idhakimketua;
						$nama = $this->parseName($listHakim,$idhakimketua);
						if(empty($nama)){
							echo json_encode(array('st'=>0,'msg'=>'Hakim Ketua Tidak Ditemukan.'));
							return;
						}
						$databanding['hakim1_banding'] = $nama;
						$databanding['majelis_hakim_banding'] = 'Hakim Ketua : '.$nama;
						$tmpid[0] = $idhakimketua;
					}

					$hakim = $this->input->post('hakim_anggota_1',TRUE);
					if(!empty($hakim)){
						$idhakim1 = $this->encrypt->decode(base64_decode($hakim));
						if(!is_numeric($idhakim1) OR intval($idhakim1)<1){
							echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 1 Tidak Ditemukan.'));
							return;
						}
						if(empty($idhakimketua)){
							echo json_encode(array('st'=>0,'msg'=>'Hakim Ketua Belum Dipilih.'));
							return;
						}
						$databanding['hakim2_banding_id'] = $idhakim1;
						$nama = $this->parseName($listHakim,$idhakim1);
						if(empty($nama)){
							echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 1 Tidak Ditemukan.'));
							return;
						}
						if(in_array($idhakim1, $tmpid)){
							echo json_encode(array('st'=>0,'msg'=>'Duplikasi Data Hakim. Mohon Memilih Hakim Yang Sesuai'));
							return;
						}
						$tmpid[1] = $idhakim1;
						$databanding['hakim2_banding'] = $nama;
						$databanding['majelis_hakim_banding'] .= '<br>'.'Hakim Anggota 1 : '.$nama;
					}

					$hakim = $this->input->post('hakim_anggota_2',TRUE);
					if(!empty($hakim)){
						$idhakim2 = $this->encrypt->decode(base64_decode($hakim));
						if(!is_numeric($idhakim2) OR intval($idhakim2)<1){
							echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 2 Tidak Ditemukan.'));
							return;
						}
						if(empty($idhakimketua)){
							echo json_encode(array('st'=>0,'msg'=>'Hakim Ketua Belum Dipilih.'));
							return;
						}
						if(empty($idhakim1)){
							echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 1 Belum Dipilih.'));
							return;
						}
						$databanding['hakim3_banding_id'] = $idhakim2;
						$nama = $this->parseName($listHakim,$idhakim2);
						if(empty($nama)){
							echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 2 Tidak Ditemukan.'));
							return;
						}
						if(in_array($idhakim2, $tmpid)){
							echo json_encode(array('st'=>0,'msg'=>'Duplikasi Data Hakim. Mohon Memilih Hakim Yang Sesuai'));
							return;
						}
						$tmpid[2] = $idhakim2;
						$databanding['hakim3_banding'] = $nama;
						$databanding['majelis_hakim_banding'] .= '<br>'.'Hakim Anggota 2 : '.$nama;
					}

					$hakim = $this->input->post('hakim_anggota_3',TRUE);
					if(!empty($hakim)){
						$idhakim3 = $this->encrypt->decode(base64_decode($hakim));
						if(!is_numeric($idhakim3) OR intval($idhakim3)<1){
							echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 3 Tidak Ditemukan.'));
							return;
						}
						if(empty($idhakimketua)){
							echo json_encode(array('st'=>0,'msg'=>'Hakim Ketua Belum Dipilih.'));
							return;
						}
						if(empty($idhakim1)){
							echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 1 Belum Dipilih.'));
							return;
						}
						if(empty($idhakim2)){
							echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 2 Belum Dipilih.'));
							return;
						}
						$databanding['hakim4_banding_id'] = $idhakim3;
						$nama = $this->parseName($listHakim,$idhakim3);
						if(empty($nama)){
							echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 3 Tidak Ditemukan.'));
							return;
						}
						if(in_array($idhakim3, $tmpid)){
							echo json_encode(array('st'=>0,'msg'=>'Duplikasi Data Hakim. Mohon Memilih Hakim Yang Sesuai'));
							return;
						}
						$tmpid[3] = $idhakim3;

						$databanding['hakim4_banding'] = $nama;
						$databanding['majelis_hakim_banding'] .= '<br>'.'Hakim Anggota 3 : '.$nama;
					}

					$hakim = $this->input->post('hakim_anggota_4',TRUE);
					if(!empty($hakim)){
						$idhakim4 = $this->encrypt->decode(base64_decode($hakim));
						if(!is_numeric($idhakim4) OR intval($idhakim4)<1){
							echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 4 Tidak Ditemukan.'));
							return;
						}
						if(empty($idhakimketua)){
							echo json_encode(array('st'=>0,'msg'=>'Hakim Ketua Belum Dipilih.'));
							return;
						}
						if(empty($idhakim1)){
							echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 1 Belum Dipilih.'));
							return;
						}
						if(empty($idhakim2)){
							echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 2 Belum Dipilih.'));
							return;
						}
						if(empty($idhakim3)){
							echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 3 Belum Dipilih.'));
							return;
						}
						$databanding['hakim5_banding_id'] = $idhakim4;
						$nama = $this->parseName($listHakim,$idhakim4);
						if(empty($nama)){
							echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 4 Tidak Ditemukan.'));
							return;
						}
						if(in_array($idhakim4, $tmpid)){
							echo json_encode(array('st'=>0,'msg'=>'Duplikasi Data Hakim. Mohon Memilih Hakim Yang Sesuai'));
							return;
						}
						$tmpid[4] = $idhakim4;
						$databanding['hakim5_banding'] = $nama;
						$databanding['majelis_hakim_banding'] .= '<br>'.'Hakim Anggota 4 : '.$nama;
					}
				}
				$listPanitera = $this->banding->getDataPaniteraPT();
				$panitera = $this->input->post('panitera',TRUE);
				if(!empty($panitera)){
					$idpanitera = $this->encrypt->decode(base64_decode($panitera));
					if(!is_numeric($idpanitera) OR intval($idpanitera)<1){
						echo json_encode(array('st'=>0,'msg'=>'Panitera Pengganti Tidak Ditemukan.'));
						return;
					}
					$databanding['panitera_pengganti_banding_id'] = $idpanitera;
					$nama = $this->parseName($listPanitera,$idpanitera);
					if(empty($nama)){
						echo json_encode(array('st'=>0,'msg'=>'Panitera Pengganti Tidak Ditemukan.'));
						return;
					}
					$databanding['panitera_pengganti_banding'] = $nama;
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Panitera Pengganti Belum Dipilih.'));
					return;
				}
			}
			// if($jenis_form==1){
				$result = $this->banding->update_data_banding($databanding,$idperkara);
			/*}elseif($jenis_form==2){
				$result = $this->banding->update_data_penerimaan_berkas($databanding,$idperkara);
			}*/
			
			
			
			if($result==TRUE){
				if($jenis_form==1){
					$this->banding->update_proses($idperkara,390,'Putusan Banding');
					$this->banding->addPerkaraProses($idperkara,390,'Putusan Banding',$tanggal);
					$this->banding->updatePerkaraProses($idperkara);
				}				
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DISIMPAN.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN PENYIMPANAN.'));
				return;
			}
		}
	}

	function parseName($list,$idpihak){
		if($list!=''){
			if($list->num_rows>0){
				foreach ($list->result() as $val) {
					if($val->id==$idpihak){
						return $val->nama_gelar;
					}
				}
			}
		}

		return '';
	}
	function confirmationhapusperkara(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$data['enc'] = $segment[2];
		$idperkara = $this->encrypt->decode(base64_decode($segment[2]));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo "string";
			show_404();
		}

		$this->load->vars($data);
		$this->load->view('perkara/banding/hapus_permohonan_banding');
	}

	function hapuspermohonan(){
		try {
			if(empty($_POST)){
				show_404();
			}

			if($this->session->userdata('is_logged_in')==FALSE){
				echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
				return;
			}

			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			if(!is_numeric($idperkara) OR intval($idperkara)<1){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
				return;
			}
			$result=TRUE;
			$this->load->model('perkara/banding','banding');
			$this->banding->deletePermohonan($idperkara);
			#$this->banding->deletePerkaraProses($idperkara,290);
			if($result==TRUE){
				#$this->banding->update_proses($idperkara,390,'Putusan Banding');
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DIHAPUS.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN MENGHAPUS.'));
				return;
			}
		} catch (Exception $e) {
			
		}
	}
}
