<?php
if($this->session->userdata('is_logged_in')===FALSE){
			redirect('login');
}

foreach ($template->result() as $template){
    $filename=$template->kdtemplate;
    $namafile=str_replace(" ","",$template->namatemplate);
}

$url = base_url("resources/template/penetapan/perdata_umum/".$filename.".rtf");
$jenisGugatan = intval($jenisGugatan); 
if(!is_numeric($jenisGugatan)){
    show_404();
    exit();
}

$Template = file_get_contents($url);

function in_multiarray($sval, $arr){
	$ret = false;
	foreach ($arr as $value) {
		if (is_array($value)){
			$ret = $ret | in_multiarray($sval, $value);
		}else{
			if ($value == $sval){
				return true;
			}
		}
	}
	return $ret;
}

$dataPenetapan = $dataTemplate;

$tergugat = array();
$penggugat = array();
$hakim = array();
foreach ($dataPenetapan->result() as $row) {
    if (!in_multiarray($row->namaP, $penggugat)){
    	$penggugatItem = array();
    	$penggugatItem["nama"] = $row->namaP;
    	$penggugatItem["alamat"] = $row->alamatP;
    	$penggugatItem["statusP"] = $row->statusP;
    	$penggugatItem["urutanP"] = $row->urutanP;
    	$penggugat[] = $penggugatItem;
    }
    if (!in_multiarray($row->namaT, $tergugat)){
    	$tergugatItem = array();
    	$tergugatItem["nama"] = $row->namaT;
    	$tergugatItem["alamat"] = $row->alamatT;
    	$tergugatItem["statusT"] = $row->statusT;
    	$tergugatItem["urutanT"] = $row->urutanT;
    	$tergugat[] = $tergugatItem;
    }
    if (!in_multiarray($row->nama_gelar, $hakim)){
    	$hakimItem = array();
    	$hakimItem["nama_gelar"] = $row->nama_gelar;
    	$hakimItem["jabatan_hakim_nama"] = $row->jabatan_hakim_nama;
    	$hakim[] = $hakimItem;
    }

	$namaPengadilan     =$this->templatehelper->standradnaming($row->namaPengadilan);
	$kota     =$this->templatehelper->namaKota($row->namaPengadilan);
	$nomorperkara   =$row->nomor_perkara;
	$urutan   =$row->urutan;
	$jabatan   =$row->jabatan;
	$namaPejabat   =$this->templatehelper->standradnaming($row->nama);
	$tanggalPendaftaran   =$this->templatehelper->convertKeTglIndo($row->tanggal_pendaftaran);
	$tanggalSurat   =$this->templatehelper->convertKeTglIndo($row->tanggal_surat);
	$nomorSurat   =$row->nomor_surat;
	$tglPenetapan   =$this->templatehelper->convertKeTglIndo($row->tanggal_penetapan);
}

$cPenggugat = count($penggugat);
$i = 1;
foreach ($penggugat as $item) {
	$naskah ="\b ".$this->templatehelper->standradnaming($item["nama"])." , \b0 ".$item["statusP"]."\b  Penggugat ".$this->templatehelper->converToAngkaRomawi($item["urutanP"])."\b0 ;";
	$brnaskah = (($cPenggugat > 1)?($i):("")).' \tab '.$naskah.' \\par '.PHP_EOL.(($i<$cPenggugat)?("#penggugatParties#"):(""));
	$Template = str_replace("#penggugatParties#",''.$brnaskah.'',$Template);	
	$i++;
}

$cTergugat = count($tergugat);
$i = 1;
foreach ($tergugat as $item) {
	$naskah ="\b ".$this->templatehelper->standradnaming($item["nama"])." , \b0 ".$item["statusT"]."\b  Tergugat ".$this->templatehelper->converToAngkaRomawi($item["urutanT"])."\b0 ;";
	$brnaskah = (($cTergugat > 1)?($i):("")).' \tab '.$naskah.' \\par '.PHP_EOL.(($i<$cTergugat)?("#tergugatParties#"):(""));
	$Template = str_replace("#tergugatParties#",''.$brnaskah.'',$Template);	
	$i++;
}

$cMajelis = count($hakim);
$i = 1;
foreach ($hakim as $item) {
	$naskah =$this->templatehelper->standradnaming($item["nama_gelar"]).' \tab '.$item["jabatan_hakim_nama"].'';
	$brnaskah = ' \tab '.$naskah.' \\par '.PHP_EOL.(($i<$cMajelis)?("#hakimParties#"):(""));
	$Template = str_replace("#hakimParties#",''.$brnaskah.'',$Template);	
	$i++;
}

$jenisGugatan = intval($jenisGugatan); 
	if ($jenisGugatan==1) {
		$jenisGugatanx = 'Gugatan';
	} else if ($jenisGugatan==2){
		$jenisGugatanx = 'Permohonan';
	}else if ($jenisGugatan==3){
		$jenisGugatanx = 'Perlawanan';
	}else if ($jenisGugatan==4){
		$jenisGugatanx = 'Bantahan';
	}
	
if (empty($tanggalSurat)){ $tanggalSurat="#Isi Dulu Tanggal Surat Pada Aplikasi#"; }

$Template = str_replace("#namaPengadilan#",''.$namaPengadilan.'',$Template);
$Template = str_replace("#nomorperkara#",''.$nomorperkara.'',$Template);
$Template = str_replace("#tanggalPendaftaran#",''.$tanggalPendaftaran.'',$Template);
$Template = str_replace("#tanggalSurat#",''.$tanggalSurat.'',$Template);
$Template = str_replace("#nomorSurat#",''.$nomorSurat.'',$Template);
$Template = str_replace("#tglPenetapan#",''.$tglPenetapan.'',$Template);
$Template = str_replace("#namaPejabat#",''.$namaPejabat.'',$Template);
$Template = str_replace("#jabatan#",''.$jabatan.'',$Template);
$Template = str_replace("#jenisGugatan#",''.$jenisGugatanx.'',$Template);
$Template = str_replace("#kota#",''.$kota.'',$Template);

header("Content-Type: application/vnd.ms-word");
header("Expires: 0");
header("Cache-Control:  must-revalidate, post-check=0, pre-check=0");
header("Content-disposition: attachment; filename=\"".$namafile."-".$nomorperkara.".rtf\"");
echo $Template;
?>