<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Pk extends CI_Model{
	
	function getJenisPerkara($idalurperkara){
		if(empty($idalurperkara)) return '';
		try {
			$this->db->where('id',$idalurperkara);
			return $this->db->get('alur_perkara')->row()->nama;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	
	function isNomorPerkara($txt){
		$re1='(\\d+)';	# Integer Number 1
		$re2='(\\/)';	# Any Single Character 1
		$re3='.*?';	# Non-greedy match on filler
		$re4='(\\/)';	# Any Single Character 2
		$re5='((?:(?:[1]{1}\\d{1}\\d{1}\\d{1})|(?:[2]{1}\\d{3})))(?![\\d])';	# Year 1
		$re6='(\\/)';	# Any Single Character 3
		$re7='(PN)';	# Variable Name 1
		if ($c=preg_match_all ("/".$re1.$re2.$re3.$re4.$re5.$re6.$re7."/is", $txt, $matches)){
		      $int1=$matches[1][0];
		      $c1=$matches[2][0];
		      $c2=$matches[3][0];
		      $year1=$matches[4][0];
		      $c3=$matches[5][0];
		      $var1=$matches[6][0];
		      return 1;
		}else{
			return 0;
		}
	}

	function parseOrderby($col){
		if($col==1){
			return "nomor_perkara_pn"; 
		}else if($col==2){
			return "permohonan_pk"; 
		}else if($col==3){
			return "pengiriman_berkas_pk"; 
		}else if($col==4){
			return "putusan_pk"; 
		}else if($col==5){
			return "nomor_perkara_pk"; 
		}else if($col==6){
			return "penerimaan_berkas_pk"; 
		}else if($col==7){
			return "pemberitahuan_putusan_pk"; 
		}else if($col==8){
			return "nomor_perkara_pn"; 
		}else{
			return "permohonan_pk";
		}
	}

	function getPerkaraList($idalurperkara='',$col=2,$type='DESC',$begin=0,$key=''){
		$orderby = $this->parseOrderby($col);
		$where = '';

		if($idalurperkara>0){
			$where = "AND alur_perkara_id IN (".$idalurperkara.")";
		}else{
			$where = "";
		}

		if(!empty($key)){
			if($this->isNomorPerkara($key)){
				$where_like = ' WHERE nomor_perkara_pn ="'.$key.'" OR nomor_perkara_banding="'.$key.'" ';

			}else{
				$where_like = ' WHERE (nomor_perkara_pn LIKE "%'.$key.'%" 
					OR permohonan_pk LIKE "%'.$key.'%"
					OR pemohon_pk LIKE "%'.$key.'%" 
					OR nomor_perkara_pk LIKE "%'.$key.'%" 
					OR status_pk_text LIKE "%'.$key.'%") ';
			}
		}else{
			$where_like =" ";
			if($idalurperkara>0){
				$where = " WHERE alur_perkara_id IN (".$idalurperkara.")";
			}
		}
		try {
			$query = $this->db->query("SELECT SQL_CALC_FOUND_ROWS perkara_id, perkara_id,
				alur_perkara_id,pemohon_pk,nomor_perkara_pn,nomor_perkara_pk, permohonan_pk
				,penerimaan_memori_pk,pengiriman_berkas_pk, putusan_pk, 
				pemberitahuan_putusan_pk, penerimaan_berkas_pk, status_pk_text 
				FROM v_perkara_pk ".$where_like." ".$where." ORDER BY ".$orderby." ".$type." LIMIT ".$begin.",50");
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getPerkaraPKCetak($idalurperkara='',$key=''){
		$where = '';

		if($idalurperkara>0){
			$where = "AND alur_perkara_id IN (".$idalurperkara.")";
		}else{
			$where = "";
		}

		if(!empty($key)){
			if($this->isNomorPerkara($key)){
				$where_like = ' WHERE nomor_perkara_pn ="'.$key.'" OR nomor_perkara_banding="'.$key.'" ';

			}else{
				$where_like = ' WHERE (nomor_perkara_pn LIKE "%'.$key.'%" 
					OR permohonan_pk LIKE "%'.$key.'%"
					OR pemohon_pk LIKE "%'.$key.'%" 
					OR nomor_perkara_pk LIKE "%'.$key.'%" 
					OR status_pk_text LIKE "%'.$key.'%") ';
			}
		}else{
			$where_like =" ";
			if($idalurperkara>0){
				$where = " WHERE alur_perkara_id IN (".$idalurperkara.")";
			}
		}
		try {
			$query = $this->db->query("SELECT SQL_CALC_FOUND_ROWS perkara_id, perkara_id,
				alur_perkara_id,pemohon_pk,nomor_perkara_pn,nomor_perkara_pk, permohonan_pk
				,pemberitahuan_pk,penerimaan_memori_pk,pengiriman_berkas_pk, putusan_pk, 
				pemberitahuan_putusan_pk, penerimaan_berkas_pk, status_pk_text,minutasi_pk  
				FROM v_perkara_pk ".$where_like." ".$where." ORDER BY permohonan_pk");
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	function fecth_data_num($idalurperkara,$key){
		$query = $this->db->query("SELECT FOUND_ROWS() as cnt;");
		if($query->num_rows>0){
			foreach ($query->result() as $row) {
				return $row->cnt;
			}
    		return $query->num_rows;
    	}else{
    		return 0;
    	}
	}
	function fetchpk($idperkara){
		try {
			return $this->db->query('SELECT * FROM perkara_pk WHERE perkara_id='.$idperkara);
		} catch (Exception $e) {
			return '';
		}
	}

	function fetchpkDetil($idperkara){
		try {
			return $this->db->query('SELECT b.*, p.pekerjaan FROM 
										perkara_pk_detil AS b
										LEFT JOIN pihak AS p
											ON p.id = b.pemohon_id
										WHERE b.perkara_id ='.$idperkara.' ORDER BY status_pihak_text ASC');
		} catch (Exception $e) {
			return '';
		}
	}

	function getAlurPerkara($idperkara){
		try {
			$result = $this->db->query('SELECT alur_perkara_id FROM perkara WHERE perkara_id ='.$idperkara);
			if($result->num_rows>0){
				return $result->row()->alur_perkara_id;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function getTanggalPutusanpk($idperkara){
		try {
			$result = $this->db->query('SELECT putusan_pk FROM perkara_pk WHERE perkara_id ='.$idperkara);
			if($result->num_rows>0){
				return $result->row()->putusan_pk;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return '';
		}
	}


	function getPihakpk($id){
		try {
			return $this->db->query('SELECT *, pbd.pemberitahuan_pk AS pemberitahuan,
					pbd.penerimaan_memori_pk AS pen_memori,
					pbd.penyerahan_memori_pk AS peny_memori,
					pbd.penerimaan_kontra_pk AS pen_kontra,
					pbd.penyerahan_kontra_pk AS peny_kontra,
					pbd.pemberitahuan_inzage_pk AS pen_inzage,
					pbd.pemberitahuan_putusan_pk As pen_putus
				FROM perkara_pk_detil AS pbd
				LEFT JOIN perkara_pk AS pb
					ON pb.perkara_id = pbd.perkara_id
					WHERE pbd.id = '.$id);
		} catch (Exception $e) {
			return '';
		}
	}	

	function getDataMediasiPK($idperkara){
		try {
			return $this->db->query('SELECT * FROM perkara_mediasi WHERE tahapan_id = 40 AND perkara_id = '.$idperkara);
		} catch (Exception $e) {
			return '';
		}
	}

	function getDataMediator(){
		try {
			return $this->db->query('SELECT id, 
				CASE WHEN status_mediator="N" THEN "Mediator Umum" 
					WHEN status_mediator="H" THEN "Hakim" 
					WHEN status_mediator="P" THEN "Pegawai" END AS status_mediator, 
					nama_gelar FROM mediator WHERE aktif = "Y"');
		} catch (Exception $e) {
			return '';
		}
	}
	function infoMediator($idmediator){
		try {
			return $this->db->query('SELECT id, status_mediator, nama_gelar FROM mediator WHERE id='.$idmediator);
		} catch (Exception $e) {
			return '';
		}
	}

	function get_maxid_mediasi(){
		try {
			$query = $this->db->query('SELECT MAX(mediasi_id) AS maxid  FROM perkara_mediasi');
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function add_data_mediasi($datamediasi){
		try {
			$this->db->insert('perkara_mediasi', $datamediasi);
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}
	
	function get_urutan_jadwal_mediasi_terakhir($mediasi_id){
		$this->db->select_max('urutan');
		$this->db->where('mediasi_id',$mediasi_id);
		$result=$this->db->get('perkara_jadwal_mediasi');
		return $result;
	}
	
	function get_id_jadwal_mediasi_terakhir()
	{
		$this->db->select_max('id');
		$result=$this->db->get('perkara_jadwal_mediasi');
		return $result;
	}

	function add_data_jadwal_mediasi($jadwalmediasi){
		try {
			$this->db->insert('perkara_jadwal_mediasi', $jadwalmediasi);
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function update_data_mediasi($datamediasi,$id){
		try {
			$this->db->where('mediasi_id',$id);
			$this->db->update('perkara_mediasi', $datamediasi);
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function dataJadwalMediasi($idperkara){
		try {
			return $this->db->query('SELECT mediasi_id  FROM perkara_jadwal_mediasi 
			WHERE mediasi_id=(SELECT mediasi_id FROM perkara_mediasi WHERE tahapan_id=30 AND perkara_id='.$idperkara.')');
		} catch (Exception $e) {
			return '';
		}
	}

	function getDataPihak($idpihak){
		try {
			return $this->db->query('SELECT id,nama,alamat,pekerjaan FROM pihak WHERE id = '.$idpihak);
		} catch (Exception $e) {
			return '';
		}
	}

	function getDatapk($idperkara){
		try {
			return $this->db->query('SELECT * FROM perkara_pk WHERE perkara_id = '.$idperkara);
		} catch (Exception $e) {
			return '';
		}
	}

	function getDataHakimMA(){
		try {
			return $this->db->query('SELECT id,nama_gelar FROM hakim_ma WHERE aktif = "Y"');
		} catch (Exception $e) {
			return '';
		}
	}

	function getDataHakimPN(){
		try {
			return $this->db->query('SELECT * FROM hakim_pn WHERE aktif = "Y"');
		} catch (Exception $e) {
			return '';
		}
	}

	function getDataPaniteraMA(){
		try {
			return $this->db->query('SELECT id,nama_gelar FROM panitera_ma WHERE aktif = "Y"');
		} catch (Exception $e) {
			return '';
		}
	}

	function getPihak($idperkara,$pihakke){
		try {
			return $this->db->query('SELECT p.pihak_id, p.nama,p.alamat, 
				permohonan_pk,status_pihak_id,pihak_asal,
				status_pihak_text,b.urutan_pk AS urutan
				FROM perkara_pihak'.$pihakke.' AS p
				LEFT JOIN perkara_pk_detil AS b
				ON p.pihak_id = b.pihak_id
				WHERE p.perkara_id = '.$idperkara.'
				ORDER BY permohonan_pk;');
		} catch (Exception $e) {
			return '';
		}
	}

	function getStatusPihak($idalurperkara){
		try {
			$this->db->where('tahapan_id',10);
			$this->db->where('aktif','Y');
			$this->db->where('alur_perkara_id',$idalurperkara);
			$this->db->select('pihak_ke,nama');
			return $this->db->get('status_pihak');
		} catch (Exception $e) {
			return '';
		}
	}

	function getTanggalPutusan($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->select('tanggal_putusan,tanggal_cabut');
			return $this->db->get('perkara_putusan');
		} catch (Exception $e) {
			return '';
		}
	}

	function getTglMemoripk($idperkara){
		try {
			$result = $this->db->query('SELECT penerimaan_memori_pk FROM perkara_pk WHERE perkara_id ='.$idperkara);
			if($result->num_rows>0){
				return $result->row()->penerimaan_memori_pk;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function getTglKirimBerkas($idperkara){
		try {
			$result = $this->db->query('SELECT pengiriman_berkas_pk FROM perkara_pk WHERE perkara_id ='.$idperkara);
			if($result->num_rows>0){
				return $result->row()->pengiriman_berkas_pk;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function update_data($datapihak,$id){
		try {
			$this->db->where('id',$id);
			$this->db->update('perkara_pk_detil', $datapihak);
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function update_data_pk($datapk,$idperkara,$datahakim=array()){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->update('perkara_pk', $datapk);
			if(!empty($datahakim)){
				$this->db->where('perkara_id',$idperkara);
				$this->db->where('tahapan_id',40);
				$this->db->delete('perkara_hakim_pn');
				$this->db->insert_batch('perkara_hakim_pn',$datahakim);
			}
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}	

	function update_proses($idperkara,$idproses,$prosestext){
		try {
			$this->db->query('CALL perkara_pk_proses('.$idperkara.','.$idproses.',"'.$prosestext.'");');
		} catch (Exception $e) {
			
		}
	}	

	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}

	function add_audittrail($action,$title,$descrip,$tablename){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => 'Add Perkara Perdata',
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			
		}
	}

	function deletePermohonan($idperkara){
		try {
			$this->db->where('perkara_id', $idperkara);
			$this->db->delete('perkara_pk');
			$this->db->where('perkara_id', $idperkara);
			$this->db->delete('perkara_pk_detil');

			$this->db->where('perkara_id', $idperkara);
			$this->db->where('tahapan_id', 40);
			$this->db->delete('perkara_biaya');

			$this->db->where('perkara_id', $idperkara);
			$this->db->where('tahapan_id', 40);
			$this->db->delete('perkara_mediasi');			

			$this->db->where('perkara_id', $idperkara);
			$this->db->where('tahapan_id', 40);
			$this->db->delete('perkara_proses');
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function deletePerkaraProses($idperkara,$idproses){
		try {
			$this->db->simple_query("CALL perkara_proses_delete(".$idperkara.", '".$idproses."');");
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function addPerkaraProses($idperkara,$idproses,$prosestext,$tanggal){
		try {
			$this->db->simple_query("CALL perkara_proses_update(".$idperkara.", 40, 'Peninjauan Kembali', ".$idproses.", '".$prosestext."', '".$tanggal."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function updatePerkaraProses($idperkara){
		try {
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function getHakimNama($idhakim){
		try {
			$query = $this->db->query("SELECT nama_gelar FROM hakim_pn WHERE id = ".$idhakim.";");
			if($query->num_rows>0){
				return $query->row()->nama_gelar;
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function getPutusanpkBHT($idperkara){
		try {
			$result = $this->db->query('SELECT tanggal_bht FROM perkara_putusan WHERE perkara_id='.$idperkara);
			if($result->num_rows>0){
				return $result->row()->tanggal_bht;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function getPermohonanPK($idperkara){
		try {
			$result = $this->db->query('SELECT permohonan_pk FROM perkara_pk WHERE perkara_id ='.$idperkara);
			if($result->num_rows>0){
				return $result->row()->permohonan_pk;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function hapus_tgl_pk($id,$idperkara,$kolom,$dataproses,$diperbaharui,$func){
		try {
			if($func==7){
				$this->db->query("UPDATE perkara_pk SET ".$kolom."=NULL, nomor_surat_pengiriman_berkas_pk='', diperbaharui_oleh='".$diperbaharui['diperbaharui_oleh']."', diperbaharui_tanggal='".$diperbaharui['diperbaharui_tanggal']."'  WHERE perkara_id=".$idperkara);
			}else{
				$this->db->query("UPDATE perkara_pk SET ".$kolom."=NULL, diperbaharui_oleh='".$diperbaharui['diperbaharui_oleh']."', diperbaharui_tanggal='".$diperbaharui['diperbaharui_tanggal']."'  WHERE perkara_id=".$idperkara);
			}					
			if($func!=7){
				$this->db->query("UPDATE perkara_pk_detil SET ".$kolom."=NULL, diperbaharui_oleh='".$diperbaharui['diperbaharui_oleh']."', diperbaharui_tanggal='".$diperbaharui['diperbaharui_tanggal']."'  WHERE id=".$id);	
			}
						
			$cekproses = $this->db->query("SELECT proses_id,proses_nama AS proses_nama FROM perkara_proses WHERE perkara_id=".$idperkara." AND tahapan_id=40 AND proses_id!=".$dataproses['status_pk_id']." ORDER BY proses_id DESC LIMIT 1;");
			if($cekproses->num_rows>0){
				foreach ($cekproses->result() as $row) {
					$idproses = $row->proses_id;
					$namaproses = $row->proses_nama;
				}				
				$this->db->query("UPDATE perkara_pk SET status_pk_id=".$idproses.", status_pk_text='".$namaproses."' WHERE perkara_id=".$idperkara);
			}
			$this->db->where('perkara_id',$idperkara);
			$this->db->where('proses_id',$dataproses['status_pk_id']);
			$this->db->delete('perkara_proses');
			$title = "HAPUS TANGGAL <br /> DELETE table <b>perkara_pk_detil</b> dari halaman <b>DETIL PK</b> dengan Primary Key [id=".$id."]";
			$descrip = $this->fetch_description($title,$datapihak);
			$this->add_audittrail("DELETE",$title,$descrip,'perkara_pk_detil');		
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}		
	}

	function hapus_putusan($idperkara,$datapk){
		try {			
			$this->db->where('perkara_id',$idperkara);
			$this->db->update('perkara_pk',$datapk);			
			$cekproses = $this->db->query("SELECT proses_id,proses_nama FROM perkara_proses WHERE perkara_id=".$idperkara." AND tahapan_id=40 AND proses_id!=570 ORDER BY proses_id DESC LIMIT 1;");			
			if($cekproses->num_rows>0){
				foreach ($cekproses->result() as $row) {
					$idproses = $row->proses_id;
					$namaproses = $row->proses_nama;
				}				
				$this->db->query("UPDATE perkara_pk SET status_pk_id=".$idproses.", status_pk_text='".$namaproses."' WHERE perkara_id=".$idperkara);
			}
			$this->db->where('perkara_id',$idperkara);
			$this->db->where('proses_id',570);
			$this->db->delete('perkara_proses');
			$title = "HAPUS PUTUSAN PK <br /> DELETE table <b>perkara_pk</b> dari halaman <b>EDIT PUTUSAN PK</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$descrip = $this->fetch_description($title,$datapk);
			$this->add_audittrail("DELETE",$title,$descrip,'perkara_pk');		
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}		
	}

	function getInfoTglPemberitahuanPts($idperkara){
		try {
			$result = $this->db->query('SELECT MAX(pemberitahuan_putusan_pk) AS pemberitahuan_putusan_pk FROM perkara_pk_detil WHERE perkara_id='.$idperkara);
			if($result->num_rows>0){
				return $result->row()->pemberitahuan_putusan_pk;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return '';
		}
	}

}
?>