<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class barang_bukti extends CI_Model{
	
	function getJenisPerkara($idalurperkara){
		if(empty($idalurperkara)) return '';
		try {
			$this->db->where('id',$idalurperkara);
			return $this->db->get('alur_perkara');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	function getDetilBB($enc_BB){
		if(empty($enc_BB)) return '';
		try {
			$query = $this->db->query("SELECT *
				FROM perkara_barang_bukti where id=$enc_BB");
				return $query;
			} catch (Exception $e) {
				log_message('error', $e);
		}
	}

	function getInfoDetilBB($idperkara){
		if(empty($idperkara)) return '';
		try {
			$query = $this->db->query("SELECT *
				FROM perkara_barang_bukti where perkara_id=$idperkara");
				return $query;
			} catch (Exception $e) {
				log_message('error', $e);
		}
	}

	function getInfoPerkara($idperkara){
		if(empty($idperkara)) return '';
		try {
			$query = $this->db->query("SELECT jenis_perkara_nama,nomor_perkara,tanggal_pendaftaran
				FROM perkara where perkara_id=$idperkara");
				return $query;
			} catch (Exception $e) {
				log_message('error', $e);
		}
	}
	
	function isNomorPerkara($txt){
		$re1='(\\d+)';	# Integer Number 1
		$re2='(\\/)';	# Any Single Character 1
		$re3='.*?';	# Non-greedy match on filler
		$re4='(\\/)';	# Any Single Character 2
		$re5='((?:(?:[1]{1}\\d{1}\\d{1}\\d{1})|(?:[2]{1}\\d{3})))(?![\\d])';	# Year 1
		$re6='(\\/)';	# Any Single Character 3
		$re7='(PN)';	# Variable Name 1
		if ($c=preg_match_all ("/".$re1.$re2.$re3.$re4.$re5.$re6.$re7."/is", $txt, $matches)){
		      $int1=$matches[1][0];
		      $c1=$matches[2][0];
		      $c2=$matches[3][0];
		      $year1=$matches[4][0];
		      $c3=$matches[5][0];
		      $var1=$matches[6][0];
		      return 1;
		}else{
			return 0;
		}
	}

	function parseOrderby($col){
		if($col==1){
			return "nomor_perkara"; 
		}else if($col==2){
			return "jenis_barang_bukti";
		}else if($col==3){
			return "tanggal_penerimaan";
		}else if($col==4){
			return "tempat_penyimpanan";
		}else if($col==5){
			return "tempat_penyerahan";
		}else if($col==6){
			return "nama_penerima";
		}
	}

	function getPerkaraList($idalurperkara='',$col=3,$type='DESC',$begin=0,$key=''){
		$orderby = $this->parseOrderby($col);
		$where = '';

		if(!empty($key)){
			$where_like = 'WHERE (nomor_perkara LIKE "%'.$key.'%" OR
								   jenis_barang_bukti LIKE "%'.$key.'%" OR
								   tanggal_penerimaan LIKE "%'.$key.'%" OR
								   tempat_penyimpanan LIKE "%'.$key.'%" OR
								   nama_penerima LIKE "%'.$key.'%" OR
								   tanggal_penyerahan LIKE "%'.$key.'%" OR
								   catatan_barang_bukti LIKE "%'.$key.'%" OR
								   tempat_penyerahan LIKE "%'.$key.'%") ';
		} else {
			$where_like = '';
		}
		try {
			$qry="SELECT SQL_CALC_FOUND_ROWS *
				FROM perkara_barang_bukti  ".$where_like." ".$where." ORDER BY ".$orderby." ".$type."  LIMIT ".$begin.",50";
				//echo $qry;
			$query = $this->db->query($qry);
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	function getPerkaraBBCetak($idalurperkara='',$key=''){
		$where = '';
		
		if(!empty($key)){
			$where_like = 'WHERE (nomor_perkara LIKE "%'.$key.'%" OR
								   jenis_barang_bukti LIKE "%'.$key.'%" OR
								   tanggal_penerimaan LIKE "%'.$key.'%" OR
								   tempat_penyimpanan LIKE "%'.$key.'%" OR
								   nama_penerima LIKE "%'.$key.'%" OR
								   tanggal_penyerahan LIKE "%'.$key.'%" OR
								   catatan_barang_bukti LIKE "%'.$key.'%" OR
								   tempat_penyerahan LIKE "%'.$key.'%") ';
		} else {
			$where_like = '';
		}
		try {
			$query = $this->db->query("SELECT SQL_CALC_FOUND_ROWS *
				FROM perkara_barang_bukti  ".$where_like." ".$where." ORDER BY tanggal_penerimaan DESC");
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}



	function fecth_data_num($idalurperkara,$key){
		$query = $this->db->query("SELECT FOUND_ROWS() as cnt;");
		if($query->num_rows>0){
			foreach ($query->result() as $row) {
				return $row->cnt;
			}
    		return $query->num_rows;
    	}else{
    		return 0;
    	}
	}

	function getDataPerkara($idperkara){
		if(empty($idperkara)) return '';

		try{
			return $this->db->query('SELECT * FROM perkara where perkara_id='.'"'.$idperkara.'"'.';');
	    }catch (Exception $e) {
	    	log_message('error', $e);
	    }
	}

	function get_info_barang_bukti($idperkara){
		if(empty($idperkara)) return '';
		try{
			return $this->db->query('SELECT * FROM perkara_barang_bukti where perkara_id='.$idperkara);
	    }catch (Exception $e) {
	    	log_message('error', $e);
	    }
	}	
	function cek_bb($idperkara){
		if(empty($idperkara)) return '';

		try{
			return $this->db->query("SELECT count(*) as adabb FROM perkara_barang_bukti where perkara_id=".$idperkara."");
	    }catch (Exception $e) {
	    	log_message('error', $e);
	    }
	}

	function fetchData($nomor_perkara){
		if(empty($nomor_perkara)) return '';

		try{
			return $this->db->query('SELECT * FROM perkara where nomor_perkara='.'"'.$nomor_perkara.'"'.';');
	    }catch (Exception $e) {
	    	log_message('error', $e);
	    }
	}
	function add_data($data_bb){
		try {
			$this->db->insert('perkara_barang_bukti', $data_bb);
			$title = "Tambah Data Permohonan Banding [Nomor Perkara=<b>".$data['nomor_perkara']."</b>]<br />Tambah table <b>perkara_barang_bukti</b> dari halaman <b>Tambah Barang Bukti</b> dengan Primary Key [perkara_id=".$data['perkara_id']."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("INSERT",$title,$descrip,'perkara_barang_bukti');		
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function hapus_bb($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->delete('perkara_barang_bukti');

			$title = "Hapus Barang Bukti <br />Hapus table <b>perkara_barang_bukti</b> dari halaman <b>Edit Barang Bukti</b> dengan Primary Key [ID Perkara=".$idperkara."]";
			$descrip = '';
			$this->add_audittrail("HAPUS",$title,$descrip,'perkara_barang_bukti');
			
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
		
	}	
	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}

	function add_audittrail($action,$title,$descrip,$tablename){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => 'Add Mediasi',
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			
		}
	}

}

?>