<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Banding extends CI_Model{
	
	function getDataStatusPutusan($alurperkara){
		try {
			if($alurperkara<100 OR $alurperkara==119){
				if($alurperkara<100){
				 	$alurperkara= 1;
				}elseif($alurperkara==119) {
					$alurperkara = 3;
				}
			}else{
				$alurperkara = 2;
			}

			$jenis_pengadilan=$this->session->userdata('jenis_pengadilan');
			
			return $this->db->query('SELECT id,nama,satuan FROM status_putusan WHERE aktif="Y" AND jenis_perkara_id ='.$alurperkara.' AND jenis_pengadilan='.$jenis_pengadilan.' and urutan<>0 ORDER BY urutan ASC');
		} catch (Exception $e) {
			
		}
	}
	
	function get_mediator($status_mediator){
		try {
			$qry="SELECT id,nama,no_sertifikasi,status_mediator FROM mediator WHERE status_mediator='$status_mediator' AND aktif='Y' ORDER BY status_mediator;";
			return $this->db->query($qry);
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getJenisPerkara($idalurperkara){
		try {
			$result = $this->db->query('SELECT nama FROM alur_perkara WHERE id ='.$idalurperkara);
			if($result->num_rows>0){
				return $result->row()->nama;;
			}else{
				return FALSE;
			}
		} catch (Exception $e) {
			return FALSE;
		}
	}
	
	function isNomorPerkara($txt){
		$re1='(\\d+)';	# Integer Number 1
		$re2='(\\/)';	# Any Single Character 1
		$re3='.*?';	# Non-greedy match on filler
		$re4='(\\/)';	# Any Single Character 2
		$re5='((?:(?:[1]{1}\\d{1}\\d{1}\\d{1})|(?:[2]{1}\\d{3})))(?![\\d])';	# Year 1
		$re6='(\\/)';	# Any Single Character 3
		$re7='(PN)';	# Variable Name 1
		if ($c=preg_match_all ("/".$re1.$re2.$re3.$re4.$re5.$re6.$re7."/is", $txt, $matches)){
		      $int1=$matches[1][0];
		      $c1=$matches[2][0];
		      $c2=$matches[3][0];
		      $year1=$matches[4][0];
		      $c3=$matches[5][0];
		      $var1=$matches[6][0];
		      return 1;
		}else{
			return 0;
		}
	}

	function parseOrderby($col){

		if($col==1){
			return "nomor_perkara_pn"; 
		}else if($col==2){
			return "permohonan_banding"; 
		}else if($col==3){
			return "pengiriman_berkas_banding"; 
		}else if($col==4){
			return "putusan_banding"; 
		}else if($col==5){
			return "nomor_perkara_banding"; 
		}else if($col==6){
			return "penerimaan_kembali_berkas_banding"; 
		}else if($col==7){
			return "pemberitahuan_putusan_banding"; 
		}else if($col==8){
			return "nomor_perkara_pn"; 
		}else{
			return "permohonan_banding";
		}
	}

	function getPerkaraList($idalurperkara='',$col=2,$type='DESC',$begin=0,$key=''){
		$orderby = $this->parseOrderby($col);
		$where = '';
		
		if($idalurperkara>0){
			$where = "AND alur_perkara_id IN (".$idalurperkara.")";
		}else{
			$where = "";
		}

		if(!empty($key)){
			if($this->isNomorPerkara($key)){
				$where_like = ' WHERE nomor_perkara_pn ="'.$key.'" OR nomor_perkara_banding="'.$key.'" ';

			}else{
				$where_like = ' WHERE (nomor_perkara_pn LIKE "%'.$key.'%" 
				OR pemohon_banding LIKE "%'.$key.'%"
				OR para_pihak LIKE "%'.$key.'%" 
				OR permohonan_banding LIKE "%'.$key.'%" 
				OR nomor_perkara_banding LIKE "%'.$key.'%") ';
			}
		}else{
			$where_like =" ";
			if($idalurperkara>0){
				$where = " WHERE alur_perkara_id IN (".$idalurperkara.")";
			}
		}
		try {
			$query = $this->db->query("SELECT SQL_CALC_FOUND_ROWS perkara_id, perkara_id,
				alur_perkara_id,pemohon_banding,nomor_perkara_pn,nomor_perkara_banding, 
				permohonan_banding ,penerimaan_memori_banding,pengiriman_berkas_banding, putusan_banding, 
				pemberitahuan_putusan_banding, penerimaan_kembali_berkas_banding, status_banding_text 
				FROM perkara_banding ".$where_like." ".$where." ORDER BY ".$orderby." ".$type." 
				LIMIT ".$begin.",50");
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getPerkaraListSearchDetail($idalurperkara='',$col=2,$type='DESC',$begin=0,$key=''){
		$orderby = $this->parseOrderby($col);
		$where = '';

		if(!empty($key)){
			$where_like = ' WHERE '.$key.' ';
		}else{
			$where_like =" ";
			if($idalurperkara>0){
				$where = " WHERE alur_perkara_id IN (".$idalurperkara.")";
			}
		}
		try {
			$query = $this->db->query("SELECT SQL_CALC_FOUND_ROWS perkara_id, perkara_id,
				alur_perkara_id,pemohon_banding,nomor_perkara_pn,nomor_perkara_banding, 
				permohonan_banding ,penerimaan_memori_banding,pengiriman_berkas_banding, putusan_banding, 
				pemberitahuan_putusan_banding, penerimaan_kembali_berkas_banding, status_banding_text 
				FROM v_perkara_banding ".$where_like." ORDER BY ".$orderby." ".$type." 
				LIMIT ".$begin.",50");
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	function getPerkaraBandingCetak($idalurperkara='',$key=''){
		$where = '';
		
		if($idalurperkara>0){
			$where = "AND alur_perkara_id IN (".$idalurperkara.")";
		}else{
			$where = "";
		}

		if(!empty($key)){
			$where_like = ' WHERE nomor_perkara_pn ="'.$key.'" OR nomor_perkara_banding="'.$key.'" ';
		}else{
			$where_like =" ";
			if($idalurperkara>0){
				$where_like = ' WHERE (nomor_perkara_pn LIKE "%'.$key.'%" 
				OR pemohon_banding LIKE "%'.$key.'%"
				OR para_pihak LIKE "%'.$key.'%" 
				OR permohonan_banding LIKE "%'.$key.'%" 
				OR nomor_perkara_banding LIKE "%'.$key.'%") ';
			}
		}
		try {
			$query = $this->db->query("SELECT SQL_CALC_FOUND_ROWS perkara_id, perkara_id,
				alur_perkara_id,pemohon_banding,nomor_perkara_pn,nomor_perkara_banding, 
				permohonan_banding ,penerimaan_memori_banding,pengiriman_berkas_banding, putusan_banding, 
				pemberitahuan_putusan_banding, penerimaan_kembali_berkas_banding, status_banding_text 
				FROM perkara_banding ".$where_like." ".$where." ORDER BY permohonan_banding ASC");
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	} 


	function getTanggalCabutPihak($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->select('tanggal_cabut');
			return $this->db->query('SELECT tanggal_cabut FROM perkara_banding_detil 
				WHERE permohonan_banding IS NOT NULL AND perkara_id = '.$idperkara);
		} catch (Exception $e) {
			
		}
	}

	function deletePerkaraProses($idperkara,$idproses){
		try {
			$this->db->simple_query("CALL perkara_proses_delete(".$idperkara.", '".$idproses."');");
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function addPerkaraProses($idperkara,$idproses,$prosestext,$tanggal){
		try {
			$this->db->simple_query("CALL perkara_proses_update(".$idperkara.", 20, 'Banding', ".$idproses.", '".$prosestext."', '".$tanggal."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function updatePerkaraProses($idperkara){
		try {
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function deletePermohonan($idperkara){
		try {
			$this->db->where('perkara_id', $idperkara);
			$this->db->delete('perkara_banding');

			$this->db->where('perkara_id', $idperkara);
			$this->db->delete('perkara_banding_detil');

			$this->db->where('perkara_id', $idperkara);
			$this->db->where('tahapan_id', 20);
			$this->db->delete('perkara_biaya');

			$this->db->where('perkara_id', $idperkara);
			$this->db->where('tahapan_id', 20);
			$this->db->delete('perkara_mediasi');			

			$this->db->where('perkara_id', $idperkara);
			$this->db->where('tahapan_id', 20);
			$this->db->delete('perkara_proses');

			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function fecth_data_num($idalurperkara,$key){
		$query = $this->db->query("SELECT FOUND_ROWS() as cnt;");
		if($query->num_rows>0){
			foreach ($query->result() as $row) {
				return $row->cnt;
			}
    		return $query->num_rows;
    	}else{
    		return 0;
    	}
	}

	function fetchBanding($idperkara){
		try {
			return $this->db->query('SELECT * FROM perkara_banding WHERE perkara_id='.$idperkara);
		} catch (Exception $e) {
			return '';
		}
	}
	function fetchBandingDetil($idperkara){
		try {
			return $this->db->query('SELECT b.*, p.pekerjaan FROM 
										perkara_banding_detil AS b
										LEFT JOIN pihak AS p
											ON p.id = b.pemohon_id
										WHERE b.perkara_id ='.$idperkara.' ORDER BY status_pihak_text ASC');
		} catch (Exception $e) {
			return '';
		}
	}

	function getAlurPerkara($idperkara){
		try {
			$result = $this->db->query('SELECT alur_perkara_id FROM perkara WHERE perkara_id ='.$idperkara);
			if($result->num_rows>0){
				return $result->row()->alur_perkara_id;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function getPermohonanBanding($idperkara){
		try {
			$result = $this->db->query('SELECT permohonan_banding FROM perkara_banding WHERE perkara_id ='.$idperkara);
			if($result->num_rows>0){
				return $result->row()->permohonan_banding;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return '';
		}
	}


	function getPihakBanding($id){
		try {
			return $this->db->query('SELECT *, pbd.pemberitahuan_permohonan_banding AS pemberitahuan,
					pbd.penerimaan_memori_banding AS pen_memori,
					pbd.penyerahan_memori_banding AS peny_memori,
					pbd.penerimaan_kontra_banding AS pen_kontra,
					pbd.penyerahan_kontra_banding AS peny_kontra,
					pbd.pemberitahuan_inzage AS pen_inzage,
					pbd.pemberitahuan_putusan_banding As pen_putus
				FROM perkara_banding_detil AS pbd
				LEFT JOIN perkara_banding AS pb
					ON pb.perkara_id = pbd.perkara_id
					WHERE pbd.id = '.$id);
		} catch (Exception $e) {
			return '';
		}
	}

	function getDataPihak($idpihak){
		try {
			return $this->db->query('SELECT id,nama,alamat,pekerjaan FROM pihak WHERE id = '.$idpihak);
		} catch (Exception $e) {
			return '';
		}
	}

	function getDataBanding($idperkara){
		try {
			return $this->db->query('SELECT * FROM perkara_banding WHERE perkara_id = '.$idperkara);
		} catch (Exception $e) {
			return '';
		}
	}

	function getDataUpayaHukum($idperkara,$table){
		try {			
			return $this->db->query('SELECT * FROM '.$table.' WHERE perkara_id ='.$idperkara);
		} catch (Exception $e) {
			return '';
		}
	}

	function getListPihakBanding($idperkara){
		try {
			return $this->db->query('SELECT perkara_id,status_pihak_id,urutan_banding FROM perkara_banding_detil WHERE status_pihak_id IN (1,2,4) AND perkara_id = '.$idperkara);
		} catch (Exception $e) {
			return '';
		}
	}

	function isAllCabut($idperkara){
		try {
			return $this->db->query('SELECT * FROM perkara_banding_detil WHERE status_pihak_id IN (1,2,4) AND tanggal_cabut IS NULL AND perkara_id = '.$idperkara);
		} catch (Exception $e) {
			
		}
	}
	function getDataHakimPT(){
		try {
			return $this->db->query('SELECT id,nama_gelar FROM hakim_pt WHERE aktif = "Y"');
		} catch (Exception $e) {
			return '';
		}
	}

	function getDataPaniteraPT(){
		try {
			return $this->db->query('SELECT id,nama_gelar FROM panitera_pt WHERE aktif = "Y"');
		} catch (Exception $e) {
			return '';
		}
	}

	function getPihak($idperkara,$pihakke){
		try {
			return $this->db->query('SELECT p.pihak_id, p.nama,p.alamat, 
				permohonan_banding,status_pihak_id,pihak_asal,
				status_pihak_text,b.urutan_banding AS urutan
				FROM perkara_pihak'.$pihakke.' AS p
				LEFT JOIN perkara_banding_detil AS b
				ON p.pihak_id = b.pihak_id
				WHERE p.perkara_id = '.$idperkara.'
				ORDER BY permohonan_banding;');
		} catch (Exception $e) {
			return '';
		}
	}

	function getStatusPihak($idalurperkara){
		try {
			$this->db->where('tahapan_id',10);
			$this->db->where('aktif','Y');
			$this->db->where('alur_perkara_id',$idalurperkara);
			$this->db->select('pihak_ke,nama');
			return $this->db->get('status_pihak');
		} catch (Exception $e) {
			return '';
		}
	}

	function getTanggalPutusan($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->select('tanggal_putusan,tanggal_cabut');
			return $this->db->get('perkara_putusan');
		} catch (Exception $e) {
			return '';
		}
	}

	function getTanggalPutusanBanding($idperkara){
		try {
			$result = $this->db->query('SELECT putusan_banding FROM perkara_banding WHERE perkara_id ='.$idperkara);
			if($result->num_rows>0){
				return $result->row()->putusan_banding;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function update_proses($idperkara,$idproses,$prosestext){
		try {
			$this->db->query('CALL perkara_banding_proses('.$idperkara.','.$idproses.',"'.$prosestext.'");');
		} catch (Exception $e) {
			
		}
	}
	function update_data($datapihak,$id){
		try {
			$this->db->where('id',$id);
			$this->db->update('perkara_banding_detil', $datapihak);
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function update_data_banding($databanding,$idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->update('perkara_banding', $databanding);
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	//---------TAHAP MEDIASI
	function getDataMediator(){
		try {
			return $this->db->query('SELECT id, 
				CASE WHEN status_mediator="N" THEN "Mediator Umum" 
					WHEN status_mediator="H" THEN "Hakim" 
					WHEN status_mediator="P" THEN "Pegawai" END AS status_mediator, 
					nama_gelar FROM mediator WHERE aktif = "Y"');
		} catch (Exception $e) {
			return '';
		}
	}
	function getDataMediasi($idperkara,$tahapan){
		try {
			return $this->db->query('SELECT * FROM perkara_mediasi WHERE tahapan_id ='.$tahapan.'  AND perkara_id = '.$idperkara);
		} catch (Exception $e) {
			return '';
		}
	}
	function getDataMediasiBanding($idperkara){
		try {
			return $this->db->query('SELECT * FROM perkara_mediasi WHERE tahapan_id = 20 AND perkara_id = '.$idperkara);
		} catch (Exception $e) {
			return '';
		}
	}	

	function get_maxid_mediasi(){
		try {
			$query = $this->db->query('SELECT MAX(mediasi_id) AS maxid  FROM perkara_mediasi');
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function add_data_mediasi($datamediasi){
		try {
			$this->db->insert('perkara_mediasi', $datamediasi);
			if($datamediasi['tahapan_id']==20)
				$title = "TAMBAH MEDIASI SUKA RELA <br /> INSERT table <b>perkara_mediasi</b> dari halaman <b>DETIL BANDING</b> dengan Primary Key [mediasi_id=".$datamediasi['mediasi_id']."]";	
			elseif($datamediasi['tahapan_id']==30)
				$title = "TAMBAH MEDIASI SUKA RELA <br /> INSERT table <b>perkara_mediasi</b> dari halaman <b>DETIL KASASI</b> dengan Primary Key [mediasi_id=".$datamediasi['mediasi_id']."]";
			elseif($datamediasi['tahapan_id']==40)				
				$title = "TAMBAH MEDIASI SUKA RELA <br /> INSERT table <b>perkara_mediasi</b> dari halaman <b>DETIL PK</b> dengan Primary Key [mediasi_id=".$datamediasi['mediasi_id']."]";

			$descrip = $this->fetch_description($title,$datamediasi);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_mediasi');
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}	

	function update_data_mediasi($datamediasi,$id){
		try {
			$this->db->where('mediasi_id',$id);
			$this->db->update('perkara_mediasi', $datamediasi);
			$title = "UPDATE Data Mediasi <br /> UPDATE table <b>perkara_mediasi</b> dari halaman <b>EDIT DATA MEDIASI</b> dengan Primary Key [id=".$id."]";
			$descrip = $this->fetch_description($title,$datamediasi);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_mediasi');
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}	

	function hapus_mediasi($idperkara,$tahapanid){
		try {			
			$this->db->where('perkara_id',$idperkara);
			$this->db->where('tahapan_id',$tahapanid);
			$this->db->delete('perkara_mediasi');
			$title = "DELETE Mediasi Sukarela <br /> DELETE table <b>perkara_mediasi</b> dari halaman <b>EDIT DATA MEDIASI</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$descrip = '';
			$this->add_audittrail("DELETE",$title,$descrip,'perkara_mediasi');		
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}		
	}
	//-----------END MEDIASI	
	//28-11-2016
	function hapus_putusan($idperkara,$databanding){
		try {			
			$this->db->where('perkara_id',$idperkara);
			$this->db->update('perkara_banding',$databanding);			
			$cekproses = $this->db->query("SELECT proses_id,proses_nama FROM perkara_proses WHERE perkara_id=".$idperkara." AND tahapan_id=20 AND proses_id!=390 ORDER BY proses_id DESC LIMIT 1;");			
			if($cekproses->num_rows>0){
				foreach ($cekproses->result() as $row) {
					$idproses = $row->proses_id;
					$namaproses = $row->proses_nama;
				}				
				$this->db->query("UPDATE perkara_banding SET status_banding_id=".$idproses.", status_banding_text='".$namaproses."' WHERE perkara_id=".$idperkara);
			}
			$this->db->where('perkara_id',$idperkara);
			$this->db->where('proses_id',390);
			$this->db->delete('perkara_proses');
			$title = "HAPUS PUTUSAN BANDING <br /> DELETE table <b>perkara_banding</b> dari halaman <b>EDIT PUTUSAN BANDING</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$descrip = $this->fetch_description($title,$databanding);
			$this->add_audittrail("DELETE",$title,$descrip,'perkara_banding');		
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}		
	}

	function hapus_tgl_banding($id,$idperkara,$kolom,$dataproses,$diperbaharui){
		try {			
			$this->db->query("UPDATE perkara_banding SET ".$kolom."=NULL, diperbaharui_oleh='".$diperbaharui['diperbaharui_oleh']."', diperbaharui_tanggal='".$diperbaharui['diperbaharui_tanggal']."'  WHERE perkara_id=".$idperkara);
			$this->db->query("UPDATE perkara_banding_detil SET ".$kolom."=NULL, diperbaharui_oleh='".$diperbaharui['diperbaharui_oleh']."', diperbaharui_tanggal='".$diperbaharui['diperbaharui_tanggal']."'  WHERE id=".$id);
			
			$cekproses = $this->db->query("SELECT proses_id,proses_nama FROM perkara_proses WHERE perkara_id=".$idperkara." AND tahapan_id=20 AND proses_id!=".$dataproses['status_banding_id']." ORDER BY proses_id DESC LIMIT 1;");			
			if($cekproses->num_rows>0){
				foreach ($cekproses->result() as $row) {
					$idproses = $row->proses_id;
					$namaproses = $row->proses_nama;
				}				
				$this->db->query("UPDATE perkara_banding SET status_banding_id=".$idproses.", status_banding_text='".$namaproses."' WHERE perkara_id=".$idperkara);
			}
			$this->db->where('perkara_id',$idperkara);
			$this->db->where('proses_id',$dataproses['status_banding_id']);
			$this->db->delete('perkara_proses');
			$title = "HAPUS TANGGAL <br /> DELETE table <b>perkara_banding_detil</b> dari halaman <b>DETIL BANDING</b> dengan Primary Key [id=".$id."]";
			$descrip = $this->fetch_description($title,$datapihak);
			$this->add_audittrail("DELETE",$title,$descrip,'perkara_banding_detil');		
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}		
	}	
	//----end

	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}

	function add_audittrail($action,$title,$descrip,$tablename){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => 'Detil Banding Perdata',
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			
		}
	}
}

?>