<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Tab_keberatan_c extends CI_Controller {
	function index(){
		
		$data=$this->load_data();
		$this->load->view('perkara_tab/keberatan/tab_keberatan_v', $data);
	}

	
	function load_data(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		
		$this->load->model('keberatan/keberatan_m');
		$row=$this->keberatan_m->get_no_perkara($data['perkara_id']);
		$data['nomor_perkara']=$row->nomor_perkara;
		$data['tanggal_putusan']=$row->tanggal_putusan;
		$data['tanggal_pendaftaran_keberatan']=$row->tanggal_pendaftaran_keberatan;
		$data['pemohon']=$row->pemohon_keberatan;
		$data['penetapan_majelis_hakim']=$row->penetapan_majelis_hakim;
		$data['majelis_hakim_id']=$row->majelis_hakim_id;
		$data['majelis_hakim_nama']=$row->majelis_hakim_nama;
		$data['majelis_hakim_text']=$row->majelis_hakim_text;
		$data['penetapan_panitera_pengganti']=$row->penetapan_panitera_pengganti;
		$data['panitera_pengganti_id']=$row->panitera_pengganti_id;
		$data['panitera_pengganti_text']=$row->panitera_pengganti_text;
		$data['penetapan_jurusita']=$row->penetapan_jurusita;
		$data['jurusita_id']=$row->jurusita_id;
		$data['jurusita_text']=$row->jurusita_text;
		$data['tanggal_penetapan_sidang_keberatan']=$row->tanggal_penetapan_sidang_keberatan;
		$data['tanggal_sidang_pertama_keberatan']=$row->tanggal_sidang_pertama_keberatan;
		$data['putusan_keberatan']=$row->putusan_keberatan;
		$data['status_putusan_keberatan_id']=$row->status_putusan_keberatan_id;
		$data['status_putusan_keberatan_text']=$row->status_putusan_keberatan_text;
		$data['amar_putusan_keberatan']=$row->amar_putusan_keberatan;
		$data['amar_putusan_keberatan_dok']=$row->amar_putusan_keberatan_dok;
		$data['pemberitahuan_putusan']=$row->pemberitahuan_putusan;
		$data['pemberitahuan_putusan_keberatan']=$row->pemberitahuan_putusan_keberatan;
		$data['pemberitahuan_putusan_keberatan_pihak1']=$row->pemberitahuan_putusan_keberatan_pihak1;
		$data['pemberitahuan_putusan_keberatan_pihak2']=$row->pemberitahuan_putusan_keberatan_pihak2;
		$data['penerimaan_memori']=$row->penerimaan_memori;
		$data['penyerahan_memori']=$row->penyerahan_memori;
		$data['penerimaan_kontra_memori']=$row->penerimaan_kontra_memori;
		$data['penyerahan_kontra_memori']=$row->penyerahan_kontra_memori;
		$data['inzage_pihak1']=$row->inzage_pihak1;
		$data['inzage_pihak2']=$row->inzage_pihak2;	
		$data['catatan_putusan_keberatan']=$row->catatan_putusan_keberatan;
		$data['current_date'] = date('d/m/Y');
		$data['list_penggugat'] = $this->keberatan_m->get_para_pihak($data['perkara_id'],1);
		$data['list_tergugat'] = $this->keberatan_m->get_para_pihak($data['perkara_id'],2);
		$data['parapihakkeberatan'] = $this->keberatan_m->getListParaPihak($data['perkara_id']);
		$data['tanggal_minutasi_keberatan']=$row->tanggal_minutasi_keberatan;
		return $data;
	}

	function add_Keberatan(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		
		$this->load->model('keberatan/keberatan_m');
		$row=$this->keberatan_m->get_no_perkara($data['perkara_id']);
		$data['nomor_perkara']=$row->nomor_perkara;
		$data['tanggal_putusan']=$row->tanggal_putusan;
		$data['tanggal_pendaftaran_keberatan']=$row->tanggal_pendaftaran_keberatan;
		$data['pemohon']=$row->pemohon_keberatan;
		$data['list_penggugat'] = $this->keberatan_m->get_para_pihak($data['perkara_id'],1);
		$data['list_tergugat'] = $this->keberatan_m->get_para_pihak($data['perkara_id'],2);
		$data['current_date'] = date('d/m/Y');
		$data['action']='add';
		$data['parapihakkeberatan'] = $this->keberatan_m->getListParaPihak($data['perkara_id']);
		$this->load->view('perkara_tab/keberatan/form_keberatan_v', $data);
	}

	function edit_Keberatan(){
		$data=$this->load_data();
		$data['action']='edit';
		$this->load->view('perkara_tab/keberatan/form_keberatan_v', $data);
	}

	function penetapan_majelis(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		
		$this->load->model('keberatan/keberatan_m');
		$row=$this->keberatan_m->get_no_perkara($data['perkara_id']);
		$data['nomor_perkara']	= $row->nomor_perkara;
		$data['tanggal_putusan']= $row->tanggal_putusan;
		$data['majelis_hakim_id'] = $row->majelis_hakim_id;
		$data['tanggal_pendaftaran_keberatan']	= $row->tanggal_pendaftaran_keberatan;
		$data['penetapan_majelis_hakim']	= $row->penetapan_majelis_hakim;
		$data['current_date'] = date('d/m/Y');
		$data['listHakim'] = $this->keberatan_m->getListHakim();
		$tmp = explode(',', $data['majelis_hakim_id']);
		if (count($tmp)>1){
			$data['idketua'] = $tmp[0];
			$data['idAnggota1'] = $tmp[1];
			$data['idAnggota2'] = $tmp[2];
		}else{
			$data['idketua'] = $tmp[0];
			$data['idAnggota1'] = '';
			$data['idAnggota2'] = '';
		}

		$this->load->view('perkara_tab/keberatan/form_keberatan_penetapan_h', $data);
	}

	function validateInputPenetapanHakim(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->form_validation->set_rules('tgl_pen_majelis', 'Tanggal Penetapan Majelis Hakim', 'trim|required|max_length[10]|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;

		}else{
			$hakimKetua = $this->encrypt->decode(base64_decode($this->input->post('h_ketua', TRUE)));
			$hakimAnggota1 = $this->encrypt->decode(base64_decode($this->input->post('h_anggota1', TRUE)));
			$hakimAnggota2 = $this->encrypt->decode(base64_decode($this->input->post('h_anggota2', TRUE)));

			$tglPenetapan = $this->input->post('tgl_pen_majelis', TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tglPenetapan = $this->tanggalhelper->convertToMysqlDate($tglPenetapan);
			if($tglPenetapan==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPenetapan,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglPenetapan);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusan = $this->tanggalhelper->getTanggalPutusan($idperkara);
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$tglPenetapan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Kurang Dari Tanggal Putusan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}

			$this->load->model('keberatan/keberatan_m','keberatan');
			$tglPermohonan = $this->keberatan->getTanggalPermohonan($idperkara);

			$selisih = $this->tanggalhelper->getSelisihHari($tglPermohonan,$tglPenetapan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Kurang Dari Tanggal Permohonan Keberatan'));
				return;
			}

			if(intval($hakimKetua)<0){
				echo json_encode(array('st'=>0,'msg'=>'Error, Identitas Hakim Ketua Tidak Ditemukan.'));
				return;
			}elseif(empty($hakimKetua)){
				echo json_encode(array('st'=>0,'msg'=>'Error, Pilih Hakim Ketua.'));
				return;
			}
			if(intval($hakimAnggota1)<0){
				echo json_encode(array('st'=>0,'msg'=>'Error, Identitas Hakim Anggota I Tidak Ditemukan.'));
				return;
			}elseif(empty($hakimAnggota1)){
				echo json_encode(array('st'=>0,'msg'=>'Error, Pilih Hakim Anggota I.'));
				return;
			}

			if(intval($hakimAnggota2)<0){
				echo json_encode(array('st'=>0,'msg'=>'Error, Identitas Hakim Anggota II Tidak Ditemukan.'));
				return;
			}elseif(empty($hakimAnggota2)){
				echo json_encode(array('st'=>0,'msg'=>'Error, Pilih Hakim Anggota II.'));
				return;
			}
			if($hakimKetua==$hakimAnggota1 OR $hakimKetua== $hakimAnggota2 OR $hakimAnggota1==$hakimAnggota2){
				echo json_encode(array('st'=>0,'msg'=>'Error, Tidak Dapat Memilih Hakim Yang Sama.'));
				return;
			}
			$hakimKetuaNama = $this->keberatan->getHakimNama($hakimKetua);
			$hakimAnggota1Nama = $this->keberatan->getHakimNama($hakimAnggota1);
			$hakimAnggota2Nama = $this->keberatan->getHakimNama($hakimAnggota2);
			$majelisHakimText = 'Hakim Ketua: '.$hakimKetuaNama.'</br>Hakim Anggota 1: '.$hakimAnggota1Nama.'</br>Hakim Anggota 2: '.$hakimAnggota2Nama;
			$majelisHakimID = $hakimKetua.','.$hakimAnggota1.','.$hakimAnggota2;
			$majelisHakimNamaText = $hakimKetuaNama.'</br>'.$hakimAnggota1Nama.'</br>'.$hakimAnggota2Nama;
			
			$dataPenetapan = array(
				'penetapan_majelis_hakim'=>$tglPenetapan,
				'majelis_hakim_id'=>$majelisHakimID,
				'majelis_hakim_nama'=>$majelisHakimNamaText,
				'majelis_hakim_text'=>$majelisHakimText,
				'diperbaharui_oleh'=>$this->session->userdata('username'),
				'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
				);
			$datahakim=array(
				array(
					'perkara_id'=>$idperkara,
					'tahapan_id' => 17,
					'tanggal_penetapan' =>$tglPenetapan,
					'urutan' => 1,
					'jabatan_hakim_id' => 1,
					'jabatan_hakim_nama' => 'Hakim Ketua',
					'hakim_id' => $hakimKetua,
					'hakim_nama' => $hakimKetuaNama,
					'aktif' => 'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
					),
				array(
					'perkara_id'=>$idperkara,
					'tahapan_id' => 17,
					'tanggal_penetapan' =>$tglPenetapan,
					'urutan' => 2,
					'jabatan_hakim_id' => 2,
					'jabatan_hakim_nama' => 'Hakim Anggota',
					'hakim_id' => $hakimAnggota1,
					'hakim_nama' => $hakimAnggota1Nama,
					'aktif' => 'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
					),
				array(
					'perkara_id'=>$idperkara,
					'tahapan_id' => 17,
					'tanggal_penetapan' =>$tglPenetapan,
					'urutan' => 3,
					'jabatan_hakim_id' => 2,
					'jabatan_hakim_nama' => 'Hakim Anggota',
					'hakim_id' => $hakimAnggota2,
					'hakim_nama' => $hakimAnggota2Nama,
					'aktif' => 'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
					)
				);
			$result = $this->keberatan->updateDataPenetapanMajelis($idperkara,$dataPenetapan,$datahakim);
			if($result){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
				return;
			}
			
		}
	}

	function penetapan_panitera(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		
		$this->load->model('keberatan/keberatan_m');
		$row=$this->keberatan_m->get_no_perkara($data['perkara_id']);
		$data['nomor_perkara']	= $row->nomor_perkara;
		$data['tanggal_putusan']= $row->tanggal_putusan;
		$data['panitera_id'] = $row->panitera_pengganti_id;
		$data['tanggal_pendaftaran_keberatan']	= $row->tanggal_pendaftaran_keberatan;
		$data['penetapan_panitera_pengganti']	= $row->penetapan_panitera_pengganti;
		$data['current_date'] = date('d/m/Y');
		$data['listPanitera'] = $this->keberatan_m->getListPanitera();
		$tmp = explode(',', $data['panitera_id']);
		if(count($tmp)>1){
			$data['idPanitera1'] = $tmp[0];
			$data['idPanitera2'] = $tmp[1];
		}else{
			$data['idPanitera1'] = $data['panitera_id'];
			$data['idPanitera2'] = '';
		}
		$this->load->view('perkara_tab/keberatan/form_keberatan_penetapan_pp', $data);
	}

	function validateInputPenetapanPanitera(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->form_validation->set_rules('tgl_pen_panitera', 'Tanggal Penetapan Panitera Pengganti', 'trim|required|max_length[10]|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;

		}else{
			$panitera1 = $this->encrypt->decode(base64_decode($this->input->post('panitera1', TRUE)));
			$panitera2 = $this->encrypt->decode(base64_decode($this->input->post('panitera2', TRUE)));

			$tglPenetapan = $this->input->post('tgl_pen_panitera', TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tglPenetapan = $this->tanggalhelper->convertToMysqlDate($tglPenetapan);
			if($tglPenetapan==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPenetapan,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglPenetapan);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusan = $this->tanggalhelper->getTanggalPutusan($idperkara);
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$tglPenetapan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Kurang Dari Tanggal Putusan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}

			$this->load->model('keberatan/keberatan_m','keberatan');
			
			$row=$this->keberatan->get_no_perkara($idperkara);
			$tglPermohonan	= $row->tanggal_pendaftaran_keberatan;
			//$tglPermohonan = $this->keberatan->getTanggalPermohonan($idperkara);

			$selisih = $this->tanggalhelper->getSelisihHari($tglPermohonan,$tglPenetapan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Kurang Dari Tanggal Permohonan Keberatan'));
				return;
			}

			$tglPenHakim	= $row->penetapan_majelis_hakim;
			//$tglPermohonan = $this->keberatan->getTanggalPermohonan($idperkara);

			$selisih = $this->tanggalhelper->getSelisihHari($tglPenHakim,$tglPenetapan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Kurang Dari Tanggal Penetapan Majelis Hakim Keberatan'));
				return;
			}


			if(intval($panitera1)<0){
				echo json_encode(array('st'=>0,'msg'=>'Error, Identitas Panitera Pertama Tidak Ditemukan.'));
				return;
			}elseif(empty($panitera1)){
				echo json_encode(array('st'=>0,'msg'=>'Error, Pilih Panitera Pertama.'));
				return;
			}
			$panitera1Nama = $this->keberatan->getPaniteraNama($panitera1);
			$paniteraID = $panitera1;
			$paniteraText = 'Panitera Pengganti: </br>'.$panitera1Nama;
			$datapanitera = array(
				array(
					'perkara_id'=>$idperkara,
					'tahapan_id' => 17,
					'tanggal_penetapan' =>$tglPenetapan,
					'urutan' => 1,
					'panitera_id' => $panitera1,
					'panitera_nama' => $panitera1Nama,
					'aktif' => 'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
					)
				);
			if(!empty($panitera2)){
				if(intval($panitera2)<0){
					echo json_encode(array('st'=>0,'msg'=>'Error, Identitas Panitera Kedua Tidak Ditemukan.'));
					return;
				}elseif(empty($panitera2)){
					echo json_encode(array('st'=>0,'msg'=>'Error, Pilih Panitera Kedua.'));
					return;
				}

				if($panitera1==$panitera2){
					echo json_encode(array('st'=>0,'msg'=>'Error, Tidak Dapat Memilih Panitera Yang Sama.'));
					return;
				}

				$panitera2Nama 	= $this->keberatan->getPaniteraNama($panitera2);
				$paniteraID 	.=  ','.$panitera2;
				$paniteraText 	.=  '</br>'.$panitera2Nama;
				$datapanitera[1] = array(
					'perkara_id'=>$idperkara,
					'tahapan_id' => 17,
					'tanggal_penetapan' =>$tglPenetapan,
					'urutan' => 2,
					'panitera_id' => $panitera2,
					'panitera_nama' => $panitera2Nama,
					'aktif' => 'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
					);
			}
			
			$dataPenetapan = array(
				'penetapan_panitera_pengganti'=>$tglPenetapan,
				'panitera_pengganti_id'=>$paniteraID,
				'panitera_pengganti_text'=>$paniteraText,
				'diperbaharui_oleh'=>$this->session->userdata('username'),
				'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
			);
			
			$result = $this->keberatan->updateDataPenetapanPanitera($idperkara,$dataPenetapan,$datapanitera);
			if($result){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
				return;
			}
			
		}
	}

	function penetapan_jurusita(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		
		$this->load->model('keberatan/keberatan_m');
		$row=$this->keberatan_m->get_no_perkara($data['perkara_id']);
		$data['nomor_perkara']	= $row->nomor_perkara;
		$data['tanggal_putusan']= $row->tanggal_putusan;
		$data['jurusita_id'] = $row->jurusita_id;
		$data['tanggal_pendaftaran_keberatan']	= $row->tanggal_pendaftaran_keberatan;
		$data['penetapan_jurusita']	= $row->penetapan_jurusita;
		$data['current_date'] = date('d/m/Y');
		$data['listJurusita'] = $this->keberatan_m->getListJurusita();
		$tmp = explode(',', $data['jurusita_id']);
		if(count($tmp)>1){
			$data['idJurusita1'] = $tmp[0];
			$data['idJurusita2'] = $tmp[0];
		}else{
			$data['idJurusita1'] = $data['jurusita_id'];
			$data['idJurusita2'] = '';
		}
		$this->load->view('perkara_tab/keberatan/form_keberatan_penetapan_jurusita', $data);
	}

	function validateInputPenetapanJurusita(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->form_validation->set_rules('tgl_pen_js', 'Tanggal Penetapan Jurusita', 'trim|required|max_length[10]|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;

		}else{
			$jurusita1 = $this->encrypt->decode(base64_decode($this->input->post('jurusita1', TRUE)));
			$jurusita2 = $this->encrypt->decode(base64_decode($this->input->post('jurusita2', TRUE)));

			$tglPenetapan = $this->input->post('tgl_pen_js', TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tglPenetapan = $this->tanggalhelper->convertToMysqlDate($tglPenetapan);
			if($tglPenetapan==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPenetapan,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglPenetapan);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusan = $this->tanggalhelper->getTanggalPutusan($idperkara);
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$tglPenetapan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Kurang Dari Tanggal Putusan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}

			$this->load->model('keberatan/keberatan_m','keberatan');
			$row=$this->keberatan->get_no_perkara($idperkara);
			$tglPermohonan	= $row->tanggal_pendaftaran_keberatan;
			//$tglPermohonan = $this->keberatan->getTanggalPermohonan($idperkara);

			$selisih = $this->tanggalhelper->getSelisihHari($tglPermohonan,$tglPenetapan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Kurang Dari Tanggal Permohonan Keberatan'));
				return;
			}

			$tglPenPanitera	= $row->penetapan_panitera_pengganti;
			//$tglPermohonan = $this->keberatan->getTanggalPermohonan($idperkara);

			$selisih = $this->tanggalhelper->getSelisihHari($tglPenPanitera,$tglPenetapan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Kurang Dari Tanggal Penetapan Panitera Pengganti Keberatan'));
				return;
			}

			if(intval($jurusita1)<0){
				echo json_encode(array('st'=>0,'msg'=>'Error, Identitas Jurusita Pertama Tidak Ditemukan.'));
				return;
			}elseif(empty($jurusita1)){
				echo json_encode(array('st'=>0,'msg'=>'Error, Pilih Jurusita Pertama.'));
				return;
			}
			$jurusita1Nama = $this->keberatan->getJurusitaNama($jurusita1);
			$jurusitaID = $jurusita1;
			$jurusitaText = 'Juru Sita Pengganti: </br>'.$jurusita1Nama;
			$datajurusita = array(
				array(
					'perkara_id'=>$idperkara,
					'tahapan_id' => 17,
					'tanggal_penetapan' =>$tglPenetapan,
					'urutan' => 1,
					'jurusita_id' => $jurusita1,
					'jurusita_nama' => $jurusita1Nama,
					'aktif' => 'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
					)
				);
			if(!empty($jurusita2)){
				if(intval($jurusita2)<0){
					echo json_encode(array('st'=>0,'msg'=>'Error, Identitas Jurusita Kedua Tidak Ditemukan.'));
					return;
				}elseif(empty($jurusita2)){
					echo json_encode(array('st'=>0,'msg'=>'Error, Pilih Jurusita Kedua.'));
					return;
				}

				if($jurusita1==$jurusita2){
					echo json_encode(array('st'=>0,'msg'=>'Error, Tidak Dapat Memilih Jurusita Yang Sama.'));
					return;
				}

				$jurusita2Nama 	= $this->keberatan->getPaniteraNama($jurusita2);
				$jurusitaID 	.=  ','.$jurusita2;
				$jurusitaText 	.=  '</br>'.$jurusita2Nama;
				$datajurusita[1] = array(
					'perkara_id'=>$idperkara,
					'tahapan_id' => 17,
					'tanggal_penetapan' =>$tglPenetapan,
					'urutan' => 2,
					'jurusita_id' => $jurusita2,
					'jurusita_nama' => $jurusita2Nama,
					'aktif' => 'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
					);
			}
			
			$dataPenetapan = array(
				'penetapan_jurusita'=>$tglPenetapan,
				'jurusita_id'=>$jurusitaID,
				'jurusita_text'=>$jurusitaText,
				'diperbaharui_oleh'=>$this->session->userdata('username'),
				'diperbaharui_tanggal'=>date('Y-m-d H:i:s')					
			);
			$result = $this->keberatan->updateDataPenetapanJurusita($idperkara,$dataPenetapan,$datajurusita);
			if($result){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
				return;
			}
			
		}
	}

	function penetapan_sidang(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		
		$this->load->model('keberatan/keberatan_m');
		$row=$this->keberatan_m->get_no_perkara($data['perkara_id']);
		$data['nomor_perkara']	= $row->nomor_perkara;
		$data['enc_sidang']	= base64_encode($this->encrypt->encode($row->sidang_id));
		$data['tanggal_putusan']= $row->tanggal_putusan;
		$data['tanggal_pendaftaran_keberatan']	= $row->tanggal_pendaftaran_keberatan;
		$data['tanggal_penetapan_sidang_keberatan']	= $row->tanggal_penetapan_sidang_keberatan;
		$data['tanggal_sidang_pertama_keberatan']	= $row->tanggal_sidang_pertama_keberatan;
		$data['current_date'] = date('d/m/Y');
		$this->load->view('perkara_tab/keberatan/form_keberatan_penetapan_sidang', $data);
	}

	function validateInputPenetapanSidang(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		
		$this->form_validation->set_rules('tgl_pen_sidang', 'Tanggal Penetapan Sidang Pertama', 'trim|required|max_length[10]|xss_clean');
		$this->form_validation->set_rules('tgl_sidang', 'Tanggal Sidang Pertama', 'trim|required|max_length[10]|xss_clean');
		
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{

			$tglPenetapan = $this->input->post('tgl_pen_sidang', TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tglPenetapan = $this->tanggalhelper->convertToMysqlDate($tglPenetapan);
			if($tglPenetapan==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPenetapan,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglPenetapan);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusan = $this->tanggalhelper->getTanggalPutusan($idperkara);
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$tglPenetapan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Kurang Dari Tanggal Putusan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}

			$this->load->model('keberatan/keberatan_m','keberatan');
			$tglPermohonan = $this->keberatan->getTanggalPermohonan($idperkara);

			$selisih = $this->tanggalhelper->getSelisihHari($tglPermohonan,$tglPenetapan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Kurang Dari Tanggal Permohonan Keberatan'));
				return;
			}

			$tglSidang = $this->input->post('tgl_sidang', TRUE);
			$tglSidang = $this->tanggalhelper->convertToMysqlDate($tglSidang);
			if($tglSidang==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglSidang);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Sidang Pertama Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusan = $this->tanggalhelper->getTanggalPutusan($idperkara);
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$tglSidang);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Sidang Pertama Tidak Boleh Kurang Dari Tanggal Putusan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}
		
			$this->load->model('keberatan/keberatan_m','keberatan');
			
			$row=$this->keberatan->get_no_perkara($idperkara);
			$tglPermohonan	= $row->tanggal_pendaftaran_keberatan;

			$selisih = $this->tanggalhelper->getSelisihHari($tglPermohonan,$tglSidang);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Sidang Pertama Tidak Boleh Kurang Dari Tanggal Permohonan Keberatan'));
				return;
			}

			$tglPenHakim	= $row->penetapan_majelis_hakim;

			$selisih = $this->tanggalhelper->getSelisihHari($tglPenHakim,$tglSidang);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Sidang Pertama Tidak Boleh Kurang Dari Tanggal Penetapan Majelis Hakim Keberatan'));
				return;
			}

			$dataPenetapan = array(
				'tanggal_penetapan_sidang_keberatan'=>$tglPenetapan,
				'tanggal_sidang_pertama_keberatan'=>$tglSidang,
				'diperbaharui_oleh'=>$this->session->userdata('username'),
				'diperbaharui_tanggal'=>date('Y-m-d H:i:s')			
			);
			
			
			$hasSidangPertama = $this->keberatan->hasSidangPertama($idperkara);
			if($hasSidangPertama==FALSE){
				$lastSidang = $this->keberatan->getLastSidang($idperkara);
				if ($tglSidang<$lastSidang){
					$lastSidang = $this->tanggalhelper->convertDayDate($lastSidang);
					echo json_encode(array('st'=>0,'msg'=>'Tanggal Sidang Keberatan Tidak Boleh sebelum Tanggal Sidang Terakhir. '.$lastSidang));
					return;
				}
				$dataSidang = array(
					'perkara_id'=>$idperkara, 
					'keberatan'=>'Y',
					'tanggal_sidang'=>$tglSidang, 
					'jam_sidang'=>'09:00',
					'agenda'=>'SIDANG PERTAMA PERMOHONAN KEBERATAN',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
				);
				$idjadwalsidang = $this->keberatan->addJadwalSidang($dataSidang);
				$dataPenetapan['sidang_id'] = $idjadwalsidang;
			}
			$result = $this->keberatan->updateDataPenetapanSidang($idperkara,$dataPenetapan);
			if($result){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
				return;
			}
			
		}
	}

	function validateDeleteSidang(){
		if(empty($_POST)){
			show_404();
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$idsidang = ($this->encrypt->decode(base64_decode($this->input->post('enc_sidang'))));
		if(empty($idsidang) OR intval($idsidang)<1){
			echo json_encode(array('st'=>0,'msg'=>'Data Tidak Ditemukan.'));
			return;
		}

		$this->load->model('keberatan/keberatan_m','keberatan');
		$delData = $this->keberatan->deleteDataSidang($idperkara,$idsidang);
		if($delData){
			echo json_encode(array('st'=>1,'msg'=>'Data Penetapan Sidang Pertama Keberatan Berhasil DiHapus.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Penghapusan Data Penetapan Sidang Pertama Keberatan Gagal.'));
			return;
		}
	}

	function validateDeleteJurusita(){
		if(empty($_POST)){
			show_404();
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->load->model('keberatan/keberatan_m','keberatan');
		$delData = $this->keberatan->deleteDataPenJurusita($idperkara);
		if($delData){
			echo json_encode(array('st'=>1,'msg'=>'Data Penetapan Jurusita Keberatan Berhasil DiHapus.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Penghapusan Data Penetapan Jurusita Keberatan Gagal.'));
			return;
		}
	}

	function validateDeletePanitera(){
		if(empty($_POST)){
			show_404();
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->load->model('keberatan/keberatan_m','keberatan');
		$delData = $this->keberatan->deleteDataPenPanitera($idperkara);
		if($delData){
			echo json_encode(array('st'=>1,'msg'=>'Data Penetapan Panitera Pengganti Keberatan Berhasil DiHapus.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Penghapusan Data Penetapan Panitera Pengganti Keberatan Gagal.'));
			return;
		}
	}

	function validateDeleteHakim(){
		if(empty($_POST)){
			show_404();
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->load->model('keberatan/keberatan_m','keberatan');
		$delData = $this->keberatan->deleteDataPenHakim($idperkara);
		if($delData){
			echo json_encode(array('st'=>1,'msg'=>'Data Penetapan Majelis Hakim Keberatan Berhasil DiHapus.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Penghapusan Data Penetapan Majelis Hakim Keberatan Gagal.'));
			return;
		}
	}

	function keberatan_putusan(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		if(empty($data['perkara_id']) OR intval($data['perkara_id'])<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'Justify lock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '1060px';
		$this->ckeditor->config['height'] = '280px';

		$this->load->model('keberatan/keberatan_m');
		$row=$this->keberatan_m->get_no_perkara($data['perkara_id']);
		$data['nomor_perkara']	= $row->nomor_perkara;
		$data['tanggal_putusan']= $row->tanggal_putusan;
		$data['tanggal_pendaftaran_keberatan']	= $row->tanggal_pendaftaran_keberatan;
		$data['putusan_keberatan']=$row->putusan_keberatan;
		$data['idputusan']=$row->status_putusan_keberatan_id;
		$data['statusputusan'] = $this->keberatan_m->get_status_putusan();
		$data['amar_putusan_keberatan']=$row->amar_putusan_keberatan;
		$data['amar_putusan_keberatan_dok']=$row->amar_putusan_keberatan_dok;
		$data['current_date'] = date('d/m/Y');
		$this->load->view('perkara_tab/keberatan/form_keberatan_putusan', $data);
	}

	function validateInputPutusanKeberatan(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$idstatusputusan = ($this->encrypt->decode(base64_decode($this->input->post('status_putusan'))));
		if(empty($idstatusputusan) OR intval($idstatusputusan)<1){
			echo json_encode(array('st'=>0,'msg'=>'Error, Invalid Data Status Putusan Found'));
			return;
		}

		$this->form_validation->set_rules('tgl_putusan_keberatan', 'Tanggal Putusan Keberatan', 'trim|required|max_length[10]|xss_clean');
		#$this->form_validation->set_rules('status_putusan', 'Status Putusan keberatan', 'trim|required|is_numeric|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{

			$tglPutusanKeberatan = $this->input->post('tgl_putusan_keberatan', TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tglPutusanKeberatan = $this->tanggalhelper->convertToMysqlDate($tglPutusanKeberatan);
			if($tglPutusanKeberatan==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusanKeberatan,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan Keberatan Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglPutusanKeberatan);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusan = $this->tanggalhelper->getTanggalPutusan($idperkara);
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$tglPutusanKeberatan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan Keberatan Tidak Boleh Kurang Dari Tanggal Putusan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}

			$this->load->model('keberatan/keberatan_m','keberatan');
			$data = $this->keberatan->get_no_perkara($idperkara);
			$tglPermohonan = $data->tanggal_pendaftaran_keberatan;
			$selisih = $this->tanggalhelper->getSelisihHari($tglPermohonan,$tglPutusanKeberatan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan Keberatan Tidak Boleh Kurang Dari Tanggal Permohonan Keberatan'));
				return;
			}

			$tanggal = $data->tanggal_penetapan_sidang_keberatan;
			$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$tglPutusanKeberatan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan Keberatan Tidak Boleh Kurang Dari Tanggal Penetapan Sidang Pertama Keberatan'));
				return;
			}

			/*
			$tanggal = $data->penetapan_jurusita;
			$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$tglPutusanKeberatan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan Keberatan Tidak Boleh Kurang Dari Tanggal Penetapan Jurusita Keberatan'));
				return;
			}
			*/
			$tanggal = $data->penetapan_panitera_pengganti;
			$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$tglPutusanKeberatan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan Keberatan Tidak Boleh Kurang Dari Tanggal Penetapan Panitera Pengganti Keberatan'));
				return;
			}

			$tanggal = $data->penetapan_majelis_hakim;
			$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$tglPutusanKeberatan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan Keberatan Tidak Boleh Kurang Dari Tanggal Penetapan Majelis Hakim Keberatan'));
				return;
			}
			

			$statusputusantext = $this->keberatan->getStatusPutusanNama($idstatusputusan);
			if(empty($statusputusantext)){
				echo json_encode(array('st'=>0,'msg'=>'Error, Invalid Data Status Putusan Found'));
				return;
			}

			$amar = trim($this->input->post('amar_putusan_keberatan_text',TRUE));
			$amar = str_replace("&nbsp;", " ", $amar);
			
			if(strlen($amar)<50){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Amar Putusan Tidak Boleh kurang dari 50 Karakter'));
				return;
			}

			$dataPutusan = array(
				'putusan_keberatan'=>$tglPutusanKeberatan,
				'status_putusan_keberatan_id'=>$idstatusputusan,
				'status_putusan_keberatan_text'=>$statusputusantext,
				'amar_putusan_keberatan'=>$amar,
				'diperbaharui_oleh'=>$this->session->userdata('username'),
				'diperbaharui_tanggal'=>date('Y-m-d H:i:s')					
			);
			
			$result = $this->keberatan->updateDataPutusan($idperkara,$dataPutusan);
			if($result){
				echo json_encode(array('st'=>1,'msg'=>'Data Putusan Berhasil Disimpan'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
				return;
			}
			
		}
	}

	function keberatan_memori(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		if(empty($data['perkara_id']) OR intval($data['perkara_id'])<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->load->model('keberatan/keberatan_m');
		$row=$this->keberatan_m->get_no_perkara($data['perkara_id']);
		$data['nomor_perkara']	= $row->nomor_perkara;
		$data['tanggal_putusan']= $row->tanggal_putusan;
		$data['tanggal_pendaftaran_keberatan']	= $row->tanggal_pendaftaran_keberatan;
		$data['penerimaan_memori']=$row->penerimaan_memori;
		$data['penyerahan_memori']=$row->penyerahan_memori;
		$data['penerimaan_kontra_memori']=$row->penerimaan_kontra_memori;
		$data['penyerahan_kontra_memori']=$row->penyerahan_kontra_memori;
		$data['inzage_pihak1']=$row->inzage_pihak1;
		$data['inzage_pihak2']=$row->inzage_pihak2;		
		$data['current_date'] = date('d/m/Y');
		$this->load->view('perkara_tab/keberatan/form_keberatan_memori', $data);
	}

	function validateInputMemoriKeberatan(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$dataPemberitahuan = array(
			'diperbaharui_oleh'=>$this->session->userdata('username'),
			'diperbaharui_tanggal'=>date('Y-m-d H:i:s')					
		);

		$curr_date = date('Y-m-d');
		$todayDate = date('d/m/Y');
		$this->load->model('keberatan/keberatan_m','keberatan');
		$penerimaanMemori = $this->input->post('tgl_penerimaan_memori', TRUE);
		$penyerahanMemori = $this->input->post('tgl_penyerahan_memori', TRUE);
		$penerimaanKontraMemori = $this->input->post('tgl_penerimaan_kontra_memori', TRUE);
		$penyerahanKontraMemori = $this->input->post('tgl_penyerahan_kontra_memori', TRUE);
		$inzagePihak1 = $this->input->post('inzage_pihak1', TRUE);
		$inzagePihak2 = $this->input->post('inzage_pihak2', TRUE);
	
		$tglPutusan = $this->tanggalhelper->getTanggalPutusan($idperkara);
		$penerimaanMemori = $this->input->post('tgl_penerimaan_memori', TRUE);
		if(!empty($penerimaanMemori)){
			$penerimaanMemori = $this->tanggalhelper->convertToMysqlDate($penerimaanMemori);
			if($penerimaanMemori==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($penerimaanMemori,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penerimaan Memori Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($penerimaanMemori);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penerimaan Memori Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$penerimaanMemori);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penerimaan Memori Tidak Boleh Kurang Dari Tanggal Putusan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}
			$dataPemberitahuan['penerimaan_memori'] = $penerimaanMemori;
		}

		$penyerahanMemori = $this->input->post('tgl_penyerahan_memori', TRUE);
		if(!empty($penyerahanMemori)){

			$penyerahanMemori = $this->tanggalhelper->convertToMysqlDate($penyerahanMemori);
			if($penyerahanMemori==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($penyerahanMemori,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penyerahan Memori Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($penyerahanMemori);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penyerahan Memori Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$penyerahanMemori);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penyerahan Memori Tidak Boleh Kurang Dari Tanggal Putusan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}
			if(empty($penerimaanMemori)){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Data Tanggal Penerimaan Memori Belum Di isi.'));
				return;
			}else{
				$selisih = $this->tanggalhelper->getSelisihHari($penerimaanMemori,$penyerahanMemori);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penyerahan Memori Tidak Boleh Kurang Dari Tanggal Penerimaan Memori'));
					return;
				}
			}
			$dataPemberitahuan['penyerahan_memori'] = $penyerahanMemori;
		}
		$penerimaanKontraMemori = $this->input->post('tgl_penerimaan_kontra_memori', TRUE);
		if(!empty($penerimaanKontraMemori)){
			$penerimaanKontraMemori = $this->tanggalhelper->convertToMysqlDate($penerimaanKontraMemori);
			if($penerimaanKontraMemori==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($penerimaanKontraMemori,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penerimaan Kontra Memori Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($penerimaanKontraMemori);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penerimaan Kontra Memori Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$penerimaanKontraMemori);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penerimaan Kontra Memori Tidak Boleh Kurang Dari Tanggal Putusan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}
			
			if(empty($penyerahanMemori)){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Data Tanggal Penyerahan Memori Belum Di isi.'));
				return;
			}else{
				$selisih = $this->tanggalhelper->getSelisihHari($penyerahanMemori,$penerimaanKontraMemori);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penerimaan Kontra Memori Tidak Boleh Kurang Dari Tanggal Penyerahan Memori'));
					return;
				}
			}

			$dataPemberitahuan['penerimaan_kontra_memori'] = $penerimaanKontraMemori;
		}
		

		$penyerahanKontraMemori = $this->input->post('tgl_penyerahan_kontra_memori', TRUE);
		if(!empty($penyerahanKontraMemori)){
			$penyerahanKontraMemori = $this->tanggalhelper->convertToMysqlDate($penyerahanKontraMemori);
			if($penyerahanKontraMemori==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($penyerahanKontraMemori,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penyerahan Kontra Memori Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($penyerahanKontraMemori);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penyerahan Kontra Memori Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$penyerahanKontraMemori);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penyerahan Kontra Memori Tidak Boleh Kurang Dari Tanggal Putusan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}
			
			if(empty($penerimaanKontraMemori)){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Data Tanggal Penerimaan Kontra Memori Belum Di isi.'));
				return;
			}else{
				$selisih = $this->tanggalhelper->getSelisihHari($penerimaanKontraMemori,$penyerahanKontraMemori);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penyerahan Kontra Memori Tidak Boleh Kurang Dari Tanggal Penerimaan Kontra Memori'));
					return;
				}
			}

			$dataPemberitahuan['penyerahan_kontra_memori'] = $penyerahanKontraMemori;
		}

		$inzagePihak1 = $this->input->post('inzage_pihak1', TRUE);
		if(!empty($inzagePihak1)){
			$inzagePihak1 = $this->tanggalhelper->convertToMysqlDate($inzagePihak1);
			if($inzagePihak1==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($inzagePihak1,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Inzage Kepada Penggugat Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($inzagePihak1);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pemberitahuan Inzage Kepada Penggugat Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$inzagePihak1);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Inzage Kepada Penggugat Tidak Boleh Kurang Dari Tanggal Putusan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}
			$dataPemberitahuan['inzage_pihak1'] = $inzagePihak1;
		}

		$inzagePihak2 = $this->input->post('inzage_pihak2', TRUE);
		if(!empty($inzagePihak2)){
			$inzagePihak2 = $this->tanggalhelper->convertToMysqlDate($inzagePihak2);
			if($inzagePihak2==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($inzagePihak2,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Inzage Kepada Tergugat Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($inzagePihak2);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pemberitahuan Inzage Kepada Penggugat Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$inzagePihak2);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Inzage Kepada Penggugat Tidak Boleh Kurang Dari Tanggal Putusan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}
			
			$dataPemberitahuan['inzage_pihak2'] = $inzagePihak2;
		}

		$result = $this->keberatan->updateDataMemori($idperkara,$dataPemberitahuan);
		if($result){
			echo json_encode(array('st'=>1,'msg'=>'Data Pemberitahuan Berhasil Disimpan'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
			return;
		}
	}

	function validateDeleteProsesKeberatan(){
		if(empty($_POST)){
			show_404();
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->load->model('keberatan/keberatan_m','keberatan');
		$delData = $this->keberatan->deleteDataMemori($idperkara);
		if($delData){
			echo json_encode(array('st'=>1,'msg'=>'Data Proses Keberatan Berhasil DiHapus.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Penghapusan Data Proses Keberatan Gagal.'));
			return;
		}
	}

	function keberatan_pemberitahuan(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		if(empty($data['perkara_id']) OR intval($data['perkara_id'])<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->load->model('keberatan/keberatan_m');
		$row=$this->keberatan_m->get_no_perkara($data['perkara_id']);
		$data['nomor_perkara']	= $row->nomor_perkara;
		$data['tanggal_putusan']= $row->tanggal_putusan;
		$data['tanggal_pendaftaran_keberatan']	= $row->tanggal_pendaftaran_keberatan;
		$data['putusan_keberatan']=$row->putusan_keberatan;
		$data['pemberitahuan_putusan_keberatan_pihak1']=$row->pemberitahuan_putusan_keberatan_pihak1;
		$data['pemberitahuan_putusan_keberatan_pihak2']=$row->pemberitahuan_putusan_keberatan_pihak2;
		$data['tanggal_minutasi_keberatan']=$row->tanggal_minutasi_keberatan;	
		$data['current_date'] = date('d/m/Y');
		$this->load->view('perkara_tab/keberatan/form_keberatan_pemberitahuan', $data);
	}

	function validateInputPemberitahuanKeberatan(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$dataPemberitahuan = array(
			'diperbaharui_oleh'=>$this->session->userdata('username'),
			'diperbaharui_tanggal'=>date('Y-m-d H:i:s')					
		);

		$curr_date = date('Y-m-d');
		$todayDate = date('d/m/Y');
		$this->load->model('keberatan/keberatan_m','keberatan');
		$tglPutusan = $this->keberatan->getTglPutusanKeberatan($idperkara);
		if(empty($tglPutusan)){
			echo json_encode(array('st'=>0,'msg'=>'Data Putusan Masih Kosong'));
			return;
		}
	
		$tglPemberitahuanPihak1 = $this->input->post('tgl_pemberitahuan_pihak1', TRUE);

		if(!empty($tglPemberitahuanPihak1)){
			$tglPemberitahuanPihak1 = $this->tanggalhelper->convertToMysqlDate($tglPemberitahuanPihak1);
			if($tglPemberitahuanPihak1==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPemberitahuanPihak1,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Keberatan Kepada Pemohon Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglPemberitahuanPihak1);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pemberitahuan Keberatan Kepada Pemohon Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$tglPemberitahuanPihak1);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Keberatan Kepada Pemohon Tidak Boleh Kurang Dari Tanggal Putusan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}
			$dataPemberitahuan['pemberitahuan_putusan'] = $tglPemberitahuanPihak1;
			$dataPemberitahuan['pemberitahuan_putusan_keberatan_pihak1'] = $tglPemberitahuanPihak1;
		}
		
		$tglPemberitahuanPihak2 = $this->input->post('tgl_pemberitahuan_pihak2', TRUE);
		if(!empty($tglPemberitahuanPihak2)){
			
			$tglPemberitahuanPihak2 = $this->tanggalhelper->convertToMysqlDate($tglPemberitahuanPihak2);
			if($tglPemberitahuanPihak2==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPemberitahuanPihak2,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Keberatan Kepada Termohon Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglPemberitahuanPihak2);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pemberitahuan Keberatan Kepada Termohon Dihari Libur, Sabtu dan Minggu.'));
				return;
			}
			
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$tglPemberitahuanPihak2);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Keberatan Kepada Termohon Tidak Boleh Kurang Dari Tanggal Putusan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}

			$dataPemberitahuan['pemberitahuan_putusan_keberatan_pihak2'] = $tglPemberitahuanPihak2;
			
			if(empty($tglpemberitahuanpihak1)){
				$dataPemberitahuan['pemberitahuan_putusan'] = $tglPemberitahuanPihak2;
			}else{
				$dataPemberitahuan['pemberitahuan_putusan'] = $tglPemberitahuanPihak1;
			}
		}

		#didik
		$tgl_minutasi = $this->input->post('tgl_minutasi', TRUE);
		if(!empty($tgl_minutasi)){
			
			$tgl_minutasi = $this->tanggalhelper->convertToMysqlDate($tgl_minutasi);
			if($tgl_minutasi==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tgl_minutasi,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Minutasi Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tgl_minutasi);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Minutasi Dihari Libur, Sabtu dan Minggu.'));
				return;
			}
			
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$tgl_minutasi);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Minutasi Tidak Boleh Kurang Dari Tanggal Putusan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}									
		}
		if(empty($tgl_minutasi)){
			$dataPemberitahuan['tanggal_minutasi_keberatan'] = NULL;
		}else{
			$dataPemberitahuan['tanggal_minutasi_keberatan'] = $tgl_minutasi;
		}

		if(empty($tglPemberitahuanPihak1)){
			echo json_encode(array('st'=>0,'msg'=>'Mohon Mengisikan Data Tanggal Pemberitahuan'));
			return;
		}
		if(empty($tglPemberitahuanPihak2)){
			echo json_encode(array('st'=>0,'msg'=>'Mohon Mengisikan Data Tanggal Pemberitahuan'));
			return;
		}
		#end

		$result = $this->keberatan->updateDataPemberitahuan($idperkara,$dataPemberitahuan);
		if($result){
			echo json_encode(array('st'=>1,'msg'=>'Data Pemberitahuan Berhasil Disimpan'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
			return;
		}
	}

	function validateDeletePutusan(){
		if(empty($_POST)){
			show_404();
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->load->model('keberatan/keberatan_m','keberatan');
		$delData = $this->keberatan->deleteDataPutusan($idperkara);
		if($delData){
			echo json_encode(array('st'=>1,'msg'=>'Data Putusan Keberatan Berhasil DiHapus.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Penghapusan Data Putusan Keberatan Gagal.'));
			return;
		}
	}

	function validateDeletePemberitahuan(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->load->model('keberatan/keberatan_m','keberatan');
		$delData = $this->keberatan->deleteDataPemberitahuan($idperkara);
		if($delData){
			echo json_encode(array('st'=>1,'msg'=>'Data Pemberitahuan Putusan Keberatan Berhasil DiHapus.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Penghapusan Data Pemberitahuan Putusan Keberatan Gagal.'));
			return;
		}
	}

	function add_pihak_Keberatan(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		
		$this->load->model('keberatan/keberatan_m');
		$row=$this->keberatan_m->get_no_perkara($data['perkara_id']);
		$data['nomor_perkara']=$row->nomor_perkara;
		$data['tanggal_putusan']=$row->tanggal_putusan;
		$data['tanggal_pendaftaran_keberatan']=$row->tanggal_pendaftaran_keberatan;
		$data['pemohon']=$row->pemohon_keberatan;
		$data['list_penggugat'] = $this->keberatan_m->get_para_pihak($data['perkara_id'],1);
		$data['list_tergugat'] = $this->keberatan_m->get_para_pihak($data['perkara_id'],2);
		$data['current_date'] = date('d/m/Y');
		$data['action']='add';
		$data['parapihakkeberatan'] = $this->keberatan_m->getListParaPihak($data['perkara_id']);
		$this->load->view('perkara_tab/keberatan/form_add_pihak_keberatan', $data);
	}

}












