<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Report_status_mediator extends CI_Model{
	
	function get_info_pn(){
		try {
			$this->db->select('*');
			$this->db->where('id >=', 61); 
			return $this->db->get('sys_config');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	function getJenisPerkara($idalurperkara){
		if(empty($idalurperkara)) return '';
		try {
			$this->db->where('id',$idalurperkara);
			return $this->db->get('alur_perkara')->row()->nama;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_tahun($idalurperkara){
		try {
			return $this->db->query('SELECT YEAR(min(tanggal_pendaftaran)) AS years FROM perkara WHERE alur_perkara_id IN ('.$idalurperkara.');');
		} catch (Exception $e) {
			
		}
	}

	function get_rekap($idalurperkara,$tahun){
		try {
			return $this->db->query('SELECT tanggal_pendaftaran, 
				left(tanggal_pendaftaran,7) AS tgl,
				tahun_pendaftaran,
				bulan_pendaftaran, 
				LEFT(tanggal_putusan,7) AS putusan, 
				LEFT(penetapan_majelis_hakim,7) AS majelis,
				hasil_mediasi,LEFT(tanggal_cabut,7) AS cabut,
				LEFT(keputusan_mediasi,7) AS mediasi, 
				LEFT(tanggal_gugur,7) AS gugur,LEFT(tanggal_minutasi,7) AS minutasi
				FROM v_perkara 
				WHERE alur_perkara_id IN ('.$idalurperkara.') AND tahun_pendaftaran<='.$tahun.';');
		} catch (Exception $e) {
			
		}
	}

	function get_stat_perkara($period,$idalurperkara){
		try {
			return $this->db->query("
				SELECT alur_perkara_id,alur_perkara_nama,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>='".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' THEN 1
						ELSE 0
						END
					) AS sisa,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
						ELSE 0
						END
					) AS putus_blm_minut,
				SUM(
					CASE 
						WHEN (keputusan_mediasi IS NOT NULL AND LEFT(keputusan_mediasi,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') AND hasil_mediasi='Y' THEN 1
						ELSE 0
						END
					) AS med_blm_minut,
				SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) = '".$period."' THEN 1
						ELSE 0
						END
					) AS masuk,
				SUM(
					CASE 
						WHEN (penetapan_majelis_hakim IS NULL OR LEFT(penetapan_majelis_hakim,7)>'".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS blm_majelis,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS putus,
				SUM(
					CASE 
						WHEN (tanggal_minutasi IS NOT NULL AND LEFT(tanggal_minutasi,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS minut,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>'".$period."') THEN 1
						WHEN (LEFT(mediasi_berhasil,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
						ELSE 0
						END
					) AS blm_minut,
				SUM(
					CASE 
						WHEN (tanggal_cabut IS NOT NULL AND LEFT(tanggal_cabut,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS cabut,
				SUM(
					CASE 
						WHEN (tanggal_gugur IS NOT NULL AND LEFT(tanggal_gugur,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS gugur,
				SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='Y' AND status_mediator='H' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
						ELSE 0
						END
					) AS mediator_hakim_berhasil,
					SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='N' AND status_mediator='H' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
						ELSE 0
						END
					) AS mediator_hakim_gagal
				FROM v_perkara
				WHERE alur_perkara_id IN (".$idalurperkara.")
				AND LEFT(tanggal_pendaftaran,7) <='".$period."';
				");
		} catch (Exception $e) {
			
		}
	}

	function get_stat_perkara_bln($period,$idalurperkara){
		try {
			return $this->db->query("
				SELECT jenis_perkara_id,jenis_perkara_nama,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>='".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' THEN 1
						ELSE 0
						END
					) AS sisa,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
						ELSE 0
						END
					) AS putus_blm_minut,
				SUM(
					CASE 
						WHEN (keputusan_mediasi IS NOT NULL AND LEFT(keputusan_mediasi,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') AND hasil_mediasi='Y' THEN 1
						ELSE 0
						END
					) AS med_blm_minut,
				SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) = '".$period."' THEN 1
						ELSE 0
						END
					) AS masuk,
				SUM(
					CASE 
						WHEN (penetapan_majelis_hakim IS NULL OR LEFT(penetapan_majelis_hakim,7)>'".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS blm_majelis,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS putus,
				SUM(
					CASE 
						WHEN (tanggal_minutasi IS NOT NULL AND LEFT(tanggal_minutasi,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS minut,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>'".$period."') THEN 1
						WHEN (LEFT(mediasi_berhasil,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
						ELSE 0
						END
					) AS blm_minut,
				SUM(
					CASE 
						WHEN (tanggal_cabut IS NOT NULL AND LEFT(tanggal_cabut,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS cabut,
				SUM(
					CASE 
						WHEN (tanggal_gugur IS NOT NULL AND LEFT(tanggal_gugur,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS gugur,
				SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='Y' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
						ELSE 0
						END
					) AS mediasi_berhasil,
					SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='N' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
						ELSE 0
						END
					) AS mediasi_gagal
				FROM v_perkara
				WHERE alur_perkara_id IN (".$idalurperkara.")
				AND LEFT(tanggal_pendaftaran,7) <='".$period."'
				GROUP BY jenis_perkara_id;");
		} catch (Exception $e) {
			
		}
	}
	function get_lap_perkara($period,$idalurperkara){
		try {
			$sql="SELECT 
						m.teks, 
						v.perkara_mediasi,
						v.berhasil_akta,
						IF(IFNULL(v.perkara_mediasi,0)=0 OR IFNULL(v.berhasil_akta,0)=0,0,CONCAT(round(v.berhasil_akta/v.perkara_mediasi*100),'%')) AS persen_akta,
						v.berhasil_sebagian,
						IF(IFNULL(v.perkara_mediasi,0)=0 OR IFNULL(v.berhasil_sebagian,0)=0,0,CONCAT(round(v.berhasil_sebagian/v.perkara_mediasi*100),'%')) AS persen_sebagian,
						v.berhasil_cabut,
						IF(IFNULL(v.perkara_mediasi,0)=0 OR IFNULL(v.berhasil_cabut,0)=0,0,CONCAT(round(v.berhasil_cabut/v.perkara_mediasi*100),'%')) AS persen_cabut,
						v.tidak_berhasil,
						IF(IFNULL(v.perkara_mediasi,0)=0 OR IFNULL(v.tidak_berhasil,0)=0,0,CONCAT(round(v.tidak_berhasil/v.perkara_mediasi*100),'%')) AS persen_tidak_berhasil,
						v.tidak_dpt_dilaksanakan,
						IF(IFNULL(v.perkara_mediasi,0)=0 OR IFNULL(v.tidak_dpt_dilaksanakan,0)=0,0,CONCAT(round(v.tidak_dpt_dilaksanakan/v.perkara_mediasi*100),'%')) AS persen_tidak_dpt_dilaksanakan
						FROM 
						(SELECT 1 AS id, 'H' AS kode, 'Hakim Bersertifikat' AS teks UNION
						SELECT 2 , 'H', 'Hakim Tidak Bersertifikat' UNION
						SELECT 3 , 'P', 'Pejabat Pengadilan' UNION
						SELECT 4 , 'N', 'Mediator Umum') AS m
						LEFT JOIN mediator AS mp ON mp.`status_mediator` = m.kode
						LEFT JOIN (SELECT p.id_mediator
							,SUM(IF(LEFT(dimulai_mediasi,7)='".$period."',1,0))  AS perkara_mediasi
							,SUM(IF(LEFT(keputusan_mediasi,7)='".$period."' AND (hasil_mediasi='Y' OR hasil_mediasi = 'Y1') AND (tanggal_putusan IS NULL OR (tanggal_putusan IS NOT NULL AND status_putusan_id NOT IN (7,37,67))),1,0)) AS berhasil_akta
							,SUM(IF(LEFT(keputusan_mediasi,7)='".$period."' AND hasil_mediasi='S',1,0)) AS berhasil_sebagian
							,SUM(IF(LEFT(keputusan_mediasi,7)='".$period."' AND (hasil_mediasi='Y' OR hasil_mediasi = 'Y2') AND (tanggal_putusan IS NULL OR (tanggal_putusan IS NOT NULL AND status_putusan_id IN (7,37,67))),1,0)) AS berhasil_cabut
							,SUM(IF(LEFT(keputusan_mediasi,7)='".$period."' AND hasil_mediasi='T',1,0)) AS tidak_berhasil
							,SUM(IF(LEFT(keputusan_mediasi,7)='".$period."' AND hasil_mediasi='D',1,0)) AS tidak_dpt_dilaksanakan
							FROM 
							(SELECT split_string(v.`mediator_id`,',',num.n) AS id_mediator ,v.* FROM v_perkara AS v 
								JOIN (SELECT 1 AS n UNION SELECT 2 UNION SELECT 3 UNION SELECT 4 UNION SELECT 5) AS num 
								ON num.n -1 <= CHAR_LENGTH(v.mediator_id) -CHAR_LENGTH(REPLACE(v.mediator_id, ',', ''))) 
						AS p WHERE p.alur_perkara_id=1 GROUP BY p.id_mediator) AS v ON v.id_mediator LIKE mp.id
						WHERE mp.aktif='Y' AND IF(m.id=2,mp.`tgl_sertifikasi` IS NULL,mp.`tgl_sertifikasi` IS NOT NULL)
					    GROUP BY m.id ORDER BY mp.id;";
			return $this->db->query($sql);
		} catch (Exception $e) {
			
		}
	}
}