<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manage_user extends CI_Controller {
	function index(){
		#make sure that only admin level that can open the page
		if($this->session->userdata('idgroup')>2){
			redirect('login');
		}
		$param = $this->encrypt->decode(base64_decode($this->input->post('action',TRUE)));
		if($param==='add'){
			$this->showPage("","");
			return;
		}
		$enc = $this->uri->segment(2);
		$userid = $this->encrypt->decode(base64_decode($enc));
		if(is_numeric($userid)){
			$this->showPage($userid,$enc);
		}else{
			redirect('login');
		}
	}
 
	function showPage($userid,$enc){
		$this->load->model('users/users');
		$data['page_title'] = 'EDIT DATA USER ';
		$data['main_body'] = 'users/user_edit';
		$data['enc'] = $enc;
		$data['page_url'] = 'user_update';
		$data['user_info'] ='';
		if(!empty($userid)){
			$data['user_info'] = $this->users->get_user_info($userid);
			$data['userid'] = $userid;
		}else{
			$row = $this->users->get_last_id();
			$userid = $row->userid+1;
			$data['userid'] = $userid;
		}
		
		$data['group_list'] = $this->users->get_group_list();
		$data['panitera_list'] = $this->users->get_list_panitera();
		$data['hakim_list'] = $this->users->get_list_hakim();
		$data['jurusita_list'] = $this->users->get_list_jurusita();
		
		$data['history'] = current_url();

		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_edit');
	}

	function validate_input(){
		if(empty($_POST)){
			show_404();
		}
		$this->form_validation->set_rules('fullname', 'Nama Lengkap', 'trim|required|xss_clean');
		
		$this->form_validation->set_rules('password', 'Password', 'trim|required|matches[password_repeat]|xss_clean');
		$this->form_validation->set_rules('password_repeat', 'Password', 'trim|required|xss_clean');
		
		if($this->input->post('act',TRUE)=='updt'){
			$this->form_validation->set_rules('username', 'Username', 'trim|required|xss_clean');
			$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');

		}else{
			$this->form_validation->set_rules('username', 'Username', 'trim|required|xss_clean|is_unique[sys_users.username]');
			$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|is_unique[sys_users.email]');

		}
		$tupoksi = $this->input->post('tupoksi',TRUE);
		if(($tupoksi==30 OR $tupoksi == 500 OR $tupoksi==410 OR $tupoksi==420 OR $tupoksi==430 OR $tupoksi==440 OR $tupoksi==450 OR $tupoksi==460 OR $tupoksi==1000 OR $tupoksi==1010 OR $tupoksi==1020) AND $this->input->post('act',TRUE)!='updt'){
			$this->form_validation->set_rules('panitera', 'Panitera', 'trim|required|xss_clean|is_unique[v_users.panitera_id]');
		}elseif(($tupoksi==10 OR $tupoksi == 20) AND $this->input->post('act',TRUE)!='updt') {
			$this->form_validation->set_rules('hakim', 'Hakim', 'trim|required|xss_clean|is_unique[v_users.hakim_id]');
		}elseif($tupoksi==600 AND $this->input->post('act',TRUE)!='updt'){
			$this->form_validation->set_rules('jurusita', 'Jurusita', 'trim|required|xss_clean|is_unique[v_users.jurusita_id]');
		}

		$updt_data_optional = FALSE;

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$expired = ($this->input->post('expired_date',TRUE)=='')? NULL:$this->parseDate($this->input->post('expired_date',TRUE));
			$data_group = array(
				'userid' => $this->input->post('userid',TRUE),
				'groupid' => $this->input->post('tupoksi',TRUE)
			);
			$code_activation = md5(uniqid());
			$password = $this->arr2md5(array($code_activation,$this->input->post('password',TRUE)));
			$activation = $this->arr2md5(array($this->input->post('fullname',TRUE), $this->input->post('username',TRUE), $this->input->post('email',TRUE)));
			$data_users = array(
				'fullname' => $this->input->post('fullname',TRUE),
				'username' => $this->input->post('username',TRUE),
				'password' => $password,
				'email' => $this->input->post('email',TRUE),
				'activation' => $activation,
				'code_activation' => $code_activation,
				'alternative_email' => $this->input->post('alter_email',TRUE),
				'block' => $this->input->post('block',TRUE),
				'user_expired' => $expired
			);

			# Manage data in table user_Hakim, user_Panitera, user_Jurusita
			$data_optional = array();
			if($tupoksi==30 OR $tupoksi == 500 OR $tupoksi==410 OR $tupoksi==420 OR $tupoksi==430 OR $tupoksi==440 OR $tupoksi==450 OR $tupoksi==460 OR $tupoksi==1000 OR $tupoksi==1010 OR $tupoksi==1020){
				$data_optional['userid'] = $this->input->post('userid',TRUE);
				$data_optional['col_value'] = $this->input->post('panitera',TRUE);
				$data_optional['table'] = 'user_panitera';
				$updt_data_optional = TRUE;
			}elseif($tupoksi==10 OR $tupoksi == 20){
				$data_optional['userid'] = $this->input->post('userid',TRUE);
				$data_optional['col_value'] = $this->input->post('hakim',TRUE);
				$data_optional['table'] = 'user_hakim';
				$updt_data_optional = TRUE;
			}elseif($tupoksi==600){
				$data_optional['userid'] = $this->input->post('userid',TRUE);
				$data_optional['col_value'] = $this->input->post('jurusita',TRUE);
				$data_optional['table'] = 'user_jurusita';
				$updt_data_optional = TRUE;
			}else{
				$data_optional['userid'] = $this->input->post('userid',TRUE);
				$data_optional['table'] = '';
			}

			if($this->input->post('act',TRUE)=='add'){	
				$data_users['userid'] = $this->input->post('userid',TRUE);
				$data_users['created_by'] = $this->session->userdata('username');
				$data_users['created_on'] = date("Y-m-d h:i:s",time());

				$this->set_add($data_users,$data_group,$data_optional);
			}elseif($this->input->post('act',TRUE)=='updt'){
				$data_users['modified_by'] = $this->session->userdata('username');
				$data_users['modified_on'] = date("Y-m-d h:i:s",time());
				$this->set_update($data_users,$data_group,$this->input->post('userid',TRUE),$data_optional);
			}
			echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
		}
	}

	function parseDate($tgl){
		$tmp = explode('/', $tgl);
		return $tmp[2].'-'.$tmp[1].'-'.$tmp[0];
	}
	function get_id(){
		$this->load->model('users/users');
		$row = $this->users->get_last_id();
		return $row->userid+1;
	}

	function set_update($data_users,$data_group,$userid,$data_optional){
		$this->load->model('users/users');
		return $this->users->update_data($data_users,$data_group,$userid,$data_optional);
	}

	function set_add($data_users,$data_group,$data_optional){
		$this->load->model('users/users');
		return $this->users->add_data($data_users,$data_group,$data_optional);
	}

	function arr2md5($arrinput){
        $hasil='';
        foreach($arrinput as $val){
        	if($hasil==''){
        		$hasil=md5($val);
        	}else {
        		$code=md5($val);
        		for($hit=0;$hit<min(array(strlen($code),strlen($hasil)));$hit++){
        			$hasil[$hit]=chr(ord($hasil[$hit]) ^ ord($code[$hit]));
        		}
        	}
        }
        return(md5($hasil));
    }
}