<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class jadwal_sidang_c extends CI_Controller {
	function index(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc']=$this->nativesession->get_flash_session('enc');
		$data['idperkara']=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($data['idperkara']) OR !intval($data['idperkara'])>0){
            show_404();
            exit();
        }
		
		$data['alur_perkara_id']=$this->tanggalhelper->getIDAlurPerkara($data['idperkara']);
		$data['jenis_perkara_id']=$this->tanggalhelper->getIDjenisPerkara($data['idperkara']);
		$this->load->model('jadwalsidang/jadwal_sidang_m');
		#10-12-2016 V315
		$data['ada_mediasi'] = 0;
		$data["ada_mediasi"] = $this->jadwal_sidang_m->getInfoMediasi($data['idperkara']);
		#end
		
		if ($query=$this->jadwal_sidang_m->get_data_jadwal($data['idperkara'])){
			$data['jsidangrecords']=$query;
		}
		$this->load->view('perkara_tab/jadwal_sidang_v',$data);
	}

	function edit(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$data['curr_date'] = date('d/m/Y');
		$data['idjadwal']=$this->nativesession->get_flash_session('encjadwalsidang');
		$data['enc']=$this->nativesession->get_flash_session('enc');
		$this->load->model('jadwalsidang/jadwal_sidang_m');

		$idjadwal=$this->encrypt->decode(base64_decode($data['idjadwal']));
        if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
            show_404();
            exit();
        }

		$idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }

		$data['id_alur_perkara'] = $this->tanggalhelper->getIDAlurPerkara($idperkara);
		$data['jenis_perkara_id']=$this->tanggalhelper->getIDjenisPerkara($idperkara);
		if ($query=$this->jadwal_sidang_m->get_detil_jadwal($idjadwal)){
			$data['detjsidang']=$query;
		}
		if ($queryrs=$this->jadwal_sidang_m->get_ruangan_sidang()){
			$data['ruangansidang']=$queryrs;
		}
		else{
			$data['ruangansidang']='';
		}
		if ($querymaxid=$this->jadwal_sidang_m->get_id_jadwal_terakhir_satu_perkara($idperkara)){
			$data['maxidjadwalsidang']=$querymaxid;
		}
		if($tgljsidangsblm=$this->jadwal_sidang_m->get_jadwal_sidang_sebelum($idperkara)){
			$data['tgljsidangsblm']=$tgljsidangsblm;
		}
		$data['jumverzet']=$this->jadwal_sidang_m->cek_jumlah_sidang_verzet($idperkara);
		$this->load->view('perkara_tab/jadwal_sidang_p_edit',$data);
	}

	function tunda(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$data['curr_date'] = date('d/m/Y');
		$data['idjadwal']=$this->nativesession->get_flash_session('encjadwalsidang');
        $data['enc']=$this->nativesession->get_flash_session('enc');
		$this->load->model('jadwalsidang/jadwal_sidang_m');

		$idjadwal=$this->encrypt->decode(base64_decode($data['idjadwal']));
        if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
            show_404();
            exit();
        }

        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
		if ($query=$this->jadwal_sidang_m->get_detil_jadwal($idjadwal)){
			$data['detjsidang']=$query;
		}
		if ($queryrs=$this->jadwal_sidang_m->get_ruangan_sidang()){
			$data['ruangansidang']=$queryrs;
		}
		else{
			$data['ruangansidang']='';
		}
        $data['id_alur_perkara'] = $this->tanggalhelper->getIDAlurPerkara($idperkara);
		$this->load->view('perkara_tab/jadwal_sidang_p_tunda',$data);
	}

	function validateEdit(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$idjadwal = $this->encrypt->decode(base64_decode($this->input->post('encjadwalsidang')));
		if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
			echo json_encode(array('st'=>0,'msg'=>'Sidang Tidak Ditemukan.'));
			return;
		}
		$this->form_validation->set_rules('tgl_sidang', 'Tanggal Sidang', 'required|trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('jammulai', 'Mulai Jam Sidang', 'required|trim|xss_clean|exact_length[5]');
		$this->form_validation->set_rules('jamselesai', 'Sampai Jam Sidang', 'required|trim|xss_clean|exact_length[5]');
		$this->form_validation->set_rules('agenda', 'Agenda Sidang', 'required|trim|xss_clean|max_length[500]|min_length[1]');

		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$this->load->model('jadwalsidang/jadwal_sidang_m');
			$urutanjsidang=$this->jadwal_sidang_m->get_urutan_jadwal_terakhir($idperkara)->row()->urutan;
			$tanggal_sidang=$this->input->post('tgl_sidang',TRUE); 
			$tanggal_sidang=$this->tanggalhelper->convertToMysqlDate($tanggal_sidang);
			$jam_mulai=$this->input->post('jammulai',TRUE);
			$jam_selesai=$this->input->post('jamselesai',TRUE);
			$data_ruangan=$this->input->post('ruangan',TRUE);

			if($tanggal_sidang==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$verzet = $this->jadwal_sidang_m->getVerzet($idperkara);						
			if($verzet!='Y'){
				$tglpenetapansidangpertama=$this->tanggalhelper->getTanggalPenetapanSidangPertama($idperkara);
				if(empty($tglpenetapansidangpertama)){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Sidang Pertama Tidak Ditemukan.'));
					return;
				}
			
				$selisih = $this->tanggalhelper->getSelisihHari($tglpenetapansidangpertama,$tanggal_sidang);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Sidang <u>Tidak Boleh Kurang</u> dari Tanggal Penetapan Sidang Pertama.'));
					return;
				}
			}
			$dayname = $this->tanggalhelper->getDayName($tanggal_sidang);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Sidang Pada Hari Libur, Sabtu dan Minggu.'));
				exit();
			}

			if ($urutanjsidang>='1'){
				$tgljsidangsebelum=$this->jadwal_sidang_m->get_jadwal_sidang_sebelum($idperkara);
				$selisih = $this->tanggalhelper->getSelisihHari($tgljsidangsebelum,$tanggal_sidang);
				if($selisih<=0){
					echo json_encode(array('st'=>0,'msg'=>'Tidak Dapat Memilih Tanggal Sebelum Atau Tepat Pada Tanggal Sidang Sebelumnya'));
					return;
				}
			}

			$selisihjam=$this->tanggalhelper->getSelisihJam($jam_mulai,$jam_selesai);
			if($selisihjam<1){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Jam Selesai Sidang <u>Tidak Boleh Sama Atau Kurang Dari</u> Jam Mulai Sidang.'));
				exit();
			}

			$data_ruangan=explode('|',$data_ruangan);
			$id_ruangan_kirim=$data_ruangan[0];
			if(!is_numeric($id_ruangan_kirim) OR !intval($id_ruangan_kirim)>0){
				echo json_encode(array('st'=>0,'msg'=>'Ruangan Tidak Ditemukan.'));
				return;
			}
			$nama_ruangan_kirim=$data_ruangan[1];
			if ($this->input->post('alasan_tunda')===''){
				$alasan_ditunda=NULL;	
			}

			$dihadiri_oleh = $this->input->post('dihadiri_oleh',TRUE);
			if(!is_numeric($dihadiri_oleh) OR intval($dihadiri_oleh)<1 OR intval($dihadiri_oleh)>4){
				echo json_encode(array('st'=>0,'msg'=>'Data Tidak Valid.'));
				return;
			}

			$data2=array(
				'tanggal_sidang'=>$tanggal_sidang,
				'jam_sidang'=>$jam_mulai,
				'sampai_jam'=>$jam_selesai,
				'agenda'=>$this->input->post('agenda',TRUE),
				'dihadiri_oleh'=>$this->input->post('dihadiri_oleh',TRUE),
				'alasan_ditunda'=>$this->input->post('alasan_tunda',TRUE),
				'keterangan'=>$this->input->post('keterangan',TRUE),
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
				);

			if ($this->input->post('sidang_keliling',TRUE)=='Y'){
				$data2['ruangan_id']=NULL;
				$data2['ruangan']=NULL;
				$data2['sidang_keliling']="Y";
			}else{
				$data_ruangan=$this->input->post('ruangan',TRUE);
				$data_ruangan=explode('|',$data_ruangan);
				$data2['ruangan_id']=$data_ruangan[0];
				if(!is_numeric($data2['ruangan_id']) OR !intval($data2['ruangan_id'])>0){
					echo json_encode(array('st'=>0,'msg'=>'Ruangan Tidak Ditemukan.'));
					return;
				}
				$data2['ruangan']=$data_ruangan[1];
				$data2['sidang_keliling']="T";
			}

			$this->jadwal_sidang_m->update_jadwal_sidang($idjadwal,$data2,$idperkara);

			echo json_encode(array('st'=>1,'msg'=>'Perubahan Data Tundaan Sidang Berhasil'));
			return;
		}
	}

	function validateTunda(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		
		$idjadwal = $this->encrypt->decode(base64_decode($this->input->post('encjadwalsidang',TRUE)));
		if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
			echo json_encode(array('st'=>0,'msg'=>'Sidang Tidak Ditemukan.'));
			return;
		}

		$this->form_validation->set_rules('jammulaisblm', '<u>Jam Awal Pelaksanaan Sidang Sebelumnya</u>', 'required|trim|xss_clean|exact_length[5]');
		$this->form_validation->set_rules('jamselesaisblm', '<u>Jam Akhir Pelaksanaan Sidang Sebelumnya</u>', 'required|trim|xss_clean|exact_length[5]');
		$this->form_validation->set_rules('agendasblm', '<u>Agenda Sidang Sebelumnya</u>', 'required|trim|xss_clean|max_length[500]|min_length[10]');
		$this->form_validation->set_rules('alasan_tunda', '<u>Alasan Penundaan Sidang Sebelumnya</u>', 'required|trim|xss_clean|max_length[500]|min_length[10]');
		$this->form_validation->set_rules('tgl_sidang', '<u>Tanggal Sidang Berikutnya</u>', 'required|trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('jammulai', '<u>Jam Pelaksanaan Sidang Berikutnya</u>', 'required|trim|xss_clean|exact_length[5]');
		$this->form_validation->set_rules('agenda', '<u>Agenda Sidang Berikutnya</u>', 'required|trim|xss_clean|max_length[500]|min_length[10]');
		
		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$this->load->model('jadwalsidang/jadwal_sidang_m');
			$this->load->model('mediasi/mediasi_m');
			$jammulaisblm=$this->input->post('jammulaisblm',TRUE);
			$jamselesaisblm=$this->input->post('jamselesaisblm',TRUE);
			#08-12-2016 validasi jika blm ada hasil mediasi tdk bisa tunda jadwal sidang
			$info_perkara = $this->mediasi_m->get_data_mediasi_all($idperkara);
			if($info_perkara!=''){
				if($info_perkara->num_rows>0){
					foreach ($info_perkara->result() as $row) {
						$hasil_mediasi = !empty($row->hasil_mediasi)?1:0;
						$ada_data_mediasi = !empty($row->is_mediasi)?1:0;
						$tahapan_mediasi = $row->tahapan_id;
					}
				}
			}
			$jenis_perkara_id = $this->tanggalhelper->getIDJenisPerkara($idperkara);
			if($tahapan_mediasi==16){
				$info_mediasi = ' Pada tahapan Verzet ';
			}else{
				$info_mediasi = '';
			}
			if($ada_data_mediasi==1 && $hasil_mediasi==0 && $jenis_perkara_id!=624){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Mohon mengisikan hasil mediasi terlebih dahulu '.$info_mediasi.' sebelum melakukan penundaan jadwal sidang.'));
				return;
			}
			#end
			$tanggalsebelum=$this->input->post('tglsidangsblm',TRUE);

			$tanggaldipilih=$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_sidang',TRUE));
			if($tanggaldipilih==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Sidang Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisihjam=$this->tanggalhelper->getSelisihJam($jammulaisblm,$jamselesaisblm);
			if($selisihjam<1){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Jam Selesai Sidang Sebelumnya <u>Tidak Boleh Kurang Atau Sama</u> Dari Jam Mulai Sidang Sebelumnya.'));
				exit();
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tanggalsebelum,$tanggaldipilih);
			if($selisih<=0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Sebelum Atau Tepat Pada Tanggal Sidang Sebelumnya.'));
				return;
			}

			$jumverzet=$this->jadwal_sidang_m->cek_apakah_verzet($idperkara);
			$tglpenetapansidangpertama=$this->tanggalhelper->getTanggalPenetapanSidangPertama($idperkara);
			if (!empty($tglpenetapansidangpertama)&&$jumverzet==0){
				if(empty($tglpenetapansidangpertama)){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Sidang Pertama Tidak Ditemukan.'));
					return;
				}
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglpenetapansidangpertama,$tanggaldipilih);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Sidang Tidak Boleh Kurang dari Tanggal Penetapan Sidang Pertama.'));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tanggaldipilih);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Sidang Pada Hari Libur, Sabtu dan Minggu.'));
				return;
			}			

			$urutanmaxid=$this->jadwal_sidang_m->get_urutan_jadwal_terakhir($idperkara);
			$urutanBaru =  $urutanmaxid->row()->urutan + 1;
			
			$jam_mulai=$this->input->post('jammulai',TRUE);
			$jam_selesai=$this->input->post('jamselesai',TRUE);

			if ($this->input->post('ruangan',TRUE)=='Ditentukan Kemudian'){
				$id_ruangan_kirim=NULL;
				$nama_ruangan_kirim=NULL;
			}else{
				$data_ruangan=$this->input->post('ruangan',TRUE);
				$data_ruangan=explode('|',$data_ruangan);
				$id_ruangan_kirim=$data_ruangan[0];
				if(!is_numeric($id_ruangan_kirim) OR !intval($id_ruangan_kirim)>0){
					echo json_encode(array('st'=>0,'msg'=>'Ruangan Tidak Ditemukan.'));
					return;
				}
				$nama_ruangan_kirim=$data_ruangan[1];
			}
			

			$dihadiri_olehsblm = $this->input->post('dihadiri_olehsblm',TRUE);
			if(!is_numeric($dihadiri_olehsblm) OR intval($dihadiri_olehsblm)<1 OR intval($dihadiri_olehsblm)>4){
				echo json_encode(array('st'=>0,'msg'=>'Data Tidak Valid.'));
				return;
			}

			$data_update = array(
				'jam_sidang'=>$this->input->post('jammulaisblm',TRUE),
				'sampai_jam'=>$this->input->post('jamselesaisblm',TRUE),
				'agenda'=>$this->input->post('agendasblm',TRUE),
				'dihadiri_oleh'=>$this->input->post('dihadiri_olehsblm',TRUE),
				'ditunda'=>"Y",
				'alasan_ditunda'=>$this->input->post('alasan_tunda',TRUE),
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);

			$data_insert = array(
				'perkara_id'=>$idperkara,
				'tanggal_sidang'=>$tanggaldipilih,
				'urutan'=>$urutanBaru,
				'jam_sidang'=>$jam_mulai,
				'agenda'=>$this->input->post('agenda',TRUE),
				'keterangan'=>$this->input->post('keterangan',TRUE),
				'diinput_oleh' => $this->session->userdata('username'),
				'diinput_tanggal' => date("Y-m-d h:i:s",time())
			);

			if ($this->input->post('sidang_kelilingsblm',TRUE)=='Y'){
				$data_update['ruangan_id']=NULL;
				$data_update['ruangan']=NULL;
				$data_update['sidang_keliling']="Y";
			}else{
				$data_ruangan=$this->input->post('ruangansblm',TRUE);
				$data_ruangan=explode('|',$data_ruangan);
				$data_update['ruangan_id']=$data_ruangan[0];
				if(!is_numeric($data_update['ruangan_id']) OR !intval($data_update['ruangan_id'])>0){
					echo json_encode(array('st'=>0,'msg'=>'Ruangan Tidak Ditemukan.'));
					return;
				}
				$data_update['ruangan']=$data_ruangan[1];
				$data_update['sidang_keliling']="T";
			}

			if ($this->input->post('sidang_keliling',TRUE)=='Y'){
				$data_insert['ruangan_id']=NULL;
				$data_insert['ruangan']=NULL;
				$data_insert['sidang_keliling']="Y";
			}else{
				if ($this->input->post('ruangan',TRUE)=='Ditentukan Kemudian'){
					$data_insert['ruangan_id']=NULL;
					$data_insert['ruangan']=NULL;
				}else{				
					$data_ruangan=$this->input->post('ruangan',TRUE);
					$data_ruangan=explode('|',$data_ruangan);
					$data_insert['ruangan_id']=$data_ruangan[0];
					if(!is_numeric($data_insert['ruangan_id']) OR !intval($data_insert['ruangan_id'])>0){
						echo json_encode(array('st'=>0,'msg'=>'Ruangan Tidak Ditemukanss.'));
						return;
					}
					$data_insert['ruangan']=$data_ruangan[1];
				}
				$data_insert['sidang_keliling']="T";
			}

			$updateProses = TRUE;
			$idproses = 200;

			if ($jumverzet>'0'){
				$statjadsidterakhir=$this->jadwal_sidang_m->cek_status_verzet_jadwalsidang_terakhir($idperkara);
				if ($statjadsidterakhir=="T"){
					$data_insert['verzet']='T';
				}else{
					$data_insert['verzet']='Y';
					$updateProses = TRUE;
					if($this->session->userdata('jenis_pengadilan')==3)
						$idproses = 116;
					else
						$idproses = 261;
				}
			}
			$jumkeberatan=$this->jadwal_sidang_m->cek_apakah_keberatan($idperkara);
			if ($jumkeberatan>'0'){
				$data_insert['keberatan']='Y';
			}

			$jumikrartalak=$this->jadwal_sidang_m->cek_apakah_ikrar_talak($idperkara);
			if ($jumikrartalak>'0'){
				$idproses = 294;
				$updateProses = FALSE;
				$data_insert['ikrar_talak']='Y';
			}

			$this->jadwal_sidang_m->tunda_sidang($data_insert,$data_update,$idjadwal);
			if ($urutanBaru>=2 AND $updateProses){
				$this->jadwal_sidang_m->updateproses($idperkara,$idproses,$tanggaldipilih,'Penundaan Jadwal Sidang');
			}

			echo json_encode(array('st'=>1,'msg'=>'Pengisian Data Tundaan Sidang Berhasil'));
			return;
		}
	}

	function hapus_jadwal_sidang(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$idjadwal = $this->encrypt->decode(base64_decode($this->input->post('encjadwalsidang')));
		if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
			echo json_encode(array('st'=>0,'msg'=>'Sidang Tidak Ditemukan.'));
			return;
		}
		
		$this->load->model('jadwalsidang/jadwal_sidang_m');
		if($this->jadwal_sidang_m->hapus_jadwal_sidang($idjadwal)){

			$jadwalsebelum=$this->jadwal_sidang_m->cari_jadwal_sidang_terakhir($idperkara);
			$tanggalsebelum=$jadwalsebelum->row(0)->tanggal_sidang;
			$diinputoleh=$jadwalsebelum->row(0)->diinput_oleh;
			$diinputtanggal=$jadwalsebelum->row(0)->diinput_tanggal;

			$idjsidangsebelum=$jadwalsebelum->row(0)->id;
			$datadiupdate['ditunda']='T';
			$datadiupdate['diperbaharui_oleh']=$this->session->userdata('username');
			$datadiupdate['diperbaharui_tanggal']=date("Y-m-d h:i:s",time());
			$this->jadwal_sidang_m->update_jadwal_sidang($idjsidangsebelum,$datadiupdate,$idperkara);
			
			echo json_encode(array('st'=>1,'msg'=>'Penghapusan Data Tundaan Sidang Berhasil'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'));
			return;
		}
	}
}
?>
