<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Jadwal_Mediasi_c extends CI_Controller {

	function edit(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$data['curr_date'] = date('d/m/Y');

		$data['enc']=$this->nativesession->get_flash_session('enc');
		$data['encmediasi']=$this->nativesession->get_flash_session('encmediasi');
		$data['encjadwalmediasi']=$this->nativesession->get_flash_session('encjadwalmediasi');
		$data['encmed']=$this->nativesession->get_flash_session('encmed');

		$idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }

		$idmediasi=$this->encrypt->decode(base64_decode($data['encmediasi']));
        if(!is_numeric($idmediasi) OR !intval($idmediasi)>0){
            show_404();
            exit();
        }

		$idjadwalmediasi=$this->encrypt->decode(base64_decode($data['encjadwalmediasi']));
        if(!is_numeric($idjadwalmediasi) OR !intval($idjadwalmediasi)>0){
            show_404();
            exit();
        }

		$this->load->model('mediasi/jadwal_mediasi_m');
		if ($query=$this->jadwal_mediasi_m->get_detil_jadwal_mediasi($idjadwalmediasi)){
			$data['detjmediasi']=$query;
		}

		if ($query=$this->jadwal_mediasi_m->get_jadwal_mediasi_sebelum($idmediasi)){
			$data['detjmediasisblm']=$query;
		}

		$this->load->view('perkara_tab/jadwal_mediasi_p_edit',$data);
	}

	function tunda(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$data['curr_date'] = date('d/m/Y'); // ini didunakan untuk validasi tanggal

		$data['enc']=$this->nativesession->get_flash_session('enc');
		$data['encmediasi']=$this->nativesession->get_flash_session('encmediasi');
		$data['encjadwalmediasi']=$this->nativesession->get_flash_session('encjadwalmediasi');
		$data['encmed']=$this->nativesession->get_flash_session('encmed');
		
		$idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }

		$idmediasi=$this->encrypt->decode(base64_decode($data['encmediasi']));
        if(!is_numeric($idmediasi) OR !intval($idmediasi)>0){
            show_404();
            exit();
        }

		$idjadwalmediasi=$this->encrypt->decode(base64_decode($data['encjadwalmediasi']));
        if(!is_numeric($idjadwalmediasi) OR !intval($idjadwalmediasi)>0){
            show_404();
            exit();
        }

		$this->load->model('mediasi/jadwal_mediasi_m');
		if ($query=$this->jadwal_mediasi_m->get_detil_jadwal_mediasi($idjadwalmediasi)){
			$data['detjmediasi']=$query;
		}
		$this->load->view('perkara_tab/jadwal_mediasi_p_tunda',$data);
	}

	function validateEdit(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		$idmediasi = $this->encrypt->decode(base64_decode($this->input->post('encmediasi')));
		$idjadwalmediasi = $this->encrypt->decode(base64_decode($this->input->post('encjadwalmediasi')));

		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Data Perkara Tidak Ditemukan.'));
			return;
		}
		if(!is_numeric($idmediasi) OR !intval($idmediasi)>0){
			echo json_encode(array('st'=>0,'msg'=>'Data Mediasi Tidak Ditemukan.'));
			return;
		}
		if(!is_numeric($idjadwalmediasi) OR !intval($idjadwalmediasi)>0){
			echo json_encode(array('st'=>0,'msg'=>'Data Jadwal Mediasi Tidak Ditemukan.'));
			return;
		}
		
		$this->form_validation->set_rules('tempat', 'Tempat Pelaksanaan Mediasi', 'required|trim|xss_clean|max_length[500]|min_length[1]');

		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{

			$tanggal_mediasi=$this->input->post('tgl_mediasi',TRUE); 
			$tanggal_mediasi=$this->tanggalhelper->convertToMysqlDate($tanggal_mediasi);
			$tanggal_mediasi_sebelum=$this->input->post('tgljadwalmediasisblm',TRUE); 

			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$selisih = $this->tanggalhelper->getSelisihHari($tanggal_mediasi_sebelum,$tanggal_mediasi);
			if($selisih<=0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Sebelum Atau Tepat Pada Tanggal Mediasi Sebelumnya'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tanggal_mediasi,$curr_date);
			if($selisih<=0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Mediasi Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			if($tanggal_mediasi==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$tglpenetapansidangpertama=$this->tanggalhelper->getTanggalPenetapanSidangPertama($idperkara);
			
			if(empty($tglpenetapansidangpertama)){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Sidang Pertama Tidak Ditemukan.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglpenetapansidangpertama,$tanggal_mediasi);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Mediasi <u>Tidak Boleh Kurang</u> dari Tanggal Penetapan Sidang Pertama.'));
				return;
			}
			$dayname = $this->tanggalhelper->getDayName($tanggal_mediasi);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Mediasi Pada Hari Libur, Sabtu dan Minggu.'));
				exit();
			}

			$dihadiri_oleh = $this->input->post('dihadiri_oleh',TRUE);
			$data_ruangan = $this->input->post('tempat',TRUE);

			$data=array(
				'tanggal_mediasi'=>$tanggal_mediasi,
				'jam_mediasi'=>$this->input->post('jammulai',TRUE),				
				'sampai_jam'=>$this->input->post('jamselesai',TRUE),
				'tempat'=>$data_ruangan,
				'dihadiri_oleh'=>$dihadiri_oleh,
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
				);

			$this->load->model('mediasi/jadwal_mediasi_m');
			$this->jadwal_mediasi_m->update_jadwal_mediasi($idjadwalmediasi,$data,$idmediasi);
			echo json_encode(array('st'=>1,'msg'=>'Perubahan Data Mediasi Berhasil'));
			return;
		}
	}

	function validateTunda(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		$idmediasi = $this->encrypt->decode(base64_decode($this->input->post('encmediasi')));
		$idjadwalmediasi = $this->encrypt->decode(base64_decode($this->input->post('encjadwalmediasi')));

		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Data Perkara Tidak Ditemukan.'));
			return;
		}
		if(!is_numeric($idmediasi) OR !intval($idmediasi)>0){
			echo json_encode(array('st'=>0,'msg'=>'Data Mediasi Tidak Ditemukan.'));
			return;
		}
		if(!is_numeric($idjadwalmediasi) OR !intval($idjadwalmediasi)>0){
			echo json_encode(array('st'=>0,'msg'=>'Data Jadwal Mediasi Tidak Ditemukan.'));
			return;
		}

		$this->form_validation->set_rules('tempat', 'Tempat Pelaksanaan Mediasi', 'required|trim|xss_clean|max_length[500]|min_length[1]');
		$this->form_validation->set_rules('tgl_mediasi', 'Tanggal Mediasi', 'required|trim|xss_clean|exact_length[10]');
		
		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$tanggalsebelum=$this->input->post('tglmediasisblm',TRUE);
			$tanggaldipilih=$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_mediasi',TRUE));
			if($tanggaldipilih==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Sidang Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			//$selisih = $this->tanggalhelper->getSelisihHari($tanggaldipilih,$curr_date);
			//if($selisih<=0){
			//	echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Mediasi Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
			//	return;
			//}

			$selisih = $this->tanggalhelper->getSelisihHari($tanggalsebelum,$tanggaldipilih);
			if($selisih<=0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Sebelum Atau Tepat Pada Tanggal Mediasi Sebelumnya.'));
				return;
			}

			$tglpenetapansidangpertama=$this->tanggalhelper->getTanggalPenetapanSidangPertama($idperkara);
			
			if(empty($tglpenetapansidangpertama)){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Sidang Pertama Tidak Ditemukan.'));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tanggaldipilih);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Sidang Pada Hari Libur, Sabtu dan Minggu.'));
				return;
			}

			$this->load->model('mediasi/jadwal_mediasi_m');

			$urutanmaxid=$this->jadwal_mediasi_m->get_urutan_jadwal_mediasi_terakhir($idmediasi);
			$urutanBaru =  $urutanmaxid->row()->urutan + 1;
			$idmax = $this->jadwal_mediasi_m->get_id_jadwal_mediasi_terakhir();
			$idjadwalberikutnya=$idmax->row()->id + 1;
			
			$data_ruangan_sebelumnya=$this->input->post('tempatsblm',TRUE);
			$data_ruangan=$this->input->post('tempat',TRUE);

			$data_update = array(
				'tempat'=>$data_ruangan_sebelumnya,
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);

			$data_insert = array(
				'id'=>$idjadwalberikutnya,
				'mediasi_id'=>$idmediasi,
				'urutan'=>$urutanBaru,
				'tanggal_mediasi'=>$tanggaldipilih,
				'tempat'=>$data_ruangan,
				'diinput_oleh' => $this->session->userdata('username'),
				'diinput_tanggal' => date("Y-m-d h:i:s",time())
			);

			$this->jadwal_mediasi_m->tunda_mediasi($data_insert,$data_update,$idmediasi);

			echo json_encode(array('st'=>1,'msg'=>'Pengisian Data Tundaan Mediasi Berhasil'));
			return;
		}
	}

	function hapus_jadwal_mediasi(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$idjadwalmediasi = $this->encrypt->decode(base64_decode($this->input->post('encjadwalmediasi')));
		if(!is_numeric($idjadwalmediasi) OR !intval($idjadwalmediasi)>0){
			echo json_encode(array('st'=>0,'msg'=>'Jadwal Mediasi Tidak Ditemukan.'));
			return;
		}
		
		$this->load->model('mediasi/jadwal_mediasi_m');
		if($this->jadwal_mediasi_m->hapus_jadwal_mediasi($idjadwalmediasi)){

			echo json_encode(array('st'=>1,'msg'=>'Penghapusan Data Jadwal Mediasi Berhasil'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'));
			return;
		}
	}
}