<?php defined('BASEPATH') OR exit('No direct script access allowed');

class c_template_mediasi extends CI_Controller {

	function index() {
        show_404();
    }
    

    function popup($enc){
        $data['enc']=$enc;
        $data['judul']="MODEL PENETAPAN / PUTUSAN Tergugat Tidak Beritikad Baik Dalam Mediasi dan Dihukum Untuk Membayar Biaya Mediasi";
        $this->load->model('generate_template/m_template_mediasi','mediasi');
        if ($enc!=NULL){
            $perkara_id=$this->encrypt->decode(base64_decode($enc));
        }
        $data['data_dukung_mediasi']=$this->mediasi->get_data_dukung_mediasi($perkara_id,'I_19');
        $idmediasi=$this->mediasi->get_mediasi_id($perkara_id);
        $data['encmediasi']=base64_encode($this->encrypt->encode($idmediasi));
        $this->load->view('generate_template/mediasi/popup_blanko',$data,FALSE);
    }

    function alasan_text($id_alasan){
        switch ($id_alasan) {
            case '1':
                $alasan_text='tidak hadir setelah dipanggil secara patut 2 (dua) kali berturut-turut dalam pertemuan Mediasi tanpa alasan sah;';
                break;
            case '2':
                $alasan_text='menghadiri pertemuan Mediasi pertama, tetapi tidak pernah hadir pada pertemuan berikutnya meskipun telah dipanggil secara patut 2 (dua) kali berturut-turut tanpa alasan sah;';
                break;
            case '3':
                $alasan_text='ketidakhadiran berulang-ulang yang mengganggu jadwal pertemuan Mediasi tanpa alasan sah;';
                break;
            case '4':
                $alasan_text='menghadiri pertemuan Mediasi, tetapi tidak mengajukan dan/atau tidak menanggapi Resume Perkara pihak lain;';
                break;
            case '5':
                $alasan_text='tidak menandatangani konsep Kesepakatan Perdamaian yang telah disepakati tanpa alasan sah;';
                break;
            default:
                $alasan_text="Data tidak ditemukan";
                break;
        }
        return $alasan_text;
    }

    function cetak($enc=NULL,$kode=NULL,$encjadwalmediasi=NULL,$encmediasi=NULL,$jenis_mediasi=NULL){
        $this->load->model('generate_template/m_template_perdata_relaas','template');
        $this->load->model('generate_template/m_template_mediasi','mediasi');
        if ($kode==NULL){
            $kode=$this->input->post('kode_template');
        }
        
        
        $alasan=$this->input->post('alasan',TRUE);
        $nama_biaya=$this->input->post('nama_biaya',TRUE);
        $biaya_mediasi=$this->input->post('biaya_mediasi',TRUE);

        if ($enc!=NULL){
            $perkara_id=$this->encrypt->decode(base64_decode($enc));
        }

        $mediasi_id=$this->mediasi->get_mediasi_id($perkara_id);
        $is_verzet=$this->mediasi->is_verzet($perkara_id);
        if ($is_verzet==1){
            $this->cetak_template_verzet($enc,$kode,$encjadwalmediasi,$encmediasi);
            exit();
        } else{
            $alasan_text='';        
            $i='a';
            if (count($alasan>0)){   
                foreach ($alasan as $k) {
                    $alasan_text .=" ".$i.'.'.' \\tab '.$this->alasan_text($k)." \\par ";
                    $i++;
                }

            }
            $nama_biaya_text='';        
            $i=1;
            if (count($nama_biaya>0)){   
                foreach ($nama_biaya as $k) {
                    if ($k!="" || !empty($k)){
                        $mediasi_biaya_rincian .=" ".$i.'.'.' \\tab '.$k." \\tab Rp. \\tab ".number_format($biaya_mediasi[$i-1],2,',','.')."\\par"." ";
                        $mediasi_biaya_jumlah += intval($biaya_mediasi[$i-1]);
                        $i++;
                    }
                }
            }

            $data['mediasi_biaya_jumlah']=$mediasi_biaya_jumlah;
            $data['alasan_text']= $alasan_text;
            $data['mediasi_biaya_rincian']= $mediasi_biaya_rincian;
            $idjadwalmediasi = $this->encrypt->decode(base64_decode($encjadwalmediasi));
            $perkara=$this->mediasi->get_perkara($perkara_id)->result();
            $perkara_putusan=$this->mediasi->get_perkara_putusan($perkara_id,1)->result();

            if ($kode=="I_02"){
                $data['jadwalsidang']=$this->mediasi->get_jadwal_sidang($idjadwalmediasi);
            }else{
                $data['jadwalmediasi']=$this->template->getJadwalMediasi($idjadwalmediasi);
                $data['jadwalmediasiterakhir']=$this->mediasi->get_mediasi_terakhir($mediasi_id)->result();
                $data['jadwalmediasiawal']=$this->mediasi->get_mediasi_awal($mediasi_id)->result();
            }
            
            $phs								=$this->mediasi->get_phs($perkara_id)->result();
            $info_pn							=$this->mediasi->get_data_pn()->result();
            $data['template']					=$this->mediasi->get_file($kode);
            $data['alurperkaraid']				=$perkara[0]->alur_perkara_id;
            $data['jenisperkaraid']				=$perkara[0]->jenis_perkara_id;
            $data['penetapan_majelis']			=$this->mediasi->get_pmh($perkara_id);
            $data['penetapan_pp']				=$this->mediasi->get_penetapan_pp($perkara_id);
            $data['penetapan_hari_sidang']		=$phs[0];
            $data['info_pn']					=$info_pn[0];
            $data['perkara']					=$perkara[0];
            $data['perkara_putusan']			=$perkara_putusan[0];
            $data['biaya_perkara']				=$this->mediasi->get_biaya_perkara($perkara_id);
			$data['penanggung_biaya_mediasi']	=$this->mediasi->get_penanggung_biaya_mediasi($perkara_id);
            $data['dataPihak1']					=$this->mediasi->get_data_pihak_loop($perkara_id,1);
            $data['dataPihak2']					=$this->mediasi->get_data_pihak_loop($perkara_id,2);
            $data['dataPihak3']					=$this->mediasi->get_data_pihak_loop($perkara_id,3);
            $data['dataPihak4']					=$this->mediasi->get_data_pihak_loop($perkara_id,4);
            $data['biayamediasi']				=$this->mediasi->get_catatan_mediasi($mediasi_id,$kode)->result();
            $data['dataMediasi']				=$this->mediasi->get_data_mediasi($perkara_id); 
            $data['pasal_kesepakatan']			=$this->mediasi->get_data_dukung_mediasi($perkara_id,$kode)->result();
            $data['dataMediator']				=$this->mediasi->get_data_mediator($perkara_id,$jenis_mediasi); 
            $data['dataPengacaraPihak1']		=$this->mediasi->get_data_pengacara($perkara_id,1);
            $data['dataPengacaraPihak2']		=$this->mediasi->get_data_pengacara($perkara_id,2);        
            $data['dataPengacaraPihak3']		=$this->mediasi->get_data_pengacara($perkara_id,3);
            $data['jadwalmediasi']				=$this->template->getJadwalMediasi($idjadwalmediasi);
             #--- save data dukung ---
            $data_dukung['mediasi_id']			=$mediasi_id;
            $data_dukung['perkara_id']			=$perkara_id;
            $data_dukung['kode_template']		=$this->input->post('kode_template',TRUE);
            $data_dukung['nama_biaya']			=$this->input->post('nama_biaya',TRUE);
            $data_dukung['biaya_mediasi']		=$this->input->post('biaya_mediasi',TRUE);
            $data_dukung['alasan']				=$this->input->post('alasan',TRUE);
            if (intval($mediasi_id!=0)){
                $this->simpan_data_dukung($data_dukung);
            }
            $this->load->view('generate_template/mediasi/cetak', $data, FALSE);
        }
    }

    function cetak_template_verzet($enc=NULL,$kode=NULL,$encjadwalmediasi=NULL,$encmediasi=NULL,$jenis_mediasi=NULL){
        $this->load->model('generate_template/m_template_perdata_relaas','template');
        $this->load->model('generate_template/m_template_mediasi','mediasi');

        if ($enc!=NULL){
            $perkara_id=$this->encrypt->decode(base64_decode($enc));
        }

        $idmediasi=$this->mediasi->get_mediasi_id($perkara_id);
        $idjadwalmediasi = $this->encrypt->decode(base64_decode($encjadwalmediasi));
        $perkara=$this->mediasi->get_perkara($perkara_id,1)->result();
        $perkara_putusan=$this->mediasi->get_perkara_putusan($perkara_id,1)->result();

        if ($kode=="I_02"){
            $data['jadwalsidang']=$this->mediasi->get_jadwal_sidang($idjadwalmediasi);
        }else{
            $data['jadwalmediasi']=$this->template->getJadwalMediasi($idjadwalmediasi);
        }
        $data['is_putusan']=1;
        $data['template']=$this->mediasi->get_file($kode);
        $info_pn=$this->mediasi->get_data_pn()->result();
        $data['alurperkaraid']=$perkara[0]->alur_perkara_id;
        $data['jenisperkaraid']=$perkara[0]->jenis_perkara_id;
        $phs=$this->mediasi->get_phs($perkara_id,1)->result();
        $data['penetapan_majelis']=$this->mediasi->get_pmh($perkara_id,1);
        $data['penetapan_pp']=$this->mediasi->get_penetapan_pp($perkara_id);
        $data['penetapan_hari_sidang']=$phs[0];
        $data['info_pn']=$info_pn[0];
        $data['perkara']=$perkara[0];
        $data['perkara_putusan']=$perkara_putusan[0];
        $data['dataPihak1']=$this->mediasi->get_data_pihak_loop($perkara_id,1);
        $data['dataPihak2']=$this->mediasi->get_data_pihak_loop($perkara_id,2);
        $data['dataPihak3']=$this->mediasi->get_data_pihak_loop($perkara_id,3);
        $data['dataPihak4']=$this->mediasi->get_data_pihak_loop($perkara_id,4);
        $data['dataMediasi']=$this->mediasi->get_data_mediasi($perkara_id,1); 
        $data['dataMediator']=$this->mediasi->get_data_mediator($perkara_id); 
        $data['biayamediasi']=$this->mediasi->get_catatan_mediasi($idmediasi,$kode,"#biaya_mediasi")->result();
        $data['dataPengacaraPihak1']=$this->mediasi->get_data_pengacara($perkara_id,1);
        $data['dataPengacaraPihak2']=$this->mediasi->get_data_pengacara($perkara_id,2);        
        $data['dataPengacaraPihak3']=$this->mediasi->get_data_pengacara($perkara_id,3);
        $data['jadwalmediasi']=$this->template->getJadwalMediasi($idjadwalmediasi);
;
        $this->load->view('generate_template/mediasi/cetak', $data, FALSE);
    }
    function simpan_data_dukung($data_dukung){
        $perkara_id=$data_dukung['perkara_id'];
        $mediasi_id=$data_dukung['mediasi_id'];
        if (!isset($mediasi_id)) {
            $mediasi_id=0;
        }
        $nama_biaya=$data_dukung['nama_biaya'];
        $biaya_mediasi=$data_dukung['biaya_mediasi'];
        $alasan=$data_dukung['alasan'];
        $kode_template=$data_dukung['kode_template'];

        $count_biaya=count($biaya_mediasi);
        $i=0;
        if ($count_biaya>0){
            $sql=$this->db->query ("SELECT COUNT(id) FROM perkara_data_dukung_mediasi 
                                    WHERE 
                                    perkara_id=$perkara_id AND
                                    mediasi_id=$mediasi_id AND
                                    identifier='#biaya_mediasi#' AND
                                    kode_template='$kode_template'");
            if ($sql->num_rows>0){    
                $this->db->query ("DELETE FROM perkara_data_dukung_mediasi 
                                    WHERE 
                                    perkara_id=$perkara_id AND
                                    mediasi_id=$mediasi_id AND
                                    identifier='#biaya_mediasi#' AND
                                    kode_template='$kode_template'");

                foreach ($biaya_mediasi as $k) {
                    if ($nama_biaya[$i]==""){
                        if ($k=="") { 
                            $k=0;
                        } 
                        $data=array('perkara_id'=>$perkara_id,
                                    'mediasi_id'=>$mediasi_id,
                                    'identifier'=>'#biaya_mediasi#',
                                    'kode_template'=>$kode_template,
                                    'uraian'=>$nama_biaya[$i],
                                    'nilai'=>$k);
                        $i++;
                        $this->db->insert('perkara_data_dukung_mediasi',$data);
                    }
               }
            }else{
               foreach ($biaya_mediasi as $k) {
                    if ($nama_biaya[$i]==""){
                        if ($k=="") { 
                            $k=0;
                        } 
                        $data=array('perkara_id'=>$perkara_id,
                                    'mediasi_id'=>$mediasi_id,
                                    'identifier'=>'#biaya_mediasi#',
                                    'kode_template'=>$kode_template,
                                    'uraian'=>$nama_biaya[$i],
                                    'nilai'=>$k);
                        $i++;
                        $this->db->insert('perkara_data_dukung_mediasi',$data);
                    }
               }
            }
        }

        $count_alasan=count($alasan);
        if ($count_alasan>0){
            $sql=$this->db->query ("SELECT COUNT(id) FROM perkara_data_dukung_mediasi 
                                    WHERE 
                                    perkara_id=$perkara_id AND
                                    mediasi_id=$mediasi_id AND
                                    identifier='#alasan_itikad#' AND
                                    kode_template='$kode_template'");
            if ($sql->num_rows>0){    
                $this->db->query ("DELETE FROM perkara_data_dukung_mediasi 
                                    WHERE 
                                    perkara_id=$perkara_id AND
                                    mediasi_id=$mediasi_id AND
                                    identifier='#alasan_itikad#' AND
                                    kode_template='$kode_template'");

                foreach ($alasan as $k) {
                     if ($k=="") { 
                            $k=0;
                     }
                    $data=array('perkara_id'=>$perkara_id,
                                'mediasi_id'=>$mediasi_id,
                                'identifier'=>'#alasan_itikad#',
                                'kode_template'=>$kode_template,
                                'uraian'=>'alasan itikad tidak baik',
                                'nilai'=>$k);
                    $this->db->insert('perkara_data_dukung_mediasi',$data);
               }
            }else{
               foreach ($alasan as $k) {
                    if ($k=="") { 
                            $k=0;
                    }
                    $data=array('perkara_id'=>$perkara_id,
                                'mediasi_id'=>$mediasi_id,
                                'identifier'=>'#alasan_itikad#',
                                'kode_template'=>$kode_template,
                                'uraian'=>'alasan itikad tidak baik',
                                'nilai'=>$k);
                    $this->db->insert('perkara_data_dukung_mediasi',$data);
               }
            }
        }
        
    }
    function popup_relaas_mediasi($enc,$encjadwalmediasi,$jenispihak){
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }  
        $this->load->model('generate_template/m_template_perdata_relaas','template');               
        $data['enc']=$enc;
        $idperkara=$this->encrypt->decode(base64_decode($enc));
        $idjadwalmediasi=$this->encrypt->decode(base64_decode($encjadwalmediasi));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }

        $dataJadwalMediasi=$this->template->getJadwalMediasi($idjadwalmediasi)->result();
        $data['encjadwalmediasi']=$encjadwalmediasi;
        $data['tanggalmediasi']=$this->tanggalhelper->convertToInputDate($dataJadwalMediasi[0]->tanggal_mediasi);
        if ($jenispihak=="P") {
            $data['listPihak'] = $this->template->getListPihak($idperkara,1);
            $data['jenisPihakText'] = 'Penggugat';
        }else{
            $data['jenisPihakText'] = 'Tergugat';
            $data['listPihak'] = $this->template->getListPihak($idperkara,2);
        }

        $data['jenispihak']=$jenispihak;
        $data['listJsp'] = $this->template->getListJurusita($idperkara); 
        $data['judul']="RELAAS PANGGILAN MEDIASI ".ucwords($data['jenisPihakText']);
        $data['jnsperkara']=$jnsperkara;

        $this->load->view('generate_template/mediasi/popup_relaas_mediasi',$data,FALSE);
    }

    function cetak_relaas_mediasi(){
        $this->load->model('generate_template/m_template_mediasi','mediasi');
        $this->load->model('generate_template/m_template_perdata_relaas','template');
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        } 
        $jenispihak= $this->input->post('jenispihak',TRUE);
        $data['enc'] = $this->input->post('enc',TRUE);
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));

        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
             show_404();
             exit();
        }
        $perkara=$this->mediasi->get_perkara($idperkara)->result();
        $idjurusita = $this->encrypt->decode(base64_decode($this->input->post('idjurusita',TRUE)));
        
        $data['idpihak'] = $this->input->post('idpihak',TRUE);
        $idpihak=$this->encrypt->decode(base64_decode($data['idpihak']));
         if(!is_numeric($idpihak) OR !intval($idpihak)>0){
             show_404();
             exit();
        }

        $idjadwalmediasi = $this->encrypt->decode(base64_decode($this->input->post('encjadwalmediasi',TRUE)));;
        $data['alurperkaraid']=$perkara[0]->alur_perkara_id;
        $data['jenisperkaraid']=$perkara[0]->jenis_perkara_id;
        $data['jadwalmediasi']=$this->template->getJadwalMediasi($idjadwalmediasi);
        $data['data_perkara'] = $this->template->getDataPerkara($idperkara);
        $data['data_pn'] = $this->template->getDataPN($idperkara);        
        $data['data_penggugat'] = $this->template->getPihakPenggugat($idperkara);  
        $data['data_tergugat'] = $this->template->getDataPihakTergugat($idperkara);                
        $data['cetak_data_penggugat'] = $this->template->getCetakPihakPenggugat($idpihak);
        $data['cetak_data_tergugat'] = $this->template->getCetakPihakTergugat($idpihak);
        
        $data['data_pengacara_penggugat'] = $this->template->getKuasaHukumP($idperkara);        
        $data['cetak_pengacara_penggugat'] = $this->template->getKuasaHukumCetak($idPengacara);
        
        $data['dataPihak'] = $this->template->getPihakInfo($idpihak);
        $dataJS = $this->template->getListJurusita($idperkara,$idjurusita)->result();
        $data['nama_jurusita']=$dataJS[0]->jurusita_nama;
        $data['jabatan_jurusita']=$dataJS[0]->jabatan;

        $this->load->model('generate_template/m_template_mediasi','mediasi');
        if ($jenispihak=="P") {
            $data['template']=$this->mediasi->get_file('I_05');
        }else{
             $data['template']=$this->mediasi->get_file('I_06');
        }
        $this->load->view('generate_template/mediasi/cetak_relaas_mediasi',$data,FALSE);
    } 


    function cetak_blanko_kosong($kode){
        $this->load->model('generate_template/m_template_mediasi','mediasi');
        $info_pn=$this->mediasi->get_data_pn()->result();
        $data['template']=$this->mediasi->get_file($kode);
        $this->load->view('generate_template/mediasi/cetak_blanko_kosong', $data, FALSE);

    }
}
