<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Keberatan_m extends CI_Model {

		
	function getLastSidang($idperkara){
		try {
			$query = $this->db->query("SELECT max(tanggal_sidang) as tglSidang FROM perkara_jadwal_sidang WHERE perkara_id = ".$idperkara.";");
			return $query->row()->tglSidang;
		} catch (Exception $e) {
			return '';
		}
	}
	function get_status_putusan(){
		try {
			return $this->db->query("SELECT id, kode, nama FROM status_putusan WHERE jenis_perkara_id=1 AND jenis_pengadilan=1 ORDER BY nama ASC;");
		} catch (Exception $e) {
			return '';
		}
	}
	
	function get_info_pihak($idpihak){
		try {
			return $this->db->query("SELECT nama,alamat FROM pihak WHERE id=".$idpihak);
		} catch (Exception $e) {
			return '';
		}
	}

	function get_para_pihak($idperkara,$pihakke){
		try {
			return $this->db->query("SELECT pihak_id, nama,alamat FROM perkara_pihak".$pihakke." WHERE perkara_id = ".$idperkara);
		} catch (Exception $e) {
			
		}
	}

	function getStatusPutusanNama($id){
		try {
			$query = $this->db->query("SELECT nama FROM status_putusan WHERE jenis_perkara_id=1 AND id = ".$id.";");
			return $query->row()->nama;
		} catch (Exception $e) {
			return '';
		}
	}

	function get_no_perkara($perkara_id){
		try {
			$query = $this->db->query("SELECT p.nomor_perkara, pp.tanggal_putusan, pv.* 
										FROM perkara p 
											LEFT JOIN (SELECT * FROM perkara_putusan WHERE perkara_id=".$perkara_id.") pp ON pp.perkara_id=p.perkara_id
											LEFT JOIN (SELECT * FROM perkara_keberatan WHERE perkara_id=".$perkara_id.") pv ON p.perkara_id=pv.perkara_id
										WHERE p.perkara_id=".$perkara_id.";");
			return $query->row();
		} catch (Exception $e) {
			return '';
		}
	}

	function add_keberatan($perkara_id, $datanya, $tahapan_id,  $tahapan_nama , $proses_id, $proses_nama, $tanggal){
		try {
			$this->db->replace('perkara_keberatan', $datanya);
			$title = "Tambah table <b>perkara_keberatan</b> dari halaman <b>Tambah Data Keberatan</b> dengan Primary Key [perkara_id=".$datanya['perkara_id']."]";
			$descrip = $this->fetch_description($title,$datanya);
			$this->add_audittrail("INSERT",$title,$descrip,'perkara_keberatan');
			
			$this->db->simple_query("CALL perkara_proses_update(".$perkara_id.", ".$tahapan_id.", 'Keberatan', ".$proses_id.", '".$proses_nama."', '".$tanggal."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			$this->db->simple_query("CALL perkara_update_status(".$perkara_id.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}	
	}

	function add_pihak_keberatan($idperkara,$data_pihak,$data_termohon){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->delete('perkara_keberatan_detil');
			foreach ($data_pihak as $data) {
				$this->db->replace('perkara_keberatan_detil', $data);
			}
			foreach ($data_termohon as $data) {
				$this->db->replace('perkara_keberatan_detil', $data);
			}
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}	
	}

	function edit_keberatan($perkara_id, $datanya, $tahapan_id, $tahapan_nama, $proses_id, $proses_nama, $tanggal){
		try {
			$this->db->where('perkara_id', $perkara_id);
			$this->db->update('perkara_keberatan', $datanya);
			$title = "Update table <b>perkara_keberatan</b> dari halaman <b>Edit Data Keberatan</b> dengan Primary Key [perkara_id=".$datanya['perkara_id']."]";
			$descrip = $this->fetch_description($title,$datanya);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_keberatan');

			$this->db->simple_query("CALL perkara_proses_update(".$perkara_id.", ".$tahapan_id.", 'Keberatan', ".$proses_id.", '".$proses_nama."', '".$tanggal."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			$this->db->simple_query("CALL perkara_update_status(".$perkara_id.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}	
	}

	function addRiwayatPerkara($perkara_id,$tahapan_id, $proses_id, $proses_nama, $tanggal){
		try {
			$this->db->simple_query("CALL perkara_proses_update(".$perkara_id.", ".$tahapan_id.", 'Keberatan', ".$proses_id.", '".$proses_nama."', '".$tanggal."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			$this->db->simple_query("CALL perkara_update_status(".$perkara_id.");");
		} catch (Exception $e) {
			
		}
	}

	function delRiwayatPerkara($idperkara,$idproses){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->where('proses_id',$idproses);
			$this->db->delete('perkara_proses');
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
		} catch (Exception $e) {
			
		}
	}

	function addJadwalSidang($data){
		try {
			$id = $this->db->query("SELECT IFNULL(max(id)+1,1) as id FROM perkara_jadwal_sidang")->row()->id;
			$data['id'] = $id;
			$urutan = $this->db->query("SELECT IFNULL(max(urutan)+1,1) as id FROM perkara_jadwal_sidang WHERE perkara_id =".$data['perkara_id'])->row()->id;
			$data['urutan'] = $urutan;
			$this->db->insert('perkara_jadwal_sidang', $data);
			return $id;
		} catch (Exception $e) {
			return 0;
		}
	}

	function exec_simple_query($query){
		try {
			$this->db->simple_query($query);
		} catch (Exception $e) {
			return '';
		}	
	}

	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}
	
	function add_audittrail($action,$title,$descrip,$tablename){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => 'add/edit Keberatan',
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			
		}
	}

	function deleteData($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->delete('perkara_keberatan');
			$title = "DELETE Data Keberatan dari halaman <b>EDIT DATA KEBERATAN</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$this->add_audittrail("DELETE",$title,'DELETE DATA KEBERTAN','perkara_keberatan');

			$this->db->where('perkara_id',$idperkara);
			$this->db->where('keberatan','Y');
			$this->db->delete('perkara_jadwal_sidang');

			$this->db->where('perkara_id',$idperkara);
			$this->db->where('tahapan_id',17);
			$this->db->delete('perkara_proses');
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function hasSidangPertama($idperkara){
		try {
			$query = $this->db->query("SELECT tanggal_sidang_pertama_keberatan FROM perkara_keberatan WHERE perkara_id = ".$idperkara.";");
			if(!empty($query->row()->tanggal_sidang_pertama_keberatan)){
				return TRUE;
			}else{
				return FALSE;
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function getListHakim(){
		try {
			return $this->db->query('SELECT id,nama_gelar FROM hakim_pn WHERE aktif="Y" ORDER BY nama ASC;');
		} catch (Exception $e) {
			
		}
	}

	function getTanggalPermohonan($idperkara){
		try {
			$query = $this->db->query("SELECT tanggal_pendaftaran_keberatan FROM perkara_keberatan WHERE perkara_id = ".$idperkara.";");
			return $query->row()->tanggal_pendaftaran_keberatan;
		} catch (Exception $e) {
			return '';
		}
	}

	function getHakimNama($idhakim){
		try {
			$query = $this->db->query("SELECT nama_gelar FROM hakim_pn WHERE id = ".$idhakim.";");
			return $query->row()->nama_gelar;
		} catch (Exception $e) {
			return '';
		}
	}

	function updateDataPenetapanMajelis($idperkara,$dataPenetapan,$datahakim){
		try {
			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_keberatan', $dataPenetapan);

			$title = "UPDATE TABLE <b>perkara_keberatan</b> dari halaman <b>PENETAPAN MAJELIS HAKIM</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$descrip = $this->fetch_description($title,$dataPenetapan);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_keberatan');

			$this->db->simple_query("CALL perkara_proses_update(".$idperkara.", 17, 'Keberatan', 282, 'Penetapan Majelis Hakim Keberatan', '".$dataPenetapan['penetapan_majelis_hakim']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");

			$this->db->where('perkara_id', $idperkara);
			$this->db->where('tahapan_id', 17);
			$this->db->delete('perkara_hakim_pn');
			foreach ($datahakim as $data) {
				$this->db->replace('perkara_hakim_pn',$data);
			}
			
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function getOldPenetapanMajelis($idperkara){
		try {
			return $this->db->query('SELECT penetapan_majelis_hakim,majelis_hakim_id,majelis_hakim_nama,majelis_hakim_text FROM perkara_penetapan WHERE perkara_id ='.$idperkara);
		} catch (Exception $e) {
			
		}
	}

	function getListPanitera(){
		try {
			return $this->db->query('SELECT id,nama_gelar FROM panitera_pn WHERE aktif="Y" ORDER BY nama ASC;');
		} catch (Exception $e) {
			
		}
	}

	function getPaniteraNama($idpanitera){
		try {
			$query = $this->db->query("SELECT nama_gelar FROM panitera_pn WHERE id = ".$idpanitera.";");
			return $query->row()->nama_gelar;
		} catch (Exception $e) {
			return '';
		}
	}

	function getOldPenetapanPanitera($idperkara){
		try {
			return $this->db->query('SELECT penetapan_panitera_pengganti,panitera_pengganti_id,panitera_pengganti_text FROM perkara_penetapan WHERE perkara_id ='.$idperkara);
		} catch (Exception $e) {
			
		}
	}

	function updateDataPenetapanPanitera($idperkara,$dataPenetapan,$datapanitera){
		try {
			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_keberatan', $dataPenetapan);

			$title = "UPDATE TABLE <b>perkara_keberatan</b> dari halaman <b>PENETAPAN PANITERA PENGGANTI</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$descrip = $this->fetch_description($title,$dataPenetapan);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_keberatan');

			$this->db->simple_query("CALL perkara_proses_update(".$idperkara.", 17, 'Keberatan', 283, 'Penetapan Panitera Pengganti Keberatan', '".$dataPenetapan['penetapan_panitera_pengganti']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");

			$this->db->where('perkara_id', $idperkara);
			$this->db->where('tahapan_id', 17);
			$this->db->delete('perkara_panitera_pn');
			foreach ($datapanitera as $data) {
				$this->db->replace('perkara_panitera_pn',$data);
			}
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function getListJurusita(){
		try {
			return $this->db->query('SELECT id,nama_gelar FROM jurusita WHERE aktif="Y" ORDER BY nama ASC;');
		} catch (Exception $e) {
			
		}
	}

	function getJurusitaNama($idpanitera){
		try {
			$query = $this->db->query("SELECT nama_gelar FROM jurusita WHERE id = ".$idpanitera.";");
			return $query->row()->nama_gelar;
		} catch (Exception $e) {
			return '';
		}
	}

	function getOldPenetapanJurusita($idperkara){
		try {
			return $this->db->query('SELECT penetapan_jurusita,jurusita_id,jurusita_text FROM perkara_penetapan WHERE perkara_id ='.$idperkara);
		} catch (Exception $e) {
			
		}
	}

	function updateDataPenetapanJurusita($idperkara,$dataPenetapan,$datajurusita){
		try {
			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_keberatan', $dataPenetapan);

			$title = "UPDATE TABLE <b>perkara_keberatan</b> dari halaman <b>PENETAPAN JURUSITA</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$descrip = $this->fetch_description($title,$dataPenetapan);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_keberatan');

			$this->db->simple_query("CALL perkara_proses_update(".$idperkara.", 17, 'Keberatan', 284, 'Penetapan Jurusita Keberatan', '".$dataPenetapan['penetapan_jurusita']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");

			$this->db->where('perkara_id', $idperkara);
			$this->db->where('tahapan_id', 17);
			$this->db->delete('perkara_jurusita');
			foreach ($datajurusita as $data) {
				$ids = 0;
				$query = $this->db->query("SELECT MAX(urutan) AS urutan FROM perkara_jurusita");
				if($query->num_rows>0){
					foreach ($query->result() as $row) {
						$ids = $row->urutan+1;
					}
				}
				$data['id'] = $ids;
				$this->db->replace('perkara_jurusita',$data);
			}
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function updateDataPenetapanSidang($idperkara,$dataPenetapan){
		try {
			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_keberatan', $dataPenetapan);

			$title = "UPDATE TABLE <b>perkara_keberatan</b> dari halaman <b>PENETAPAN JADWAL SIDANG</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$descrip = $this->fetch_description($title,$dataPenetapan);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_keberatan');

			$this->db->simple_query("CALL perkara_proses_update(".$idperkara.", 17, 'Keberatan', 285, 'Penetapan Jadwal Sidang Keberatan', '".$dataPenetapan['tanggal_penetapan_sidang_keberatan']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function deleteDataSidang($idperkara,$idsidang){
		try {
			$dataKeberatan['sidang_id'] = NULL;
			$dataKeberatan['tanggal_penetapan_sidang_keberatan'] = NULL;
			$dataKeberatan['tanggal_sidang_pertama_keberatan'] = NULL;
			$dataKeberatan['diperbaharui_oleh'] = $this->session->userdata('username');
			$dataKeberatan['diperbaharui_tanggal'] = date('Y-m-d H:i:s');

			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_keberatan', $dataKeberatan);

			$title = "DELETE DATA PENETAPAN SIDANG PERTAMA KEBERATAN dari halaman <b>PENETAPAN SIDANG PERTAMA KEBERATAN</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$this->add_audittrail("DELETE",$title,'DELETE DATA PENETAPAN SIDANG PERTAMA KEBERATAN','perkara_keberatan');

			$this->db->where('perkara_id',$idperkara);
			$this->db->where('id',$idsidang);
			$this->db->delete('perkara_jadwal_sidang');

			$this->db->where('perkara_id',$idperkara);
			$this->db->where('proses_id',285);
			$this->db->delete('perkara_proses');

			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function deleteDataPenJurusita($idperkara){
		try {
			$dataKeberatan['penetapan_jurusita'] = NULL;
			$dataKeberatan['jurusita_id'] = NULL;
			$dataKeberatan['jurusita_text'] = NULL;
			$dataKeberatan['diperbaharui_oleh'] = $this->session->userdata('username');
			$dataKeberatan['diperbaharui_tanggal'] = date('Y-m-d H:i:s');

			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_keberatan', $dataKeberatan);

			$title = "DELETE DATA PENETAPAN JURUSITA KEBERATAN dari halaman <b>PENETAPAN JURUSITA KEBERATAN</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$this->add_audittrail("DELETE",$title,'DELETE DATA PENETAPAN JURUSITA KEBERATAN','perkara_keberatan');

			$this->db->where('perkara_id',$idperkara);
			$this->db->where('proses_id',284);
			$this->db->delete('perkara_proses');

			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function deleteDataPenPanitera($idperkara){
		try {
			$dataKeberatan['penetapan_panitera_pengganti'] = NULL;
			$dataKeberatan['panitera_pengganti_id'] = NULL;
			$dataKeberatan['panitera_pengganti_text'] = NULL;
			$dataKeberatan['diperbaharui_oleh'] = $this->session->userdata('username');
			$dataKeberatan['diperbaharui_tanggal'] = date('Y-m-d H:i:s');

			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_keberatan', $dataKeberatan);

			$title = "DELETE DATA PENETAPAN PANITERA PENGGANTI KEBERATAN dari halaman <b>PENETAPAN PANITERA PENGGANTI KEBERATAN</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$this->add_audittrail("DELETE",$title,'DELETE DATA PENETAPAN PANITERA PENGGANTI KEBERATAN','perkara_keberatan');

			$this->db->where('perkara_id',$idperkara);
			$this->db->where('proses_id',283);
			$this->db->delete('perkara_proses');

			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function deleteDataPenHakim($idperkara){
		try {
			$dataKeberatan['penetapan_majelis_hakim'] = NULL;
			$dataKeberatan['majelis_hakim_id'] = NULL;
			$dataKeberatan['majelis_hakim_nama'] = NULL;
			$dataKeberatan['majelis_hakim_text'] = NULL;
			$dataKeberatan['diperbaharui_oleh'] = $this->session->userdata('username');
			$dataKeberatan['diperbaharui_tanggal'] = date('Y-m-d H:i:s');

			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_keberatan', $dataKeberatan);

			$title = "DELETE DATA PENETAPAN MAJELIS HAKIM KEBERATAN dari halaman <b>PENETAPAN MAJELIS HAKIM KEBERATAN</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$this->add_audittrail("DELETE",$title,'DELETE DATA PENETAPAN MAJELIS HAKIM KEBERATAN','perkara_keberatan');

			$this->db->where('perkara_id',$idperkara);
			$this->db->where('proses_id',282);
			$this->db->delete('perkara_proses');

			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function deleteDataPutusan($idperkara){
		try {
			$dataKeberatan['putusan_keberatan'] = NULL;
			$dataKeberatan['status_putusan_keberatan_id'] = NULL;
			$dataKeberatan['status_putusan_keberatan_text'] = NULL;
			$dataKeberatan['amar_putusan_keberatan'] = NULL;
			$dataKeberatan['amar_putusan_keberatan_dok'] = NULL;
			$dataKeberatan['diperbaharui_oleh'] = $this->session->userdata('username');
			$dataKeberatan['diperbaharui_tanggal'] = date('Y-m-d H:i:s');

			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_keberatan', $dataKeberatan);

			$title = "DELETE DATA PUTUSAN KEBERATAN dari halaman <b>PUTUSAN KEBERATAN</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$this->add_audittrail("DELETE",$title,'DELETE DATA PUTUSAN KEBERATAN','perkara_keberatan');

			$this->db->where('perkara_id',$idperkara);
			$this->db->where('proses_id',288);
			$this->db->delete('perkara_proses');

			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function updateDataPutusan($idperkara,$dataPutusan){
		try {
			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_keberatan', $dataPutusan);

			$title = "UPDATE TABLE <b>perkara_keberatan</b> dari halaman <b>PUTUSAN KEBERATAN</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$descrip = $this->fetch_description($title,$dataPutusan);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_keberatan');

			$this->db->simple_query("CALL perkara_proses_update(".$idperkara.", 17, 'Keberatan', 288, 'Putusan Keberatan', '".$dataPutusan['putusan_keberatan']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function getTglPutusanKeberatan($idperkara){
		try {
			$query = $this->db->query("SELECT putusan_keberatan FROM perkara_keberatan WHERE perkara_id = ".$idperkara.";");
			return $query->row()->putusan_keberatan;
		} catch (Exception $e) {
			return '';
		}
	}

	function updateDataMemori($idperkara,$dataPemberitahuan){
		try {
			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_keberatan', $dataPemberitahuan);

			$title = "UPDATE TABLE <b>perkara_keberatan</b> dari halaman <b>PROSES PERMOHONAN KEBERATAN</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$descrip = $this->fetch_description($title,$dataPemberitahuan);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_keberatan');
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function deleteDataMemori($idperkara){
		try {
			$dataKeberatan['penerimaan_memori'] = NULL;
			$dataKeberatan['penyerahan_memori'] = NULL;

			$dataKeberatan['penerimaan_kontra_memori'] = NULL;
			$dataKeberatan['penyerahan_kontra_memori'] = NULL;

			$dataKeberatan['inzage_pihak1'] = NULL;
			$dataKeberatan['inzage_pihak2'] = NULL;
			$dataKeberatan['diperbaharui_oleh'] = $this->session->userdata('username');
			$dataKeberatan['diperbaharui_tanggal'] = date('Y-m-d H:i:s');

			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_keberatan', $dataKeberatan);

			$title = "DELETE DATA PROSES PERMOHONAN KEBERATAN dari halaman <b>PROSES PERMOHONAN KEBERATAN</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$this->add_audittrail("DELETE",$title,'DELETE DATA PROSES PERMOHONAN KEBERATAN','perkara_keberatan');
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}
	function updateDataPemberitahuan($idperkara,$dataPemberitahuan){
		try {
			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_keberatan', $dataPemberitahuan);

			$title = "UPDATE TABLE <b>perkara_keberatan</b> dari halaman <b>PUTUSAN PEMBERITAHUAN</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$descrip = $this->fetch_description($title,$dataPemberitahuan);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_keberatan');

			$this->db->simple_query("CALL perkara_proses_update(".$idperkara.", 17, 'Keberatan', 289, 'Pemberitahuan Putusan Keberatan', '".$dataPemberitahuan['pemberitahuan_putusan']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function deleteDataPemberitahuan($idperkara){
		try {
			$dataKeberatan['pemberitahuan_putusan'] = NULL;
			$dataKeberatan['pemberitahuan_putusan_keberatan_pihak1'] = NULL;
			$dataKeberatan['pemberitahuan_putusan_keberatan_pihak2'] = NULL;
			$dataKeberatan['tanggal_minutasi_keberatan'] = NULL;
			$dataKeberatan['diperbaharui_oleh'] = $this->session->userdata('username');
			$dataKeberatan['diperbaharui_tanggal'] = date('Y-m-d H:i:s');

			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_keberatan', $dataKeberatan);

			$title = "DELETE DATA PEMBERITAHUAN PUTUSAN KEBERATAN dari halaman <b>PEMBERITAHUAN PUTUSAN KEBERATAN</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$this->add_audittrail("DELETE",$title,'DELETE DATA PEMBERITAHUAN PUTUSAN KEBERATAN','perkara_keberatan');

			$this->db->where('perkara_id',$idperkara);
			$this->db->where('proses_id',289);
			$this->db->delete('perkara_proses');

			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function getListParaPihak($idperkara){
		try {
			return $this->db->query('SELECT nama,pihak_id,urutan_keberatan,status_pihak_id,status_pihak_text,pihak_asal_text FROM perkara_keberatan_detil WHERE perkara_id='.$idperkara);
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function update_pihak_keberatan($data){
		try {
			$idperkara = 0;
			foreach ($data as $row) {
				$idperkara = $row['perkara_id'];
				$this->db->where('perkara_id',$row['perkara_id']);
				$this->db->where('pihak_id',$row['pihak_id']);
				$this->db->update('perkara_keberatan_detil', $row);
			}
			$title = "ADD DATA PIHAK PEMOHON KEBERATAN dari halaman <b>ADD PIHAK PEMOHON KEBERATAN</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$this->add_audittrail("INSERT",$title,'ADD DATA PIHAK PEMOHON KEBERATAN','perkara_keberatan_detil');

			$dataparapihak ='';
			$datapemohon = $this->getListParaPihak($idperkara);
			foreach ($datapemohon->result() as $row) {
				$dataparapihak .= $row->status_pihak_text.' Ke- '.$row->urutan_keberatan.':</br>'.$row->nama.'.('.$row->pihak_asal_text.')</br></br>';
			}
			$updatedata = array(
				'pemohon_keberatan' => $dataparapihak
				);
			$this->db->where('perkara_id',$idperkara);
			$this->db->update('perkara_keberatan', $updatedata);
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}
}

