<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manage_arsip_c extends CI_Controller {

	public function __construct(){
		parent::__construct();
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
	}
	function validateInputAddArsip(){
		if(empty($_POST)){
			show_404();
		}
		$this->form_validation->set_rules('no_ruang', 'Nomor Ruang', 'trim|required|xss_clean');		
		$this->form_validation->set_rules('no_lemari', 'Nomor Lemari', 'trim|required|xss_clean');		
		$this->form_validation->set_rules('no_rak', 'Nomor Rak', 'trim|required|xss_clean');		
		$this->form_validation->set_rules('no_berkas', 'Nomor Boks', 'trim|required|xss_clean');				
		if($this->input->post('act',true)=='add'){
			$this->form_validation->set_rules('nomor_perkara', 'Nomor Perkara', 'trim|required|xss_clean|is_unique[arsip.nomor_perkara]');		
		}else{
			$this->form_validation->set_rules('nomor_perkara', 'Nomor Perkara', 'trim|required|xss_clean');
		}
		$this->form_validation->set_rules('tgl_masuk_berkas', 'Tanggal Masuk Arsip', 'trim|required|xss_clean');		
		$this->form_validation->set_rules('nama_penyerah', 'Staff Yang Menyerahkan Arsip', 'trim|required|xss_clean');		
		$this->form_validation->set_rules('nama_penerima', 'Petugas Yang Menerima Arsip', 'trim|required|xss_clean');		
		$this->form_validation->set_rules('status_id', 'Status Arsip', 'trim|required|xss_clean|callback_f_dropdown_id_check');		
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$this->load->model('arsip/arsip_m','arsip');
			$nomor_perkara=$this->input->post('nomor_perkara',true);
			$nomor_perkara=trim($nomor_perkara);
			$perkara_id=$this->arsip->get_perkara_id($nomor_perkara);
			//insert data
			$data=array('no_ruang'=>$this->input->post('no_ruang',true),
						'no_lemari'=>$this->input->post('no_lemari',true),
						'no_rak'=>$this->input->post('no_rak',true),
						'no_berkas'=>$this->input->post('no_berkas',true),
						'nomor_arsip'=>$this->input->post('nomor_arsip',true),
						'perkara_id'=>$perkara_id,
						'nomor_perkara'=>$nomor_perkara,
						'tanggal_masuk_arsip'=>$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_masuk_berkas',true)),
						'nama_penerima'=>$this->input->post('nama_penerima',true),
						'nama_penyerah'=>$this->input->post('nama_penyerah',true),
						'status'=>$this->input->post('status_id',true),
						'keterangan'=>$this->input->post('keterangan',true)
				);
			switch ($this->input->post('act',true)) {
				case 'add':
					$data['diinput_oleh'] = $this->session->userdata('username');
					$data['diinput_tanggal'] = date("Y-m-d h:i:s",time());
					if ($this->arsip->add_arsip($data)){
						$this->session->set_userdata('arsip_id', $this->arsip->get_last_inserted_id());
						echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
					}else{
						echo json_encode(array('st'=>0,'msg'=>'Data Tidak Tersimpan'));
					}	
				break;
				case 'edit':
					$arsip_id=$this->encrypt->decode(base64_decode($this->input->post('enc',true)));
					$data['diperbaharui_oleh'] = $this->session->userdata('username');
					$data['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
					if ($this->arsip->edit_arsip($arsip_id,$data)){
						echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
					}else{
						echo json_encode(array('st'=>0,'msg'=>'Data Tidak Tersimpan'));
					}	
				break;
			}
			return;
		}
	}

	function validateInputAddPinjaman(){
		if(empty($_POST)){
			show_404();
		}
		$enc=$this->input->post('enc',true);
		$arsip_id=$this->encrypt->decode(base64_decode($enc));
		if (!intval($arsip_id)){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil - ID Arsip Tidak Benar'));
			return;
		}
		$this->form_validation->set_rules('tgl_pinjam', 'Tanggal Peminjaman', 'trim|required|xss_clean');		
		$this->form_validation->set_rules('peminjam_id', 'Peminjam Berkas', 'trim|required|xss_clean');		
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$act=$this->input->post('act',true);
			$this->load->model('arsip/arsip_m','arsip');
			$tglpinjam = $this->input->post('tgl_pinjam',true);
			$tglkembali = $this->input->post('tgl_kembali',true);
			if ($tglkembali!=''){
				$selisih = $this->tanggalhelper->getSelisihHari($tglpinjam,$tglkembali);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pengembalian Tidak Boleh Kurang Dari Tanggal Pinjam'));
					return;
				}
			}
			$data=array('petugas_peminjam'=>$this->input->post('peminjam_id',true),
							'tanggal_pinjam'=>$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pinjam',true)),
							'tanggal_kembali'=>$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_kembali',true)),
							'keterangan'=>$this->input->post('keterangan',true)
					);
			$data['arsip_id']=$arsip_id;
			switch ($act) {
				case 'add':
					$data['diinput_oleh'] = $this->session->userdata('username');
					$data['diinput_tanggal'] = date("Y-m-d h:i:s",time());
					if ($this->arsip->add_pinjaman($data)){
						echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
					}else{
						echo json_encode(array('st'=>0,'msg'=>'Data Tidak Tersimpan'));
					}	
				break;
				case 'edit':
					$pinjam_id=$this->encrypt->decode(base64_decode($this->input->post('enc_pjm',true)));
					$data['diperbaharui_oleh'] = $this->session->userdata('username');
					$data['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
					if ($this->arsip->edit_pinjaman($pinjam_id,$data)){
						echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
					}else{
						echo json_encode(array('st'=>0,'msg'=>'Data Tidak Tersimpan'));
					}	
				break;
			}
		}
	}

	function tab_arsip_detail(){
		$this->load->model('arsip/arsip_m', 'arsip');
		$segment = $this->uri->segment_array();
		$arsip_id=$this->encrypt->decode(base64_decode($this->uri->segment(3)));
		$data['enc']=$this->uri->segment(3);
		$data['arsip_detail']=$this->arsip->get_arsip_detail($arsip_id);
		$arsip_detail=$this->arsip->get_arsip_detail($arsip_id);
		$no_ruang = str_replace(' ', '_', $arsip_detail->no_ruang);
		$no_lemari = str_replace(' ', '_', $arsip_detail->no_lemari);
		$no_rak = str_replace(' ', '_', $arsip_detail->no_rak);
		$no_berkas = str_replace(' ', '_', $arsip_detail->no_berkas);
		$nomor_perkara=trim($arsip_detail->nomor_perkara);
		$nomor_perkara=str_replace("/", "_", $nomor_perkara);
		$nomor_perkara = str_replace(' ', '_', $nomor_perkara);
		$nomor_perkara=str_replace(".", "_", $nomor_perkara);
		$filename="dokumen_arsip/".$no_ruang."/".$no_lemari."/".$no_rak."/".$no_berkas."/Arsip_".$nomor_perkara.".*";
		$data['filename']=$filename;
		$data['edoc_arsip']=glob ($filename);
		$this->load->view('arsip_list/tab_arsip_detil', $data);
	}

	function tab_peminjaman_detail(){
		$this->load->model('arsip/arsip_m', 'arsip');
		$segment = $this->uri->segment_array();
		$arsip_id=$this->encrypt->decode(base64_decode($this->uri->segment(3)));
		$data['enc']=$this->uri->segment(3);
		$data['arsip_detail']=$this->arsip->get_arsip_detail($arsip_id);
		$data['riwayat_list']=$this->arsip->get_riwayat_peminjaman($arsip_id);
		$this->load->view('arsip_list/tab_pinjaman_arsip', $data);
	}

	function upload(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$action=$this->input->post('act',true);
		if($action=='edit'){
			$arsip_id = $this->encrypt->decode(base64_decode($this->input->post('enc')));	
		}else{
			$arsip_id=$this->session->userdata('arsip_id');
		}
		if(!is_numeric($arsip_id)){
			return;
		}
		$this->load->model('arsip/arsip_m', 'arsip');
		$info=$this->arsip->get_arsip_detail($arsip_id);
		if($info==''){
			return;
		}
		$namafileori = $_FILES['edoc_arsip']['name'];
		$no_ruang=$info->no_ruang;
		$no_lemari=$info->no_lemari;
		$no_rak=$info->no_rak;
		$no_berkas=$info->no_berkas;
		$nomor_perkara=trim($info->nomor_perkara);
		$nomor_perkara=str_replace("/", "_", $nomor_perkara);
		$nomor_perkara=str_replace(" ", "_", $nomor_perkara);
		$nomor_perkara=str_replace(".", "_", $nomor_perkara);
		$no_ruang = str_replace(' ', '_', $no_ruang);
		$no_lemari = str_replace(' ', '_', $no_lemari);
		$no_rak = str_replace(' ', '_', $no_rak);
		$no_berkas = str_replace(' ', '_', $no_berkas);
		$direktori="dokumen_arsip/".$no_ruang."/".$no_lemari."/".$no_rak."/".$no_berkas."/";
		try {			
			chmod($direktori, 0777);
			@mkdir($direktori,0777,true);
			$extension	= pathinfo($namafileori);
			$extension	= $extension['extension'];
			$fileName 	= "Arsip_".$nomor_perkara.".".$extension;
			$fileName = str_replace(' ', '_', $fileName);
		} catch (Exception $e) {
			echo json_encode(array('st'=>0,'msg'=>'E-Doc TIDAK Berhasil Disimpan.'));
			return;
		}
		
		$upload_config = array(
			'upload_path' => $direktori,
			'allowed_types' => 'pdf|zip|rar',
			'max_size' => '10240',
			'overwrite' => true,
			'file_name' =>$fileName);
		$this->upload->initialize($upload_config);
		$this->load->library('upload', $upload_config);			

		if (!$this->upload->do_upload('edoc_arsip')){
			echo json_encode(array('st'=>0,'msg'=>'E-Doc Tidak Berhasil Disimpan. '.$this->upload->display_errors('<span>', '</span>')));
			return;
		 }else{
			echo json_encode(array('st'=>1,'msg'=>'DATA Berhasil Disimpan.'));
			return;
		}
	}

	function doDownload($param){
		$arsip_id = $this->encrypt->decode(base64_decode($param));
		if(!is_numeric($arsip_id) OR intval($arsip_id)<1){
				show_404();
				exit();
		}
		$this->load->model('arsip/arsip_m', 'arsip');
		$arsip_detail=$this->arsip->get_arsip_detail($arsip_id);
		$no_ruang = str_replace(' ', '_', $arsip_detail->no_ruang);
		$no_lemari = str_replace(' ', '_', $arsip_detail->no_lemari);
		$no_rak = str_replace(' ', '_', $arsip_detail->no_rak);
		$no_berkas = str_replace(' ', '_', $arsip_detail->no_berkas);
		$nomor_perkara=trim($arsip_detail->nomor_perkara);
		$nomor_perkara=str_replace("/", "_", $arsip_detail->nomor_perkara);
		$nomor_perkara = str_replace(' ', '_', $nomor_perkara);
		$nomor_perkara=str_replace(".", "_", $nomor_perkara);
		$filename="dokumen_arsip/".$no_ruang."/".$no_lemari."/".$no_rak."/".$no_berkas."/Arsip_".$nomor_perkara.".*";
		$arr=glob ($filename);
		$filename="dokumen_arsip/".$no_ruang."/".$no_lemari."/".$no_rak."/".$no_berkas."/";
		$expld=explode("/", $arr[0]);
		$key=count($expld)-1;
		$filename.=$expld[$key];
		$data = file_get_contents($filename);
		$this->load->helper('download');
		force_download($filename, $data);
	}

	function doDelete(){
		$arsip_id = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($arsip_id) OR intval($arsip_id)<1){
			show_404();
			exit();
		}
		$this->load->model('arsip/arsip_m', 'arsip');
		$arsip_detail=$this->arsip->get_arsip_detail($arsip_id);
		$no_ruang = str_replace(' ', '_', $arsip_detail->no_ruang);
		$no_lemari = str_replace(' ', '_', $arsip_detail->no_lemari);
		$no_rak = str_replace(' ', '_', $arsip_detail->no_rak);
		$no_berkas = str_replace(' ', '_', $arsip_detail->no_berkas);
		$nomor_perkara=trim($arsip_detail->nomor_perkara);
		$nomor_perkara=str_replace("/", "_", $arsip_detail->nomor_perkara);
		$nomor_perkara = str_replace(' ', '_', $nomor_perkara);
		$nomor_perkara=str_replace(".", "_", $nomor_perkara);
		$filename="dokumen_arsip/".$no_ruang."/".$no_lemari."/".$no_rak."/".$no_berkas."/Arsip_".$nomor_perkara.".*";
		$arr=glob ($filename);

		$filename="dokumen_arsip/".$no_ruang."/".$no_lemari."/".$no_rak."/".$no_berkas."/";
		$expld=explode("/", $arr[0]);
		$key=count($expld)-1;
		$filename.=$expld[$key];
		try {
			@unlink($filename);
			echo json_encode(array('st'=>1,'msg'=>'E-Doc Arsip Berhasil Dihapus'));
			return;
		} catch (Exception $e) {
		echo json_encode(array('st'=>0,'msg'=>'E-Doc Arsip Tidak Berhasil Dihapus'));
			return;
		}
	}

}