<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class C_efiling extends CI_Controller {
	public function __construct() {
        parent::__construct();
		$this->load->model('api/m_delegasi','delegasi_api');
		$this->load->model('delegasi/d_delegasi_m');
		$this->load->model('efiling/ecourt','efiling');
    }
    function index() {

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}else{
			$this->dashboard_efiling();
			$this->nativesession->set_flash_session('url_requested',current_url());	
		}
	}

	function dashboard_efiling(){
		$data['previous'] = $this->nativesession->get_flash_session('url_requested');
		$data['efiling_blm_perkara']=$this->efiling->efiling_blm_perkara();
        $this->load->view('header');
        $this->load->view('efiling/d_efiling',$data);
        $this->load->view('footer');

	}

	function show_data($alur,$tahapan,$efiling_id,$panjaronline,$epayment=false){
		$idalurperkara=$this->encrypt->decode(base64_decode($alur));
		$idtahapan=$this->encrypt->decode(base64_decode($tahapan));
		$data['efiling_id']=$this->encrypt->decode(base64_decode($efiling_id));
		$data['panjaronline'] = $panjaronline;
		$this->load->model('perkara/new_perdata','perkara');
		$data['page_title'] = 'TAMBAH - DATA PERKARA '.strtoupper($this->perkara->getJenisPerkara($idalurperkara));
		$data['main_body'] = 'perkara/new_perdata_online';
		$data['previous'] = $this->nativesession->get_flash_session('url_requested');
		
		#flag epayment
		$data['epayment'] = $epayment;
		
		$data['biaya'] = $this->perkara->getBiayaPerkara($idalurperkara,$idtahapan);
		$data['current_date'] = date('d/m/Y');
		$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
		if($jenis_pengadilan==1)
			$format = '#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PN #kode_pn#';
		elseif($jenis_pengadilan==3)
			$format = '#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PTUN.#kode_pn#';
		elseif($jenis_pengadilan==4)
			$format = '#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#';
		$urutan = $this->perkara->getNomorUrutPerkara($idalurperkara,date("Y"));
		$kode = $this->perkara->getKodePerkara($idalurperkara);
		$kodePN = $this->perkara->getKodePN();
		$data['no_perkara'] = $this->parseFormat($format,$urutan,date("Y"),$kode,$kodePN);
		if($jenis_pengadilan==1)
			$format_manual = '/#kode_alur_perkara#/#tahun#/PN #kode_pn#';
		elseif($jenis_pengadilan==3)
			$format_manual = '/#kode_alur_perkara#/#tahun#/PTUN.#kode_pn#';
		elseif($jenis_pengadilan==4)
			$format_manual = '/#kode_alur_perkara#/#tahun#/#kode_pn#';
		$data['no_perkara_manual'] = $this->parseFormat($format_manual,$urutan,date("Y"),$kode,$kodePN);
		$data['no_urutan_perkara'] = $urutan;
		$data['no_urut'] = $this->perkara->getNomorUrutRegister($idalurperkara,date("Y-m"));
		$data['jenis_perkara'] = $this->perkara->getKlasifikasiPerkara($idalurperkara);
		$data['enc'] = base64_encode($this->encrypt->encode($idalurperkara));
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}

	function getFormat(){
		$idalurperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		$idjenisperkara = $this->input->post('val',TRUE);
		$date = $this->input->post('date',TRUE);
		if(is_numeric($idalurperkara) AND $idalurperkara>0){
			$this->load->model('perkara/new_perdata','perkara');
			if($idjenisperkara=='-1'){
				$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
				if($jenis_pengadilan==1)
					$format = '#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PN #kode_pn#';
				elseif($jenis_pengadilan==3)
					$format = '#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PTUN.#kode_pn#';
				elseif($jenis_pengadilan==4)
					$format = '#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#';
			}elseif($idalurperkara==7){
				$format = '#nomor_urut_perkara#/Pdt.Bth/#tahun#/PN #kode_pn#';
			}else{
				$format = $this->perkara->getFormatPerkara($idjenisperkara);
			}
			$kode = $this->perkara->getKodePerkara($idalurperkara);
			$kodePN1 = $this->perkara->getKodePN();
			
			#parse tahun
			$tmp = explode("/", $date);
			$tahun = $tmp[2];
			$bulan = $tmp[1];
			$urutan = $this->perkara->getNomorUrutPerkara($idalurperkara,$tahun);

			#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PN.#kode_pn#
			$tglNomor = $this->tanggalhelper->convertToMysqlDate($date);
			$selisih = $this->tanggalhelper->getSelisihHari($tglNomor,'2014-03-20');
			if($selisih>0 AND $jenis_pengadilan==1){
				if (file_exists(FCPATH."resources/ini/pnformat.ini")){
		            $iniArray = parse_ini_file(FCPATH."resources/ini/pnformat.ini");
		            $kodepn = $iniArray[$kodePN1];
		            $kode = strtoupper($kode);
		            $format = str_replace('PN ', 'PN.', $format);
	        	}
			}else{
				$kodepn = $kodePN1;
			}
			$format = $this->parseFormat($format,$urutan,$tahun,$kode,$kodepn);
			$nourutregister= $this->perkara->getNomorUrutRegister($idalurperkara,$tahun.'-'.$bulan);
			echo json_encode(array('st'=>1,'msg'=>$format,'nourutregister'=>$nourutregister));
		}else{
			echo json_encode(array('st'=>0,'msg'=>"Error, Please refresh your Page",'nourutregister'=>"Error, Please refresh your Page"));
		}
	}

	function parseFormat($format,$urutan,$tahun,$kode,$kodePN){
		$format = str_replace("#nomor_urut_perkara#",$urutan,$format);
		$format = str_replace("#kode_alur_perkara#",$kode,$format);
		$format = str_replace("#tahun#",$tahun,$format);
		$format = str_replace("#kode_pn#",$kodePN,$format);
		return $format;
	}

	function validateNomorPerkara(){
		$idalurperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		$date = $this->input->post('date',TRUE);
		$urutan = $this->input->post('urutan',TRUE);
		$no_manual = $this->input->post('no_manual',TRUE);
		$no_urut_register = $this->input->post('no_urut_register',TRUE);
		$this->load->model('perkara/new_perdata','perkara');
		$nomor_perkara = $urutan.$no_manual;

		if($this->perkara->cekNomorUrut($date, $no_urut_register)->num_rows()==0 && $this->perkara->cekNomorPerkara($nomor_perkara)->num_rows()==0){
			echo json_encode(array('st'=>1,'msg'=>'Valid'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'ERROR, Nomor Perkara Sudah Terdaftar Di dalam Sistem. Periksa Kembali Nomor Yang Anda Masukan.'));
		}
	}

	function validateInput(){
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		if(empty($_POST)){
			show_404();
		}
		$klas_perkara = $this->input->post('klas_perkara',TRUE);
		if($klas_perkara==-1){
			echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Anda Belum Memilih Klasifikasi Perkara'));
			return;
		}
		$this->form_validation->set_rules('tgl_pendaftaran', 'Tanggal Pendaftaran', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('klas_perkara', 'Klasifikasi Perkara', 'trim|required|numeric|greater_than[0]|xss_clean');
		$this->form_validation->set_rules('no_urut', 'Nomor Urut', 'trim|required|numeric|xss_clean');
		
		$this->form_validation->set_rules('generate', 'Generate Nomor Perkara', 'trim|required|numeric|xss_clean');
		$generate = $this->input->post('generate',TRUE);
		if($generate==1){
			$this->form_validation->set_rules('no_perkara_auto', 'Nomor Perkara', 'trim|required|xss_clean|is_unique[perkara.nomor_perkara]');
		}elseif ($generate==0) {
			$this->form_validation->set_rules('no_urutan_manual', 'Nomor Urut Register', 'trim|required|numeric|xss_clean');
			$this->form_validation->set_rules('no_perkara_manual', 'Nomor Perkara', 'trim|required|xss_clean');
		}else{
			show_404();
		}

		$this->form_validation->set_rules('prodeo', 'Prodeo', 'trim|required|numeric|xss_clean');
		$prodeo = $this->input->post('prodeo',TRUE);
		$jenis_prodeo = -1;
		if($prodeo==1){
			$this->form_validation->set_rules('jenis_prodeo', 'Jenis Prodeo', 'trim|required|numeric|xss_clean');
			$jenis_prodeo = $this->input->post('jenis_prodeo',TRUE);
			if($jenis_prodeo!=2 AND $jenis_prodeo!=3){
				echo json_encode(array('st'=>0,'msg'=>'Silahkan Pilih Jenis Prodeo'));
				return;
			}
			$id_pembiayaan = $jenis_prodeo;
		}else{
			$id_pembiayaan = 1;
		}

		$this->form_validation->set_rules('b_panjar', 'Biaya Panjar Perkara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('b_pendaftaran', 'Biaya Pendaftaran Perkara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('b_atk', 'Biaya Alat Tulis Kantor', 'trim|required|xss_clean');

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil'.validation_errors()));
		}else{
			
			
			$noUrutReg = $this->input->post('no_urut',TRUE);
			$this->load->model('perkara/new_perdata','perkara');
			$idalurperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			$isNoUrutRegisterExists = $this->perkara->isNomorUrutRegisterExists($this->input->post('tgl_pendaftaran',TRUE),$idalurperkara,$noUrutReg);
			if($isNoUrutRegisterExists==TRUE OR $isNoUrutRegisterExists==-2){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Nomor Urut Register Sudah Ada'.$isNoUrutRegisterExists));
				return;
			}

			$tgl_pendaftaran = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pendaftaran',TRUE));
			$tglPendaftaran = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pendaftaran',TRUE));
			if($tglPendaftaran==false){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}
			
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$selisih = $this->tanggalhelper->getSelisihHari($tgl_pendaftaran,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tanggal Pendaftaran Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
				return;
			}

			if($generate==1){
				$noPerkara = $this->input->post('no_perkara_auto',TRUE);
			}elseif ($generate==0) {
				$noPerkara =$this->input->post('no_urutan_manual',TRUE).$this->input->post('no_perkara_manual',TRUE);
			}

			$tmp = explode("/", $noPerkara);
			if((count($tmp)!=5 AND $idalurperkara==9) AND count($tmp)!=4){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Please Refresh Your Browser'.count($tmp)));
				return;
			}
			
			$nomor_urut_perkara = $tmp[0];
			$tmpIndexs = $tmp[0];
			if($tmpIndexs<10){
				$tmpIndexs = '000'.$tmpIndexs;
			}elseif($tmpIndexs>9 and $tmpIndexs <1000){
				$tmpIndexs = '00'.$tmpIndexs;
			}
			$nomorIndexs = $tmp[3].'_'.$tmp[2].'_'.$tmp[1].'_'.$tmpIndexs;
			$isPerkaraExists = $this->perkara->isNomorPerkaraExist($noPerkara);
			if($isPerkaraExists===TRUE){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Nomor Perkara Sudah Ada Didalam System'));
				return;
			}
			$no_ref = $this->input->post('no_ref',TRUE);
			$b_panjar = str_replace('.','',$this->input->post('b_panjar',TRUE));
			$b_pendaftaran = str_replace('.','',$this->input->post('b_pendaftaran',TRUE));
			$b_atk = str_replace('.','',$this->input->post('b_atk',TRUE));
			if($b_panjar<($b_pendaftaran+$b_atk)){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Biaya Panjar Tidak Boleh Kurang dari Biaya Pendaftaran ditambah Biaya ATK'));
				return;
			}elseif ($b_panjar==0 AND $jenis_prodeo<>3) {
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Biaya Panjar Tidak Boleh Kosong'));
				return;
			}

			#masukan ke db
			#
			$jenisPerkara = $this->perkara->getJenisPerkaraNama($klas_perkara);
			if($jenisPerkara->num_rows>0){
				foreach ($jenisPerkara->result() as $row) {
					$kode = $row->kode;
					$jenisPerkaraNama = $row->nama;
					$jenisPerkaraText = $row->nama_lengkap;
				}
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Please Refresh Your Browser'));
				return;
			}
			$dayName = $this->tanggalhelper->getDayName($tgl_pendaftaran);
			if($dayName=="Sunday" OR $dayName=="Saturday"){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Dapat memilih diluar hari kerja (Sabtu - Minggu).'));
				return;
			}

			

			$data_perkara = array(
				'nomor_perkara' => $noPerkara,
				'alur_perkara_id' => $idalurperkara,
				'tanggal_pendaftaran' => $tglPendaftaran,
				'jenis_perkara_id' => $klas_perkara,
				'jenis_perkara_kode' => $kode,
				'jenis_perkara_nama' => $jenisPerkaraNama,
				'jenis_perkara_text' => $jenisPerkaraText,
				'nomor_urut_register' => $noUrutReg,
				'nomor_urut_perkara' => $nomor_urut_perkara,
				'nomor_indeks' => $nomorIndexs,
				'tahapan_terakhir_id' => 10,
				'tahapan_terakhir_text' => 'Pendaftaran',
				'proses_terakhir_id' => 10,
				'proses_terakhir_text' => 'Pendaftaran Perkara',
				'diinput_oleh' => $this->session->userdata('username'),
				'diinput_tanggal' => date("Y-m-d h:i:s",time())
			);
			if(!empty($prodeo)){
				$data_perkara['prodeo'] = $prodeo;
			}
			$data_keuangan_perkara = array(
				array(
					'id_pembiayaan' => $id_pembiayaan,
					'tahapan_id' => 10,
					'kategori_id' => 1,
					'jenis_biaya_id' => 1,
					'urutan' => 1,
					'jenis_transaksi' => 1,
					'tanggal_transaksi' => $tglPendaftaran,
					'uraian' => 'Panjar Biaya Perkara',
					'jumlah' => $b_panjar,
					'diinput_oleh' => $this->session->userdata('username'),
					'diinput_tanggal' => date("Y-m-d h:i:s",time())
				),
				array(
					'id_pembiayaan' => $id_pembiayaan,
					'tahapan_id' => 10,
					'kategori_id' => 11,
					'jenis_biaya_id' => 61,
					'urutan' => 2,
					'jenis_transaksi' => -1,
					'tanggal_transaksi' => $tglPendaftaran,
					'uraian' => 'Biaya Pendaftaran/PNBP',
					'jumlah' => $b_pendaftaran,
					'diinput_oleh' => $this->session->userdata('username'),
					'diinput_tanggal' => date("Y-m-d h:i:s",time())
				),
				array(
					'id_pembiayaan' => $id_pembiayaan,
					'tahapan_id' => 10,
					'kategori_id' => 12,
					'jenis_biaya_id' => 155,
					'urutan' => 3,
					'jenis_transaksi' => -1,
					'tanggal_transaksi' => $tglPendaftaran,
					'uraian' => 'Biaya Pemberkasan/ATK',
					'jumlah' => $b_atk,
					'diinput_oleh' => $this->session->userdata('username'),
					'diinput_tanggal' => date("Y-m-d h:i:s",time())
				)
			);
			if($this->perkara->add_data($data_perkara,$data_keuangan_perkara)){
				echo json_encode(array('st'=>1,'msg'=>'Berhasil Disimpan'));
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Database Error, Pendaftaran Perkara Tidak Berhasil'));
			}	
		}
	}













	function show_hasil_pencarian(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		
		$search=$this->input->post('search',TRUE);

		if($search!=""){
			$cari_delegasi_k=$this->d_delegasi_m->hasil_cari_k($search);
			$cari_delegasi_m=$this->d_delegasi_m->hasil_cari_m($search);
			
			if($cari_delegasi_k->num_rows()>0 || $cari_delegasi_m->num_rows()>0){
				if($cari_delegasi_k->num_rows()>0){
					$hslcari = "<div class='box'>
			             			<div class='box-header with-border'>
			              			<h3 class='box-title red'><strong>Hasil Pencarian Delegasi Keluar</strong<small></small></h3>
			            			</div>";
						$hslcari .= "<div class='box-body'>
							              <table class='table table-bordered table-hover' style='font-size: 14px;'>
							                <tr>
							                  <th style='width: 5%'>No.</th>
							                  <th style='width: 40%'>Nomor Perkara<br>Pihak</th>
							                  <th style='width: 13%'>Status Delegasi</th>
							                  <th style='width: 30%'>Pengadilan Tujuan</th>
							                  <th style='width: 5%'>Detil</th>
							                </tr>";
							    			$i=1;
										    foreach ($cari_delegasi_k->result() as $row) {
										    	if($row->status_kirim==0){
										    		$status_delegasi="<font color='red'>Belum dikirim</font>";
										    	}else if($row->status_kirim==1){
										    		$status_delegasi="<font color='orange'>Sudah Dikirim</font>";
										    	}else if($row->status_kirim==2){
										    		$status_delegasi="<font color='green'>Sudah Dilaksanakan</font>";
										    	}
										    	$hslcari.= "<tr>";
										    	$hslcari.= "<td height='30'>".$i."</td>";
										    	$hslcari.= "<td height='30'>".$row->nomor_perkara."<br>".$row->pihak."</td>";
										    	$hslcari.= "<td height='30'>".$status_delegasi."</td>";
										    	$hslcari.= "<td height='30'>".$row->pn_tujuan_text."</td>";
										    	$hslcari.= '<td height="30"><a class="btn btn-warning btn-sm" href="'.base_url('manage_delegasi_perkara/detil_delegasi/'.base64_encode($this->encrypt->encode(2))."/".base64_encode($this->encrypt->encode($row->id))."/".base64_encode($this->encrypt->encode($row->id_pn_asal))."/".base64_encode($this->encrypt->encode($row->id_pn_tujuan))).'"><i class="fa fa-send"></i> Detil </a></td>';
										    	$hslcari.= "</tr>";
										    	$i++;
										    };          			
							    $hslcari .= "</div>";

						$hslcari.= "</table>";
	
				}else{
					$hslcari = "";
				}

				if($cari_delegasi_m->num_rows()>0){
					$hslcari .= "<div class='box'>
			             			<div class='box-header with-border'>
			              			<h3 class='box-title red'><strong>Hasil Pencarian Delegasi Masuk</strong<small></small></h3>
			            			</div>";
						$hslcari .= "<div class='box-body'>
							              <table class='table table-bordered table-hover' style='font-size: 14px;'>
							                <tr>
							                  <th style='width: 5%'>No.</th>
							                  <th style='width: 40%'>Nomor Perkara<br>Pihak</th>
							                  <th style='width: 13%'>Status Delegasi</th>
							                  <th style='width: 30%'>Pengadilan Asal</th>
							                  <th style='width: 5%'>Detil</th>
							                </tr>";
							    			$i=1;
										    foreach ($cari_delegasi_m->result() as $row1) {
										    	if($row1->id_status_delegasi<=0){
										    		$status_delegasi="<font color='red'>Belum Dilaksanakan</font>";
										    	}else if($row1->id_status_delegasi>0){
										    		$status_delegasi="<font color='green'>Sudah Dilaksanakan</font>";
										    	}										    	
										    	$hslcari.= "<tr>";
										    	$hslcari.= "<td height='30'>".$i."</td>";
										    	$hslcari.= "<td height='30'>".$row1->nomor_perkara."<br>".$row1->pihak."</td>";
										    	$hslcari.= "<td height='30'>".$status_delegasi."</td>";
										    	$hslcari.= "<td height='30'>".$row1->pn_asal_text."</td>";
										    	$hslcari.= '<td height="30"><a class="btn btn-warning btn-sm" href="'.base_url('manage_delegasi_perkara/detil_delegasi/'.base64_encode($this->encrypt->encode(1))."/".base64_encode($this->encrypt->encode($row1->id))."/".base64_encode($this->encrypt->encode($row1->id_pn_asal))."/".base64_encode($this->encrypt->encode($row1->id_pn_tujuan))).'"><i class="fa fa-send"></i> Detil </a></td>';
										    	$hslcari.= "</tr>";
										    	$i++;
										    };          			
							    $hslcari .= "</div>";

						$hslcari.= "</table>";
	
				}else{
					$hslcari .= "";
				}

			echo json_encode(array('st'=>1,'hasil_cari'=>$hslcari));
			return;
			}
		}else{

			echo json_encode(array('st'=>0));
			return;
		}
		
	}














	function dashboard(){
		$tmp=base_url();
		$tmp=str_replace('http://','',$tmp);
		$tmp2=str_replace('https://','',$tmp);
		$ip=explode('/',$tmp2);
		$data['is_connect']=$this->check_connection();
		$data['ip_sipp']=$ip[0];
  		$data['main_body']='delegasi/iframe';
  		$this->load->vars($data);
  		$this->load->view('header');
  		$this->load->view('body/body_new');
	
	}

	function check_connection(){
	 	$connected = @fsockopen("www.google.com"); 
	    if ($connected){
	        $is_conn = true; 
	        fclose($connected);
	    }else{
	        $is_conn = false;
	    }
	    return $is_conn;
	}

	function session_connect($value=0,$sesion){
		if ($value==0){
			$this->session->set_userdata('is_connect',FALSE);
		}else if ($value==1){
			$this->session->set_userdata('is_connect',TRUE);
		}
		echo json_encode($value);
		return;
	}


	function send_identity() {
		$query=$this->delegasi->get_username();
		// $data_online=$this->user_online->get_user_online()->result_object();
  //   	$session_id=$data_online[0]->session_id;
    	$userid	=$data_online[0]->userid;
		if ($query->num_rows >= 1) {
			$data=$query->result_object();
			$IDPN=$data[0]->IDPN;
			$kode_satker=$data[0]->kode_satker;
			// $NamaPN='pengadilan negeri';
			$user_sipp_ma=$data[0]->user_sipp_ma;
			$pwd_sipp_ma=$data[0]->pwd_sipp_ma;
		}
	   // $val="IDPN='".$IDPN."&kode_satker=".$kode_satker."&NamaPN=".$NamaPN."&user_sipp_ma=".$user_sipp_ma."&pwd_sipp_ma=".$pwd_sipp_ma;
		$var="v4r_user=".$user_sipp_ma."&v4r_pw5=".$pwd_sipp_ma;
        $curl = curl_init();

		curl_setopt_array($curl, array(
		  CURLOPT_URL => "http://192.168.78.78/sipp_delegasi/api/delegasi/auth_sipp?".$var,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => "",
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 30,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => "GET",
		));

		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);

		if ($err) {
		  // echo "cURL Error #:" . $err;
			echo json_encode($err);
		} else {
	 		echo json_encode(json_decode($response));
		}

    }
}
