<style type="text/css">
body{
	margin: 0;
}
.update{
	height: 100%;
	width: 100%;
	margin: 0;
	padding: 0;
}
.head{
	font-size: 28px;
	font-family: "Century Gothic", CenturyGothic, Geneva, AppleGothic, sans-serif;
	margin-left:auto;
	margin-right:auto;
	width:310px;
	padding-top: 25px;
}

.seperator{
	height: 20px;
}

.body{
	font-size: 13px;
	font-family: "Century Gothic", CenturyGothic, Geneva, AppleGothic, sans-serif;
	margin-left:auto;
	margin-right:auto;
	width:620px;
}

.first-column{
    padding: 7px;
    background:-o-linear-gradient(bottom, #5FB85C 5%, #5FB85C 100%);    
    background:-webkit-gradient( linear, left top, left bottom, color-stop(0.05, #5FB85C), color-stop(1, #5FB85C) );
    background:-moz-linear-gradient( center top, #5FB85C 5%, #5FB85C 100% );
    filter:progid:DXImageTransform.Microsoft.gradient(startColorstr="#5FB85C", endColorstr="#5FB85C");  
    background: -o-linear-gradient(top,#5FB85C,02a3cc);

    background-color:#5FB85C;
    border:0px solid #ffffff;
    text-align:left;
    border-width:1px 1px 1px 1px;
    font-weight: 500px;
    color:#ffffff;
    padding-left: 10px;
}

.second-column{
    padding: 5px;
    padding-left: 15px;
    background-color:white;
    border:0px solid #ffffff;
    text-align:left;
    border-width:1px 1px 1px 1px;
    font-weight: 500px;
    color:black;
    padding-left: 10px;
}

.two-column table {
	font-family: "Century Gothic", CenturyGothic, Geneva, AppleGothic, sans-serif;
	width: 100%;
	border-width: thin;
	border-collapse: collapse;
	table-layout: fixed;
	font-size:13px;
}
.lblBtn{
	margin: 5px;
	background-color: #5FB85C;
	padding: 10px;
	font-size: 15px;
	color: white;
}
.lblBtn:hover{
	background-color: #f1c40f;
	cursor: pointer;
}
</style>

<?php
#should parse from database
function get_siteInfo(){
	return '3.1.1';
}
function getUpdateInformation($url){
	
	$systemVersion = get_siteInfo();
	$versionAvailable = '';
	
	/* Read XML file */
	$xml_file_content = file_get_contents("http://103.16.79.19/update.xml");
	#$xml_file_content = file_get_contents($url."/update.xml");

	/* Parse XML */
	$xml = new SimpleXMLElement($xml_file_content);
	$lastRecord = count($xml->children())-1;
	$updateInfo = $xml->children();

	foreach($updateInfo[$lastRecord]->children() as $info){
		if($info->getName()=='version'){
			$versionAvailable = $info;
		}
		if($info->getName()=='filename'){
			$filename = $info;
		}
		if($info->getName()=='message'){
			$message = $info;
		}
		if($info->getName()=='level'){
			$level = $info;
		}
		if($info->getName()=='size'){
			$size = $info;
		}
		if($info->getName()=='checksum'){
			$checksum = $info;
		}
		if($info->getName()=='bugsfixed'){
			$bugsfixed = $info;
		}
	}
	if (version_compare($systemVersion, $versionAvailable, '<')){
		$update['version'] = '<font color="blue">New Version Available: SIPP '.$versionAvailable.'</font>';
		$update['filename'] = $filename;
		$update['message'] = $message;
		$update['level'] = $level;
		$update['size'] = $size.' KB';
		$update['checksum'] = $checksum;
		$update['bugsfixed'] = $bugsfixed;
		return $update;
	}else{
		$update['version'] = 'No New Update Available';
		$update['filename'] = '-';
		$update['message'] = '-';
		$update['level'] = '-';
		$update['size'] = '-';
		$update['checksum'] = '-';
		$update['bugsfixed'] = '-';
		return $update;
	}
}

$updatesInfo = getUpdateInformation('');
?>
<div class='update'>
	<div class='head'>
		<div class='title'>DYNAMIC UPDATE SIPP</div>
	</div>
	<div class='seperator'></div>
	<div class='body' style="border: 1px solid rgb(221, 221, 221); padding: 5px;">
		<div id='information' class='two-column'>
			<table>
				<tr>
					<td width='200' class='first-column'>SIPP Current Version</td>
					<td class='second-column'>SIPP Version <?php echo get_siteInfo();?></td>
				</tr>
				<tr>
					<td width='200' class='first-column'>Update</td>
					<td class='second-column'><?php if(isset($updatesInfo['version'])){echo $updatesInfo['version'];}?></td>
				</tr>
				<tr>
					<td width='200' class='first-column'>File Size</td>
					<td class='second-column'><?php if(isset($updatesInfo['size'])){echo $updatesInfo['size'];}?></td>
				</tr>
				<tr>
					<td width='200' class='first-column'>File Checksum</td>
					<td class='second-column'><?php if(isset($updatesInfo['checksum'])){echo $updatesInfo['checksum'];}?></td>
				</tr>
				<tr>
					<td width='200' class='first-column'>Level</td>
					<td class='second-column'><?php if(isset($updatesInfo['level'])){echo $updatesInfo['level'];}?></td>
				</tr>
				<tr>
					<td width='200' class='first-column'>Message</td>
					<td class='second-column'><?php if(isset($updatesInfo['message'])){echo $updatesInfo['message'];}?></td>
				</tr>
				<tr>
					<td width='200' class='first-column'>Bugs Fixed</td>
					<td class='second-column'><?php if(isset($updatesInfo['bugsfixed'])){echo $updatesInfo['bugsfixed'];}?></td>
				</tr>
				<tr>
					<td width='200' class='first-column'>Information</td>
					<td class='second-column'>Link</td>
				</tr>
				<tr>
					<td colspan='2'>
						<div class='lblBtn' style='float:right;text-align:center;' onclick=''>update</div>
					</td>
				</tr>
			</table>
		</div>
	</div>
</div>