<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Staff extends CI_Model {
	function parseOrderby($col){
		if($col==1){
			return "status_hakim_id"; 
		}else if($col==2){
			return "nip"; 
		}else if($col==3){
			return "nama"; 
		}else if($col==4){
			return "nama_gelar"; 
		}else if($col==5){
			return "aktif"; 
		}else{
			return "nama";
		}
	}

	function get_hakim_list($col=3,$asc_desc='ASC',$begin=0,$key=''){
		$orderby = $this->parseOrderby($col);
		$where = '';
		if(!empty($key)){
			$where .= ' WHERE (nama LIKE "%'.$key.'%" OR nama_gelar LIKE "%'.$key.'%") ';
		}
		try {
			return $this->db->query("SELECT SQL_CALC_FOUND_ROWS id, 
				IF(status_hakim_id=1,'Hakim Tetap','Hakim Adhock') AS status_hakim_text, status_hakim_id, 
				nip, nama, nama_gelar, IF(aktif='T','Tidak','Aktif') AS aktif_text, aktif
				FROM hakim_pn ".$where." ORDER BY ".$orderby." ".$asc_desc." LIMIT ".$begin.",50;");
		} catch (Exception $e) {
			
		}
	}

	function fecth_data_num(){
		$query = $this->db->query("SELECT FOUND_ROWS() as cnt;");
		if($query->num_rows>0){
			foreach ($query->result() as $row) {
				return $row->cnt;
			}
    		return $query->num_rows;
    	}else{
    		return 0;
    	}
	}


	function get_hakim_info($id_hakim){
		if(empty($id_hakim)){
			return "";
		}
		try {
			return $this->db->query("SELECT id,	status_hakim_id, nip,pangkat, jabatan,kode, nama, nama_gelar,
				IF(aktif='T',0,1) AS aktif, keterangan FROM hakim_pn where id=".$id_hakim);
		} catch (Exception $e) {
			
		}
	}

	

	function get_last_id(){
		try {
			$this->db->select_max('id');
			$query = $this->db->get('hakim_pn');
			if ($query->num_rows() > 0){
				return $query->row();
			}else{
				return 0;
			}		
		} catch (Exception $e) {
			
		}
	}

	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}

	function add_audittrail($action,$title,$descrip){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => 'hakim_pn',
				'formname' => 'Data Hakim',
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			
		}
	}

	function add_data($data){
		try {
			$this->db->insert('hakim_pn', $data);
			$title = "Tambah Hakim [Username=<b>".$data['nama']."</b>]<br />Tambah table <b>hakim_pn</b> dari halaman <b>hakim_pn</b> dengan Primary Key [id=".$data['id']."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("INSERT",$title,$descrip);
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function update_data($data,$id_hakim){
		try {
			$this->db->where('id', $id_hakim);
			$this->db->update('hakim_pn', $data); 
			$title = "Edit Data Hakim [hakim=<b>".$data['nama']."</b>]<br />Edit table <b>hakim_pn</b> dari halaman <b>hakim_pn</b> dengan Primary Key [ID Hakim=".$id_hakim."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("UPDATE",$title,$descrip);
			$this->update_sync($id_hakim,$data['aktif']);
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	#this function used to update status activation on respective table that hold id Hakim such as mediator
	function update_sync($idHakim,$aktif){
		try {
			$data = array(
               'diperbaharui_oleh' => 'System',
               'diperbaharui_tanggal' => date("Y-m-d h:i:s",time()),
               'aktif' => $aktif,
               'keterangan' => 'Automatic Update to InActive by System,Hakim no longer active'
            );
			$this->db->where('hakim_id',$idHakim);
			$this->db->update('mediator',$data);
		} catch (Exception $e) {
			
		}
	}

	function get_userid($idHakim){
		try {
			$this->db->select('userid');
			$this->db->where('hakim_id',$idHakim);
			$this->db->get('v_users');
		} catch (Exception $e) {
			
		}
	}
}
?>