<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Report_pidmil_nominatif_pk extends CI_Model{
	
	function get_info_pn(){
		try {
			$this->db->select('*');
			$this->db->where('id >=', 61); 
			return $this->db->get('sys_config');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	function getJenisPerkara($idalurperkara){
		if(empty($idalurperkara)) return '';
		try {
			$this->db->where('id',$idalurperkara);
			return $this->db->get('alur_perkara')->row()->nama;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_tahun($idalurperkara){
		try {
			return $this->db->query('SELECT YEAR(min(tanggal_pendaftaran)) AS years FROM perkara WHERE alur_perkara_id IN ('.$idalurperkara.');');
		} catch (Exception $e) {
			
		}
	}

	function get_rekap1($idalurperkara,$tahun){
		try {
			return $this->db->query("SELECT 
									jp.id,
									jp.nama, 
									vsum.* FROM jenis_perkara AS jp
									        LEFT JOIN (
									        SELECT p.jenis_perkara_id
									        ,SUM(LEFT(tanggal_pendaftaran,4)<'".$tahun."' AND (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,4)>='".$tahun."'))  AS sisa
											,SUM(LEFT(tanggal_pendaftaran,4)='".$tahun."')  AS masuk
											,SUM(LEFT(tanggal_putusan,4)='".$tahun."')  AS putus
											,SUM(LEFT(tanggal_putusan,4)='".$tahun."' AND status_putusan_id=59)  AS dikembalikan
											,(SUM(LEFT(tanggal_pendaftaran,4)<'".$tahun."' AND (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,4)>='".$tahun."'))+SUM(LEFT(tanggal_pendaftaran,4)='".$tahun."')-
											  SUM(LEFT(tanggal_putusan,4)='".$tahun."')-SUM(LEFT(tanggal_putusan,4)='".$tahun."' AND status_putusan_id=59) )  AS sisa_akhir
											,SUM(pt_denda.durasi_nominal) AS denda
											,SUM(pt_biaya.durasi_nominal) AS biaya
											FROM 
											v_perkara AS p 
											LEFT JOIN (
													SELECT 
														perkara_id		AS perkara_id				
														,SUM(durasi_nominal) 	AS durasi_nominal
														FROM perkara_putusan_terdakwa 
													WHERE status_putusan_id=46 OR status_putusan_id=57
													GROUP BY perkara_id		
											) AS pt_denda ON p.perkara_id=pt_denda.perkara_id
											LEFT JOIN (
													SELECT 
														perkara_id		AS perkara_id				
														,SUM(durasi_nominal) 	AS durasi_nominal
														FROM perkara_putusan_terdakwa 
													WHERE status_putusan_id=60
													GROUP BY perkara_id			
											) AS pt_biaya ON p.perkara_id=pt_biaya.perkara_id	
											WHERE p.alur_perkara_id = ".$idalurperkara." GROUP BY p.jenis_perkara_id) AS vsum
											ON jp.id =  vsum.jenis_perkara_id

									WHERE jp.aktif='Y'
									AND jp.id IN (SELECT ja.jenis_perkara_id FROM jenis_alur_perkara AS ja WHERE ja.alur_perkara_id=".$idalurperkara.")
									ORDER BY jp.lft;");
		} catch (Exception $e) {
			
		}
	}

	function get_rekap($idalurperkara,$periode_awal,$periode_akhir){
		try {
			return $this->db->query("SELECT 
										p.perkara_id 			AS perkara_id,
										p.nomor_perkara 		AS nomor_perkara,
										pb.nomor_perkara_pk		AS nomor_perkara_pk,
										CONCAT('APP/',SUBSTRING_INDEX(p.nomor_perkara,'/',3),'/',
										(CASE MID(permohonan_pk,6,2)
											WHEN '01' THEN 'I'
											WHEN '02' THEN 'II'
											WHEN '03' THEN 'III'
											WHEN '04' THEN 'IV'
											WHEN '05' THEN 'V'
											WHEN '06' THEN 'VI'
											WHEN '07' THEN 'VII'
											WHEN '08' THEN 'VIII'
											WHEN '09' THEN 'IX'
											WHEN '10' THEN 'X'
											WHEN '11' THEN 'XI'
											WHEN '12' THEN 'XII'
										 END),'/',LEFT(permohonan_pk,4)
										) 				AS nomor_app,
										pb.permohonan_pk 		AS permohonan_pk,
										p.tanggal_putusan 		AS tanggal_putusan,
										pm.tanggal_kejadian 		AS tanggal_kejadian,
										pm.nomor_skeppera 		AS nomor_skeppera,
										pm.tanggal_skeppera 		AS tanggal_skeppera,
										GROUP_CONCAT(CONCAT_WS('</br>',pp2.nama,pp2.pangkat,pp2.nrp,pp2.kesatuan) SEPARATOR ';') 		AS terdakwa,
										IF(pm.matra=1,'AD',IF(pm.matra=2,'AL',IF(pm.matra=3,'AU',''))) AS matra,
										p.jenis_perkara_nama 		AS klasifikasi,
										p.pasal_dakwaan		 	AS pasal_dakwaan,
										p.amar_putusan 			AS amar_putusan,
										pb.pemohon_pk 		AS pemohon_pk
									FROM perkara_pk AS pb
									LEFT JOIN v_perkara AS p ON pb.perkara_id=p.perkara_id
									LEFT JOIN perkara_pihak2 AS pp2 ON p.perkara_id=pp2.perkara_id
									LEFT JOIN perkara_matra AS pm ON p.perkara_id=pm.perkara_id
									WHERE p.alur_perkara_id=".$idalurperkara." AND 
									(LEFT(pb.permohonan_pk,7)>='".$periode_awal."' AND LEFT(pb.permohonan_pk,7)<='".$periode_akhir."')
									GROUP BY perkara_id");
		} catch (Exception $e) {
			
		}
	}


	function get_stat_perkara($period,$idalurperkara){
		try {
			return $this->db->query("
				SELECT alur_perkara_id,alur_perkara_nama,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>='".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' THEN 1
						ELSE 0
						END
					) AS sisa,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
						ELSE 0
						END
					) AS putus_blm_minut,
				SUM(
					CASE 
						WHEN (keputusan_mediasi IS NOT NULL AND LEFT(keputusan_mediasi,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') AND hasil_mediasi='Y' THEN 1
						ELSE 0
						END
					) AS med_blm_minut,
				SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) = '".$period."' THEN 1
						ELSE 0
						END
					) AS masuk,
				SUM(
					CASE 
						WHEN (penetapan_majelis_hakim IS NULL OR LEFT(penetapan_majelis_hakim,7)>'".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS blm_majelis,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS putus,
				SUM(
					CASE 
						WHEN (tanggal_minutasi IS NOT NULL AND LEFT(tanggal_minutasi,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS minut,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>'".$period."') THEN 1
						WHEN (LEFT(mediasi_berhasil,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
						ELSE 0
						END
					) AS blm_minut,
				SUM(
					CASE 
						WHEN (tanggal_cabut IS NOT NULL AND LEFT(tanggal_cabut,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS cabut,
				SUM(
					CASE 
						WHEN (tanggal_gugur IS NOT NULL AND LEFT(tanggal_gugur,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS gugur,
				SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='Y' AND status_mediator='H' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
						ELSE 0
						END
					) AS mediator_hakim_berhasil,
					SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='N' AND status_mediator='H' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
						ELSE 0
						END
					) AS mediator_hakim_gagal
				FROM v_perkara
				WHERE alur_perkara_id IN (".$idalurperkara.")
				AND LEFT(tanggal_pendaftaran,7) <='".$period."';
				");
		} catch (Exception $e) {
			
		}
	}

	function get_stat_perkara_bln($period,$idalurperkara){
		try {
			return $this->db->query("
				SELECT jenis_perkara_id,jenis_perkara_nama,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>='".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' THEN 1
						ELSE 0
						END
					) AS sisa,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
						ELSE 0
						END
					) AS putus_blm_minut,
				SUM(
					CASE 
						WHEN (keputusan_mediasi IS NOT NULL AND LEFT(keputusan_mediasi,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') AND hasil_mediasi='Y' THEN 1
						ELSE 0
						END
					) AS med_blm_minut,
				SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) = '".$period."' THEN 1
						ELSE 0
						END
					) AS masuk,
				SUM(
					CASE 
						WHEN (penetapan_majelis_hakim IS NULL OR LEFT(penetapan_majelis_hakim,7)>'".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS blm_majelis,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS putus,
				SUM(
					CASE 
						WHEN (tanggal_minutasi IS NOT NULL AND LEFT(tanggal_minutasi,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS minut,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>'".$period."') THEN 1
						WHEN (LEFT(mediasi_berhasil,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
						ELSE 0
						END
					) AS blm_minut,
				SUM(
					CASE 
						WHEN (tanggal_cabut IS NOT NULL AND LEFT(tanggal_cabut,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS cabut,
				SUM(
					CASE 
						WHEN (tanggal_gugur IS NOT NULL AND LEFT(tanggal_gugur,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS gugur,
				SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='Y' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
						ELSE 0
						END
					) AS mediasi_berhasil,
					SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='N' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
						ELSE 0
						END
					) AS mediasi_gagal
				FROM v_perkara
				WHERE alur_perkara_id IN (".$idalurperkara.")
				AND LEFT(tanggal_pendaftaran,7) <='".$period."'
				GROUP BY jenis_perkara_id;");
		} catch (Exception $e) {
			
		}
	}
	function get_lap_perkara($period,$idalurperkara){
		try {
			return $this->db->query("SELECT 
									jp.id,
									jp.nama, 
									vsum.* FROM jenis_perkara AS jp
									        LEFT JOIN (
									        SELECT p.jenis_perkara_id
									        ,SUM(LEFT(tanggal_pendaftaran,7)<'".$period."' AND (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>='".$period."'))  AS sisa
										,SUM(LEFT(tanggal_pendaftaran,7)='".$period."')  AS masuk
										,SUM(LEFT(tanggal_putusan,7)='".$period."')  AS putus
										,SUM(LEFT(tanggal_putusan,7)='".$period."' AND status_putusan_id=59)  AS dikembalikan
										,(SUM(LEFT(tanggal_pendaftaran,7)<'".$period."' AND (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>='".$period."'))+SUM(LEFT(tanggal_pendaftaran,7)='".$period."')-
										  SUM(LEFT(tanggal_putusan,7)='".$period."')-SUM(LEFT(tanggal_putusan,7)='".$period."' AND status_putusan_id=59) )  AS sisa_akhir
										,SUM(pt_denda.durasi_nominal) AS denda
										,SUM(pt_biaya.durasi_nominal) AS biaya
										FROM 
										v_perkara AS p 
										LEFT JOIN (
												SELECT 
													perkara_id		AS perkara_id				
													,SUM(durasi_nominal) 	AS durasi_nominal
													FROM perkara_putusan_terdakwa 
												WHERE status_putusan_id=46 OR status_putusan_id=57
												GROUP BY perkara_id		
										) AS pt_denda ON p.perkara_id=pt_denda.perkara_id
										LEFT JOIN (
												SELECT 
													perkara_id		AS perkara_id				
													,SUM(durasi_nominal) 	AS durasi_nominal
													FROM perkara_putusan_terdakwa 
												WHERE status_putusan_id=60
												GROUP BY perkara_id			
										) AS pt_biaya ON p.perkara_id=pt_biaya.perkara_id	
										WHERE p.alur_perkara_id = ".$idalurperkara." GROUP BY p.jenis_perkara_id) AS vsum
										ON jp.id =  vsum.jenis_perkara_id

								WHERE jp.aktif='Y'
								AND jp.id IN (SELECT ja.jenis_perkara_id FROM jenis_alur_perkara AS ja WHERE ja.alur_perkara_id=".$idalurperkara.")
								ORDER BY jp.lft;
				");
		} catch (Exception $e) {
			
		}
	}
}