<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Report_pidmil_keuangan extends CI_Model{
	
	function get_info_pn(){
		try {
			$this->db->select('*');
			$this->db->where('id >=', 61); 
			return $this->db->get('sys_config');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	function getJenisPerkara($idalurperkara){
		if(empty($idalurperkara)) return '';
		try {
			$this->db->where('id',$idalurperkara);
			return $this->db->get('alur_perkara')->row()->nama;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_tahun($idalurperkara){
		try {
			return $this->db->query('SELECT YEAR(min(tanggal_pendaftaran)) AS years FROM perkara WHERE alur_perkara_id IN ('.$idalurperkara.');');
		} catch (Exception $e) {
			
		}
	}


	function get_rekap1($idalurperkara,$tahun){
		try {
			return $this->db->query("SELECT 
										SUM(IF(perkara_id IS NOT NULL,1,0)) 	AS jml_perkara_putus,
										SUM(biaya) 				AS biaya,
										SUM(denda)				AS denda
									FROM (
									SELECT 
										pp.perkara_id 		AS perkara_id
										,p.alur_perkara_id	AS alur_perkara_id
										,tanggal_putusan 	AS tanggal_putusan
										,n.biaya 		AS biaya
										,n.denda 		AS denda
									FROM perkara_putusan AS pp
									LEFT JOIN perkara AS p ON pp.perkara_id=p.perkara_id
									LEFT JOIN (SELECT 
											ppt.perkara_id		AS perkara_id	
											,p.alur_perkara_id 	AS alur_perkara_id			
											,SUM(IF(ppt.status_putusan_id=60,ppt.durasi_nominal,0)) 	AS biaya
											,SUM(IF((ppt.status_putusan_id=46 OR ppt.status_putusan_id=57),ppt.durasi_nominal,0)) 	AS denda
												
										FROM perkara_putusan_terdakwa AS ppt
										LEFT JOIN perkara AS p ON p.perkara_id=ppt.perkara_id
										WHERE p.alur_perkara_id=120 GROUP BY perkara_id
										) AS n ON n.perkara_id=pp.perkara_id
									WHERE p.alur_perkara_id=".$idalurperkara." AND LEFT(tanggal_putusan,4)='".$tahun."'
									) AS t_keuangan");
		} catch (Exception $e) {
			
		}
	}


	function get_rekap($idalurperkara,$periode_awal,$periode_akhir){
		try {
			return $this->db->query("SELECT 
										SUM(IF(perkara_id IS NOT NULL,1,0)) 	AS jml_perkara_putus,
										SUM(biaya) 				AS biaya,
										SUM(denda)				AS denda
									FROM (
									SELECT 
										pp.perkara_id 		AS perkara_id
										,p.alur_perkara_id	AS alur_perkara_id
										,tanggal_putusan 	AS tanggal_putusan
										,n.biaya 		AS biaya
										,n.denda 		AS denda
									FROM perkara_putusan AS pp
									LEFT JOIN perkara AS p ON pp.perkara_id=p.perkara_id
									LEFT JOIN (SELECT 
											ppt.perkara_id		AS perkara_id	
											,p.alur_perkara_id 	AS alur_perkara_id			
											,SUM(IF(ppt.status_putusan_id=60,ppt.durasi_nominal,0)) 	AS biaya
											,SUM(IF((ppt.status_putusan_id=46 OR ppt.status_putusan_id=57),ppt.durasi_nominal,0)) 	AS denda
												
										FROM perkara_putusan_terdakwa AS ppt
										LEFT JOIN perkara AS p ON p.perkara_id=ppt.perkara_id
										WHERE p.alur_perkara_id=120 GROUP BY perkara_id
										) AS n ON n.perkara_id=pp.perkara_id
									WHERE p.alur_perkara_id=".$idalurperkara." AND (LEFT(tanggal_putusan,7)>='".$periode_awal."' and LEFT(tanggal_putusan,7)<='".$periode_akhir."')
									) AS t_keuangan");
		} catch (Exception $e) {
			
		}
	}


	function get_stat_perkara($period,$idalurperkara){
		try {
			return $this->db->query("
				SELECT alur_perkara_id,alur_perkara_nama,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>='".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' THEN 1
						ELSE 0
						END
					) AS sisa,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
						ELSE 0
						END
					) AS putus_blm_minut,
				SUM(
					CASE 
						WHEN (keputusan_mediasi IS NOT NULL AND LEFT(keputusan_mediasi,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') AND hasil_mediasi='Y' THEN 1
						ELSE 0
						END
					) AS med_blm_minut,
				SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) = '".$period."' THEN 1
						ELSE 0
						END
					) AS masuk,
				SUM(
					CASE 
						WHEN (penetapan_majelis_hakim IS NULL OR LEFT(penetapan_majelis_hakim,7)>'".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS blm_majelis,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS putus,
				SUM(
					CASE 
						WHEN (tanggal_minutasi IS NOT NULL AND LEFT(tanggal_minutasi,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS minut,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>'".$period."') THEN 1
						WHEN (LEFT(mediasi_berhasil,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
						ELSE 0
						END
					) AS blm_minut,
				SUM(
					CASE 
						WHEN (tanggal_cabut IS NOT NULL AND LEFT(tanggal_cabut,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS cabut,
				SUM(
					CASE 
						WHEN (tanggal_gugur IS NOT NULL AND LEFT(tanggal_gugur,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS gugur,
				SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='Y' AND status_mediator='H' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
						ELSE 0
						END
					) AS mediator_hakim_berhasil,
					SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='N' AND status_mediator='H' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
						ELSE 0
						END
					) AS mediator_hakim_gagal
				FROM v_perkara
				WHERE alur_perkara_id IN (".$idalurperkara.")
				AND LEFT(tanggal_pendaftaran,7) <='".$period."';
				");
		} catch (Exception $e) {
			
		}
	}

	function get_stat_perkara_bln($period,$idalurperkara){
		try {
			return $this->db->query("
				SELECT jenis_perkara_id,jenis_perkara_nama,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>='".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' THEN 1
						ELSE 0
						END
					) AS sisa,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
						ELSE 0
						END
					) AS putus_blm_minut,
				SUM(
					CASE 
						WHEN (keputusan_mediasi IS NOT NULL AND LEFT(keputusan_mediasi,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') AND hasil_mediasi='Y' THEN 1
						ELSE 0
						END
					) AS med_blm_minut,
				SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) = '".$period."' THEN 1
						ELSE 0
						END
					) AS masuk,
				SUM(
					CASE 
						WHEN (penetapan_majelis_hakim IS NULL OR LEFT(penetapan_majelis_hakim,7)>'".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS blm_majelis,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS putus,
				SUM(
					CASE 
						WHEN (tanggal_minutasi IS NOT NULL AND LEFT(tanggal_minutasi,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS minut,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>'".$period."') THEN 1
						WHEN (LEFT(mediasi_berhasil,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
						ELSE 0
						END
					) AS blm_minut,
				SUM(
					CASE 
						WHEN (tanggal_cabut IS NOT NULL AND LEFT(tanggal_cabut,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS cabut,
				SUM(
					CASE 
						WHEN (tanggal_gugur IS NOT NULL AND LEFT(tanggal_gugur,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS gugur,
				SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='Y' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
						ELSE 0
						END
					) AS mediasi_berhasil,
					SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='N' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
						ELSE 0
						END
					) AS mediasi_gagal
				FROM v_perkara
				WHERE alur_perkara_id IN (".$idalurperkara.")
				AND LEFT(tanggal_pendaftaran,7) <='".$period."'
				GROUP BY jenis_perkara_id;");
		} catch (Exception $e) {
			
		}
	}
	function get_lap_perkara($period,$idalurperkara){
		try {
			return $this->db->query("SELECT 
										SUM(IF(perkara_id IS NOT NULL,1,0)) 	AS jml_perkara_putus,
										SUM(biaya) 				AS biaya,
										SUM(denda)				AS denda
									FROM (
									SELECT 
										pp.perkara_id 		AS perkara_id
										,p.alur_perkara_id	AS alur_perkara_id
										,tanggal_putusan 	AS tanggal_putusan
										,n.biaya 		AS biaya
										,n.denda 		AS denda
									FROM perkara_putusan AS pp
									LEFT JOIN perkara AS p ON pp.perkara_id=p.perkara_id
									LEFT JOIN (SELECT 
											ppt.perkara_id		AS perkara_id	
											,p.alur_perkara_id 	AS alur_perkara_id			
											,SUM(IF(ppt.status_putusan_id=60,ppt.durasi_nominal,0)) 	AS biaya
											,SUM(IF((ppt.status_putusan_id=46 OR ppt.status_putusan_id=57),ppt.durasi_nominal,0)) 	AS denda
												
										FROM perkara_putusan_terdakwa AS ppt
										LEFT JOIN perkara AS p ON p.perkara_id=ppt.perkara_id
										WHERE p.alur_perkara_id=120 GROUP BY perkara_id
										) AS n ON n.perkara_id=pp.perkara_id
									WHERE p.alur_perkara_id=".$idalurperkara." AND LEFT(tanggal_putusan,7)='".$period."'
									) AS t_keuangan	;
				");
		} catch (Exception $e) {
			
		}
	}
}