<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Report_mediasi_klasifikasi extends CI_Model{
	
	function get_info_pn(){
		try {
			$this->db->select('*');
			$this->db->where('id >=', 61); 
			return $this->db->get('sys_config');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	function getJenisPerkara($idalurperkara){
		if(empty($idalurperkara)) return '';
		try {
			$this->db->where('id',$idalurperkara);
			return $this->db->get('alur_perkara')->row()->nama;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_tahun($idalurperkara){
		try {
			return $this->db->query('SELECT YEAR(min(tanggal_pendaftaran)) AS years FROM perkara WHERE alur_perkara_id IN ('.$idalurperkara.');');
		} catch (Exception $e) {
			
		}
	}

	function get_rekap($idalurperkara,$tahun){
		try {
			return $this->db->query('SELECT tanggal_pendaftaran, 
				left(tanggal_pendaftaran,7) AS tgl,
				tahun_pendaftaran,
				bulan_pendaftaran, 
				LEFT(tanggal_putusan,7) AS putusan, 
				LEFT(penetapan_majelis_hakim,7) AS majelis,
				hasil_mediasi,LEFT(tanggal_cabut,7) AS cabut,
				LEFT(keputusan_mediasi,7) AS mediasi, 
				LEFT(tanggal_gugur,7) AS gugur,LEFT(tanggal_minutasi,7) AS minutasi
				FROM v_perkara 
				WHERE alur_perkara_id IN ('.$idalurperkara.') AND tahun_pendaftaran<='.$tahun.';');
		} catch (Exception $e) {
			
		}
	}

	function get_stat_perkara($period,$idalurperkara){
		try {
			return $this->db->query("
				SELECT alur_perkara_id,alur_perkara_nama,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>='".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' THEN 1
						ELSE 0
						END
					) AS sisa,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
						ELSE 0
						END
					) AS putus_blm_minut,
				SUM(
					CASE 
						WHEN (keputusan_mediasi IS NOT NULL AND LEFT(keputusan_mediasi,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') AND hasil_mediasi='Y' THEN 1
						ELSE 0
						END
					) AS med_blm_minut,
				SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) = '".$period."' THEN 1
						ELSE 0
						END
					) AS masuk,
				SUM(
					CASE 
						WHEN (penetapan_majelis_hakim IS NULL OR LEFT(penetapan_majelis_hakim,7)>'".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS blm_majelis,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS putus,
				SUM(
					CASE 
						WHEN (tanggal_minutasi IS NOT NULL AND LEFT(tanggal_minutasi,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS minut,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>'".$period."') THEN 1
						WHEN (LEFT(mediasi_berhasil,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
						ELSE 0
						END
					) AS blm_minut,
				SUM(
					CASE 
						WHEN (tanggal_cabut IS NOT NULL AND LEFT(tanggal_cabut,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS cabut,
				SUM(
					CASE 
						WHEN (tanggal_gugur IS NOT NULL AND LEFT(tanggal_gugur,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS gugur,
				SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='Y' AND status_mediator='H' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
						ELSE 0
						END
					) AS mediator_hakim_berhasil,
					SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='N' AND status_mediator='H' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
						ELSE 0
						END
					) AS mediator_hakim_gagal
				FROM v_perkara
				WHERE alur_perkara_id IN (".$idalurperkara.")
				AND LEFT(tanggal_pendaftaran,7) <='".$period."';
				");
		} catch (Exception $e) {
			
		}
	}

	function get_stat_perkara_bln($period,$idalurperkara){
		try {
			return $this->db->query("
				SELECT jenis_perkara_id,jenis_perkara_nama,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>='".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' THEN 1
						ELSE 0
						END
					) AS sisa,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
						ELSE 0
						END
					) AS putus_blm_minut,
				SUM(
					CASE 
						WHEN (keputusan_mediasi IS NOT NULL AND LEFT(keputusan_mediasi,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') AND hasil_mediasi='Y' THEN 1
						ELSE 0
						END
					) AS med_blm_minut,
				SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) = '".$period."' THEN 1
						ELSE 0
						END
					) AS masuk,
				SUM(
					CASE 
						WHEN (penetapan_majelis_hakim IS NULL OR LEFT(penetapan_majelis_hakim,7)>'".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS blm_majelis,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS putus,
				SUM(
					CASE 
						WHEN (tanggal_minutasi IS NOT NULL AND LEFT(tanggal_minutasi,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS minut,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>'".$period."') THEN 1
						WHEN (LEFT(mediasi_berhasil,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
						ELSE 0
						END
					) AS blm_minut,
				SUM(
					CASE 
						WHEN (tanggal_cabut IS NOT NULL AND LEFT(tanggal_cabut,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS cabut,
				SUM(
					CASE 
						WHEN (tanggal_gugur IS NOT NULL AND LEFT(tanggal_gugur,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS gugur,
				SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='Y' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
						ELSE 0
						END
					) AS mediasi_berhasil,
					SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='N' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
						ELSE 0
						END
					) AS mediasi_gagal
				FROM v_perkara
				WHERE alur_perkara_id IN (".$idalurperkara.")
				AND LEFT(tanggal_pendaftaran,7) <='".$period."'
				GROUP BY jenis_perkara_id;");
		} catch (Exception $e) {
			
		}
	}
	function get_lap_perkara($period,$idalurperkara){
		try {
			$sql="SELECT 
						jp.nama,
						v.sisa_mediasi,
						v.perkara_mediasi,
						@total_mediasi:=(v.sisa_mediasi + v.perkara_mediasi) AS total_mediasi,
						v.berhasil_akta,
						IF(IFNULL(@total_mediasi,0)=0 OR IFNULL(v.berhasil_akta,0)=0,0,CONCAT(round(v.berhasil_akta/@total_mediasi*100),'%')) AS persen_akta,
						v.berhasil_sebagian,
						IF(IFNULL(@total_mediasi,0)=0 OR IFNULL(v.berhasil_sebagian,0)=0,0,CONCAT(round(v.berhasil_sebagian/@total_mediasi*100),'%')) AS persen_sebagian,
						v.berhasil_cabut,
						IF(IFNULL(@total_mediasi,0)=0 OR IFNULL(v.berhasil_cabut,0)=0,0,CONCAT(round(v.berhasil_cabut/@total_mediasi*100),'%')) AS persen_cabut,
						@total_berhasil:=(v.berhasil_akta+v.berhasil_sebagian + v.berhasil_cabut) as total_berhasil,
						IF(IFNULL(@total_mediasi,0)=0 OR IFNULL(@total_berhasil,0)=0,0,CONCAT(round(@total_berhasil/@total_mediasi*100),'%')) AS persen_total_berhasil,
						v.tidak_berhasil,
						IF(IFNULL(@total_mediasi,0)=0 OR IFNULL(v.tidak_berhasil,0)=0,0,CONCAT(round(v.tidak_berhasil/@total_mediasi*100),'%')) AS persen_tidak_berhasil,
						v.tidak_dpt_dilaksanakan,
						IF(IFNULL(@total_mediasi,0)=0 OR IFNULL(v.tidak_dpt_dilaksanakan,0)=0,0,CONCAT(round(v.tidak_dpt_dilaksanakan/@total_mediasi*100),'%')) AS persen_tidak_dpt_dilaksanakan,
						v.mediasi_berjalan,
						IF(IFNULL(@total_mediasi,0)=0 OR IFNULL(v.mediasi_berjalan,0)=0,0,CONCAT(ROUND(v.mediasi_berjalan/@total_mediasi*100),'%')) AS persen_mediasi_berjalan
						FROM jenis_perkara AS jp
						LEFT JOIN (SELECT p.jenis_perkara_id
							,SUM(IF(LEFT(dimulai_mediasi,7)<'".$period."' AND (keputusan_mediasi IS NULL OR LEFT(keputusan_mediasi,7)>='".$period."'),1,0))  AS sisa_mediasi
							,SUM(IF(LEFT(dimulai_mediasi,7)='".$period."',1,0))  AS perkara_mediasi
							,SUM(IF(LEFT(dimulai_mediasi,7)<='".$period."' AND (keputusan_mediasi IS NULL OR LEFT(keputusan_mediasi,7)>'".$period."'),1,0))  AS mediasi_berjalan
							,SUM(IF(LEFT(keputusan_mediasi,7)='".$period."' AND (hasil_mediasi='Y' OR hasil_mediasi = 'Y1') AND (tanggal_putusan IS NULL OR (tanggal_putusan IS NOT NULL AND status_putusan_id NOT IN (7,37,67))),1,0)) AS berhasil_akta
							,SUM(IF(LEFT(keputusan_mediasi,7)='".$period."' AND hasil_mediasi='S',1,0)) AS berhasil_sebagian
							,SUM(IF(LEFT(keputusan_mediasi,7)='".$period."' AND (hasil_mediasi='Y' OR hasil_mediasi = 'Y2') AND (tanggal_putusan IS NULL OR (tanggal_putusan IS NOT NULL AND status_putusan_id IN (7,37,67))),1,0)) AS berhasil_cabut
							,SUM(IF(LEFT(keputusan_mediasi,7)='".$period."' AND hasil_mediasi='T',1,0)) AS tidak_berhasil
							,SUM(IF(LEFT(keputusan_mediasi,7)='".$period."' AND hasil_mediasi='D',1,0)) AS tidak_dpt_dilaksanakan
							FROM 
							(select * from v_mediasi group by mediasi_id) AS p WHERE p.alur_perkara_id = '".$idalurperkara."' GROUP BY p.jenis_perkara_id) AS v
							ON jp.id =  v.jenis_perkara_id
					WHERE jp.aktif='Y'
					AND jp.id IN (SELECT ja.jenis_perkara_id FROM jenis_alur_perkara AS ja WHERE ja.alur_perkara_id='".$idalurperkara."')
					ORDER BY jp.id;";
			return $this->db->query($sql);
		} catch (Exception $e) {
			
		}
	}
}