<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Report_grasi extends CI_Model{
	function get_info_pn(){
		try {
			$this->db->select('*');
			$this->db->where('id >=', 61); 
			return $this->db->get('sys_config');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	function getJenisPerkara($idalurperkara){
		if(empty($idalurperkara)) return '';
		try {
			$this->db->where('id',$idalurperkara);
			return $this->db->get('alur_perkara')->row()->nama;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_tahun($idalurperkara){
		try {
			return $this->db->query('SELECT YEAR(min(tanggal_pendaftaran)) AS years FROM perkara WHERE alur_perkara_id IN ('.$idalurperkara.');');
		} catch (Exception $e) {
			
		}
	}

	function get_stat_perkara($period,$idalurperkara){
		try {
			return $this->db->query("
				SELECT alur_perkara_id,
					SUM(
					CASE
						WHEN permohonan_grasi IS NOT NULL AND LEFT(permohonan_grasi,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS masuk,
					SUM(
					CASE
						WHEN tanggal_putusan_grasi IS NOT NULL AND LEFT(tanggal_putusan_grasi,7) >= '".$period."' AND status_putusan_grasi_id=1 THEN 1
						ELSE 0
						END
					) AS tolak,
					SUM(
					CASE
						WHEN tanggal_putusan_grasi IS NOT NULL AND LEFT(tanggal_putusan_grasi,7) >= '".$period."' AND status_putusan_grasi_id=2 THEN 1
						ELSE 0
						END
					) AS kabul
					FROM perkara_grasi
					WHERE alur_perkara_id IN (".$idalurperkara.")
					AND LEFT(permohonan_grasi,7) <= '".$period."';
				");
		} catch (Exception $e) {
			
		}
	}

	function get_lap_perkara($period,$idalurperkara){
		try {
			return $this->db->query("
				SELECT 
					id,perkara_id,nomor_perkara_pn,terdakwa_nama,pemohon_grasi,permohonan_grasi
					,pengiriman_berkas_grasi_ke_ma,pengiriman_pertimbangan_hakim_grasi,tanggal_putusan_grasi
					,tanggal_penerimaan_kembali_berkas_grasi,catatan_putusan_grasi
				FROM 
					  perkara_grasi
				WHERE alur_perkara_id IN (".$idalurperkara.") AND (LEFT(permohonan_grasi,7) <= '".$period."' 
					AND (tanggal_putusan_grasi is null OR LEFT(tanggal_putusan_grasi,7) >= '".$period."'))
				ORDER BY permohonan_grasi ASC;");
		} catch (Exception $e) {
			
		}
	}
}