<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class List_rehabilitasi extends CI_Model{
	function parseOrderby($col){
		if($col==1){
			return "p.nomor_perkara"; 
		}else if($col==2){
			return "p.para_pihak"; 
		}else if($col==3){
			return "penetapan_penyegelan"; 
		}else if($col==4){
			return "pelaksanaan_penyegelan"; 
		}else if($col==5){
			return "jenis_barang"; 
		}else if($col==6){
			return "disita_dari"; 
		}else if($col==7){
			return "pp.nomor_urut_register"; 
		}else{
			return "tanggal_permohonan";
		}
	}

	function getListRehabilitasi($col=9,$type='DESC',$begin=0,$idalurperkara,$key=''){
		try {
			$orderby = $this->parseOrderby($col);
			$where = '';
			if(!empty($key)){
				$where .= ' WHERE (p.para_pihak LIKE "%'.$key.'%" OR 
					tanggal_permohonan LIKE "%'.$key.'%" OR tanggal_surat_kabar LIKE "%'.$key.'%" OR
					tanggal_putusan_mohon LIKE "%'.$key.'%" OR nomor_putusan_mohon LIKE "%'.$key.'%"
					OR tanggal_berita_putusan LIKE "%'.$key.'%" OR tanggal_putusan LIKE "%'.$key.'%") ';
			}
			return $this->db->query("SELECT SQL_CALC_FOUND_ROWS pp.nomor_urut_register,
				pp.perkara_id,p.para_pihak,tanggal_permohonan,tanggal_surat_kabar,
				tanggal_putusan_mohon,nomor_putusan_mohon, tanggal_berita_putusan,tanggal_putusan
				FROM perkara_rehabilitasi AS pp
				LEFT JOIN perkara AS p
				ON p.perkara_id = pp.perkara_id
				".$where." ORDER BY ".$orderby." ".$type." LIMIT ".$begin.",30;");
		} catch (Exception $e) {
			log_message('error', $e);
			return '';
		}
	}

	function getNomorPerkara($idalurperkara){
		try {
			return $this->db->query('SELECT perkara_id,nomor_perkara FROM perkara WHERE alur_perkara_id IN ('.$idalurperkara.');');
		} catch (Exception $e) {
			return '';
		}
	}

	function getAlurPerkara($idperkara){
		try {
			$result = $this->db->query('SELECT alur_perkara_id FROM perkara WHERE perkara_id = '.$idperkara);
			if($result->num_rows>0){
				return $result->row()->alur_perkara_id;
			}else{
				return '';
			}
		} catch (Exception $e) {
			log_message('error', $e);
			return '';
		}
	}

	function getParaPihak($idperkara){
		try {
			$result = $this->db->query('SELECT para_pihak FROM perkara WHERE perkara_id = '.$idperkara);
			if($result->num_rows>0){
				return $result->row()->para_pihak;
			}else{
				return '';
			}
		} catch (Exception $e) {
			log_message('error', $e);
			return '';
		}
	}

	function isPerkaraExist($idperkara){
		try {
			$result = $this->db->query('SELECT perkara_id FROM perkara_rehabilitasi WHERE perkara_id = '.$idperkara);
			if($result->num_rows>0){
				return TRUE;
			}else{
				return FALSE;
			}
		} catch (Exception $e) {
			log_message('error', $e);
			return '-1';
		}
	}

	function getDetilPerkara($idperkara){
		try {
			return $this->db->query('SELECT pp.nomor_urut_register,
				pp.perkara_id,p.para_pihak,tanggal_permohonan,tanggal_surat_kabar,
				tanggal_putusan_mohon,nomor_putusan_mohon, tanggal_berita_putusan,tanggal_putusan,
				alasan_permohonan,surat_kabar,tanggal_perlawanan,tanggal_putusan,amar_putusan,
				amar_putusan_dok,keterangan
				FROM perkara_rehabilitasi AS pp
				LEFT JOIN perkara AS p
				ON p.perkara_id = pp.perkara_id
				WHERE pp.perkara_id ='.$idperkara);
		} catch (Exception $e) {
			return '';
		}
	}

	function fecth_data_num(){
		try {
			$query = $this->db->query("SELECT FOUND_ROWS() as cnt;");
			if($query->num_rows>0){
				foreach ($query->result() as $row) {
					return $row->cnt;
				}
	    		return $query->num_rows;
	    	}else{
	    		return 0;
	    	}
		} catch (Exception $e) {
			
		}
	}

	function getNoUrut(){
		try {
			return $this->db->query("SELECT IFNULL(max(nomor_urut_register)+1,1) as id FROM perkara_rehabilitasi;")->row()->id;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function getTglPutusan($idperkara){
		try {
			$result = $this->db->query("SELECT IFNULL('',tanggal_putusan) AS tanggal_putusan FROM perkara_putusan WHERE perkara_id=".$idperkara);
			if($result->num_rows>0){
				return $result->row()->tanggal_putusan;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}

	function add_audittrail($action,$title,$descrip,$tablename){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => 'Add Referensi Pihak',
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			
		}
	}

	function add_data($data){
		try {
			$id = $this->db->query("SELECT IFNULL(max(id)+1,1) as id FROM perkara_rehabilitasi;")->row()->id;
			if($id>0){
				$data['id'] = $id;
				$this->db->insert('perkara_rehabilitasi', $data);
				$title = "Tambah Register Perkara Rehabilitasi [perkara_id=<b>".$data['perkara_id']."</b>]<br />Tambah table <b>perkara_rehabilitasi</b> dari halaman <b>REGISTER REHABILITASI</b> dengan Primary Key [id=".$data['id']."]";
				$descrip = $this->fetch_description($title,$data);
				$this->add_audittrail("INSERT",$title,$descrip,'perkara_rehabilitasi');
				return TRUE;
			}else{
				return FALSE;
			}
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function update_data($data,$idperkara){
		try {
			if($idperkara>0){
				$this->db->where('perkara_id', $idperkara);
				$this->db->update('perkara_rehabilitasi', $data); 
				$title = "Ubah Data Register Perkara Rehabilitasi [perkara_id=<b>".$data['perkara_id']."</b>]<br />Update table <b>perkara_rehabilitasi</b> dari halaman <b>REGISTER REHABILITASI</b> dengan Primary Key [id=".$data['perkara_id']."]";
				$descrip = $this->fetch_description($title,$data);
				$this->add_audittrail("UPDATE",$title,$descrip,'perkara_rehabilitasi');
				return TRUE;
			}else{
				return FALSE;
			}
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function del_data($idperkara){
		try {
			$this->db->query("DELETE FROM perkara_rehabilitasi WHERE perkara_id =".$idperkara);
			$title = "Delete Data Register Perkara Rehabilitasi <br />dengan id [perkara_id=".$idperkara."] Oleh = ".$this->session->userdata('username');
			$this->add_audittrail("DELETE",$title,'DELETE DATA','perkara_rehabilitasi');
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

}