<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Data_pihak_HT extends CI_Model{
	function getUrutanPihak($pihakKe,$htid){
		if(is_numeric($pihakKe) AND $pihakKe>0 AND $pihakKe<5){
			$table = "perkara_eksekusi_detil_ht";
		}else{
			return -1;
		}

		if(!is_numeric($htid) AND $htid<0){
			return -2;
		}
		try {
			$query = $this->db->query("SELECT MAX(urutan) AS urutan FROM ".$table." WHERE ht_id =".$htid);
			if($query->num_rows>0){
				foreach ($query->result() as $row) {
					return $row->urutan+1;
				}
	    	}else{
	    		return 1;
	    	}
		} catch (Exception $e) {
			return -3;
		}
	}

	function getPihakInfo($idpihak){
		try {
			return $this->db->query('SELECT id,nama,alamat,jenis_pihak_id FROM pihak WHERE id = '.$idpihak);
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function getDetilInfoPihak($idPihak){
		try {
			return $this->db->query('SELECT p.id,jp.nama AS jenis_pihak,ji.nama AS jenis_indentitas,
					p.keterangan,nomor_indentitas,p.nama,tempat_lahir,tanggal_lahir,jenis_kelamin,
					golongan_darah,alamat,pekerjaan,st.nama AS status_kawin,n.nama AS warga_negara,t.nama AS pendidikan, a.nama AS agama
					FROM pihak AS p
					LEFT JOIN 
						negara AS n
					ON p.warga_negara_id = n.id
					LEFT JOIN 
						agama AS a
					ON p.agama_id = a.id
					LEFT JOIN
						tingkat_pendidikan AS t
					ON p.pendidikan_id = t.id
					LEFT JOIN 
						status_perkawinan AS st
					ON p.status_kawin = st.id
					LEFT JOIN 
						jenis_pihak AS jp
					ON p.jenis_pihak_id = jp.id
					LEFT JOIN 
						jenis_identitas AS ji
					ON p.jenis_indentitas = ji.id
					WHERE p.id='.$idPihak.';');
		} catch (Exception $e) {
			log_message('error', $e);
			return '';
		}
	}

	function add_data($data,$pihakKe){
		#jng lupa update table perkara
		try {
			$table = "perkara_eksekusi_detil_ht";

			# get pihak info
			$query = $this->getPihakInfo($data['pihak_id']);
			if($query->num_rows>0){
				foreach ($query->result() as $row) {
					$data['nama'] = $row->nama;
					$data['alamat'] = $row->alamat;
					$data['jenis_pihak_id'] = $row->jenis_pihak_id;
				}
			}else{
				return FALSE;
			}
			# get id from perkara_pihak1
			$id = $this->db->query("SELECT IFNULL(max(id)+1,1) as id FROM ".$table)->row()->id;
			if($id>0){
				$data['id'] = $id;
				$this->db->insert($table, $data);

				# insert audittrail
				$title = "Tambah Pihak berPerkara [nama=<b>".$data['nama']."</b>]<br />Tambah table <b>".$table."</b> dari halaman <b>TAMBAH DATA PIHAK</b> dengan Primary Key [id=".$data['id']."]";
				$descrip = $this->fetch_description($title,$data);
				$this->add_audittrail("INSERT",$title,$descrip,$table);
				return TRUE;
			}else{
				return FALSE;
			}
		} catch (Exception $e) {
			return FALSE;
		}
	}


	function updt_data_pihak($id,$data,$pihakKe){
		#jng lupa update table perkara
		try {
			$table = "perkara_pihak".$pihakKe;

			$isDuplicate = $this->db->query("SELECT count(id) AS cnt FROM ".$table." WHERE ht_id = ".$data['ht_id']." AND pihak_id = ".$data['pihak_id']." AND urutan <>".$data['urutan'])->row()->cnt;
			if(intval($isDuplicate)!=0){
				return 5;
			}
			# get pihak info
			$query = $this->getPihakInfo($data['pihak_id']);
			if($query->num_rows>0){
				foreach ($query->result() as $row) {
					$data['nama'] = $row->nama;
					$data['alamat'] = $row->alamat;
					$data['jenis_pihak_id'] = $row->jenis_pihak_id;
				}
			}else{
				return FALSE;
			}
			# get id from perkara_pihak1
			$this->db->where('id', $id);
			$this->db->update($table, $data);

			# insert audittrail
			$title = "UPDATE Pihak berPerkara [nama=<b>".$data['nama']."</b>]<br />UPDATE table <b>".$table."</b> dari halaman <b>UPDATE DATA PIHAK</b> dengan Primary Key [id=".$id."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("UPDATE",$title,$descrip,$table);
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function update_data($data,$htid,$pihakKe){
		try {
			$functName = "GetListPihak".$pihakKe."Text(".$htid.")";
			$colname = "pihak".$pihakKe."_text";
			$listPihak = $this->db->query("SELECT ".$functName." AS pihak")->row()->pihak;
			$data[$colname] = $listPihak;
			$this->db->where('ht_id', $htid);
			$this->db->update('perkara', $data);
			$result = $this->update_data_parapihak($data,$htid);
			if($result){
				return TRUE; 
			}else{
				return FALSE;
			}
		} catch (Exception $e) {
			
		}
	}

	function del_data($id,$pihakKe){
		try {
			$table = "perkara_pihak".$pihakKe;
			$this->db->query("DELETE FROM ".$table." WHERE id =".$id);
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function update_data_parapihak($data,$htid){
		try {
			$parapihak = $this->db->query("SELECT GetListParaPihakText(".$htid.") AS parapihak")->row()->parapihak;
			$data['para_pihak'] = $parapihak;
			$this->db->where('ht_id', $htid);
			$this->db->update('perkara', $data);
			return TRUE; 
		} catch (Exception $e) {
			
		}
	}

	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}

	function add_audittrail($action,$title,$descrip,$tablename){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => 'Add Pihak',
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			
		}
	}
}