<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class New_lalulintas extends CI_Model{
	
	function getJenisPerkara($idalurperkara){
		if(empty($idalurperkara)) return '';
		try {
			$this->db->where('id',$idalurperkara);
			return $this->db->get('alur_perkara')->row()->nama;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	function get_list_hakim_pn(){
		try {
			$sql = "SELECT id,nama_gelar FROM hakim_pn WHERE aktif='Y' ORDER BY nama ASC;";
			return $this->db->query($sql);
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}



	function getNomorUrutPerkara($idalurperkara,$year){
		if(empty($idalurperkara)) return '';
		if(empty($year)) return '';
		try {
			$query = $this->db->query("SELECT ifnull(max(nomor_urut_perkara),0) + 1 AS nomor FROM perkara WHERE alur_perkara_id='".$idalurperkara."' AND year(tanggal_pendaftaran)='".$year."';");
			if($query->num_rows>0){
				foreach ($query->result() as $row) {
					return $row->nomor;
				}
	    	}else{
	    		return 0;
	    	}
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getNomorUrutRegister($idalurperkara,$date){
		if(empty($idalurperkara)) return '';
		if(empty($date)) return '';
		try {
			$query = $this->db->query("SELECT (ifnull(max(nomor_urut_register),0)) +1 AS nomor 
				FROM perkara WHERE alur_perkara_id='".$idalurperkara."' AND LEFT(tanggal_pendaftaran,7) = '".$date."';");
			if($query->num_rows>0){
				foreach ($query->result() as $row) {
					return $row->nomor;
				}
	    	}else{
	    		return 0;
	    	}
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getKlasifikasiPerkara($idalurperkara){
		if(empty($idalurperkara)) return '';
		if($idalurperkara<0) return '';
		try {
			$query = $this->db->query("SELECT alur_perkara_id, jenis_perkara_id AS id,nama_lengkap AS nama
				FROM jenis_alur_perkara AS j, jenis_perkara AS p
				WHERE j.jenis_perkara_id = p.id AND j.alur_perkara_id = ".$idalurperkara."
				ORDER BY nama_lengkap ASC");
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

		
	function getFormatPerkara($idjenisperkara){
		if(empty($idjenisperkara)) return '';
		try {
			$this->db->where('id',$idjenisperkara);
			return $this->db->get('jenis_perkara')->row()->format_nomor;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getKodePerkara($idalurperkara){
		if(empty($idalurperkara)) return '';
		try {
			$this->db->where('id',$idalurperkara);
			$this->db->select('kode');
			return $this->db->get('alur_perkara')->row()->kode;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getKodePN(){
		try {
			$this->db->where('id',61);
			$this->db->select('value');
			return $this->db->get('sys_config')->row()->value;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function isNomorPerkaraExist($nomorPerkara){
		try {
			$this->db->where('nomor_perkara',$nomorPerkara);
			$this->db->select('nomor_perkara');
			$query = $this->db->get('perkara');
			if($query->num_rows>0){
				return TRUE;
			}else{
				return FALSE;
			}
		} catch (Exception $e) {
			log_message('error', $e);
			return -1;
		}
	}

	function isNomorUrutRegisterExists($tglPendaftaran,$idalurperkara,$noUrutReg){
		$tmp = explode("/", $tglPendaftaran);
		if(count($tmp)==3){
			$date = $tmp[2]."-".$tmp[1];
		}else{
			return -2;
		}
		try {
			$query = $this->db->query("SELECT nomor_urut_register 
				FROM perkara 
				WHERE LEFT(tanggal_pendaftaran,7)='".$date."' 
				AND alur_perkara_id='".$idalurperkara."' AND nomor_urut_register='".$noUrutReg."';");
			if($query->num_rows>0){
				return TRUE;
			}else{
				return FALSE;
			}
		} catch (Exception $e) {
			log_message('error', $e);
			return -2;
		}
	}

	function getJenisPerkaraNama($id){
		if(empty($id)) return '';
		try {
			$this->db->where('id',$id);
			$this->db->select('kode,nama,nama_lengkap');
			return $this->db->get('jenis_perkara');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	

	

	function add_audittrail($action,$title,$descrip,$tablename){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => 'Add Perkara Perdata',
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			
		}
	}

	
}