<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Kasasi extends CI_Model{
	
	function getJenisPerkara($idalurperkara){
		if(empty($idalurperkara)) return '';
		try {
			$this->db->where('id',$idalurperkara);
			return $this->db->get('alur_perkara')->row()->nama;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	
	function isNomorPerkara($txt){
		$re1='(\\d+)';	# Integer Number 1
		$re2='(\\/)';	# Any Single Character1 
		$re3='.*?';	# Non-greedy match on filler
		$re4='(\\/)';	# Any Single Character 2
		$re5='((?:(?:[1]{1}\\d{1}\\d{1}\\d{1})|(?:[2]{1}\\d{3})))(?![\\d])';	# Year 1
		$re6='(\\/)';	# Any Single Character 3
		$re7='(PN)';	# Variable Name 1
		if ($c=preg_match_all ("/".$re1.$re2.$re3.$re4.$re5.$re6.$re7."/is", $txt, $matches)){
		      $int1=$matches[1][0];
		      $c1=$matches[2][0];
		      $c2=$matches[3][0];
		      $year1=$matches[4][0];
		      $c3=$matches[5][0];
		      $var1=$matches[6][0];
		      return 1;
		}else{
			return 0;
		}
	}

	function parseOrderby($col){
		if($col==1){
			return "nomor_perkara_pn"; 
		}else if($col==2){
			return "permohonan_kasasi"; 
		}else if($col==3){
			return "pengiriman_berkas_kasasi"; 
		}else if($col==4){
			return "putusan_kasasi"; 
		}else if($col==5){
			return "nomor_perkara_kasasi"; 
		}else if($col==6){
			return "penerimaan_berkas_kasasi"; 
		}else if($col==7){
			return "pemberitahuan_putusan_kasasi"; 
		}else if($col==8){
			return "nomor_perkara_pn"; 
		}else{
			return "permohonan_kasasi";
		}
	}

	function getPerkaraList($idalurperkara='',$col=2,$type='DESC',$begin=0,$key=''){
		$orderby = $this->parseOrderby($col);
		$where = '';

		if($idalurperkara>0){
			$where = "AND alur_perkara_id IN (".$idalurperkara.")";
		}else{
			$where = "";
		}

		if(!empty($key)){
			if($this->isNomorPerkara($key)){
				$where_like = ' WHERE nomor_perkara_pn ="'.$key.'" OR nomor_perkara_kasasi="'.$key.'" ';

			}else{
				$where_like = ' WHERE (nomor_perkara_pn LIKE "%'.$key.'%" 
					OR permohonan_kasasi LIKE "%'.$key.'%"
					OR pemohon_kasasi LIKE "%'.$key.'%" 
					OR nomor_perkara_kasasi LIKE "%'.$key.'%" 
					OR status_kasasi_text LIKE "%'.$key.'%") ';
			}
		}else{
			$where_like =" ";
			if($idalurperkara>0){
				$where = " WHERE alur_perkara_id IN (".$idalurperkara.")";
			}
		}
		try {
			$query = $this->db->query("SELECT SQL_CALC_FOUND_ROWS perkara_id, perkara_id,
				alur_perkara_id,pemohon_kasasi,nomor_perkara_pn,nomor_perkara_kasasi, permohonan_kasasi
				,penerimaan_memori_kasasi,pengiriman_berkas_kasasi, putusan_kasasi, 
				pemberitahuan_putusan_kasasi, penerimaan_berkas_kasasi, status_kasasi_text 
				FROM v_perkara_kasasi ".$where_like." ".$where." ORDER BY ".$orderby." ".$type." LIMIT ".$begin.",50");
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	function fecth_data_num($idalurperkara,$key){
		$query = $this->db->query("SELECT FOUND_ROWS() as cnt;");
		if($query->num_rows>0){
			foreach ($query->result() as $row) {
				return $row->cnt;
			}
    		return $query->num_rows;
    	}else{
    		return 0;
    	}
	}

	function getPerkaraKasasiCetak($idalurperkara='',$key=''){
		$where = '';
		
		if($idalurperkara>0){
			$where = "AND alur_perkara_id IN (".$idalurperkara.")";
		}else{
			$where = "";
		}

		if(!empty($key)){
			if($this->isNomorPerkara($key)){
				$where_like = ' WHERE nomor_perkara_pn ="'.$key.'" OR nomor_perkara_banding="'.$key.'" ';

			}else{
				$where_like = ' WHERE (nomor_perkara_pn LIKE "%'.$key.'%" 
					OR permohonan_kasasi LIKE "%'.$key.'%"
					OR pemohon_kasasi LIKE "%'.$key.'%" 
					OR nomor_perkara_kasasi LIKE "%'.$key.'%" 
					OR status_kasasi_text LIKE "%'.$key.'%") ';
			}
		}else{
			$where_like =" ";
			if($idalurperkara>0){
				$where = " WHERE alur_perkara_id IN (".$idalurperkara.")";
			}
		}
		try {
			$query = $this->db->query("SELECT SQL_CALC_FOUND_ROWS perkara_id, perkara_id,
				alur_perkara_id,pemohon_kasasi,nomor_perkara_pn,nomor_perkara_kasasi, permohonan_kasasi
				,penerimaan_memori_kasasi,pengiriman_berkas_kasasi, putusan_kasasi, 
				pemberitahuan_putusan_kasasi, penerimaan_berkas_kasasi, status_kasasi_text 
				FROM v_perkara_kasasi ".$where_like." ".$where." ORDER BY permohonan_kasasi ASC");
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	

	function fetchkasasi($idperkara){
		try {
			return $this->db->query('SELECT * FROM perkara_kasasi WHERE perkara_id='.$idperkara);
		} catch (Exception $e) {
			return '';
		}
	}

	function fetchkasasiDetil($idperkara){
		try {
			$sql="SELECT b.*, p.pekerjaan,b.id as kasasi_id FROM 
										perkara_kasasi_detil AS b
										LEFT JOIN pihak AS p
											ON p.id = b.pemohon_id
										WHERE b.perkara_id = $idperkara ORDER BY status_pihak_text ASC";
			return $this->db->query($sql);
		} catch (Exception $e) {
			return '';
		}
	}

	function getAlurPerkara($idperkara){
		try {
			$result = $this->db->query('SELECT alur_perkara_id FROM perkara WHERE perkara_id ='.$idperkara);
			if($result->num_rows>0){
				return $result->row()->alur_perkara_id;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function getTanggalPutusanKasasi($idperkara){
		try {
			$result = $this->db->query('SELECT putusan_kasasi FROM perkara_kasasi WHERE perkara_id ='.$idperkara);
			if($result->num_rows>0){
				return $result->row()->putusan_kasasi;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return '';
		}
	}


	function getPihakkasasi($id){
		try {
			return $this->db->query('SELECT *, pbd.pemberitahuan_kasasi AS pemberitahuan,
					pbd.penerimaan_memori_kasasi AS pen_memori,
					pbd.penyerahan_memori_kasasi AS peny_memori,
					pbd.penerimaan_kontra_kasasi AS pen_kontra,
					pbd.penyerahan_kontra_kasasi AS peny_kontra,
					pbd.pemberitahuan_inzage_kasasi AS pen_inzage,
					pbd.pemberitahuan_putusan_kasasi As pen_putus
				FROM perkara_kasasi_detil AS pbd
				LEFT JOIN perkara_kasasi AS pb
					ON pb.perkara_id = pbd.perkara_id
					WHERE pbd.id = '.$id);
		} catch (Exception $e) {
			return '';
		}
	}

	function getDataMediasiKasasi($idperkara){
		try {
			return $this->db->query('SELECT * FROM perkara_mediasi WHERE tahapan_id = 30 AND perkara_id = '.$idperkara);
		} catch (Exception $e) {
			return '';
		}
	}

	function getDataMediator(){
		try {
			return $this->db->query('SELECT id, 
				CASE WHEN status_mediator="N" THEN "Mediator Umum" 
					WHEN status_mediator="H" THEN "Hakim" 
					WHEN status_mediator="P" THEN "Pegawai" END AS status_mediator, 
					nama_gelar FROM mediator WHERE aktif = "Y"');
		} catch (Exception $e) {
			return '';
		}
	}
	function infoMediator($idmediator){
		try {
			return $this->db->query('SELECT id, status_mediator, nama_gelar FROM mediator WHERE id='.$idmediator);
		} catch (Exception $e) {
			return '';
		}
	}		

	function get_maxid_mediasi(){
		try {
			$query = $this->db->query('SELECT MAX(mediasi_id) AS maxid  FROM perkara_mediasi');
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}	

	function getDataPihak($idpihak){
		try {
			return $this->db->query('SELECT id,nama,alamat,pekerjaan FROM pihak WHERE id = '.$idpihak);
		} catch (Exception $e) {
			return '';
		}
	}

	function getDatakasasi($idperkara){
		try {
			return $this->db->query('SELECT * FROM perkara_kasasi WHERE perkara_id = '.$idperkara);
		} catch (Exception $e) {
			return '';
		}
	}

	function getDataHakimMA(){
		try {
			return $this->db->query('SELECT id,nama_gelar FROM hakim_ma WHERE aktif = "Y"');
		} catch (Exception $e) {
			return '';
		}
	}

	function getDataPaniteraMA(){
		try {
			return $this->db->query('SELECT id,nama_gelar FROM panitera_ma WHERE aktif = "Y"');
		} catch (Exception $e) {
			return '';
		}
	}

	function getPihak($idperkara,$pihakke){
		try {
			return $this->db->query('SELECT p.pihak_id, p.nama,p.alamat, 
				permohonan_kasasi,status_pihak_id,pihak_asal,
				status_pihak_text,b.urutan_kasasi AS urutan
				FROM perkara_pihak'.$pihakke.' AS p
				LEFT JOIN perkara_kasasi_detil AS b
				ON p.pihak_id = b.pihak_id
				WHERE p.perkara_id = '.$idperkara.'
				ORDER BY permohonan_kasasi;');
		} catch (Exception $e) {
			return '';
		}
	}

	function getStatusPihak($idalurperkara){
		try {
			$this->db->where('tahapan_id',10);
			$this->db->where('aktif','Y');
			$this->db->where('alur_perkara_id',$idalurperkara);
			$this->db->select('pihak_ke,nama');
			return $this->db->get('status_pihak');
		} catch (Exception $e) {
			return '';
		}
	}

	function getTanggalPutusan($idperkara){
			try {
				$this->db->where('perkara_id',$idperkara);
				$this->db->select('tanggal_putusan,tanggal_cabut');
				return $this->db->get('perkara_putusan');
			} catch (Exception $e) {
				return '';
			}
	}

	function getTanggalPutusanBanding($idperkara){
		try {
			$result = $this->db->query('SELECT putusan_banding FROM perkara_banding WHERE perkara_id ='.$idperkara);
			if($result->num_rows>0){
				return $result->row()->putusan_banding;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return '';
		}
	}
	
	function getTglMemoriKasasi($idperkara){
		try {
			$result = $this->db->query('SELECT penerimaan_memori_kasasi FROM perkara_kasasi WHERE perkara_id ='.$idperkara);
			if($result->num_rows>0){
				return $result->row()->penerimaan_memori_kasasi;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function getTglKirimBerkas($idperkara){
		try {
			$result = $this->db->query('SELECT pengiriman_berkas_kasasi FROM perkara_kasasi WHERE perkara_id ='.$idperkara);
			if($result->num_rows>0){
				return $result->row()->pengiriman_berkas_kasasi;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function update_data($datapihak,$id){
		try {
			$this->db->where('id',$id);
			$this->db->update('perkara_kasasi_detil', $datapihak);
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function update_data_kasasi($datakasasi,$idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->update('perkara_kasasi', $datakasasi);
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function add_data_mediasi($datamediasi){
		try {
			$this->db->insert('perkara_mediasi', $datamediasi);
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}
	
	function get_urutan_jadwal_mediasi_terakhir($mediasi_id){
		$this->db->select_max('urutan');
		$this->db->where('mediasi_id',$mediasi_id);
		$result=$this->db->get('perkara_jadwal_mediasi');
		return $result;
	}

	function tunda_mediasi($datainsert,$dataupdate1,$dataupdate2,$idmediasi){
		try {
			$this->db->where('id',$idmediasi);
			$this->db->update('perkara_jadwal_mediasi',$dataupdate1);
			$title = "UPDATE Jadwal Mediasi <br /> UPDATE table <b>perkara_jadwal_mediasi</b> dari halaman <b>PENUNDAAN JADWAL MEDIASI</b> dengan Primary Key [id=".$idmediasi."]";
			$descrip = $this->fetch_description($title,$dataupdate1);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_jadwal_mediasi');
			$this->db->insert('perkara_jadwal_mediasi', $datainsert);			
			$title = "INSERT Jadwal Mediasi <br /> INSERT table <b>perkara_jadwal_mediasi</b> dari halaman <b>PENUNDAAN JADWAL MEDIASI</b> dengan Primary Key [id=".$datainsert['id']."]";
			$descrip = $this->fetch_description($title,$datainsert);
			$this->add_audittrail("INSERT",$title,$descrip,'perkara_jadwal_mediasi');
			$this->db->where('mediasi_id',$idmediasi);
			$this->db->update('perkara_mediasi',$dataupdate2);			
			$title = "UPDATE Tanggal Kesepakatan Mediasi <br /> UPDATE table <b>perkara_mediasi</b> dari halaman <b>PENUNDAAN JADWAL MEDIASI</b> dengan Primary Key [id=".$idmediasi."]";
			$descrip = $this->fetch_description($title,$dataupdate2);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_mediasi');			
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function get_detil_jadwal_mediasi($idjadwalmediasi){
		if(empty($idjadwalmediasi)) {
			return '';
		}
		try {
			$this->db->where('id',$idjadwalmediasi);
			$query=$this->db->get('perkara_jadwal_mediasi');
			return $query->result();
		}catch (Exception $e) {
			log_message('error', $e);
		}
	}
	
	function get_id_jadwal_mediasi_terakhir()
	{
		$this->db->select_max('id');
		$result=$this->db->get('perkara_jadwal_mediasi');
		return $result;
	}

	function add_data_jadwal_mediasi($jadwalmediasi){
		try {
			$this->db->insert('perkara_jadwal_mediasi', $jadwalmediasi);
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function update_proses($idperkara,$idproses,$prosestext){
		try {
			$this->db->query('CALL perkara_kasasi_proses('.$idperkara.','.$idproses.',"'.$prosestext.'");');
		} catch (Exception $e) {
			
		}
	}

	function update_data_mediasi($datamediasi,$id){
		try {
			$this->db->where('mediasi_id',$id);
			$this->db->update('perkara_mediasi', $datamediasi);
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function update_jadwal_mediasi($id_jadwal_mediasi,$data_diupdate,$id_mediasi){
		try {
			$this->db->where('id',$id_jadwal_mediasi);
			$this->db->update('perkara_jadwal_mediasi',$data_diupdate);
			$datamediasi=array('keputusan_mediasi'=>$data_diupdate['tanggal_mediasi']);
			$this->db->where('mediasi_id',$id_mediasi);
			$this->db->update('perkara_mediasi',$datamediasi);			
		}
		 catch (Exception $e) {
			return FALSE;
		}
	}

	function hapus_jadwal_mediasi($id_jadwal_mediasi){
		try {
			$tgljmediasisebelum="SELECT mediasi_id,tanggal_mediasi FROM perkara_jadwal_mediasi 
							WHERE mediasi_id=(SELECT mediasi_id FROM perkara_jadwal_mediasi WHERE id='$id_jadwal_mediasi') 
									AND urutan=(SELECT MAX(urutan)-1 FROM perkara_jadwal_mediasi WHERE mediasi_id=(SELECT mediasi_id FROM perkara_jadwal_mediasi WHERE id='$id_jadwal_mediasi'));";
			$tgljmediasisebelum=$this->db->query($tgljmediasisebelum)->row();
			$updatemediasi="UPDATE perkara_mediasi SET keputusan_mediasi='$tgljmediasisebelum->tanggal_mediasi' WHERE mediasi_id='$tgljmediasisebelum->mediasi_id'";
			$this->db->query($updatemediasi);
			$this->db->where('id',$id_jadwal_mediasi);
			$this->db->delete('perkara_jadwal_mediasi');
			$title = "DELETE Jadwal Mediasi <br /> DELETE table <b>perkara_jadwal_mediasi</b> dari halaman <b>EDIT JADWAL MEDIASI</b> dengan Primary Key [id=".$id_jadwal_mediasi."]";
			$descrip = '';
			$this->add_audittrail("DELETE",$title,$descrip,'perkara_jadwal_mediasi');		
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}		
	}

	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}

	function add_audittrail($action,$title,$descrip,$tablename){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => 'Add Perkara Perdata',
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			
		}
	}

	function deletePerkaraProses($idperkara,$idproses){
		try {
			$this->db->simple_query("CALL perkara_proses_delete(".$idperkara.", '".$idproses."');");
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function addPerkaraProses($idperkara,$idproses,$prosestext,$tanggal){
		try {
			$this->db->simple_query("CALL perkara_proses_update(".$idperkara.", 30, 'Kasasi', ".$idproses.", '".$prosestext."', '".$tanggal."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function updatePerkaraProses($idperkara){
		try {
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}	

	function dataJadwalMediasi($idperkara){
		try {
			return $this->db->query('SELECT mediasi_id  FROM perkara_jadwal_mediasi 
			WHERE mediasi_id=(SELECT mediasi_id FROM perkara_mediasi WHERE tahapan_id=30 AND perkara_id='.$idperkara.')');
		} catch (Exception $e) {
			return '';
		}
	}
	
	function deletePermohonan($idperkara){
		try {
			$this->db->where('perkara_id', $idperkara);
			$this->db->delete('perkara_kasasi');
			$this->db->where('perkara_id', $idperkara);
			$this->db->delete('perkara_kasasi_detil');

			$this->db->where('perkara_id', $idperkara);
			$this->db->where('tahapan_id', 30);
			$this->db->delete('perkara_biaya');

			$this->db->where('perkara_id', $idperkara);
			$this->db->where('tahapan_id', 30);
			$this->db->delete('perkara_mediasi');			

			$this->db->where('perkara_id', $idperkara);
			$this->db->where('tahapan_id', 30);
			$this->db->delete('perkara_proses');
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function getPermohonanKasasi($idperkara){
		try {
			$result = $this->db->query('SELECT permohonan_kasasi FROM perkara_kasasi WHERE perkara_id ='.$idperkara);
			if($result->num_rows>0){
				return $result->row()->permohonan_kasasi;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function hapus_tgl_kasasi($id,$idperkara,$kolom,$dataproses,$diperbaharui,$func){
		try {
			if($func==7){
				$this->db->query("UPDATE perkara_kasasi SET ".$kolom."=NULL, nomor_surat_pengiriman_berkas_kasasi='', diperbaharui_oleh='".$diperbaharui['diperbaharui_oleh']."', diperbaharui_tanggal='".$diperbaharui['diperbaharui_tanggal']."'  WHERE perkara_id=".$idperkara);
			}else{
				$this->db->query("UPDATE perkara_kasasi SET ".$kolom."=NULL, diperbaharui_oleh='".$diperbaharui['diperbaharui_oleh']."', diperbaharui_tanggal='".$diperbaharui['diperbaharui_tanggal']."'  WHERE perkara_id=".$idperkara);
			}					
			if($func!=7){
				$this->db->query("UPDATE perkara_kasasi_detil SET ".$kolom."=NULL, diperbaharui_oleh='".$diperbaharui['diperbaharui_oleh']."', diperbaharui_tanggal='".$diperbaharui['diperbaharui_tanggal']."'  WHERE id=".$id);	
			}
						
			$cekproses = $this->db->query("SELECT proses_id,proses_nama AS proses_nama FROM perkara_proses WHERE perkara_id=".$idperkara." AND tahapan_id=30 AND proses_id!=".$dataproses['status_kasasi_id']." ORDER BY proses_id DESC LIMIT 1;");
			if($cekproses->num_rows>0){
				foreach ($cekproses->result() as $row) {
					$idproses = $row->proses_id;
					$namaproses = $row->proses_nama;
				}				
				$this->db->query("UPDATE perkara_kasasi SET status_kasasi_id=".$idproses.", status_kasasi_text='".$namaproses."' WHERE perkara_id=".$idperkara);
			}
			$this->db->where('perkara_id',$idperkara);
			$this->db->where('proses_id',$dataproses['status_kasasi_id']);
			$this->db->delete('perkara_proses');
			$title = "HAPUS TANGGAL <br /> DELETE table <b>perkara_kasasi_detil</b> dari halaman <b>DETIL KASASI</b> dengan Primary Key [id=".$id."]";
			$descrip = $this->fetch_description($title,$datapihak);
			$this->add_audittrail("DELETE",$title,$descrip,'perkara_kasasi_detil');		
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}		
	}

	function hapus_putusan($idperkara,$datakasasi){
		try {			
			$this->db->where('perkara_id',$idperkara);
			$this->db->update('perkara_kasasi',$datakasasi);			
			$cekproses = $this->db->query("SELECT proses_id,proses_nama FROM perkara_proses WHERE perkara_id=".$idperkara." AND tahapan_id=30 AND proses_id!=490 ORDER BY proses_id DESC LIMIT 1;");			
			if($cekproses->num_rows>0){
				foreach ($cekproses->result() as $row) {
					$idproses = $row->proses_id;
					$namaproses = $row->proses_nama;
				}				
				$this->db->query("UPDATE perkara_kasasi SET status_kasasi_id=".$idproses.", status_kasasi_text='".$namaproses."' WHERE perkara_id=".$idperkara);
			}
			$this->db->where('perkara_id',$idperkara);
			$this->db->where('proses_id',490);
			$this->db->delete('perkara_proses');
			$title = "HAPUS PUTUSAN KASASI <br /> DELETE table <b>perkara_kasasi</b> dari halaman <b>EDIT PUTUSAN KASASI</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$descrip = $this->fetch_description($title,$datakasasi);
			$this->add_audittrail("DELETE",$title,$descrip,'perkara_kasasi');		
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}		
	}

	function getInfoTglPemberitahuanPts($idperkara){
		try {
			$result = $this->db->query('SELECT MAX(pemberitahuan_putusan_kasasi) AS pemberitahuan_putusan_kasasi FROM perkara_kasasi_detil WHERE perkara_id='.$idperkara);
			if($result->num_rows>0){
				return $result->row()->pemberitahuan_putusan_kasasi;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return '';
		}
	}

}

?>