<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class List_penyitaan extends CI_Model{
	function parseOrderby($col){
		if($col==1){
			return "p.nomor_perkara"; 
		}else if($col==2){
			return "p.para_pihak"; 
		}else if($col==3){
			return "penetapan_sita"; 
		}else if($col==4){
			return "pelaksanaan_sita"; 
		}else if($col==5){
			return "jenis_sita_nama"; 
		}else if($col==6){
			return "jenis_barang"; 
		}else{
			return "penetapan_sita";
		}
	}

	function getListPenyitaan($col=9,$type='DESC',$begin=0,$idalurperkara,$key=''){
		try {
			$orderby = $this->parseOrderby($col);
			$where = '';
			if(!empty($key)){
				$where .= ' AND (p.para_pihak LIKE "%'.$key.'%" OR 
					p.nomor_perkara LIKE "%'.$key.'%" OR penetapan_sita LIKE "%'.$key.'%" OR
					pelaksanaan_sita LIKE "%'.$key.'%" OR jenis_sita_nama LIKE "%'.$key.'%"
					OR jenis_barang LIKE "%'.$key.'%" OR tanggal_pendaftaran_penyitaan LIKE "%'.$key.'%") ';
			}
			return $this->db->query("SELECT SQL_CALC_FOUND_ROWS id,pp.perkara_id,p.para_pihak,
				p.nomor_perkara,penetapan_sita,pelaksanaan_sita,jenis_sita_nama, jenis_barang,tanggal_pendaftaran_penyitaan
				FROM perkara_penyitaan AS pp
				LEFT JOIN perkara AS p
				ON p.perkara_id = pp.perkara_id
				WHERE pp.alur_perkara_id IN (".$idalurperkara.") ".$where." ORDER BY ".$orderby." ".$type." LIMIT ".$begin.",30;");
		} catch (Exception $e) {
			log_message('error', $e);
			return '';
		}
	}

	function getNomorPerkara($idalurperkara){
		try {
			return $this->db->query('SELECT perkara_id,nomor_perkara FROM perkara WHERE alur_perkara_id IN ('.$idalurperkara.');');
		} catch (Exception $e) {
			return '';
		}
	}

	function getAlurPerkara($idperkara){
		try {
			$result = $this->db->query('SELECT alur_perkara_id FROM perkara WHERE perkara_id = '.$idperkara);
			if($result->num_rows>0){
				return $result->row()->alur_perkara_id;
			}else{
				return '';
			}
		} catch (Exception $e) {
			log_message('error', $e);
			return '';
		}
	}

	function getParaPihak($idperkara){
		try {
			$result = $this->db->query('SELECT para_pihak FROM perkara WHERE perkara_id = '.$idperkara);
			if($result->num_rows>0){
				return $result->row()->para_pihak;
			}else{
				return '';
			}
		} catch (Exception $e) {
			log_message('error', $e);
			return '';
		}
	}

	function isPerkaraExist($idperkara){
		try {
			$result = $this->db->query('SELECT perkara_id FROM perkara_penyitaan WHERE perkara_id = '.$idperkara);
			if($result->num_rows>0){
				return TRUE;
			}else{
				return FALSE;
			}
		} catch (Exception $e) {
			log_message('error', $e);
			return '-1';
		}
	}

	function getDetilPerkara($idperkara){
		try {
			return $this->db->query('SELECT pp.perkara_id,p.para_pihak,
				p.nomor_perkara,penetapan_sita,pelaksanaan_sita,jenis_sita_nama,
				jenis_barang,disita_dari,penyimpanan_barang,penetapan_pengangkatan_sita,
				pelaksanaan_pengangkatan_sita,catatan_penyitaan
				FROM perkara_penyitaan AS pp
				LEFT JOIN perkara AS p
				ON p.perkara_id = pp.perkara_id
				WHERE pp.perkara_id ='.$idperkara);
		} catch (Exception $e) {
			return '';
		}
	}

	function fecth_data_num(){
		try {
			$query = $this->db->query("SELECT FOUND_ROWS() as cnt;");
			if($query->num_rows>0){
				foreach ($query->result() as $row) {
					return $row->cnt;
				}
	    		return $query->num_rows;
	    	}else{
	    		return 0;
	    	}
		} catch (Exception $e) {
			
		}
	}

	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}

	function add_audittrail($action,$title,$descrip,$tablename){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => 'Add Referensi Pihak',
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			
		}
	}

	function add_data($data){
		try {
			$id = $this->db->query("SELECT IFNULL(max(id)+1,1) as id FROM perkara_penyitaan;")->row()->id;
			if($id>0){
				$data['id'] = $id;
				$this->db->insert('perkara_penyitaan', $data);
				$title = "Tambah Register Perkara Penyitaan [perkara_id=<b>".$data['perkara_id']."</b>]<br />Tambah table <b>perkara_penyitaan</b> dari halaman <b>REGISTER PENYITAAN</b> dengan Primary Key [id=".$data['id']."]";
				$descrip = $this->fetch_description($title,$data);
				$this->add_audittrail("INSERT",$title,$descrip,'perkara_penyitaan');
				return TRUE;
			}else{
				return FALSE;
			}
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function update_data($data,$idperkara){
		try {
			if($idperkara>0){
				#$data['perkara_id'] = $idperkara;
				$this->db->where('perkara_id', $idperkara);
				$this->db->update('perkara_penyitaan', $data); 
				$title = "Ubah Data Register Perkara Penyitaan [perkara_id=<b>".$data['perkara_id']."</b>]<br />Update table <b>perkara_penyitaan</b> dari halaman <b>REGISTER PENYITAAN</b> dengan Primary Key [id=".$data['perkara_id']."]";
				$descrip = $this->fetch_description($title,$data);
				$this->add_audittrail("UPDATE",$title,$descrip,'perkara_penyitaan');
				return TRUE;
			}else{
				return FALSE;
			}
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function del_data($idperkara){
		try {
			$this->db->query("DELETE FROM perkara_penyitaan WHERE perkara_id =".$idperkara);
			$title = "Delete Data Register Perkara Penyitaan <br />dengan id [perkara_id=".$idperkara."] Oleh = ".$this->session->userdata('username');
			$this->add_audittrail("DELETE",$title,'DELETE DATA','perkara_penyitaan');
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

}