<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class penuntutan_m extends CI_Model{

	// fungsi yang harus ada di setiap controller. fungsi : penambahan audittrail
	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}

	function add_audittrail($action,$title,$descrip,$tablename,$namahalaman){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => $namahalaman,
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			
		}
	}
	//============================================================================

	function get_detil_data_penuntutan($perkara_id){
		if(empty($perkara_id)){
				return '';
			}
		try{
			$where="A.perkara_id = B.perkara_id AND A.perkara_id = C.perkara_id AND A.perkara_id = $perkara_id";
			$this->db->select('B.perkara_id,A.nomor_perkara,A.tanggal_pendaftaran,MIN(C.tanggal_sidang) as tanggal_sidang,B.tanggal_penuntutan,B.isi_penuntutan,B.isi_penuntutan_dok');
			$this->db->from('perkara A, perkara_penuntutan B, perkara_jadwal_sidang C');
			$this->db->where($where);
			$query=$this->db->get();
			return $query->result();
		}catch (Exception $e){
			log_message('error', $e);
		}
	}

	function get_detil_data_utama($perkara_id){
		if(empty($perkara_id)){
				return '';
			}
		try{
			$where="A.perkara_id = C.perkara_id AND A.perkara_id = $perkara_id";
			$this->db->select('A.perkara_id,A.nomor_perkara,A.tanggal_pendaftaran,MIN(C.tanggal_sidang) as tanggal_sidang,');
			$this->db->from('perkara A, perkara_jadwal_sidang C');
			$this->db->where($where);
			$query=$this->db->get();
			return $query->result();
		}catch (Exception $e){
			log_message('error', $e);
		}
	}

	function get_penetapan_sidang_pertama($perkara_id){
		try {
			$query = $this->db->query("SELECT sidang_pertama
				FROM v_perkara 
				WHERE perkara_id='".$perkara_id."';");
			return $query->row(0);
		} catch (Exception $e) {
			return '';
		}
	}

	function update_penuntutan($perkara_id,$datadiupdate,$namahalaman){
		try{
			$namatabel="perkara_penuntutan";
			$primarykey="perkara_id";

			$this->db->where($primarykey,$perkara_id);
			$this->db->update($namatabel,$datadiupdate);

			$title = "UPDATE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey."=".$perkara_id."]";
			$descrip = $this->fetch_description($title,$datadiupdate);
			$this->add_audittrail("UPDATE",$title,$descrip,$namatabel,$namahalaman);
			return TRUE;
		}catch (Exception $e){
			return FALSE;
		}
	}

	function tambah_penuntutan($datadiinsert,$namahalaman){
		try{
			$namatabel="perkara_penuntutan";
			$primarykey="perkara_id";
			
			$this->db->insert($namatabel,$datadiinsert);			

			$title = "INSERT table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey."=".$datadiinsert['perkara_id']."]";
			$descrip = $this->fetch_description($title,$datadiinsert);
			$this->add_audittrail("INSERT",$title,$descrip,$namatabel,$namahalaman);
			return TRUE;
		}catch (Exception $e) {
			return FALSE;
		}
	}

	function hapus_penuntutan($id_perkara,$namahalaman){
		try {
			$namatabel="perkara_penuntutan";
			$primarykey="perkara_id";

			$this->db->where($primarykey,$id_perkara);
			$this->db->delete($namatabel);

			$title = "DELETE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey."=".$id_perkara."]";
			$descrip = '';
			$this->add_audittrail("DELETE",$title,$descrip,$namatabel,$namahalaman);
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	//=== $aksi : 1 - Menambahkan Proses ; 2 - Menghapus Proses
	// function updateproses($perkara_id,$idproses,$tanggal,$urutan,$namahalaman,$aksi){
		// try {
			// $alur_perkara_id = $this->tanggalhelper->getIDAlurPerkara($perkara_id);
			// $proses_alur_perkara=$this->db->query("SELECT * FROM proses_alur_perkara WHERE alur_perkara_id=".$alur_perkara_id.' AND proses_id='.$idproses)->row(0);
			
				// $data_tahapan=array(
					// 'tahapan_terakhir_id'	=> $proses_alur_perkara->tahapan_id,
                    // 'tahapan_terakhir_text'	=> $proses_alur_perkara->tahapan_nama,
                    // 'proses_terakhir_id'	=> $proses_alur_perkara->proses_id,
                    // 'proses_terakhir_text'	=> $proses_alur_perkara->proses_nama,
                    // 'diperbaharui_oleh'		=> $this->session->userdata('username'),
					// 'diperbaharui_tanggal'	=> date('Y-m-d H:i:s')
				// );
				// if ($aksi==1){
				// $this->db->simple_query("CALL perkara_proses_update('".$perkara_id."','".$proses_alur_perkara->tahapan_id."','".$proses_alur_perkara->tahapan_nama."',
										// '".$proses_alur_perkara->proses_id."','".$proses_alur_perkara->proses_nama."','".$tanggal."','".$urutan."','".$this->session->userdata('username')."','".date("Y-m-d H:i:s")."');");
				// }else{
					// $namatabel="perkara_proses";
					// $primarykey1="perkara_id";
					// $primarykey2="proses_id";
					// $this->db->where($primarykey2,$idproses);
					// $this->db->where($primarykey1,$perkara_id);
					// $this->db->delete($namatabel);
					// $title = "DELETE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey1."=".$perkara_id." & ".$primarykey2."=".$idproses."]";
					// $descrip = '';
					// $this->add_audittrail("DELETE",$title,$descrip,$namatabel,$namahalaman);

					// $qry="SELECT B.* FROM perkara_proses A, proses_alur_perkara B WHERE A.perkara_id='".$perkara_id."' 
							// AND B.`alur_perkara_id`='".$alur_perkara_id."'
							// AND	B.`tahapan_id`=A.`tahapan_id` AND B.`proses_id`=A.`proses_id`
							// AND 
							// (A.diinput_tanggal=(SELECT MAX(IFNULL(diperbaharui_tanggal,diinput_tanggal)) AS disp_diinput_tanggal FROM perkara_proses WHERE perkara_id='".$perkara_id."' ORDER BY tanggal ASC, urutan ASC, disp_diinput_tanggal ASC, tahapan_id ASC,  proses_id ASC) 
							// || A.diperbaharui_tanggal=(SELECT MAX(IFNULL(diperbaharui_tanggal,diinput_tanggal)) AS disp_diinput_tanggal FROM perkara_proses WHERE perkara_id='".$perkara_id."' ORDER BY tanggal ASC, urutan ASC, disp_diinput_tanggal ASC, tahapan_id ASC, proses_id ASC));
							// ";
					// $proses_alur_perkara=$this->db->query($qry)->row(0);

					// $data_tahapan=array(
						// 'tahapan_terakhir_id'	=> $proses_alur_perkara->tahapan_id,
						// 'tahapan_terakhir_text'	=> $proses_alur_perkara->tahapan_nama,
						// 'proses_terakhir_id'	=> $proses_alur_perkara->proses_id,
						// 'proses_terakhir_text'	=> $proses_alur_perkara->proses_nama,
						// 'diperbaharui_oleh'		=> $this->session->userdata('username'),
						// 'diperbaharui_tanggal'	=> date('Y-m-d H:i:s')
					// );
				// }
			// $namatabel="perkara";
			// $primarykey="perkara_id";
			// $this->db->where($primarykey, $perkara_id);
			// $this->db->update($namatabel, $data_tahapan);
			// $title = "UPDATE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [perkara_id=".$perkara_id."]";
			// $descrip = $this->fetch_description($title,$data_tahapan);
			// $this->add_audittrail("UPDATE",$title,$descrip,$namatabel,$namahalaman);

		// }catch (Exception $e) {
			// return FALSE;
		// }
	// }
}
?>