<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class add_panitera_m extends CI_Model{
	
	function get_data_panitera_aktif(){
		try {
			$query = $this->db->query("SELECT id, nama_gelar
				FROM panitera_pn 
				WHERE aktif='Y' order by nama_gelar ASC;");
			return $query->result_array();
		} catch (Exception $e) {
			return '';
		}
	}
	
	function get_no_perkara($perkara_id){
		try {
			$query = $this->db->query("SELECT nomor_perkara, alur_perkara_id, tanggal_pendaftaran
				FROM perkara 
				WHERE perkara_id='".$perkara_id."';");
			return $query->result_array();
		} catch (Exception $e) {
			return '';
		}
	}
	
	function get_last_id(){
		try {
			$query = $this->db->query("SELECT (ifnull(max(id),0)) +1 AS last_id 
				FROM perkara_panitera_pn;");
			if($query->num_rows>0){
				foreach ($query->result() as $row) {
					return $row->last_id;
				}
	    	}else{
	    		return 0;
	    	}
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_data_penetapan($perkara_id){
		try {
			$query = $this->db->query("SELECT perkara_id, penetapan_majelis_hakim, majelis_hakim_id, majelis_hakim_text,
				penetapan_panitera_pengganti, panitera_pengganti_id, panitera_pengganti_text
				FROM perkara_penetapan 
				WHERE perkara_id='".$perkara_id."';");
			return $query->result_array();
		} catch (Exception $e) {
			return '';
		}
	}
	function get_penetapan_hakim_pertama($perkara_id){
		try {
			$query = $this->db->query("SELECT penetapan_majelis_hakim, penetapan_panitera_pengganti
				FROM v_perkara 
				WHERE perkara_id='".$perkara_id."';");
			return $query->row(0);
		} catch (Exception $e) {
			return '';
		}
	}
	
	function get_data_panitera_detail($perkara_id){
		try {
			$query = $this->db->query("SELECT *
				FROM perkara_panitera_pn 
				WHERE tahapan_id=10 AND perkara_id='".$perkara_id."' and aktif='Y' ORDER BY urutan ASC;");
			return $query->result_array();
		} catch (Exception $e) {
			return '';
		}
	}

	function getStatusPP($perkara_id){
		try {
			$result = $this->db->query("SELECT COUNT(perkara_id) AS jumlah FROM perkara_panitera_pn 
										WHERE perkara_id=$perkara_id AND aktif='T'");
			if($result->num_rows>0){
				return $result->row()->jumlah;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return '';
		}
	}
	
	function insert_penunjukan_panitera($perkara_id, $tgl_penunjukan, $namahalaman){
		try {
			$arr_panitera = explode(",", $this->panitera_id);
			$last_id = $this->get_last_id();
			$panitera_kode='';$panitera_text='';
			$data_insert=array();
			for ($i=0;$i<(count($arr_panitera));$i++){
				$data_panitera = $this->db->query("SELECT id, kode, nip, nama, nama_gelar FROM panitera_pn where id = ".$arr_panitera[$i].";")->row(0);
				
				$panitera_kode .= $data_panitera->kode;
				switch ($i){
					case 0:
						$panitera_text.= "Panitera Pengganti: ".$data_panitera->nama_gelar;
					break;
					case 1:
						$panitera_text.= "Panitera Pengganti 2: ".$data_panitera->nama_gelar;
					break;
					case 2:
						$panitera_text.= "Panitera Pengganti 3: ".$data_panitera->nama_gelar;
					break;
				}
				if ($i<>(count($arr_panitera)-1)){
					$panitera_kode.="|";
					$panitera_text.="</br>";
				}
				
				$data_insert[]=array(
					'id'=>$last_id,
					'perkara_id'=>$perkara_id,
					'tanggal_penetapan'=>$tgl_penunjukan,
					'urutan'=>$i+1,
					'panitera_id'=>$arr_panitera[$i],
					'panitera_kode'=>$data_panitera->kode,
					'panitera_nip'=>$data_panitera->nip,
					'panitera_nama'=>$data_panitera->nama_gelar,
					'aktif'=>'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s'),
					'keterangan'=>$this->keterangan
				);
				$last_id++;
			}
			$data = array(
				'penetapan_panitera_pengganti'=>$tgl_penunjukan,
				'panitera_pengganti_id'=>$this->panitera_id,
				'panitera_pengganti_text'=>$panitera_text
			);
			//update perkara penetapan
			$namatabel="perkara_penetapan";
			$primarykey="perkara_id";
			$this->db->where('perkara_id', $perkara_id);
			$this->db->update('perkara_penetapan', $data);
			$title = "UPDATE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey."=".$perkara_id."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("UPDATE",$title,$descrip,$namatabel,$namahalaman);
			
			//insert perkara_panitera_pn
			$namatabel="perkara_panitera_pn";
			$primarykey="perkara_id";
			$this->db->insert_batch('perkara_panitera_pn', $data_insert);
			for ($i=0;$i<count($data_insert);$i++){
				$title = "INSERT table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Foreign Key [".$primarykey."=".$data_insert[$i]['perkara_id']."]";
				$descrip = $this->fetch_description($title,$data_insert[$i]);
				$this->add_audittrail("INSERT",$title,$descrip,$namatabel,$namahalaman);
			}			
		} catch (Exception $e) {
			return '';
		}
	}

	function edit_penunjukan_panitera($perkara_id, $tgl_penunjukan, $panitera_sebelumnya_id='',$penunjukan_kembali=0,$namahalaman){
		try {
			$arr_panitera = explode(",", $this->panitera_id);
			$arr_panitera_sebelumnya = explode(",", $panitera_sebelumnya_id);
			$last_id = $this->get_last_id();
			$panitera_kode='';$panitera_text='';
			$data_insert=array();
			for ($i=0;$i<(count($arr_panitera));$i++){
				$data_panitera = $this->db->query("SELECT id, kode, nip, nama, nama_gelar FROM panitera_pn where id = ".$arr_panitera[$i].";")->row(0);
				
				$panitera_kode .= $data_panitera->kode;
				switch ($i){
					case 0:
						$panitera_text.= "Panitera Pengganti: ".$data_panitera->nama_gelar;
					break;
					case 1:
						$panitera_text.= "Panitera Pengganti 2: ".$data_panitera->nama_gelar;
					break;
					case 2:
						$panitera_text.= "Panitera Pengganti 3: ".$data_panitera->nama_gelar;
					break;
				}
				if ($i<>(count($arr_panitera)-1)){
					$panitera_kode.="|";
					$panitera_text.="</br>";
				}
				
				if (array_key_exists($i, $arr_panitera_sebelumnya)){
					$data_update[]=array(
						'id'=>$arr_panitera_sebelumnya[$i],
						'perkara_id'=>$perkara_id,
						'tanggal_penetapan'=>$tgl_penunjukan,
						'urutan'=>$i+1,
						'panitera_id'=>$arr_panitera[$i],
						'panitera_kode'=>$data_panitera->kode,
						'panitera_nip'=>$data_panitera->nip,
						'panitera_nama'=>$data_panitera->nama_gelar,
						'aktif'=>'Y',
						'diperbaharui_oleh'=>$this->session->userdata('username'),
						'diperbaharui_tanggal'=>date('Y-m-d H:i:s'),
						'keterangan'=>$this->keterangan
					);

				}else{
					$data_insert[]=array(
						'id'=>$last_id,
						'perkara_id'=>$perkara_id,
						'tanggal_penetapan'=>$tgl_penunjukan,
						'urutan'=>$i+1,
						'panitera_id'=>$arr_panitera[$i],
						'panitera_kode'=>$data_panitera->kode,
						'panitera_nip'=>$data_panitera->nip,
						'panitera_nama'=>$data_panitera->nama_gelar,
						'aktif'=>'Y',
						'diinput_oleh'=>$this->session->userdata('username'),
						'diinput_tanggal'=>date('Y-m-d H:i:s')
					);
					$last_id++;
				}
			}
			$data = array(
				'penetapan_panitera_pengganti'=>$tgl_penunjukan,
				'panitera_pengganti_id'=>$this->panitera_id,
				'panitera_pengganti_text'=>$panitera_text,
				'diperbaharui_oleh'=>$this->session->userdata('username'),
				'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
			);
			//update perkara penetapan
			$namatabel="perkara_penetapan";
			$primarykey="perkara_id";
			$this->db->where($primarykey, $perkara_id);
			$this->db->update($namatabel, $data);
			$title = "UPDATE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey."=".$perkara_id."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("UPDATE",$title,$descrip,$namatabel,$namahalaman);
			
			//update perkara_panitera_pn
			$namatabel="perkara_panitera_pn";
			$primarykey="id";
			foreach ($data_update as $row) {
				$this->db->where('id', $row['id']);	
				$this->db->update('perkara_panitera_pn', $row);
				$title = "UPDATE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey."=".$row['id']."]";
				$descrip = $this->fetch_description($title,$row);
				$this->add_audittrail("UPDATE",$title,$descrip,$namatabel,$namahalaman);
			}

			//insert table perkara_panitera_pn jika ada penambahan jumlah panitera
			$namatabel="perkara_panitera_pn";
			$primarykey="perkara_id";
			if (!empty($data_insert)){
				$this->db->insert_batch($namatabel, $data_insert);
				for ($i=0;$i<count($data_insert);$i++){
					$title = "INSERT table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Foreign Key [".$primarykey."=".$data_insert[$i]['perkara_id']."]";
					$descrip = $this->fetch_description($title,$data_insert[$i]);
					$this->add_audittrail("INSERT",$title,$descrip,$namatabel,$namahalaman);
				}	
			}
			
			//delete row perkara_pantitera_pn jika ada pengurangan jumlah panitera
			$namatabel="perkara_panitera_pn";
			$primarykey1="id";
			$primarykey2="perkara_id";
			if (count($arr_panitera)<count($arr_panitera_sebelumnya)){
				for ($i=0;$i<(count($arr_panitera_sebelumnya));$i++){
					if (!array_key_exists($i, $arr_panitera)){
						$this->db->where($primarykey1, $arr_panitera_sebelumnya[$i]);
						$this->db->where($primarykey2, $perkara_id);
						$this->db->delete($namatabel); 
						$title = "DELETE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey1."=".$arr_panitera_sebelumnya[$i]."]";
						$descrip = '';
						$this->add_audittrail("DELETE",$title,$descrip,$namatabel,$namahalaman);
					}
				}
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function insert_penunjukan_kembali_panitera($perkara_id, $tgl_penunjukan,$namahalaman){
		try {
			$arr_panitera = explode(",", $this->panitera_id);
			$last_id = $this->get_last_id();
			$panitera_kode='';$panitera_text='';
			$data_insert=array();
			for ($i=0;$i<(count($arr_panitera));$i++){
				$data_panitera = $this->db->query("SELECT id, kode, nip, nama, nama_gelar FROM panitera_pn where id = ".$arr_panitera[$i].";")->row(0);
				
				$panitera_kode .= $data_panitera->kode;
				switch ($i){
					case 0:
						$panitera_text.= "Panitera Pengganti: ".$data_panitera->nama_gelar;
					break;
					case 1:
						$panitera_text.= "Panitera Pengganti 2: ".$data_panitera->nama_gelar;
					break;
					case 2:
						$panitera_text.= "Panitera Pengganti 3: ".$data_panitera->nama_gelar;
					break;
				}
				if ($i<>(count($arr_panitera)-1)){
					$panitera_kode.="|";
					$panitera_text.="</br>";
				}
				
				$data_insert[]=array(
					'id'=>$last_id,
					'perkara_id'=>$perkara_id,
					'tanggal_penetapan'=>$tgl_penunjukan,
					'urutan'=>$i+1,
					'panitera_id'=>$arr_panitera[$i],
					'panitera_kode'=>$data_panitera->kode,
					'panitera_nip'=>$data_panitera->nip,
					'panitera_nama'=>$data_panitera->nama_gelar,
					'aktif'=>'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s'),
					'keterangan'=>$this->keterangan
				);
				$last_id++;
			}
			$data = array(
				'penetapan_panitera_pengganti' => $tgl_penunjukan,
				'panitera_pengganti_id'=>$this->panitera_id,
				'panitera_pengganti_text'=>$panitera_text
			);
			//update perkara penetapan
			$namatabel="perkara_penetapan";
			$primarykey="perkara_id";
			$this->db->where($primarykey, $perkara_id);
			$this->db->update($namatabel, $data);
			$title = "UPDATE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey."=".$perkara_id."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("UPDATE",$title,$descrip,$namatabel,$namahalaman);
			
			//update perkara_panitera_pn
			$data = array(
				'aktif' => 'T',
				'tanggal_tidak_aktif' => $tgl_penunjukan,
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date('Y-m-d H:i:s')
			);
			$namatabel="perkara_panitera_pn";
			$primarykey="perkara_id";
			$this->db->where($primarykey, $perkara_id);
			$this->db->where('aktif', 'Y');
			$this->db->update($namatabel, $data);
			$title = "UPDATE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Foreign Key [".$primarykey."=".$perkara_id."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("UPDATE",$title,$descrip,$namatabel,$namahalaman);

			//insert perkara_panitera_pn
			$namatabel="perkara_panitera_pn";
			$primarykey="perkara_id";
			$this->db->insert_batch($namatabel, $data_insert);
			for ($i=0;$i<count($data_insert);$i++){
				$title = "INSERT table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Foreign Key [".$primarykey."=".$data_insert[$i]['perkara_id']."]";
				$descrip = $this->fetch_description($title,$data_insert[$i]);
				$this->add_audittrail("INSERT",$title,$descrip,$namatabel,$namahalaman);
			}			
		} catch (Exception $e) {
			return '';
		}
	}
	
	function get_jumlah_tanggal_input($idperkara){
		try {
			return $this->db->query("SELECT DISTINCT(diinput_tanggal) AS tanggal,tanggal_penetapan
				FROM perkara_panitera_pn
				WHERE perkara_id = ".$idperkara." AND tahapan_id=10 ORDER BY id DESC;;");
		} catch (Exception $e) {
			return FALSE;
		}
	}	
	function get_tanggal_input($idperkara){
		try {
			return $this->db->query("SELECT DISTINCT(diinput_tanggal) AS tanggal,urutan,id, aktif
				FROM perkara_panitera_pn
				WHERE perkara_id = ".$idperkara." AND tahapan_id=10 ORDER BY id DESC;;");
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function get_tanggal_penetapan($idperkara){
		try {
			return $this->db->query("SELECT penetapan_jurusita, penetapan_hari_sidang 
				FROM perkara_penetapan  
				WHERE perkara_id = ".$idperkara.";");
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function get_jumlah_sidang($idperkara){
		try {
			$result = $this->db->query("SELECT count(*) As jmlh 
				FROM perkara_jadwal_sidang  
				WHERE keberatan='T' AND perkara_id = ".$idperkara.";");
			if($result->num_rows>0){
				return $result->row()->jmlh;
			}else{
				return 0;
			}
		} catch (Exception $e) {
			return 0;
		}
	}

	function get_tahapan($idperkara){
		try {
			$result = $this->db->query("SELECT tahapan_terakhir_id
				FROM perkara  
				WHERE perkara_id = ".$idperkara.";");
			if($result->num_rows>0){
				return $result->row()->tahapan_terakhir_id;
			}else{
				return 0;
			}
		} catch (Exception $e) {
			return 0;
		}
	}

	function hapus_penetapan($idperkara,$oldid,$newid,$namahalaman){
		try {
			$idhapus = '';
			$namatabel="perkara_panitera_pn";
			$primarykey1="id";
			$primarykey2="perkara_id";
			foreach ($oldid as $id) {
				$this->db->where($primarykey1,$id);
				$this->db->where($primarykey2,$idperkara);
				$this->db->delete($namatabel);
				$idhapus .= $id.',';
			}

			$title = "DELETE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey1."=".$idhapus."]";
			$descrip = '';
			$this->add_audittrail("DELETE",$title,$descrip,$namatabel,$namahalaman);

			$idupdate = '';
			$namatabel="perkara_panitera_pn";
			$primarykey1="id";
			$primarykey2="perkara_id";
			foreach ($newid as $id) {
				$data = '';
				$this->db->where($primarykey1,$id);
				$this->db->where($primarykey2,$idperkara);
				$data = array(
					'aktif'=>'Y',
					'diperbaharui_oleh'=>$this->session->userdata('username'),
					'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
					);
				$this->db->update($namatabel,$data);
				$idupdate .= $id.',';
				$title = "UPDATE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey1."=".$idupdate."]";
				$descrip = $this->fetch_description($title,$data);
				$this->add_audittrail("UPDATE",$title,$descrip,$namatabel,$namahalaman);
			}			

			$data = '';
			$datahakim = $this->get_data_panitera_detail($idperkara);
			if(!empty($datahakim)){
				$paniteratext = "";
				$hakimnama = "";
				$paniteraid = "";
				$majeliskode = "";
				$jmlh = count($datahakim);
				$i = 0;
				$data = array(
					'diperbaharui_oleh'=>$this->session->userdata('username'),
					'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
					);
				foreach ($datahakim as $row) {
					$paniteratext .= 'Panitera Pengganti:'.$row['panitera_nama'];
					$paniteraid .= $row['panitera_id'];
					$i++;
					if($i!=$jmlh){
						$paniteratext .= '</br>';
						$paniteraid .= ',';
					}
					$data['penetapan_panitera_pengganti'] = $row['tanggal_penetapan'];
					if(!empty($row['nomor_sk_penetapan'])){
						$data['nomor_sk_penetapan_panitera_pengganti'] = $row['nomor_sk_penetapan'];
					}
				}
				$data['panitera_pengganti_text'] = $paniteratext;
				$data['panitera_pengganti_id'] = $paniteraid;
				
				$namatabel="perkara_penetapan";
				$primarykey="perkara_id";
				$this->db->where($primarykey,$idperkara);
				$this->db->update($namatabel,$data);

				$title = "UPDATE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey."=".$idperkara."]";
				$descrip = $this->fetch_description($title,$data);
				$this->add_audittrail("UPDATE",$title,$descrip,$namatabel,$namahalaman);
			}
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function hapus_all_penetapan($idperkara,$namahalaman){
		try {
			$namatabel="perkara_panitera_pn";
			$primarykey="perkara_id";
			$this->db->where($primarykey,$idperkara);
			$this->db->where('tahapan_id',10);
			$this->db->delete($namatabel);
			$title = "DELETE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Foreign Key [".$primarykey."=".$idperkara."]";
			$descrip = '';
			$this->add_audittrail("DELETE",$title,$descrip,$namatabel,$namahalaman);

			$data = array(
				'penetapan_panitera_pengganti'=>NULL,
				'nomor_sk_penetapan_panitera_pengganti'=>NULL,
				'sk_penetapan_panitera_pengganti_dok'=>NULL,
				'panitera_pengganti_id'=>NULL,
				'panitera_pengganti_text'=>NULL,
				'diperbaharui_oleh'=>$this->session->userdata('username'),
				'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
			);
			$namatabel="perkara_penetapan";
			$primarykey="perkara_id";
			$this->db->where($primarykey,$idperkara);
			$this->db->update($namatabel,$data);
			$title = "UPDATE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey."=".$idperkara."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("UPDATE",$title,$descrip,$namatabel,$namahalaman);
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}
	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}
	
	function add_audittrail($action,$title,$descrip,$tablename,$namahalaman){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => $namahalaman,
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			
		}
	}
}
?>