<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class add_majelis_m extends CI_Model{
	
	function get_data_hakim_aktif(){
		try {
			$query = $this->db->query("SELECT id, nama_gelar
				FROM hakim_pn 
				WHERE aktif='Y' order by nama_gelar ASC;");
			return $query->result_array();
		} catch (Exception $e) {
			return '';
		}
	}
	
	function get_no_perkara($perkara_id){
		try {
			$query = $this->db->query("SELECT nomor_perkara, alur_perkara_id
				FROM perkara 
				WHERE perkara_id='".$perkara_id."';");
			return $query->result_array();
		} catch (Exception $e) {
			return '';
		}
	}

	function getStatusHakim($perkara_id){
		try {
			$result = $this->db->query("SELECT COUNT(perkara_id) AS jumlah FROM perkara_hakim_pn 
										WHERE perkara_id=$perkara_id AND aktif='T'");
			if($result->num_rows>0){
				return $result->row()->jumlah;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return '';
		}
	}
	
	function get_last_id(){
		try {
			$query = $this->db->query("SELECT (ifnull(max(id),0)) +1 AS last_id 
				FROM perkara_hakim_pn;");
			if($query->num_rows>0){
				foreach ($query->result() as $row) {
					return $row->last_id;
				}
	    	}else{
	    		return 0;
	    	}
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_tanggal_pelimpahan($perkara_id){
		try {
			$query = $this->db->query("SELECT tanggal_pendaftaran
				FROM perkara 
				WHERE perkara_id='".$perkara_id."';");
			return $query->row(0);
		} catch (Exception $e) {
			return '';
		}
	}
	
	function get_penetapan_hakim_pertama($perkara_id){
		try {
			$query = $this->db->query("SELECT penetapan_majelis_hakim
				FROM v_perkara 
				WHERE perkara_id='".$perkara_id."';");
			return $query->row(0);
		} catch (Exception $e) {
			return '';
		}
	}	

	function get_data_majelis($perkara_id){
		try {
			$query = $this->db->query("SELECT perkara_id, jenis_acara, penetapan_majelis_hakim, majelis_hakim_id, majelis_hakim_text
				FROM perkara_penetapan 
				WHERE perkara_id='".$perkara_id."';");
			return $query->result_array();
		} catch (Exception $e) {
			return '';
		}
	}
	
	function get_data_hakim_separator($perkara_id){
		try {
			$query = $this->db->query("SELECT GROUP_CONCAT(CONCAT(jabatan_hakim_nama, IF(urutan=1,'',(urutan)-1),' : ',hakim_nama) SEPARATOR '<br>') AS hakim_separator FROM perkara_hakim_pn WHERE perkara_id='".$perkara_id."' ORDER BY jabatan_hakim_id");
			return $query->result_array();
		} catch (Exception $e) {
			return '';
		}
	}
	
	function get_data_majelis_detail($perkara_id){
		try {
			$query = $this->db->query("SELECT *
				FROM perkara_hakim_pn 
				WHERE perkara_id='".$perkara_id."' and aktif='Y' AND tahapan_id=10 ORDER BY urutan ASC;");
			return $query->result_array();
		} catch (Exception $e) {
			return '';
		}
	}
	
	function insert_penetapan_majelis($perkara_id, $jenis_acara, $tgl_penetapan, $majelis_hakim_id, $namahalaman){
		try {
			$arr_hakim = explode(",", $this->hakim_id);
			$last_id = $this->get_last_id();
			$hakim_kode='';$hakim_nama='';$hakim_text='';
			$data_insert=array();
			for ($i=0;$i<(count($arr_hakim));$i++){
				$data_hakim = $this->db->query("SELECT id, kode, nip, nama, nama_gelar FROM hakim_pn where id = ".$arr_hakim[$i].";")->row(0);
				
				$hakim_kode.=$data_hakim->kode;
				$hakim_nama .= $data_hakim->nama;
				switch ($i){
					case 0:
						if ($this->input->post('pilihan_majelis')==='majelis'){
							$hakim_text.= "Hakim Ketua: ".$data_hakim->nama_gelar;
							$jabatan_hakim_nama = "Hakim Ketua";
							$jabatan_hakim_id = 1;
						}else{
							$hakim_text.= "Hakim Tunggal: ".$data_hakim->nama_gelar;
							$jabatan_hakim_nama = "Hakim Tunggal";
							$jabatan_hakim_id = 3;
						}
					break;
					case 1:
						$hakim_text.= "Hakim Anggota 1: ".$data_hakim->nama_gelar;
						$jabatan_hakim_nama = "Hakim Anggota";
						$jabatan_hakim_id = 2;
					break;
					case 2:
						$hakim_text.= "Hakim Anggota 2: ".$data_hakim->nama_gelar;
						$jabatan_hakim_nama = "Hakim Anggota";
						$jabatan_hakim_id = 2;
					break;
					case 3:
						$hakim_text.= "Hakim Anggota 3: ".$data_hakim->nama_gelar;
						$jabatan_hakim_nama = "Hakim Anggota";
						$jabatan_hakim_id = 2;
					break;
					case 4:
						$hakim_text.= "Hakim Anggota 4: ".$data_hakim->nama_gelar;
						$jabatan_hakim_nama = "Hakim Anggota";
						$jabatan_hakim_id = 2;
					break;
				}
				if ($i<>(count($arr_hakim)-1)){
					$hakim_kode.="|";
					$hakim_nama.="</br>";
					$hakim_text.="</br>";
				}
				
				$data_insert[]=array(
					'id'=>$last_id,
					'perkara_id'=>$perkara_id,
					'tanggal_penetapan'=>$tgl_penetapan,
					'urutan'=>$i+1,
					'jabatan_hakim_id'=>$jabatan_hakim_id,
					'jabatan_hakim_nama'=>$jabatan_hakim_nama,
					'hakim_id'=>$arr_hakim[$i],
					'hakim_kode'=>$data_hakim->kode,
					'hakim_nip'=>$data_hakim->nip,
					'hakim_nama'=>$data_hakim->nama_gelar,
					'aktif'=>'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s'),
					'keterangan'=>$this->keterangan
				);
				$last_id++;
			}
			$data = array(
				'perkara_id'=>$perkara_id,
				'jenis_acara'=>$jenis_acara,
				'penetapan_majelis_hakim'=>$tgl_penetapan,
				'majelis_hakim_id'=>$majelis_hakim_id,
				'majelis_hakim_kode'=>$hakim_kode,
				'majelis_hakim_nama'=>$hakim_nama,
				'majelis_hakim_text'=>$hakim_text,
				'diinput_oleh'=>$this->session->userdata('username'),
				'diinput_tanggal'=>date('Y-m-d H:i:s')
			);
			$namatabel="perkara_penetapan";
			$primarykey="perkara_id";
			$this->db->insert($namatabel, $data);
			$title = "INSERT table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey."=".$data['perkara_id']."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("INSERT",$title,$descrip,$namatabel,$namahalaman);
		
			//insert table perkara_hakim_pn
			$namatabel="perkara_hakim_pn";
			$primarykey="perkara_id";
			$this->db->insert_batch($namatabel, $data_insert);
			for ($i=0;$i<count($data_insert);$i++){
				$title = "INSERT table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey."=".$data_insert[$i]['perkara_id']."]";
				$descrip = $this->fetch_description($title,$data_insert[$i]);
				$this->add_audittrail("INSERT",$title,$descrip,$namatabel,$namahalaman);
			}			
		} catch (Exception $e) {
			return '';
		}
	}
	
	function edit_penetapan_majelis($perkara_id, $jenis_acara, $tgl_penetapan, $majelis_hakim_id, $majelis_sebelumnya_id='', $penetapan_kembali=0, $namahalaman){
		try {
			$arr_hakim = explode(",", $this->hakim_id);
			$last_id = $this->get_last_id();
			$arr_hakim_sebelumnya = explode(",", $majelis_sebelumnya_id);
			$hakim_kode='';$hakim_nama='';$hakim_text='';
			$data_update=array();
			$data_insert=array();
			for ($i=0;$i<(count($arr_hakim));$i++){
				$data_hakim = $this->db->query("SELECT id, kode, nip, nama, nama_gelar FROM hakim_pn where id = ".$arr_hakim[$i].";")->row(0);
				
				$hakim_kode.=$data_hakim->kode;
				$hakim_nama .= $data_hakim->nama;
				switch ($i){
					case 0:
						if ($this->input->post('pilihan_majelis')==='majelis'){
							$hakim_text.= "Hakim Ketua: ".$data_hakim->nama_gelar;
							$jabatan_hakim_nama = "Hakim Ketua";
							$jabatan_hakim_id = 1;
						}else{
							$hakim_text.= "Hakim Tunggal: ".$data_hakim->nama_gelar;
							$jabatan_hakim_nama = "Hakim Tunggal";
							$jabatan_hakim_id = 3;
						}
					break;
					case 1:
						$hakim_text.= "Hakim Anggota 1: ".$data_hakim->nama_gelar;
						$jabatan_hakim_nama = "Hakim Anggota";
						$jabatan_hakim_id = 2;
					break;
					case 2:
						$hakim_text.= "Hakim Anggota 2: ".$data_hakim->nama_gelar;
						$jabatan_hakim_nama = "Hakim Anggota";
						$jabatan_hakim_id = 2;
					break;
					case 3:
						$hakim_text.= "Hakim Anggota 3: ".$data_hakim->nama_gelar;
						$jabatan_hakim_nama = "Hakim Anggota";
						$jabatan_hakim_id = 2;
					break;
					case 4:
						$hakim_text.= "Hakim Anggota 4: ".$data_hakim->nama_gelar;
						$jabatan_hakim_nama = "Hakim Anggota";
						$jabatan_hakim_id = 2;
					break;
				}
				if ($i<>(count($arr_hakim)-1)){
					$hakim_kode.="|";
					$hakim_nama.="</br>";
					$hakim_text.="</br>";
				}
				if (array_key_exists($i, $arr_hakim_sebelumnya)){
					$data_update[]=array(
						'id'=> $arr_hakim_sebelumnya[$i],
						'perkara_id'=>$perkara_id,
						'tanggal_penetapan'=>$tgl_penetapan,
						'urutan'=>$i+1,
						'jabatan_hakim_id'=>$jabatan_hakim_id,
						'jabatan_hakim_nama'=>$jabatan_hakim_nama,
						'hakim_id'=>$arr_hakim[$i],
						'hakim_kode'=>$data_hakim->kode,
						'hakim_nip'=>$data_hakim->nip,
						'hakim_nama'=>$data_hakim->nama_gelar,
						'aktif'=>'Y',
						'diperbaharui_oleh'=>$this->session->userdata('username'),
						'diperbaharui_tanggal'=>date('Y-m-d H:i:s'),
						'keterangan'=>$this->keterangan
					);
				}else{
					$data_insert[]=array(
						'id'=>$last_id,
						'perkara_id'=>$perkara_id,
						'tanggal_penetapan'=>$tgl_penetapan,
						'urutan'=>$i+1,
						'jabatan_hakim_id'=>$jabatan_hakim_id,
						'jabatan_hakim_nama'=>$jabatan_hakim_nama,
						'hakim_id'=>$arr_hakim[$i],
						'hakim_kode'=>$data_hakim->kode,
						'hakim_nip'=>$data_hakim->nip,
						'hakim_nama'=>$data_hakim->nama_gelar,
						'aktif'=>'Y',
						'diinput_oleh'=>$this->session->userdata('username'),
						'diinput_tanggal'=>date('Y-m-d H:i:s')
					);
					$last_id++;
				}
			}
			$data = array(
				'perkara_id'=>$perkara_id,
				'jenis_acara'=>$jenis_acara,
				'penetapan_majelis_hakim'=>$tgl_penetapan,
				'majelis_hakim_id'=>$majelis_hakim_id,
				'majelis_hakim_kode'=>$hakim_kode,
				'majelis_hakim_nama'=>$hakim_nama,
				'majelis_hakim_text'=>$hakim_text,
				'diperbaharui_oleh'=>$this->session->userdata('username'),
				'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
			);
			$namatabel="perkara_penetapan";
			$primarykey="perkara_id";
			$this->db->where($primarykey, $perkara_id);
			$this->db->update($namatabel, $data);
			$title = "UPDATE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey."=".$data['perkara_id']."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("UPDATE",$title,$descrip,$namatabel,$namahalaman);

			//update table perkara_hakim_pn
			foreach ($data_update as $row) {
				$namatabel="perkara_hakim_pn";
				$primarykey="id";
				$this->db->where($primarykey, $row['id']);	
				$this->db->update($namatabel, $row);
				$title = "UPDATE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey."=".$row['perkara_id']."]";
				$descrip = $this->fetch_description($title,$row);
				$this->add_audittrail("UPDATE",$title,$descrip,$namatabel,$namahalaman);
			}

			//insert table perkara_hakim_pn jika ada penambahan jumlah majelis hakim
			$namatabel="perkara_hakim_pn";
			$primarykey="perkara_id";
			if (!empty($data_insert)){
				$this->db->insert_batch($namatabel, $data_insert);
				for ($i=0;$i<count($data_insert);$i++){
					$title = "INSERT table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey."=".$data_insert[$i]['perkara_id']."]";
					$descrip = $this->fetch_description($title,$data_insert[$i]);
					$this->add_audittrail("INSERT",$title,$descrip,$namatabel,$namahalaman);
				}
			}

			//delete row perkara_hakim_pn jika ada pengurangan jumlah majelis
			$namatabel="perkara_hakim_pn";
			$primarykey1="id";
			$primarykey2="perkara_id";
			if (count($arr_hakim)<count($arr_hakim_sebelumnya)){
				for ($i=0;$i<(count($arr_hakim_sebelumnya));$i++){
					if (!array_key_exists($i, $arr_hakim)){
						//$data_delete[]=$arr_hakim_sebelumnya[$i];
						$this->db->where($primarykey1, $arr_hakim_sebelumnya[$i]);
						$this->db->where($primarykey2, $perkara_id);
						$this->db->delete($namatabel); 
						$title = "DELETE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey1."=".$arr_hakim_sebelumnya[$i]."]";
						$descrip = '';
						$this->add_audittrail("DELETE",$title,$descrip,$namatabel,$namahalaman);
					}
				}
			}
		} catch (Exception $e) {
			return '';
		}
	}
	
	function update_perkara_penetapan($id_perkara,$namahalaman){
		try {
			$arr_hakim = explode(",", $this->hakim_id);
			$last_id = $this->get_last_id();
			$hakim_kode='';$hakim_nama='';$hakim_text='';
			$data_insert=array();
			for ($i=0;$i<(count($arr_hakim));$i++){
				$data_hakim = $this->db->query("SELECT id, kode, nip, nama, nama_gelar FROM hakim_pn where id = ".$arr_hakim[$i].";")->row(0);
				
				$hakim_kode.=$data_hakim->kode;
				$hakim_nama .= $data_hakim->nama_gelar;
				
				switch ($i){
					case 0:
						if ($this->input->post('pilihan_majelis')==='majelis'){
							$hakim_text.= "Hakim Ketua: ".$data_hakim->nama_gelar;
							$jabatan_hakim_nama = "Hakim Ketua";
							$jabatan_hakim_id = 1;
						}else{
							$hakim_text.= "Hakim Tunggal: ".$data_hakim->nama_gelar;
							$jabatan_hakim_nama = "Hakim Tunggal";
							$jabatan_hakim_id = 3;
						}
					break;
					case 1:
						$hakim_text.= "Hakim Anggota 1: ".$data_hakim->nama_gelar;
						$jabatan_hakim_nama = "Hakim Anggota";
						$jabatan_hakim_id = 2;
					break;
					case 2:
						$hakim_text.= "Hakim Anggota 2: ".$data_hakim->nama_gelar;
						$jabatan_hakim_nama = "Hakim Anggota";
						$jabatan_hakim_id = 2;
					break;
					case 3:
						$hakim_text.= "Hakim Anggota 3: ".$data_hakim->nama_gelar;
						$jabatan_hakim_nama = "Hakim Anggota";
						$jabatan_hakim_id = 2;
					break;
					case 4:
						$hakim_text.= "Hakim Anggota 4: ".$data_hakim->nama_gelar;
						$jabatan_hakim_nama = "Hakim Anggota";
						$jabatan_hakim_id = 2;
					break;
				}
				if ($i<>(count($arr_hakim)-1)){
					$hakim_kode.="|";
					$hakim_nama.="</br>";
					$hakim_text.="</br>";
				}
				$data_insert[]=array(
							'id'=>$last_id,
						     'perkara_id'=>$id_perkara,
						     'tanggal_penetapan'=>$this->tgl_penetapan_majelis,
						     'urutan'=>$i+1,
						     'jabatan_hakim_id'=>$jabatan_hakim_id,
						     'jabatan_hakim_nama'=>$jabatan_hakim_nama,
						     'hakim_id'=>$arr_hakim[$i],
						     'hakim_kode'=>$data_hakim->kode,
						     'hakim_nip'=>$data_hakim->nip,
						     'hakim_nama'=>$data_hakim->nama,
						     'aktif'=>'Y',
						     'diinput_oleh'=>$this->session->userdata('username'),
						     'diinput_tanggal'=>date('Y-m-d H:i:s'),
						     'keterangan'=>$this->keterangan
						);
				$last_id++;
			}
			
			$data = array(
				'jenis_acara' => $this->jenis_acara,
				'penetapan_majelis_hakim' => $this->tgl_penetapan_majelis,
				'majelis_hakim_id' => $this->hakim_id,
				'majelis_hakim_kode' => $hakim_kode,
				'majelis_hakim_nama' => $hakim_nama,
				'majelis_hakim_text' => $hakim_text
			);
			$namatabel="perkara_penetapan";
			$primarykey="perkara_id";
			$this->db->where($primarykey, $id_perkara);
			$this->db->update($namatabel, $data);
			$title = "UPDATE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey."=".$id_perkara."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("UPDATE",$title,$descrip,$namatabel,$namahalaman);
			
			$data = array(
				'aktif' => 'T',
				'tanggal_tidak_aktif' => $this->tgl_penetapan_majelis,
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date('Y-m-d H:i:s')
			);
			$namatabel="perkara_hakim_pn";
			$primarykey="perkara_id";
			$this->db->where($primarykey, $id_perkara);
			$this->db->where('aktif', 'Y');
			$this->db->update($namatabel, $data);
			$title = "UPDATE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Foreign Key [".$primarykey."=".$id_perkara."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("UPDATE",$title,$descrip,$namatabel,$namahalaman);
			
			$namatabel="perkara_hakim_pn";
			$primarykey="perkara_id";
			$this->db->insert_batch('perkara_hakim_pn', $data_insert);
			for ($i=0;$i<count($data_insert);$i++){
				$title = "INSERT table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Foreign Key [".$primarykey."=".$data_insert[$i]['perkara_id']."]";
				$descrip = $this->fetch_description($title,$data_insert[$i]);
				$this->add_audittrail("INSERT",$title,$descrip,$namatabel,$namahalaman);
			}
		} catch (Exception $e) {
			return '';
		}
	}
	
	function get_jumlah_tanggal_input($idperkara){
		try {
			return $this->db->query("SELECT DISTINCT(diinput_tanggal) AS tanggal, tanggal_penetapan
				FROM perkara_hakim_pn 
				WHERE perkara_id = ".$idperkara." AND tahapan_id=10 ORDER BY id DESC;");
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function get_tanggal_input($idperkara){
		try {
			return $this->db->query("SELECT DISTINCT(diinput_tanggal) AS tanggal,urutan,id,aktif
				FROM perkara_hakim_pn 
				WHERE perkara_id = ".$idperkara." AND tahapan_id=10 ORDER BY id DESC;");
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function get_tanggal_penetapan($idperkara){
		try {
			return $this->db->query("SELECT penetapan_panitera_pengganti, penetapan_jurusita, penetapan_hari_sidang 
				FROM perkara_penetapan  
				WHERE perkara_id = ".$idperkara.";");
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function get_jumlah_sidang($idperkara){
		try {
			$result = $this->db->query("SELECT count(*) As jmlh 
				FROM perkara_jadwal_sidang  
				WHERE keberatan='T' AND perkara_id = ".$idperkara.";");
			if($result->num_rows>0){
				return $result->row()->jmlh;
			}else{
				return 0;
			}
		} catch (Exception $e) {
			return 0;
		}
	}

	function get_tahapan($idperkara){
		try {
			$result = $this->db->query("SELECT tahapan_terakhir_id
				FROM perkara  
				WHERE perkara_id = ".$idperkara.";");
			if($result->num_rows>0){
				return $result->row()->tahapan_terakhir_id;
			}else{
				return 0;
			}
		} catch (Exception $e) {
			return 0;
		}
	}

	function hapus_penetapan($idperkara,$oldid,$newid,$namahalaman){
		try {
			$idhapus = '';

			$namatabel="perkara_hakim_pn";
			$primarykey1="id";
			$primarykey2="perkara_id";
			foreach ($oldid as $id){
				$this->db->where($primarykey1,$id);
				$this->db->where($primarykey2,$idperkara);
				$this->db->delete($namatabel);
				$idhapus .= $id.',';
			}
			$title = "DELETE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey1."=".$idhapus."]";
			$descrip = '';
			$this->add_audittrail("DELETE",$title,$descrip,$namatabel,$namahalaman);

			$idupdate = '';
			$namatabel="perkara_hakim_pn";
			$primarykey1="id";
			$primarykey2="perkara_id";
			foreach ($newid as $id){
				$data = '';
				$this->db->where($primarykey1,$id);
				$this->db->where($primarykey2,$idperkara);
				$data = array(
					'aktif'=>'Y',
					'diperbaharui_oleh'=>$this->session->userdata('username'),
					'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
					);
				$this->db->update($namatabel,$data);
				$idupdate .= $id.',';
				$title = "UPDATE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey1."=".$idupdate."]";
				$descrip = $this->fetch_description($title,$data);
				$this->add_audittrail("UPDATE",$title,$descrip,$namatabel,$namahalaman);
			}

			
			$data = '';
			$datahakim = $this->get_data_majelis_detail($idperkara);
			if(!empty($datahakim)){
				$hakimtext = "";
				$hakimnama = "";
				$hakimid = "";
				$majeliskode = "";
				$jmlh = count($datahakim);
				$i = 0;
				$data = array(
					'diperbaharui_oleh'=>$this->session->userdata('username'),
					'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
					);
				foreach ($datahakim as $row) {
					$hakimtext .= $row['jabatan_hakim_nama'].':'.$row['hakim_nama'];
					$hakimnama .= $row['hakim_nama'];
					$hakimid .= $row['hakim_id'];
					$majeliskode .= $row['hakim_kode'];
					$i++;
					if($i!=$jmlh){
						$hakimtext .= '</br>';
						$hakimnama .= '</br>';
						$hakimid .= ',';
						$majeliskode .= '||';
					}
					$data['penetapan_majelis_hakim'] = $row['tanggal_penetapan'];
					if(!empty($row['nomor_sk_penetapan'])){
						$data['nomor_sk_penetapan_majelis_hakim'] = $row['nomor_sk_penetapan'];
					}
				}
				$data['majelis_hakim_text'] = $hakimtext;
				$data['majelis_hakim_nama'] = $hakimnama;
				$data['majelis_hakim_id'] = $hakimid;
				$data['majelis_hakim_kode'] = $majeliskode;
				
				$namatabel="perkara_penetapan";
				$primarykey="perkara_id";
				$this->db->where($primarykey,$idperkara);
				$this->db->update($namatabel,$data);

				$title = "UPDATE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey."=".$idperkara."]";
				$descrip = $this->fetch_description($title,$data);
				$this->add_audittrail("UPDATE",$title,$descrip,$namatabel,$namahalaman);

			}
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function hapus_all_penetapan($idperkara,$namahalaman){
		try {
			$namatabel="perkara_hakim_pn";
			$primarykey1="perkara_id";
			$primarykey2="tahapan_id";
			$this->db->where('perkara_id',$idperkara);
			$this->db->where('tahapan_id',10);
			$this->db->delete('perkara_hakim_pn');

			$title = "DELETE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Foreign Key [".$primarykey1."=".$idperkara." & ".$primarykey2."=10]";
			$descrip = '';
			$this->add_audittrail("DELETE",$title,$descrip,$namatabel,$namahalaman);

			$namatabel="perkara_penetapan";
			$primarykey="perkara_id";
			$this->db->where('perkara_id',$idperkara);
			$this->db->delete('perkara_penetapan');

			$title = "DELETE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Foreign Key [".$primarykey."=".$idperkara."]";
			$descrip = '';
			$this->add_audittrail("DELETE",$title,$descrip,$namatabel,$namahalaman);
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}
	
	function add_audittrail($action,$title,$descrip,$tablename,$namahalaman){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => $namahalaman,
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			
		}
	}
}
?>