<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class add_juru_sita_m extends CI_Model{
	
	function get_data_juru_sita_aktif(){
		try {
			$query = $this->db->query("SELECT id, IF(nama_gelar ='',nama,nama_gelar) AS nama_gelar
				FROM jurusita 
				WHERE aktif='Y' order by nama_gelar ASC;");
			return $query->result_array();
		} catch (Exception $e) {
			return '';
		}
	}
	
	function get_last_id(){
		try {
			$query = $this->db->query("SELECT (ifnull(max(id),0)) +1 AS last_id 
				FROM perkara_jurusita;");
			if($query->num_rows>0){
				foreach ($query->result() as $row) {
					return $row->last_id;
				}
	    	}else{
	    		return 0;
	    	}
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_no_perkara($perkara_id){
		try {
			$query = $this->db->query("SELECT nomor_perkara, alur_perkara_id, tanggal_pendaftaran
				FROM perkara 
				WHERE perkara_id='".$perkara_id."';");
			return $query->result_array();
		} catch (Exception $e) {
			return '';
		}
	}
	
	function get_data_penetapan($perkara_id){
		try {
			$query = $this->db->query("SELECT perkara_id, penetapan_majelis_hakim, majelis_hakim_id, majelis_hakim_text,
				penetapan_panitera_pengganti, panitera_pengganti_id, panitera_pengganti_text,
				penetapan_jurusita, jurusita_id, jurusita_text
				FROM perkara_penetapan 
				WHERE perkara_id='".$perkara_id."';");
			return $query->result_array();
		} catch (Exception $e) {
			return '';
		}
	}
	function get_penetapan_panitera($perkara_id){
		try {
			$query = $this->db->query("SELECT penetapan_panitera_pengganti, penetapan_jurusita
				FROM v_perkara 
				WHERE perkara_id='".$perkara_id."';");
			return $query->row(0);
		} catch (Exception $e) {
			return '';
		}
	}
	
	function get_data_juru_sita_detail($perkara_id){
		try {
			$query = $this->db->query("SELECT *
				FROM perkara_jurusita
				WHERE tahapan_id=10 AND perkara_id='".$perkara_id."' and aktif='Y';");
			return $query->result_array();
		} catch (Exception $e) {
			return '';
		}
	}
	
	function insert_penunjukan_juru_sita($perkara_id, $tgl_penunjukan,$namahalaman){
		try {
			$arr_juru_sita = explode(",", $this->juru_sita_id);
			$last_id = $this->get_last_id();
			$juru_sita_kode='';$juru_sita_text='';
			$data_insert=array();
			for ($i=0;$i<(count($arr_juru_sita));$i++){
				$data_juru_sita = $this->db->query("SELECT id, kode, nip, nama, nama_gelar FROM jurusita where id = ".$arr_juru_sita[$i].";")->row(0);
				
				$juru_sita_kode .= $data_juru_sita->kode;
				switch ($i){
					case 0:
						$juru_sita_text.= "Juru Sita Pengganti: ".$data_juru_sita->nama_gelar;
					break;
					case 1:
						$juru_sita_text.= "Juru Sita Pengganti 2: ".$data_juru_sita->nama_gelar;
					break;
					case 2:
						$juru_sita_text.= "Juru Sita Pengganti 3: ".$data_juru_sita->nama_gelar;
					break;
				}
				if ($i<>(count($arr_juru_sita)-1)){
					$juru_sita_kode.="|";
					$juru_sita_text.="</br>";
				}
				
				$data_insert[]=array(
					'id'=>$last_id,
					'perkara_id'=>$perkara_id,
					'tanggal_penetapan'=>$tgl_penunjukan,
					'urutan'=>$i+1,
					'jurusita_id'=>$arr_juru_sita[$i],
					'jurusita_kode'=>$data_juru_sita->kode,
					'jurusita_nip'=>$data_juru_sita->nip,
					'jurusita_nama'=>$data_juru_sita->nama,
					'aktif'=>'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
				);
				$last_id++;
			}
			$data = array(
				'penetapan_jurusita'=>$tgl_penunjukan,
				'jurusita_id'=>$this->juru_sita_id,
				'jurusita_text'=>$juru_sita_text
			);
			//update perkara penetapan
			$namatabel="perkara_penetapan";
			$primarykey="perkara_id";
			$this->db->where($primarykey, $perkara_id);
			$this->db->update($namatabel, $data);
			$title = "UPDATE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey."=".$perkara_id."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("UPDATE",$title,$descrip,$namatabel,$namahalaman);
			
			
			//insert perkara_juru_sita_pn
			$namatabel="perkara_jurusita";
			$primarykey="perkara_id";
			$this->db->insert_batch($namatabel, $data_insert);
			for ($i=0;$i<count($data_insert);$i++){
				$title = "INSERT table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Foreign Key [".$primarykey."=".$data_insert[$i]['perkara_id']."]";
				$descrip = $this->fetch_description($title,$data_insert[$i]);
				$this->add_audittrail("INSERT",$title,$descrip,$namatabel,$namahalaman);
			}
			
			
			//update perkara
			// $data = array(
				// 'tahapan_terakhir_id'=>12,
				// 'tahapan_terakhir_text'=>'Penetapan',
				// 'proses_terakhir_id'=>40,
				// 'proses_terakhir_text'=>'Penunjukan Jurusita'
			// );
			// $this->db->where('perkara_id', $perkara_id);
			// $this->db->where('proses_terakhir_id <', '41');
			// if($this->db->update('perkara', $data)){
				// $title = "Update table <b>perkara</b> dari halaman <b>Penetapan Majelis Hakim</b> dengan Primary Key [perkara_id=".$perkara_id."]";
				// $descrip = $this->fetch_description($title,$data);
				// $this->add_audittrail("UPDATE",$title,$descrip,'perkara');
			// };
			
			//insert tabel perkara_proses
			// $data = array(
				// 'perkara_id'=>$perkara_id,
				// 'tahapan_id'=>'12',
				// 'tahapan_nama'=>'Penetapan',
				// 'proses_id'=>'40',
				// 'proses_nama'=>'Penunjukan Jurusita',
				// 'tanggal'=>$tgl_penunjukan,
				// 'diinput_oleh'=>$this->session->userdata('username'),
				// 'diinput_tanggal'=>date('Y-m-d H:i:s')
			// );
			// $this->db->replace('perkara_proses', $data);
			return true;
		} catch (Exception $e) {
			return false;
		}
	}

	function update_penunjukan_juru_sita($perkara_id, $tgl_penunjukan, $jurusita_sebelumnya_id='', $penunjukan_kembali=0, $namahalaman){
		try {
			$arr_juru_sita = explode(",", $this->juru_sita_id);
			$arr_juru_sita_sebelumnya = explode(",", $jurusita_sebelumnya_id);
			$last_id = $this->get_last_id();
			$juru_sita_kode='';$juru_sita_text='';
			$data_insert=array();
			for ($i=0;$i<(count($arr_juru_sita));$i++){
				$data_juru_sita = $this->db->query("SELECT id, kode, nip, nama, nama_gelar FROM jurusita where id = ".$arr_juru_sita[$i].";")->row(0);
				
				$juru_sita_kode .= $data_juru_sita->kode;
				switch ($i){
					case 0:
						$juru_sita_text.= "Jurusita: ".$data_juru_sita->nama_gelar;
					break;
					case 1:
						$juru_sita_text.= "Jurusita 2: ".$data_juru_sita->nama_gelar;
					break;
					case 2:
						$juru_sita_text.= "Jurusita 3: ".$data_juru_sita->nama_gelar;
					break;
				}
				if ($i<>(count($arr_juru_sita)-1)){
					$juru_sita_kode.="|";
					$juru_sita_text.="</br>";
				}
				
				if (array_key_exists($i, $arr_juru_sita_sebelumnya)){
					$data_update[]=array(
						'id'=>$arr_juru_sita_sebelumnya[$i],
						'perkara_id'=>$perkara_id,
						'tanggal_penetapan'=>$tgl_penunjukan,
						'urutan'=>$i+1,
						'jurusita_id'=>$arr_juru_sita[$i],
						'jurusita_kode'=>$data_juru_sita->kode,
						'jurusita_nip'=>$data_juru_sita->nip,
						'jurusita_nama'=>$data_juru_sita->nama,
						'aktif'=>'Y',
						'diperbaharui_oleh'=>$this->session->userdata('username'),
						'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
					);

				}else{
					$data_insert[]=array(
						'id'=>$last_id,
						'perkara_id'=>$perkara_id,
						'tanggal_penetapan'=>$tgl_penunjukan,
						'urutan'=>$i+1,
						'jurusita_id'=>$arr_juru_sita[$i],
						'jurusita_kode'=>$data_juru_sita->kode,
						'jurusita_nip'=>$data_juru_sita->nip,
						'jurusita_nama'=>$data_juru_sita->nama,
						'aktif'=>'Y',
						'diinput_oleh'=>$this->session->userdata('username'),
						'diinput_tanggal'=>date('Y-m-d H:i:s')
					);
					$last_id++;
				}				
				
			}
			$data = array(
				'jurusita_id'=>$this->juru_sita_id,
				'penetapan_jurusita'=>$tgl_penunjukan,
				'jurusita_text'=>$juru_sita_text
			);

			//update perkara penetapan
			$namatabel="perkara_penetapan";
			$primarykey="perkara_id";
			$this->db->where('perkara_id', $perkara_id);
			$this->db->update('perkara_penetapan', $data);
			$title = "UPDATE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey."=".$perkara_id."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("UPDATE",$title,$descrip,$namatabel,$namahalaman);
			
			//update table perkara_jurusita
			$namatabel="perkara_jurusita";
			$primarykey="id";
			foreach ($data_update as $row) {
				$this->db->where('id', $row['id']);	
				$this->db->update('perkara_jurusita', $row);
				$title = "UPDATE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey."=".$row['id']."]";
				$descrip = $this->fetch_description($title,$row);
				$this->add_audittrail("UPDATE",$title,$descrip,$namatabel,$namahalaman);
			}
			//insert table perkara_jurusita jika ada penambahan jumlah jurusita
			$namatabel="perkara_jurusita";
			$primarykey="perkara_id";
			if (!empty($data_insert)){
				$this->db->insert_batch($namatabel, $data_insert);
				for ($i=0;$i<count($data_insert);$i++){
					$title = "INSERT table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Foreign Key [".$primarykey."=".$data_insert[$i]['perkara_id']."]";
					$descrip = $this->fetch_description($title,$data_insert[$i]);
					$this->add_audittrail("INSERT",$title,$descrip,$namatabel,$namahalaman);
				}
			}
			//delete row perkara_jurusita jika ada pengurangan jumlah jurusita
			if (count($arr_juru_sita)<count($arr_juru_sita_sebelumnya)){
				for ($i=0;$i<(count($arr_juru_sita_sebelumnya));$i++){
					if (!array_key_exists($i, $arr_juru_sita)){
						$namatabel="perkara_jurusita";
						$primarykey1="id";
						$primarykey2="perkara_id";
						$this->db->where($primarykey1, $arr_juru_sita_sebelumnya[$i]);
						$this->db->where($primarykey2, $perkara_id);
						$this->db->delete($namatabel); 
						$title = "DELETE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey1."=".$arr_juru_sita_sebelumnya[$i]."]";
						$descrip = '';
						$this->add_audittrail("DELETE",$title,$descrip,$namatabel,$namahalaman);
					}
				}
			}

			//update tabel perkara_proses
			// $data = array(
				// 'perkara_id'=>$perkara_id,
				// 'tahapan_id'=>'12',
				// 'tahapan_nama'=>'Penetapan',
				// 'proses_id'=>'40',
				// 'proses_nama'=>'Penunjukan Jurusita',
				// 'tanggal'=>$tgl_penunjukan,
				// 'diinput_oleh'=>$this->session->userdata('username'),
				// 'diinput_tanggal'=>date('Y-m-d H:i:s')
			// );
			// if ($penunjukan_kembali==1){
				// $data['proses_id']='41';
				// $data['proses_nama']='Penunjukan Kembali Jurusita';
			// }
			// $this->db->replace('perkara_proses', $data);

			return true;
		} catch (Exception $e) {
			return false;
		}
	}

	function insert_penunjukan_kembali_juru_sita($perkara_id, $tgl_penunjukan,$namahalaman){
		try {
			$arr_juru_sita = explode(",", $this->juru_sita_id);
			$last_id = $this->get_last_id();
			$juru_sita_kode='';$juru_sita_text='';
			$data_insert=array();
			for ($i=0;$i<(count($arr_juru_sita));$i++){
				$data_juru_sita = $this->db->query("SELECT id, kode, nip, nama, nama_gelar FROM jurusita where id = ".$arr_juru_sita[$i].";")->row(0);
				
				$juru_sita_kode .= $data_juru_sita->kode;
				switch ($i){
					case 0:
						$juru_sita_text.= "Jurusita: ".$data_juru_sita->nama_gelar;
					break;
					case 1:
						$juru_sita_text.= "Jurusita 2: ".$data_juru_sita->nama_gelar;
					break;
					case 2:
						$juru_sita_text.= "Jurusita 3: ".$data_juru_sita->nama_gelar;
					break;
				}
				if ($i<>(count($arr_juru_sita)-1)){
					$juru_sita_kode.="|";
					$juru_sita_text.="</br>";
				}
				
				$data_insert[]=array(
					'id'=>$last_id,
					'perkara_id'=>$perkara_id,
					'tanggal_penetapan'=>$tgl_penunjukan,
					'urutan'=>$i+1,
					'jurusita_id'=>$arr_juru_sita[$i],
					'jurusita_kode'=>$data_juru_sita->kode,
					'jurusita_nip'=>$data_juru_sita->nip,
					'jurusita_nama'=>$data_juru_sita->nama,
					'aktif'=>'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
				);
				$last_id++;
			}
			$data = array(
				'penetapan_jurusita' => $tgl_penunjukan,
				'jurusita_id'=>$this->juru_sita_id,
				'jurusita_text'=>$juru_sita_text
			);
			//update perkara penetapan
			$namatabel="perkara_penetapan";
			$primarykey="perkara_id";
			$this->db->where($primarykey, $perkara_id);
			$this->db->update($namatabel, $data);
			$title = "UPDATE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey."=".$perkara_id."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("UPDATE",$title,$descrip,$namatabel,$namahalaman);
			
			//update perkara_juru_sita_pn
			$data = array(
				'aktif' => 'T',
				'tanggal_tidak_aktif' => $tgl_penunjukan,
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date('Y-m-d H:i:s')
			);
			$namatabel="perkara_jurusita";
			$primarykey="perkara_id";
			$this->db->where($primarykey, $perkara_id);
			$this->db->where('aktif', 'Y');
			$this->db->update($namatabel, $data);
			$title = "UPDATE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Foreign Key [".$primarykey."=".$perkara_id."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("UPDATE",$title,$descrip,$namatabel,$namahalaman);

			//insert perkara_juru_sita_pn
			$namatabel="perkara_jurusita";
			$primarykey="perkara_id";
			$this->db->insert_batch($namatabel, $data_insert);
			for ($i=0;$i<count($data_insert);$i++){
				$title = "INSERT table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Foreign Key [".$primarykey."=".$data_insert[$i]['perkara_id']."]";
				$descrip = $this->fetch_description($title,$data_insert[$i]);
				$this->add_audittrail("INSERT",$title,$descrip,$namatabel,$namahalaman);
			}
			
			//update perkara
			// $data = array(
				// 'tahapan_terakhir_id'=>12,
				// 'tahapan_terakhir_text'=>'Penetapan',
				// 'proses_terakhir_id'=>41,
				// 'proses_terakhir_text'=>'Penunjukan Kembali Jurusita'
			// );
			// $this->db->where('perkara_id', $perkara_id);
			// $this->db->where('proses_terakhir_id <', '41');
			// if($this->db->update('perkara', $data)){
				// $title = "Update table <b>perkara</b> dari halaman <b>Penetapan Majelis Hakim</b> dengan Primary Key [perkara_id=".$perkara_id."]";
				// $descrip = $this->fetch_description($title,$data);
				// $this->add_audittrail("UPDATE",$title,$descrip,'perkara');
			// };
			
			//insert tabel perkara_proses
			// $data = array(
				// 'perkara_id'=>$perkara_id,
				// 'tahapan_id'=>'12',
				// 'tahapan_nama'=>'Penetapan',
				// 'proses_id'=>'41',
				// 'proses_nama'=>'Penunjukan Kembali Jurusita',
				// 'tanggal'=>$tgl_penunjukan,
				// 'diinput_oleh'=>$this->session->userdata('username'),
				// 'diinput_tanggal'=>date('Y-m-d H:i:s')
			// );
			// $this->db->replace('perkara_proses', $data);
		} catch (Exception $e) {
			return '';
		}
	}
	
	function get_tanggal_input($idperkara){
		try {
			return $this->db->query("SELECT DISTINCT(diinput_tanggal) AS tanggal,urutan,id,aktif
				FROM perkara_jurusita 
				WHERE perkara_id = ".$idperkara." AND tahapan_id=10 ORDER BY id DESC;");
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function get_jumlah_tanggal_input($idperkara){
		try {
			return $this->db->query("SELECT DISTINCT(diinput_tanggal) AS tanggal, tanggal_penetapan
				FROM perkara_jurusita 
				WHERE perkara_id = ".$idperkara." AND tahapan_id=10 ORDER BY id DESC;");
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function get_tanggal_penetapan($idperkara){
		try {
			$result = $this->db->query("SELECT penetapan_jurusita
				FROM perkara_penetapan  
				WHERE perkara_id = ".$idperkara.";");
			if($result->num_rows>0){
				return $result->row()->penetapan_jurusita;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function get_tanggal_penetapan_sidang_pertama($idperkara){
		try {
			$result = $this->db->query("SELECT penetapan_hari_sidang
				FROM perkara_penetapan  
				WHERE perkara_id = ".$idperkara.";");
			if($result->num_rows>0){
				return $result->row()->penetapan_hari_sidang;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function get_jumlah_sidang($idperkara){
		try {
			$result = $this->db->query("SELECT count(*) As jmlh 
				FROM perkara_jadwal_sidang  
				WHERE keberatan='T' AND perkara_id = ".$idperkara.";");
			if($result->num_rows>0){
				return $result->row()->jmlh;
			}else{
				return 0;
			}
		} catch (Exception $e) {
			return 0;
		}
	}

	function get_tahapan($idperkara){
		try {
			$result = $this->db->query("SELECT tahapan_terakhir_id
				FROM perkara  
				WHERE perkara_id = ".$idperkara.";");
			if($result->num_rows>0){
				return $result->row()->tahapan_terakhir_id;
			}else{
				return 0;
			}
		} catch (Exception $e) {
			return 0;
		}
	}

	function hapus_penetapan($idperkara,$oldid,$newid,$namahalaman){
		try {
			$idhapus = '';
			$namatabel="perkara_jurusita";
			$primarykey="perkara_id";
			foreach ($oldid as $id) {
				$this->db->where($primarykey,$idperkara);
				$this->db->where('id',$id);
				$this->db->delete($namatabel);
				$idhapus .= $id.',';
			}
			
			$title = "DELETE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Foreign Key [".$primarykey."=".$idhapus."]";
			$descrip = '';
			$this->add_audittrail("DELETE",$title,$descrip,$namatabel,$namahalaman);

			$idupdate = '';
			$namatabel="perkara_jurusita";
			$primarykey1="id";
			$primarykey2="perkara_id";
			foreach ($newid as $id) {
				$data = '';
				$this->db->where($primarykey1,$id);
				$this->db->where($primarykey2,$idperkara);
				$data = array(
					'aktif'=>'Y',
					'diperbaharui_oleh'=>$this->session->userdata('username'),
					'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
					);
				$this->db->update($namatabel,$data);
				$idupdate .= $id.',';
			}
			$title = "UPDATE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey1."=".$idupdate."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("UPDATE",$title,$descrip,$namatabel,$namahalaman);

			$data = '';
			$datahakim = $this->get_data_juru_sita_detail($idperkara);
			if(!empty($datahakim)){
				$jurusitatext = "";
				$hakimnama = "";
				$jurusitaid = "";
				$jmlh = count($datahakim);
				$i = 0;
				$data = array(
					'diperbaharui_oleh'=>$this->session->userdata('username'),
					'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
					);
				foreach ($datahakim as $row) {
					$jurusitatext .= 'Jurusita:'.$row['jurusita_nama'];
					$jurusitaid .= $row['jurusita_id'];
					$i++;
					if($i!=$jmlh){
						$jurusitatext .= '</br>';
						$jurusitaid .= ',';
					}
					$data['penetapan_jurusita'] = $row['tanggal_penetapan'];
					if(!empty($row['nomor_sk_penetapan'])){
						$data['nomor_sk_penetapan_jurusita'] = $row['nomor_sk_penetapan'];
					}
				}
				$data['jurusita_text'] = $jurusitatext;
				$data['jurusita_id'] = $jurusitaid;
				
				$namatabel="perkara_penetapan";
				$primarykey="perkara_id";
				$this->db->where($primarykey,$idperkara);
				$this->db->update($namatabel,$data);

				$title = "UPDATE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey."=".$idperkara."]";
				$descrip = $this->fetch_description($title,$data);
				$this->add_audittrail("UPDATE",$title,$descrip,$namatabel,$namahalaman);

			}
			// $this->db->where('perkara_id',$idperkara);
			// $this->db->where('proses_id','41');
			// $this->db->delete('perkara_proses');
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function hapus_all_penetapan($idperkara,$namahalaman){
		try {
			$namatabel="perkara_jurusita";
			$primarykey="perkara_id";
			$this->db->where($primarykey,$idperkara);
			$this->db->where('tahapan_id',10);
			$this->db->delete($namatabel);
			$title = "DELETE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Foreign Key [".$primarykey."=".$idperkara."]";
			$descrip = '';
			$this->add_audittrail("DELETE",$title,$descrip,$namatabel,$namahalaman);

			#$this->db->where('perkara_id',$idperkara);
			#$this->db->delete('perkara_penetapan');
			$data = array(
				'penetapan_jurusita'=>NULL,
				'nomor_sk_penetapan_jurusita'=>NULL,
				'sk_penetapan_jurusita_dok'=>NULL,
				'jurusita_id'=>NULL,
				'jurusita_text'=>NULL,
				'diperbaharui_oleh'=>$this->session->userdata('username'),
				'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
			);
			$namatabel="perkara_penetapan";
			$primarykey="perkara_id";
			$this->db->where('perkara_id',$idperkara);
			$this->db->update('perkara_penetapan',$data);
			$title = "UPDATE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey."=".$idperkara."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("UPDATE",$title,$descrip,$namatabel,$namahalaman);

			// $this->db->simple_query("CALL perkara_proses_delete(".$idperkara.", 40);");
			// $this->db->simple_query("CALL perkara_update_status(".$idperkara.");");

			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}
	
	function add_audittrail($action,$title,$descrip,$tablename,$namahalaman){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => $namahalaman,
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			
		}
	}
}
?>