<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Penahanan_m extends CI_Model{
	
	function getJenisPerkara($idalurperkara){
		if(empty($idalurperkara)) return '';
		try {
			$this->db->where('id',$idalurperkara);
			return $this->db->get('alur_perkara')->row()->nama;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	
	function isNomorPerkara($txt){
		$re1='(\\d+)';	# Integer Number 1
		$re2='(\\/)';	# Any Single Character 1
		$re3='.*?';	# Non-greedy match on filler
		$re4='(\\/)';	# Any Single Character 2
		$re5='((?:(?:[1]{1}\\d{1}\\d{1}\\d{1})|(?:[2]{1}\\d{3})))(?![\\d])';	# Year 1
		$re6='(\\/)';	# Any Single Character 3
		$re7='(PN)';	# Variable Name 1
		if ($c=preg_match_all ("/".$re1.$re2.$re3.$re4.$re5.$re6.$re7."/is", $txt, $matches)){
		      $int1=$matches[1][0];
		      $c1=$matches[2][0];
		      $c2=$matches[3][0];
		      $year1=$matches[4][0];
		      $c3=$matches[5][0];
		      $var1=$matches[6][0];
		      return 1;
		}else{
			return 0;
		}
	}

	function parseOrderby($col){
		if($col==1){
			return "nomor_perkara"; 
		}else if($col==2){
			return "nama"; 
		}else if($col==3){
			return "tempat_lahir"; 
		}else if($col==4){
			return "tanggal_lahir"; 
		}else if($col==5){
			return "umur"; 
		}else if($col==6){
			return "jenis_kelamin"; 
		}else if($col==7){
			return "alamat"; 
		}else if($col==8){
			return "jenis_penahanan_nama"; 
		}else if($col==9){
			return "mulai"; 
		}else if($col==10){
			return "sampai"; 
		}else{
			return "tanggal_pendaftaran";
		}
	}

	function getPenahananList($idalurperkara='',$col=2,$type='DESC',$begin=0,$key=''){
		$orderby = $this->parseOrderby($col);
		$where = '';
		

		if($idalurperkara>0){
			$where = "AND alur_perkara_id IN (".$idalurperkara.")";
		}else{
			$where = "";
		}

		if(!empty($key)){
			$where_like = ' WHERE (nomor_perkara LIKE "%'.$key.'%" OR nama LIKE "%'.$key.'%" OR tempat_lahir LIKE "%'.$key.'%" OR tanggal_lahir LIKE "%'.$key.'%" OR alamat LIKE "%'.$key.'%" OR jenis_penahanan_nama LIKE "%'.$key.'%" OR mulai like "%'.$key.'%"  OR sampai like "%'.$key.'%") ';
		}else{
			$where_like =" ";
			if($idalurperkara>0){
				$where = " WHERE alur_perkara_id IN (".$idalurperkara.")";
			}
		}
		try {
			$query = $this->db->query("SELECT SQL_CALC_FOUND_ROWS perkara_id, perkara_id,alur_perkara_id,jenis_perkara_id,nomor_perkara
				,tanggal_pendaftaran, dakwaan, pihak_id, nama, tempat_lahir, tanggal_lahir, umur, jenis_kelamin, alamat, 
				status_penahanan_id, status_penahanan_nama, jenis_tahanan_id, jenis_tahanan_nama, jenis_penahanan_id, jenis_penahanan_nama, mulai, sampai, alur_perkara_aktif, nomor_indeks
				FROM v_penahanan  ".$where_like." ".$where." ORDER BY ".$orderby." ".$type." ,nomor_indeks DESC LIMIT ".$begin.",50");
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	function getPenahananListCetak($idalurperkara='',$key=''){
		$where = '';
		
		if($idalurperkara>0){
			$where = "AND alur_perkara_id IN (".$idalurperkara.")";
		}else{
			$where = "";
		}

		if(!empty($key)){
			$where_like = ' WHERE (nomor_perkara LIKE "%'.$key.'%" OR tanggal_pendaftaran LIKE "%'.$key.'%" OR jenis_perkara_nama LIKE "%'.$key.'%" OR para_pihak LIKE "%'.$key.'%" OR tahapan_terakhir_text LIKE "%'.$key.'%" OR proses_terakhir_text LIKE "%'.$key.'%") ';
		}else{
			$where_like =" ";
			if($idalurperkara>0){
				$where = " WHERE alur_perkara_id IN (".$idalurperkara.")";
			}
		}
		try {
			$query = $this->db->query("SELECT SQL_CALC_FOUND_ROWS perkara_id, perkara_id,alur_perkara_id,jenis_perkara_id,nomor_perkara
				,tanggal_pendaftaran, dakwaan, pihak_id, nama, tempat_lahir, tanggal_lahir, umur, jenis_kelamin, alamat, 
				status_penahanan_id, status_penahanan_nama, jenis_tahanan_id, jenis_tahanan_nama, jenis_penahanan_id, jenis_penahanan_nama, mulai, sampai, alur_perkara_aktif, nomor_indeks
				FROM v_penahanan  ".$where_like." ".$where."");
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	} 




	function fecth_data_num($idalurperkara,$key){
		$query = $this->db->query("SELECT FOUND_ROWS() as cnt;");
		if($query->num_rows>0){
			foreach ($query->result() as $row) {
				return $row->cnt;
			}
    		return $query->num_rows;
    	}else{
    		return 0;
    	}
	}
}

?>