<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Jadwal_Mediasi_m extends CI_Model{

	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}

	function add_audittrail($action,$title,$descrip,$tablename){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => 'Add Mediasi',
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			
		}
	}

	function get_urutan_jadwal_mediasi_terakhir($mediasi_id){
		$this->db->select_max('urutan');
		$this->db->where('mediasi_id',$mediasi_id);
		$result=$this->db->get('perkara_jadwal_mediasi');
		return $result;
	}

	function get_id_jadwal_mediasi_terakhir()
	{
		$this->db->select_max('id');
		$result=$this->db->get('perkara_jadwal_mediasi');
		return $result;
	}

	function add_jadwal_mediasi($data_add){
		try {
			$this->db->insert('perkara_jadwal_mediasi', $data_add);
			$title = "Tambah Data Jadwal Mediasi <br />Tambah table <b>Perkara_Jadwal_Mediasi</b> dari halaman <b>Penetapan Mediasi</b> dengan Primary Key [id=".$data_add['id']."]";
			$descrip = $this->fetch_description($title,$data_add);
			$this->add_audittrail("INSERT",$title,$descrip,'perkara_mediasi');
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function get_data_jadwal_mediasi($idmediasi){
		try {

			$this->db->where('mediasi_id',$idmediasi);
			$this->db->order_by("id", "ASC"); 
			$result=$this->db->get('perkara_jadwal_mediasi');#->result_array();
			return $result->result();

		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_detil_jadwal_mediasi($idjadwalmediasi){
		if(empty($idjadwalmediasi)) {
			return '';
		}
		try {
			$this->db->where('id',$idjadwalmediasi);
			$query=$this->db->get('perkara_jadwal_mediasi');
			return $query->result();
		}catch (Exception $e) {
			log_message('error', $e);
		}
	}	

	function update_jadwal_mediasi($id_jadwal_mediasi,$data_diupdate,$id_mediasi)
	{
		try {

			$this->db->where('id',$id_jadwal_mediasi);
			$this->db->update('perkara_jadwal_mediasi',$data_diupdate);
		}
		 catch (Exception $e) {
			return FALSE;
		}
	}		

	function tunda_mediasi($datainsert,$dataupdate1,$idmediasi){
		try {

			//update
			$this->db->where('id',$idmediasi);
			$this->db->update('perkara_jadwal_mediasi',$dataupdate1);

			//update audittrail
			$title = "UPDATE Jadwal Mediasi <br /> UPDATE table <b>perkara_jadwal_mediasi</b> dari halaman <b>PENUNDAAN JADWAL MEDIASI</b> dengan Primary Key [id=".$idmediasi."]";
			$descrip = $this->fetch_description($title,$dataupdate1);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_jadwal_mediasi');

			$this->db->insert('perkara_jadwal_mediasi', $datainsert);

			//insert audittrail
			$title = "INSERT Jadwal Mediasi <br /> INSERT table <b>perkara_jadwal_mediasi</b> dari halaman <b>PENUNDAAN JADWAL MEDIASI</b> dengan Primary Key [id=".$datainsert['id']."]";
			$descrip = $this->fetch_description($title,$datainsert);
			$this->add_audittrail("INSERT",$title,$descrip,'perkara_jadwal_mediasi');

			return TRUE;

		} catch (Exception $e) {
			return FALSE;
		}
	}

	function hapus_jadwal_mediasi($id_jadwal_mediasi){
		try {

			$tgljmediasisebelum="SELECT mediasi_id,tanggal_mediasi FROM perkara_jadwal_mediasi 
							WHERE mediasi_id=(SELECT mediasi_id FROM perkara_jadwal_mediasi WHERE id='$id_jadwal_mediasi') 
									AND urutan=(SELECT MAX(urutan)-1 FROM perkara_jadwal_mediasi WHERE mediasi_id=(SELECT mediasi_id FROM perkara_jadwal_mediasi WHERE id='$id_jadwal_mediasi'));";
			$tgljmediasisebelum=$this->db->query($tgljmediasisebelum)->row();

			$updatemediasi="UPDATE perkara_mediasi SET keputusan_mediasi='$tgljmediasisebelum->tanggal_mediasi' WHERE mediasi_id='$tgljmediasisebelum->mediasi_id'";
			$this->db->query($updatemediasi);
			$this->db->where('id',$id_jadwal_mediasi);
			$this->db->delete('perkara_jadwal_mediasi');


			# insert audittrail
			$title = "DELETE Jadwal Mediasi <br /> DELETE table <b>perkara_jadwal_mediasi</b> dari halaman <b>EDIT JADWAL MEDIASI</b> dengan Primary Key [id=".$id_jadwal_mediasi."]";
			$descrip = '';
			$this->add_audittrail("DELETE",$title,$descrip,'perkara_jadwal_mediasi');
			
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
		
	}

	function get_jadwal_mediasi_sebelum($idmediasi)
	{
			$qry="SELECT tanggal_mediasi FROM perkara_jadwal_mediasi 
					WHERE mediasi_id='$idmediasi' AND urutan=(SELECT MAX(urutan)-1 FROM perkara_jadwal_mediasi WHERE mediasi_id='$idmediasi');";
			$tgljmediasisebelum=$this->db->query($qry);
			$jumhasil=$tgljmediasisebelum->num_rows();
			if ($jumhasil>0)
			{
			$tgljmediasisebelum=$tgljmediasisebelum->row()->tanggal_mediasi;
			return $tgljmediasisebelum;
			}
	}

}