<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Jurnal_buku_induk extends CI_Model{
	function isNomorPerkara($txt){
		$re1='(\\d+)';	# Integer Number 1
		$re2='(\\/)';	# Any Single Character 1
		$re3='.*?';	# Non-greedy match on filler
		$re4='(\\/)';	# Any Single Character 2
		$re5='((?:(?:[1]{1}\\d{1}\\d{1}\\d{1})|(?:[2]{1}\\d{3})))(?![\\d])';	# Year 1
		$re6='(\\/)';	# Any Single Character 3
		$re7='(PN)';	# Variable Name 1
		if ($c=preg_match_all ("/".$re1.$re2.$re3.$re4.$re5.$re6.$re7."/is", $txt, $matches)){
		      $int1=$matches[1][0];
		      $c1=$matches[2][0];
		      $c2=$matches[3][0];
		      $year1=$matches[4][0];
		      $c3=$matches[5][0];
		      $var1=$matches[6][0];
		      return 1;
		}else{
			return 0;
		}
	}

	function parseOrderby($col){
		if($col==1){
			return "nomor_perkara"; 
		}else if($col==2){
			return "tanggal_pendaftaran"; 
		}else if($col==3){
			return "jenis_perkara_nama"; 
		}else if($col==6){
			return "proses_terakhir_text"; 
		}else if($col==7){
			return "pihak1_text"; 
		}else if($col==8){
			return "pihak2_text"; 
		}else{
			return "tanggal_pendaftaran";
		}
	}
	function getJurnalList($idalurperkara,$start_page=0,$key='',$col=2,$type='DESC'){
		
		$where = "";
		if(!empty($idalurperkara)){
			$where = "where alur_perkara_id IN (".$idalurperkara.") ";
		}		
		$orderby = $this->parseOrderby($col);

		if(!empty($key)){
			if($this->isNomorPerkara($key)){
				$where .= " and (nomor_perkara LIKE '%".$key."%')";
			}else{
				$where .= ' and (nomor_perkara LIKE "%'.$key.'%" OR tanggal_pendaftaran LIKE "%'.$key.'%" OR jenis_perkara_nama LIKE "%'.$key.'%" OR kategori_nama LIKE "%'.$key.'%" OR uraian LIKE "%'.$key.'%" OR jenis_biaya_nama LIKE "%'.$key.'%" OR tanggal_transaksi like "%'.$key.'%") ';
			}
		}
		$sql = "SELECT tanggal_transaksi AS tanggal_transaksi, nomor_perkara AS nomor_perkara,
			CASE
				WHEN tahapan_id = 10 THEN 'Tingkat Pertama'
				WHEN tahapan_id = 20 THEN 'Banding'
				WHEN tahapan_id = 30 THEN 'Kasasi'
				WHEN tahapan_id = 40 THEN 'Peninjauan Kembali'
				WHEN tahapan_id = 50 THEN 'Eksekusi'
				ELSE ''
				END AS tahapan_proses,
			kategori_nama AS kategori_nama, 
			jenis_biaya_nama AS jenis_biaya_nama, 
			uraian AS uraian, IF(penerimaan<>0,penerimaan,'') AS penerimaan, IF(pengeluaran<>0,pengeluaran,'') AS pengeluaran,
			keterangan AS keterangan
				FROM v_perkara_biaya_detil ".$where."
				ORDER BY tanggal_transaksi DESC
                ,".$orderby." ".$type." 
				LIMIT ".$start_page.",51";
		try {
			return $this->db->query($sql);
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function fecth_data_num($idalurperkara,$key=''){

		$where = "";
		if(!empty($idalurperkara)){
			$where = " where alur_perkara_id IN (".$idalurperkara.") ";
		}		

		if(!empty($key)){
			if($this->isNomorPerkara($key)){
				$where .= " and (nomor_perkara = '".$key."')";
			}else{
				$where .= ' and (nomor_perkara LIKE "%'.$key.'%" OR tanggal_pendaftaran LIKE "%'.$key.'%" OR jenis_perkara_nama LIKE "%'.$key.'%" OR kategori_nama LIKE "%'.$key.'%" OR uraian LIKE "%'.$key.'%" OR jenis_biaya_nama LIKE "%'.$key.'%" OR tanggal_transaksi like "%'.$key.'%") ';
			}
		}
		
		try {
			$query = $this->db->query("SELECT count(*) as cnt
								FROM v_perkara_biaya_detil 
								".$where."
								");
			if($query->num_rows>0){
				foreach ($query->result() as $row) {
					return $row->cnt;
				}
	    		return $query->num_rows;
	    	}else{
	    		return 0;
	    	}
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getTotalMoney($tgltransaksi){
		try {
			return $this->db->query("SELECT
				sum(
					CASE WHEN penerimaan IS NOT NULL OR penerimaan <>'' THEN penerimaan
					ELSE 0
					END
				) AS penerimaan,
				sum(
					CASE WHEN pengeluaran IS NOT NULL OR pengeluaran <>'' THEN pengeluaran
					ELSE 0
					END
				) AS pengeluaran
				FROM v_perkara_biaya_detil
					WHERE tanggal_transaksi ='".$tgltransaksi."'");
		} catch (Exception $e) {
			
		}
	}
}