<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Jurnal extends CI_Model{
	function isNomorPerkara($txt){
		$re1='(\\d+)';	# Integer Number 1
		$re2='(\\/)';	# Any Single Character 1
		$re3='.*?';	# Non-greedy match on filler
		$re4='(\\/)';	# Any Single Character 2
		$re5='((?:(?:[1]{1}\\d{1}\\d{1}\\d{1})|(?:[2]{1}\\d{3})))(?![\\d])';	# Year 1
		$re6='(\\/)';	# Any Single Character 3
		$re7='(PN)';	# Variable Name 1
		if ($c=preg_match_all ("/".$re1.$re2.$re3.$re4.$re5.$re6.$re7."/is", $txt, $matches)){
		      $int1=$matches[1][0];
		      $c1=$matches[2][0];
		      $c2=$matches[3][0];
		      $year1=$matches[4][0];
		      $c3=$matches[5][0];
		      $var1=$matches[6][0];
		      return 1;
		}else{
			return 0;
		}
	}

	function parseOrderby($col){
		if($col==1){
			return "nomor_perkara"; 
		}else if($col==2){
			return "tanggal_pendaftaran"; 
		}else if($col==3){
			return "jenis_perkara_nama"; 
		}else if($col==6){
			return "proses_terakhir_text"; 
		}else if($col==7){
			return "pihak1_text"; 
		}else if($col==8){
			return "pihak2_text"; 
		}else{
			return "tanggal_pendaftaran";
		}
	}
	function getJurnalList($idalurperkara=1,$tahapan_id=10,$start_page=0,$key='',$col=2,$type='DESC'){
		$orderby = $this->parseOrderby($col);

		$where = "";
		if(!empty($idalurperkara)){
			$where = "AND alur_perkara_id IN (".$idalurperkara.") ";
		}

		if(!empty($key)){
			if($this->isNomorPerkara($key)){
				$where .= " AND (nomor_perkara) = '".$key."'";
			}else{
				$where .= ' AND (nomor_perkara LIKE "%'.$key.'%" OR tanggal_pendaftaran LIKE "%'.$key.'%" OR jenis_perkara_nama LIKE "%'.$key.'%" OR pihak1_text LIKE "%'.$key.'%" OR pihak2_text LIKE "%'.$key.'%" OR proses_terakhir_text LIKE "%'.$key.'%") ';
			}
		}
		$sql = "SELECT SQL_CALC_FOUND_ROWS p.perkara_id,
                tanggal_pendaftaran,
                nomor_perkara,
                jenis_perkara_nama,
                pihak1_text,
                pihak2_text,
                proses_terakhir_text,
                proses_terakhir_id, pemasukan, pengeluaran 
                FROM perkara AS p, v_sum_perkara_biaya AS b
                WHERE p.perkara_id = b.perkara_id AND tahapan_id = ".$tahapan_id." ".$where."
                ORDER BY ".$orderby." ".$type." 
				LIMIT ".$start_page.",50";
		try {
			return $this->db->query($sql);
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	function getJurnalListDetail($idalurperkara=1,$tahapan_id=10,$start_page=0,$key='',$col=2,$type='DESC'){
		
		if(empty($idalurperkara)){
			log_message('error', 'idalurperkara not expected = '.$idalurperkara);
			#show_404();
		}
		$orderby = $this->parseOrderby($col);

		$where = "";
		if(!empty($idalurperkara)){
			$where = "AND alur_perkara_id IN (".$idalurperkara.") ";
		}

		if(!empty($key)){
			$where .= 'and '.$key;
		}
		$sql = " SELECT SQL_CALC_FOUND_ROWS p.perkara_id,
                tanggal_pendaftaran,
                nomor_perkara,
                jenis_perkara_nama,
                pihak1_text,
                pihak2_text,
                proses_terakhir_text,
                proses_terakhir_id, pemasukan, pengeluaran 
                FROM perkara AS p, v_sum_perkara_biaya AS b
                WHERE p.perkara_id = b.perkara_id AND tahapan_id = ".$tahapan_id." ".$where."
                ORDER BY ".$orderby." ".$type." 
				LIMIT ".$start_page.",50";
		try {
			return $this->db->query($sql);
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	function getJurnalListCetak($idalurperkara='',$key='',$tahapan_id=10){
		if(empty($idalurperkara)){
			log_message('error', 'idalurperkara not expected = '.$idalurperkara);
			#show_404();
		}
		$where = "";
		if(!empty($idalurperkara)){
			$where = "AND alur_perkara_id IN (".$idalurperkara.") ";
		}

		if(!empty($key)){
			if($this->isNomorPerkara($key)){
				$where .= " AND (nomor_perkara) = '".$key."'";
			}else{
				$where .= ' AND (nomor_perkara LIKE "%'.$key.'%" OR tanggal_pendaftaran LIKE "%'.$key.'%" OR jenis_perkara_nama LIKE "%'.$key.'%" OR pihak1_text LIKE "%'.$key.'%" OR pihak2_text LIKE "%'.$key.'%" OR proses_terakhir_text LIKE "%'.$key.'%") ';
			}
		}
		try {
			$sql = "SELECT SQL_CALC_FOUND_ROWS p.perkara_id,
                tanggal_pendaftaran,
                nomor_perkara,
                jenis_perkara_nama,
                pihak1_text,
                pihak2_text,
                proses_terakhir_text,
                proses_terakhir_id, pemasukan, pengeluaran 
                FROM perkara AS p, v_sum_perkara_biaya AS b
                WHERE p.perkara_id = b.perkara_id AND tahapan_id = ".$tahapan_id." ".$where."
                ORDER BY tanggal_pendaftaran DESC";
			$query = $this->db->query($sql);
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	} 

	function fecth_data_num($idalurperkara=1,$tahapan_id=10,$key=''){
		try {
			$query = $this->db->query("SELECT FOUND_ROWS() as cnt;");
			if($query->num_rows>0){
				foreach ($query->result() as $row) {
					return $row->cnt;
				}
	    		return $query->num_rows;
	    	}else{
	    		return 0;
	    	}
		} catch (Exception $e) {
			
		}
	}
}