<?php 
if (!defined('BASEPATH')) exit('No direct script access allowed');
class m_template_mediasi_agama extends CI_Model {

	function getDataPenetapanSidang($idperkara){
		try{
			if(!is_numeric($idperkara)){ return '';	}
			$sql = "SELECT a.penetapan_hari_sidang, a.sidang_pertama, b.tanggal_sidang,  b.jam_sidang
					FROM perkara_penetapan AS a, perkara_jadwal_sidang AS b
					WHERE a.perkara_id=b.perkara_id AND b.urutan=1 AND a.perkara_id=$idperkara";
			$query=$this->db->query($sql);
			return $query;
		}catch(Exception $e){ return false; }
	}

	function getDataPenetapanPanitera($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT * FROM 
						(SELECT perkara_id, panitera_id, tanggal_penetapan 
							FROM perkara_panitera_pn 
							WHERE perkara_id = $idperkara AND aktif='Y'
							GROUP BY panitera_id) AS ph
					LEFT JOIN
						(SELECT id, nama_gelar FROM panitera_pn) AS h
					ON ph.panitera_id = h.id";
			$query=$this->db->query($sql);
			return $query;
		}catch(Exception $e) { return false; }
	}

	function getRefJenisTahanan(){
		try{
			$sql = "SELECT * 
					FROM jenis_tahanan";
			$query=$this->db->query($sql);
			return $query;
		}catch(Exception $e) { return false; }
	}

	function getDataPerkara($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT A.nomor_perkara,A.nomor_surat,A.tanggal_surat, A.tanggal_pendaftaran, A.dakwaan,B.nama 
					FROM perkara A LEFT JOIN jenis_perkara B ON A.jenis_perkara_id=B.id
					WHERE A.perkara_id =$idperkara";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataMediasi($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT A.*, B.nama_mediator FROM perkara_mediasi as A INNER JOIN perkara_mediator as B ON A.mediator_id=B.mediator_id WHERE A.perkara_id=$idperkara";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getJenisPerkara($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT nama 
					FROM jenis_perkara 
					WHERE id=(SELECT jenis_perkara_id 
								FROM perkara 
								WHERE perkara_id=$idperkara)";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataPA(){
		try{
			$sql = "SELECT * FROM 
					(SELECT value AS NamaPN FROM sys_config WHERE id = 62) AS T1,
					(SELECT value AS KetuaPNNama FROM sys_config WHERE id = 64) AS T2,
					(SELECT value AS AlamatPN FROM sys_config WHERE id = 63) AS T3,
					(SELECT value AS WakilKetuaPNNama FROM sys_config WHERE id = 66) AS T4,
					(SELECT value AS PansekPNNama FROM sys_config WHERE id = 68) AS T5,
					(SELECT value AS WaPanNama FROM sys_config WHERE id = 70) AS T6, 
					(SELECT value AS ZonaWaktu FROM sys_config WHERE id = 75) AS T7";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getAllHakim(){
		try{
			$sql = "SELECT * FROM hakim_pn";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataPihak($pihak_id){
		try{
			if(!is_numeric($pihak_id)) { return ''; }
			$sql = "SELECT * 
					FROM pihak 
					WHERE id=$pihak_id";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_data_pihak_loop($idperkara,$jenispihak){
		try {
			if(!is_numeric($idperkara)){
				return '';
			}
			return $this->db->query('SELECT b.*,  a.*,c.nama AS kewarganegaraan, d.nama as agama,
											group_concat(e.pengacara_id) as pengacara_id , f.nama AS pendidikan, year(g.tanggal_pendaftaran) - year(a.tanggal_lahir) as umur
											FROM pihak AS a
											LEFT JOIN
											(SELECT * FROM perkara_pihak'.$jenispihak.') AS b
											ON a.id=b.pihak_id
											LEFT JOIN
											(SELECT id,nama FROM negara) AS c
											ON a.warga_negara_id=c.id
											LEFT JOIN
											(SELECT id,nama FROM agama) AS d
											ON a.agama_id=d.id
											LEFT JOIN
											(SELECT pengacara_id, pihak_id, perkara_id FROM perkara_pengacara) AS e
											ON b.pihak_id=e.pihak_id and e.perkara_id=b.perkara_id
											LEFT JOIN tingkat_pendidikan f ON a.pendidikan_id = f.id
											left join perkara g on b.perkara_id = g.perkara_id
											WHERE b.perkara_id='.$idperkara.' GROUP BY b.id ORDER BY b.id ASC');
			} catch (Exception $e) {
				return '';
			}
	}
	
	
	function getDataPanitera($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT DISTINCT perkara_id,urutan,panitera_id,panitera_nama,tanggal_penetapan 
					FROM perkara_panitera_pn 
					WHERE perkara_id=$idperkara";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataPutusan($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT tanggal_putusan
					FROM perkara_putusan
					WHERE perkara_id=$idperkara";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataTerdakwa($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			 $sql="SELECT 		a.*
								,b.tempat_lahir
								,b.tanggal_lahir
								,b.jenis_kelamin
								,d.nama AS warga_negara
								,c.nama AS agama_nama
								,b.pekerjaan
							FROM perkara_pihak2 AS a
							LEFT JOIN pihak AS b
							ON b.id=a.pihak_id
							LEFT JOIN agama AS c
							ON c.id=b.agama_id
							LEFT JOIN negara AS d
							ON d.id=b.warga_negara_id
							
							WHERE a.perkara_id=$idperkara
							ORDER BY a.urutan";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataPihakTerdakwa1($idperkara, $idpihak){
		try{
			if(!is_numeric($idperkara) OR !is_numeric($idpihak)) { return ''; }
			$sql = "SELECT 	a.pihak_id, a.urutan, 
						b.nama, b.alamat, b.tempat_lahir, b.tanggal_lahir, b.jenis_kelamin, a.pangkat, a.nrp, a.jabatan, a.kesatuan,
						c.nama AS agama_nama, d.nama AS warga_negara, b.pekerjaan 
					FROM 		perkara_pihak2 a
					LEFT JOIN pihak AS b ON a.pihak_id=b.id
					LEFT JOIN agama AS c ON  b.agama_id=c.id
					LEFT JOIN negara AS d ON b.warga_negara_id=d.id
					WHERE a.perkara_id = $idperkara AND a.pihak_id=$idpihak
					ORDER BY urutan ASC";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataPenahananTerdakwa($idperkara,$idpihak){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT 	pihak_id,
							jp.id AS idjns_penahanan,
							jp.nama AS oleh, 
							sp.nama AS status_penahanan, 
							jt.nama AS jenis_tahanan,
							pt.mulai AS sejak, 
							pt.sampai, 
							pt.lama_penahanan,
							pt.tanggal_surat as tglPenetapan,
							pt.id ,
							pt.tanggal_surat, pt.nomor_surat 
					FROM (SELECT * FROM penahanan_terdakwa WHERE perkara_id = $idperkara AND pihak_id = $idpihak ORDER BY jenis_penahanan_id, mulai ASC) pt 
					LEFT JOIN jenis_penahanan jp ON pt.jenis_penahanan_id=jp.id
					LEFT JOIN status_penahanan sp ON pt.status_penahanan_id=sp.id
					LEFT JOIN jenis_tahanan jt ON pt.jenis_tahanan_id=jt.id
					ORDER BY jp.id" ;
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}
	
	function getDataPenahanan($idpenahanan){
		try{
		$sql= "SELECT 	A.id,
						A.perkara_id,
						A.pihak_id,
						B.nama AS jenis_penahanan,
						C.nama AS status_penahanan,
						D.nama AS jenis_tahanan,
						A.tanggal_surat,
						A.nomor_surat,
						A.mulai,
						A.sampai,
						A.waktu_penahanan,
						A.lama_penahanan,
						A.rutan_id,
						E.nama
				FROM penahanan_terdakwa A 
				LEFT JOIN jenis_penahanan B ON A.jenis_penahanan_id=B.id 
				LEFT JOIN status_penahanan C ON A.status_penahanan_id=C.id
				LEFT JOIN jenis_tahanan D ON A.jenis_tahanan_id=D.id
				LEFT JOIN lembaga_pemasyarakatan AS E ON A.rutan_id = E.id
				WHERE A.id=$idpenahanan ";				
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataHakim($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT * 
					FROM (SELECT perkara_id,urutan,jabatan_hakim_id, jabatan_hakim_nama, hakim_id, tanggal_penetapan 
							FROM perkara_hakim_pn 
							WHERE perkara_id = $idperkara AND aktif='Y'
							GROUP BY hakim_id) AS ph
					LEFT JOIN (SELECT id, nama_gelar FROM hakim_pn) AS h
					ON ph.hakim_id = h.id
					ORDER BY jabatan_hakim_id ASC";		
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false;	}
	}

	function getDataPenetapanHakim($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT * 
					FROM (SELECT perkara_id,urutan,jabatan_hakim_id, jabatan_hakim_nama, hakim_nama, hakim_id,tanggal_penetapan,aktif
							FROM perkara_hakim_pn 
							WHERE perkara_id = $idperkara AND aktif='Y'
							GROUP BY hakim_id) AS ph
					LEFT JOIN (SELECT id, nama_gelar FROM hakim_pn) AS h
					ON ph.hakim_id = h.id
					ORDER BY urutan ASC";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}
/* 	function getDataJurusita($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT * 
					FROM (SELECT *
							FROM perkara_jurusita
							WHERE perkara_id = $idperkara AND aktif='Y'
							GROUP BY jurusita_id) AS ph
					LEFT JOIN (SELECT id, nama_gelar FROM jurusita) AS h
					ON ph.jurusita_id = h.id
					ORDER BY urutan ASC";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	} */
	function getDataJurusita($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT B.nama_gelar,A.tanggal_penetapan FROM perkara_jurusita AS A LEFT JOIN jurusita AS B ON A.jurusita_id=B.id WHERE A.perkara_id='$idperkara'";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}
	function getDataPP($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT B.nama_gelar,A.tanggal_penetapan FROM perkara_panitera_pn AS A LEFT JOIN panitera_pn AS B ON A.panitera_id=B.id WHERE A.perkara_id='$idperkara'";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}
	function getPenahananBefore($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT * FROM penahanan_terdakwa WHERE id = ";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getKejaksaan($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT IF(a.alamat <> '',a.alamat, b.kejaksaan) AS kejaksaan  FROM 
					perkara_pihak1 AS a
					LEFT JOIN  pihak_jaksa AS b ON a.pihak_id=b.pihak_id
					WHERE a.perkara_id='".$idperkara."' ";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}
	
	//PERADILAN AGAMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
	function blangko_pmh_pertama(){
		try{
			$sql = "SELECT kode,nama FROM template_dokumen WHERE alur_perkara_id='15' AND tahapan_id='12'  AND proses_id='20'";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}
	
	function blangko_pppp(){
		try{
			$sql = "SELECT kode,nama FROM template_dokumen WHERE alur_perkara_id='15' AND tahapan_id='12'  AND proses_id='30'";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function blangko_phs(){
		try{
			$sql = "SELECT kode,nama FROM template_dokumen WHERE alur_perkara_id='15' AND tahapan_id='12'  AND proses_id='80' ORDER BY nama ASC";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}
	
	function blangko_pjs(){
		try{
			$sql = "SELECT kode,nama FROM template_dokumen WHERE alur_perkara_id='15' AND tahapan_id='12'  AND proses_id='40'";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataIkrarTalak($idperkara){
		try{
			$sql = "SELECT a.*,b.nama_gelar as nama_pp_ikrar,c.nama_gelar as nama_js_ikrar 
							from perkara_ikrar_talak a 
							left join panitera_pn b on a.panitera_pengganti_id = b.id 
							left join jurusita c on a.jurusita_id = c.id 
							where perkara_id ='".$idperkara."' ";
			$query=$this->db->query($sql);
			return $query;
			}catch(Exception $e){
				return false;
			}
	}
	function getDataPMHIkrar($idperkara) {
			try{
			$sql = "SELECT a.tanggal_putusan AS tgl_putus, b.majelis_hakim_nama AS majelis_hakim, penetapan_majelis_hakim AS tgl_pmh
					FROM perkara_putusan a
					JOIN perkara_ikrar_talak b ON a.perkara_id = b.perkara_id WHERE a.perkara_id =".$idperkara;
			$query=$this->db->query($sql);
			return $query;
			}catch(Exception $e){
				return false;
			}
	}
	/*function getStatusPenetapanIkrarTalak($idperkara){
		try{
			if(intval($idperkara)>0){
				$sql = "select status_penetapan_ikrar_talak_id from perkara_ikrar_talak where perkara_id = $idperkara";
				$query = $this->db->query($sql);
				if($query->num_rows()>0){
					foreach ($query->result as $row) {
						$status = $row->status_penetapan_ikrar_talak_id;
					}
					return $status;
				}else{
					return false;
				}
			}else{
				return false;
			}
		}catch(Exception $e){
			return false;
		}
	}*/

	function getDataMajelisIkrarTalak($idperkara){
		try{
			if(intval($idperkara)>0){
				$sql = "SELECT majelis_hakim_nama FROM perkara_ikrar_talak WHERE perkara_id = $idperkara";
				$query = $this->db->query($sql);
				return $query;
			}else{
				return "";
			}
		}catch(Exception $e){
			return FALSE;
		}
	}

	function getDataPaniteraIkrarTalak($idperkara){
		try{
			if(intval($idperkara)>0){
				$sql = "select a.panitera_pengganti_id,b.nama from perkara_ikrar_talak a join panitera_pn b on a.panitera_pengganti_id = b.id where a.perkara_id = $idperkara";
				$query = $this->db->query($sql);
				return $query;
			}else{
				return "";
			}
		}catch(Exception $e){
			return FALSE;
		}
	}
	//PERADILAN AGAMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
}
?>