<?php 
if (!defined('BASEPATH')) exit('No direct script access allowed');
class m_template_bas_pertama_agama extends CI_Model {

	function getDataPenetapanSidang($idperkara){
		try{
			if(!is_numeric($idperkara)){ return '';	}
			$sql = "SELECT a.penetapan_hari_sidang, a.sidang_pertama, b.tanggal_sidang,  b.jam_sidang, b.urutan
					FROM perkara_penetapan AS a, perkara_jadwal_sidang AS b
					WHERE a.perkara_id=b.perkara_id AND a.perkara_id=$idperkara";
			$query=$this->db->query($sql);
			return $query;
		}catch(Exception $e){ return false; }
	}

	function cek_sidang($idperkara, $idsidang){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "select 
					a.urutan as ke,
					a.dihadiri_oleh as hadir,
					c.pengacara_id as id_kuasa
					from perkara_jadwal_sidang a
					join perkara_pihak1 b on a.perkara_id = b.perkara_id
					left join perkara_pengacara c on a.perkara_id = c.perkara_id and b.pihak_id = c.pihak_id
					where a.perkara_id =".$idperkara." and a.id =".$idsidang;
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataPenetapanPanitera($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT * FROM 
						(SELECT perkara_id, panitera_id, tanggal_penetapan 
							FROM perkara_panitera_pn 
							WHERE perkara_id = $idperkara AND aktif='Y'
							GROUP BY panitera_id) AS ph
					LEFT JOIN
						(SELECT id, nama_gelar FROM panitera_pn) AS h
					ON ph.panitera_id = h.id";
			$query=$this->db->query($sql);
			return $query;
		}catch(Exception $e) { return false; }
	}
	

	function getDataPerkara($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT nomor_perkara,nomor_surat,tanggal_surat, tanggal_pendaftaran, dakwaan 
					FROM perkara 
					WHERE perkara_id =$idperkara";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataSidang($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT id,urutan, tanggal_sidang 
					FROM perkara_jadwal_sidang
					WHERE perkara_id =$idperkara  ";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataPutusanVerstek($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT amar_putusan 
					FROM perkara_putusan
					WHERE perkara_id =$idperkara AND putusan_verstek='Y' ";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataPutusanSela($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT tanggal_putusan_sela,amar_sela 
					FROM perkara_putusan_sela
					WHERE perkara_id =$idperkara ";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataMediator($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT mediator_text 
					FROM perkara_mediasi
					WHERE perkara_id =$idperkara AND tahapan_id=10 AND jenis_mediasi=1";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getJenisPerkara($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT nama 
					FROM jenis_perkara 
					WHERE id=(SELECT jenis_perkara_id 
								FROM perkara 
								WHERE perkara_id=$idperkara)";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function get_data_pihak_loop($idperkara,$jenispihak){
		try {
			if(!is_numeric($idperkara)){
				return '';
			}
			$sql="SELECT a.nomor_perkara, b.urutan, b.pihak_id as id_pihak,c.pengacara_id as id_kuasa,
					d.nama, (year(now()) - year(d.tanggal_lahir)) as umur, e.nama as agama, 
					d.pekerjaan, f.nama as pendidikan, d.alamat, c.nama as nama_kuasa, c.alamat as alamat_kuasa, c.aktif_mulai as tgl_kuasa
					FROM perkara a 
					left join perkara_pihak".$jenispihak." b on a.perkara_id = b.perkara_id
					left join perkara_pengacara c on a.perkara_id = c.perkara_id and b.pihak_id = c.pihak_id
					left join pihak d on b.pihak_id = d.id
					left join agama e on d.agama_id = e.id
					left join tingkat_pendidikan f on d.pendidikan_id = f.id
					where a.perkara_id = ".$idperkara." 
					order by b.urutan";
			return $this->db->query($sql);
			} catch (Exception $e) {
				return '';
			}
	}

	function get_data_pengacara($idperkara,$jenispihak){
		try {
			if(!is_numeric($idperkara)){
				return '';
			}
			return $this->db->query ("SELECT a.id,
						GROUP_CONCAT(a.pihak_id SEPARATOR ';') AS pihak_id,
						a.urutan,a.nama,a.alamat,
						a.aktif_mulai,'Indonesia' AS kewarganegaraan,
						b.pekerjaan,b.jenis_pihak_id
					FROM perkara_pengacara AS a
										LEFT JOIN
										(SELECT * FROM pihak ) AS b
										ON b.id=a.pengacara_id
										WHERE a.pihak_id IN 
										(SELECT pihak_id FROM perkara_pihak".$jenispihak." WHERE perkara_id=".$idperkara.")
										AND perkara_id=".$idperkara." 
										GROUP BY a.pengacara_id
										ORDER BY urutan ASC");
			} catch (Exception $e) {
				return '';
			}
	}
	
	function getDataPA(){
		try{
			$sql = "SELECT * FROM 
					(SELECT value AS NamaPN FROM sys_config WHERE id = 62) AS T1,
					(SELECT value AS KetuaPNNama FROM sys_config WHERE id = 64) AS T2,
					(SELECT value AS AlamatPN FROM sys_config WHERE id = 63) AS T3,
					(SELECT value AS WakilKetuaPNNama FROM sys_config WHERE id = 66) AS T4,
					(SELECT value AS PansekPNNama FROM sys_config WHERE id = 68) AS T5,
					(SELECT value AS WaPanNama FROM sys_config WHERE id = 70) AS T6, 
					(SELECT value AS ZonaWaktu FROM sys_config WHERE id = 75) AS T7";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getAllHakim(){
		try{
			$sql = "SELECT * FROM hakim_pn";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataPihak($pihak_id){
		try{
			if(!is_numeric($pihak_id)) { return ''; }
			$sql = "SELECT * 
					FROM pihak 
					WHERE id=$pihak_id";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}

	function getDataPanitera($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT DISTINCT perkara_id,urutan,panitera_id,panitera_nama,tanggal_penetapan 
					FROM perkara_panitera_pn 
					WHERE perkara_id=$idperkara";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}		

	function getDataPenetapanHakim($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT * 
					FROM (SELECT perkara_id,urutan,jabatan_hakim_id, jabatan_hakim_nama, hakim_nama, hakim_id,tanggal_penetapan,aktif
							FROM perkara_hakim_pn 
							WHERE perkara_id = $idperkara AND aktif='Y'
							GROUP BY hakim_id) AS ph
					LEFT JOIN (SELECT id, nama_gelar FROM hakim_pn) AS h
					ON ph.hakim_id = h.id
					ORDER BY urutan ASC";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}
/* 	function getDataJurusita($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT * 
					FROM (SELECT *
							FROM perkara_jurusita
							WHERE perkara_id = $idperkara AND aktif='Y'
							GROUP BY jurusita_id) AS ph
					LEFT JOIN (SELECT id, nama_gelar FROM jurusita) AS h
					ON ph.jurusita_id = h.id
					ORDER BY urutan ASC";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	} */
	function getDataJurusita($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT B.nama_gelar,A.tanggal_penetapan FROM perkara_jurusita AS A LEFT JOIN jurusita AS B ON A.jurusita_id=B.id WHERE A.perkara_id='$idperkara'";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}
	function getDataPP($idperkara){
		try{
			if(!is_numeric($idperkara)) { return ''; }
			$sql = "SELECT B.nama_gelar,A.tanggal_penetapan FROM perkara_panitera_pn AS A LEFT JOIN panitera_pn AS B ON A.panitera_id=B.id WHERE A.perkara_id='$idperkara'";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}
		
	//PERADILAN AGAMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
	function blangko_bas_pertama_agama($nomor){
		try{
			$sql = "SELECT kode,nama FROM template_dokumen WHERE alur_perkara_id='15' AND tahapan_id='14'  AND proses_id='200' AND nomor >= 1 and nomor <= 20 ORDER BY nomor ASC";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}
	//PERADILAN AGAMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA

	//PERADILAN AGAMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
	function blangko_bas_pertama_agamaxxx($nomor){
		try{
			$sql = "SELECT kode,nama FROM template_dokumen WHERE alur_perkara_id='15' AND tahapan_id='14'  AND proses_id='200' AND (nomor =".$nomor." or nomor = 12 or nomor = 13) ORDER BY nomor ASC";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}
	//PERADILAN AGAMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
}
?>