<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Register_diversi_blm_12tahun_m extends CI_Model {
	function parseOrderby($col){
		if($col==1){
			return "nomor_penetapan"; 
		}else if($col==3){
			return "tgl_lap_kemasyarakatan";
		}else{
			return "tgl_penetapan";
		}
	}

	function get_register_anak_blm_12tahun($col=2,$asc_desc='ASC',$begin=0,$key=''){
		$orderby = $this->parseOrderby($col);
		$where = '';
		
		if(!empty($key)){
			$where .= ' AND (r.nomor_penetapan LIKE "%'.$key.'%" OR r.nomor_lap_kemasyarakatan LIKE "%'.$key.'%" OR nomor_kep_penyidik LIKE "%'.$key.'%" OR p.nama LIKE "%'.$key.'%" OR p.tempat_lahir LIKE "%'.$key.'%" OR p.alamat LIKE "%'.$key.'%") ';
			$orderby = $this->parseOrderby($col);
		}
		try {
			return $this->db->query("SELECT 
									 r.id,
									 r.nomor_penetapan,
									 r.tgl_penetapan,
									 r.nomor_lap_kemasyarakatan,
									 r.tgl_lap_kemasyarakatan,
									 r.nomor_kep_penyidik,
									 r.tgl_kep_penyidik,
									 r.tgl_tindak_pidana,
									 p.nama, 
							         group_concat('- ', p.nama
							             separator '<br>')  nama
									FROM
									  diversi_register_blm_12tahun AS r
									LEFT JOIN diversi_anak_blm_12tahun as d on r.id=d.register_id
									LEFT JOIN pihak as p on d.pihak_anak=p.id
									
									   ".$where."
									GROUP BY r.id
									ORDER BY ".$orderby." ".$asc_desc." LIMIT ".$begin.",50;");
			
		} catch (Exception $e) {
			
		}
	}


	function fecth_data_num(){
		$query = $this->db->query("SELECT FOUND_ROWS() as cnt;");
		if($query->num_rows>0){
			foreach ($query->result() as $row) {
				return $row->cnt;
			}
    		return $query->num_rows;
    	}else{
    		return 0;
    	}
	}

	function get_data_register($register_id){
		try {
			return $this->db->query("SELECT 
									 id,
									 nomor_penetapan,
									 tgl_penetapan,
									 nomor_lap_kemasyarakatan,
									 tgl_lap_kemasyarakatan,
									 nomor_kep_penyidik,
									 tgl_kep_penyidik,
									 tgl_tindak_pidana,
									 nomor_permohonan,
									 tgl_permohonan,
									 uraian_tindak_pidana,
									 isi_kep_penyidik
									FROM diversi_register_blm_12tahun
									WHERE id=".$register_id);
		} catch (Exception $e) {
			
		}
	}

	function get_data_anak($register_id){
		try {
			$sql="SELECT
										count(d.id) as jumlah_row,
										d.id,
										d.urutan,
										d.register_id,
										p.id as pihak_id,
										p.nomor_indentitas,
										p.nama,
										p.tempat_lahir,
										p.tanggal_lahir,
										p.jenis_kelamin,
										p.golongan_darah,
										p.alamat,
										p.rtrw,
										p.kelurahan,
										p.kecamatan,
										p.kabupaten_id,
										p.kabupaten,
										p.propinsi_id,
										p.propinsi,
										p.agama_nama,
										p.status_kawin,
										p.pekerjaan,
										p.pendidikan,
										p.warga_negara,
										p.nama_ayah,
										p.nama_ibu ,
									    concat(TIMESTAMPDIFF(YEAR,p.tanggal_lahir,r.tgl_tindak_pidana),' ' ,'Tahun') AS umur
									FROM
									  diversi_register_blm_12tahun AS r
									LEFT JOIN diversi_anak_blm_12tahun as d on r.id=d.register_id
									LEFT JOIN pihak as p on d.pihak_anak=p.id
									WHERE r.id=".$register_id .' GROUP BY d.id' ;
			return $this->db->query($sql);
		} catch (Exception $e) {
			
		}
	}

}
?>