<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Jadwal_Diversi_m extends CI_Model{

	//dipake
	function get_id_jadwal_diversi_terakhir(){
		try{
		$this->db->select_max('id');
		$result=$this->db->get('perkara_jadwal_musyawarah_diversi');
		return $result;
		}catch (Exception $e) {
			log_message('error', $e);
		}
	}

	//dipake : tab_diversi_m.php
	function get_data_jadwal_diversi($iddiversi){
		try {
			$this->db->where('diversi_id',$iddiversi);
			$this->db->order_by("id", "ASC"); 
			$result=$this->db->get('perkara_jadwal_musyawarah_diversi');#->result_array();
			return $result->result();
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	//dipake
	function get_detil_jadwal_diversi($idjadwaldiversi){
		try {
			$this->db->where('id',$idjadwaldiversi);
			$query=$this->db->get('perkara_jadwal_musyawarah_diversi');
			return $query->result();
		}catch (Exception $e) {
			log_message('error', $e);
		}
	}	

	//dipake
	function get_jadwal_diversi_sebelum($iddiversi){
		try{
			$qry="SELECT tanggal_musyawarah FROM perkara_jadwal_musyawarah_diversi 
					WHERE diversi_id='$iddiversi' AND urutan=(SELECT MAX(urutan)-1 FROM perkara_jadwal_mediasi WHERE mediasi_id='$iddiversi');";
			$tgljdiversisebelum=$this->db->query($qry);
			$jumhasil=$tgljdiversisebelum->num_rows();
			if ($jumhasil>0)
			{
				$tgljdiversisebelum=$tgljdiversisebelum->row()->tanggal_musyawarah;
				return $tgljdiversisebelum;
			}
			}catch (Exception $e) {
			log_message('error', $e);
		}
	}

	//dipake
	function get_urutan_jadwal_diversi_terakhir($diversi_id){
		try{
		$this->db->select_max('urutan');
		$this->db->where('diversi_id',$diversi_id);
		$result=$this->db->get('perkara_jadwal_musyawarah_diversi');
		return $result;
		}catch (Exception $e) {
			log_message('error', $e);
		}
	}

	//dipake : tab_diversi_c.php
	function add_jadwal_diversi($data_add){
		try {
			$this->db->insert('perkara_jadwal_musyawarah_diversi', $data_add);
			$title = "Tambah Data Jadwal Musyawarah Diversi <br />Tambah table <b>perkara_jadwal_musyawarah_diversi</b> dari halaman <b>PENETAPAN MUSYAWARAH DIVERSI</b> dengan Primary Key [id=".$data_add['id']."]";
			$descrip = $this->fetch_description($title,$data_add);
			$this->add_audittrail("INSERT",$title,$descrip,'perkara_mediasi');
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	//dipake
	function update_jadwal_diversi($id_jadwal_diversi,$data_diupdate,$id_diversi,$namahalaman){
		try {
			$namatabel="perkara_jadwal_musyawarah_diversi";
			$primarykey="id";
			$this->db->where($primarykey,$id_jadwal_diversi);
			$this->db->update($namatabel,$data_diupdate);
			$title = "UPDATE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey."=".$id_jadwal_diversi."]";
			$descrip = $this->fetch_description($title,$data_diupdate);
			$this->add_audittrail("UPDATE",$title,$descrip,$namatabel,$namahalaman);
		}
		 catch (Exception $e) {
			return FALSE;
		}
	}		

	//dipake
	function tunda_diversi($datainsert,$dataupdate1,$iddiversi,$idjadwaldiversi,$namahalaman){
		try {
			$namatabel="perkara_jadwal_musyawarah_diversi";
			$primarykey="id";

			$this->db->where($primarykey,$idjadwaldiversi);
			$this->db->update($namatabel,$dataupdate1);
			$title = "UPDATE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey."=".$idjadwaldiversi."]";
			$descrip = $this->fetch_description($title,$dataupdate1);
			$this->add_audittrail("UPDATE",$title,$descrip,$namatabel,$namahalaman);

			$this->db->insert($namatabel, $datainsert);
			$title = "INSERT table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey."=".$datainsert['id']."]";
			$descrip = $this->fetch_description($title,$datainsert);
			$this->add_audittrail("INSERT",$title,$descrip,$namatabel,$namahalaman);
			return TRUE;

		} catch (Exception $e) {
			return FALSE;
		}
	}

	//dipake
	function hapus_jadwal_diversi($id_jadwal_diversi,$namahalaman){
		try {
			$namatabel="perkara_jadwal_musyawarah_diversi";
			$primarykey="id";
			$this->db->where($primarykey,$id_jadwal_diversi);
			$this->db->delete($namatabel);
			$title = "DELETE table <b>".$namatabel."</b> dari halaman <b>".$namahalaman."</b> dengan Primary Key [".$primarykey."=".$id_jadwal_diversi."]";
			$descrip = '';
			$this->add_audittrail("DELETE",$title,$descrip,$namatabel,$namahalaman);
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}

	function add_audittrail($action,$title,$descrip,$tablename,$formname){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => $formname,
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		}catch (Exception $e) {
		}
	}
}