<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Arsip_m extends CI_Model {

	function parseOrderby($col){
		if($col==1){
			return "nomor_arsip"; 
		}else if($col==2){
			return "no_ruang"; 
		}else if($col==3){
			return "no_lemari"; 
		}else if($col==4){
			return "no_rak"; 
		}else if($col==5){
			return "no_berkas"; 
		}else if($col==6){
			return "nomor_perkara"; 
		}else if($col==7){
			return "tanggal_masuk_arsip"; 
		}else if($col==8){
			return "status"; 
		}else{
			return "tanggal_masuk_arsip";
		}
	}

	function getArsipList($col=7,$type='DESC',$begin=0,$key=''){
		$orderby = $this->parseOrderby($col);

		if(!empty($key) AND $key!='search_detail'){
			$where_like = ' WHERE (nomor_arsip LIKE "%'.$key.'%" OR no_ruang LIKE "%'.$key.'%" OR no_lemari LIKE "%'.$key.'%" OR no_rak LIKE "%'.$key.'%"
							OR no_berkas LIKE "%'.$key.'%"
							OR nomor_perkara LIKE "%'.$key.'%") ';
		}else{
			$where_like =" ";
		}
		try {
			$query = $this->db->query("SELECT SQL_CALC_FOUND_ROWS 
					id as arsip_id,
					nomor_arsip,
					no_ruang,
					no_lemari,
					no_rak,
					no_berkas,
					nomor_perkara,
					tanggal_masuk_arsip,
					nama_penerima,
					nama_penyerah,
					lengkap,
					status as status_id,
					IF (status=1,'Ada',if(status=2,'Dipinjam','Pemusnahan')) as status
				from arsip  ".$where_like." ORDER BY ".$orderby." ".$type." LIMIT ".$begin.",50");
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	function getArsipList_search_detail($col=1,$type='DESC',$begin=0,$key=''){
		$orderby = $this->parseOrderby($col);

		if(!empty($key)){
			$where_like = 'WHERE '.$key;
		}else{
			$where_like =" ";
		}
		try {
			$query = $this->db->query("SELECT SQL_CALC_FOUND_ROWS 
					id as arsip_id,
					nomor_arsip,
					no_ruang,
					no_lemari,
					no_rak,
					no_berkas,
					nomor_perkara,
					tanggal_masuk_arsip,
					nama_penerima,
					nama_penyerah,
					lengkap,
					status as status_id,
					IF (status=1,'Ada',if(status=2,'Dipinjam','Pemusnahan')) as status
				from arsip  ".$where_like." ORDER BY ".$orderby." ".$type." LIMIT ".$begin.",50");
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function fecth_data_num(){
		$query = $this->db->query("SELECT FOUND_ROWS() as cnt;");
		if($query->num_rows>0){
			foreach ($query->result() as $row) {
				return $row->cnt;
			}
    		return $query->num_rows;
    	}else{
    		return 0;
    	}
	}

	function get_arsip_detail($arsip_id){
		try {
			$sql="Select a.id as arsip_id,
					a.no_ruang,
					a.no_lemari,
					a.no_rak,
					a.no_berkas,
					a.nomor_arsip,
					a.perkara_id,
					a.nomor_perkara,
					a.tanggal_masuk_arsip,
					a.nama_penerima,
					a.nama_penyerah,
					a.status,
					a.keterangan
				from (Select * from arsip where id=".$arsip_id.") a;";
			$query=$this->db->query($sql);
			if ($query->num_rows>0){
				return $query->row();
			}else{
				return '';
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function get_riwayat_peminjaman($arsip_id, $pinjaman_id=0){
		try {
			$sql="Select a.id as pinjaman_id,
					a.arsip_id,
					a.petugas_peminjam,
					a.tanggal_pinjam,
					a.batas_waktu,
					a.tanggal_kembali,
					a.petugas_penerima,
					a.keterangan
				from (Select * from arsip_pinjam where arsip_id=".$arsip_id;
			if($pinjaman_id!=0){
				$sql.=" AND id=".$pinjaman_id;
			}
			$sql.=") a;";
			$query=$this->db->query($sql);
			//if ($query->num_rows>0){
				return $query->result();
			//}else{
			//	return '';
			//}
		} catch (Exception $e) {
			return '';
		}
	}

	function get_perkara_id($nomor_perkara){
		try {
			$sql="Select perkara_id from perkara where nomor_perkara='".$nomor_perkara."'";
			$query=$this->db->query($sql);
			if($query->num_rows>0){
				return $query->row()->perkara_id;
			}else{
				return 0;
			}
		} catch (Exception $e) {
			return 0;
		}
	}

	function add_arsip($data){
		try {
			if ($this->db->insert('arsip',$data)){
				return true;
			}else{
				return false;
			}
		} catch (Exception $e) {
			return false;
		}
	}

	function edit_arsip($arsip_id,$data){
		try {
			$this->db->where('id',$arsip_id);
			if ($this->db->update('arsip',$data)){
				return true;
			}else{
				return false;
			}
		} catch (Exception $e) {
			return false;
		}
	}

	function add_pinjaman($data){
		try {
			if ($this->db->insert('arsip_pinjam',$data)){
				if ($data['tanggal_kembali']!=''){
					$dat=array('status'=>1);
					$this->db->where('id',$data['arsip_id']);
					if ($this->db->update('arsip',$dat)){
						return true;
					}else{
						return false;
					}
				}else{
					$dat=array('status'=>2);
					$this->db->where('id',$data['arsip_id']);
					if ($this->db->update('arsip',$dat)){
						return true;
					}else{
						return false;
					}
				}
			}else{
				return false;
			}
		} catch (Exception $e) {
			return false;
		}
	}

	function edit_pinjaman($pinjaman_id,$data){
		try {
			$this->db->where('id',$pinjaman_id);
			if ($this->db->update('arsip_pinjam',$data)){
				if ($data['tanggal_kembali']!=''){
					$dat=array('status'=>1);
					$this->db->where('id',$data['arsip_id']);
					if ($this->db->update('arsip',$dat)){
						return true;
					}else{
						return false;
					}
				}else{
					$dat=array('status'=>2);
					$this->db->where('id',$data['arsip_id']);
					if ($this->db->update('arsip',$dat)){
						return true;
					}else{
						return false;
					}
				}
			}else{
				return false;
			}
		} catch (Exception $e) {
			return false;
		}
	}

	function get_last_inserted_id(){
		return $this->db->insert_id();
	}

}