<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class View_laporan_mediasi extends CI_Controller {

	function index(){
		$act = $this->nativesession->get_flash_session('view');
		if($act==='view_rekap_perkara'){
			$this->view_rekap_perkara();
		}elseif($act==='view_laporan'){
			$this->view_laporan_perkara();
		}elseif($act==='view_rekap_perkara_bulan'){
			$this->view_rekap_perkara_bulan();
		}elseif($act==='view_chart1_mediasi'){
			$this->view_chart_mediasi1();
		}elseif($act==='view_chart2_mediasi'){
			$this->view_chart_mediasi2();
		}else{
			show_404();
		}
	}

	function rekap(){
		if(empty($_POST)){
			show_404();
		}

		$event = trim($this->input->post('events',TRUE));
		$th_name = trim($this->input->post('th_name',TRUE));
		$tahun = trim($this->input->post('tahun_opt',TRUE));
		$type = trim($this->input->post('jenis',TRUE));
		$idalur = trim($this->input->post('idalur',TRUE));
		$tahapan = trim($this->input->post('tahapan',TRUE));
		$cetak = trim($this->input->post('cetak',TRUE));
		$status = FALSE;
		if(is_numeric($event)){
			if($event>0 AND $event<=12){
				$this->nativesession->set_flash_session('event','rekap_bulan');
				$this->nativesession->set_flash_session('month',$event);
				$status = TRUE;
			}
		}elseif($event=='tab'){
			$this->nativesession->set_flash_session('event','tab');
			$status = TRUE;
		}elseif($event=='chart1'){
			$this->nativesession->set_flash_session('event','chart1');
			$status = TRUE;
		}elseif($event=='chart2'){
			$this->nativesession->set_flash_session('event','chart2');
			$status = TRUE;
		}

		//$this->nativesession->set_flash_session('idalurperkara',$idalur);

		if(is_numeric($idalur)){
			if($idalur>=0){
				$this->nativesession->set_flash_session('idalur',$idalur);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}


		if(is_numeric($tahun)){
			if($tahun>=0){
				$this->nativesession->set_flash_session('tahun',$tahun);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($type)){
			if($type>0 AND $type<=10){
				$this->nativesession->set_flash_session('type',$type);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($tahapan)){
			if($tahapan==10 OR $tahapan==20 OR $tahapan==30 OR $tahapan==40 OR $tahapan==50 OR $tahapan==60 OR $tahapan==88 OR $tahapan==99){
				$this->nativesession->set_flash_session('tahapan',$tahapan);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		if($status===TRUE  and $event=='tab'){
			$this->nativesession->set_flash_session('view','view_rekap_perkara');
			echo json_encode(array('st'=>1,'msg'=>'Done'));
		}else if($status===TRUE and $event=='chart1'){
			$this->nativesession->set_flash_session('view','view_chart1_mediasi');
			echo json_encode(array('st'=>1,'msg'=>'Done'));
		}else if($status===TRUE and $event=='chart2'){
			$this->nativesession->set_flash_session('view','view_chart2_mediasi');
			echo json_encode(array('st'=>1,'msg'=>'Done'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Invalid Argument'));
		}
	}


	function view_chart_mediasi1(){
		$idalurperkara = $this->nativesession->get_flash_session('idalur');
		$tahun = $this->nativesession->get_flash_session('tahun');
		$type = $this->nativesession->get_flash_session('type');
		$tahapan = $this->nativesession->get_flash_session('tahapan');
		if($type==1){
			$this->load->model('report/report_mediasi_hasil_tahunan','report');
			$data['view_lap'] = 'laporan/view_chart1_perkara_mediasi';
			$data['perkara_nama'] = 'GRAFIK JUMLAH PERKARA MEDIASI DAN HASIL MEDIASI';
		}
		$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
		if($jenis_pengadilan==1)
			$idalurperkara = 1;
		elseif ($jenis_pengadilan==4)
			$idalurperkara = 15;
		else
			$idalurperkara = 1;
		$data['idalurperkara'] = $idalurperkara;

		$data['rekap'] = $this->report->get_rekap($idalurperkara,$tahun);
		$data['tahun'] = $tahun;
		
		
		
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
		}
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}

	function view_chart_mediasi2(){
		$idalurperkara = $this->nativesession->get_flash_session('idalur');
		$tahun = $this->nativesession->get_flash_session('tahun');
		$type = $this->nativesession->get_flash_session('type');
		$tahapan = $this->nativesession->get_flash_session('tahapan');
		if($type==1){
			$this->load->model('report/report_mediasi_hasil_tahunan','report');
			$data['view_lap'] = 'laporan/view_chart2_perkara_mediasi';
			$data['perkara_nama'] = 'GRAFIK JUMLAH PERKARA MEDIASI DAN HASIL MEDIASI';
		}
		$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
		if($jenis_pengadilan==1)
			$idalurperkara = 1;
		elseif ($jenis_pengadilan==4)
			$idalurperkara = 15;
		else
			$idalurperkara = 1;
		$data['idalurperkara'] = $idalurperkara;

		$data['rekap'] = $this->report->get_rekap($idalurperkara,$tahun);
		$data['tahun'] = $tahun;
		
		
		
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
		}
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}

	function rekap_bulan(){
		if(empty($_POST)){
			show_404();
		}

		$event = trim($this->input->post('events',TRUE));
		$th_name = trim($this->input->post('th_name',TRUE));
		$tahun = trim($this->input->post('tahun_opt',TRUE));
		$idalur = trim($this->input->post('idalur',TRUE));
		$type = trim($this->input->post('jenis',TRUE));
		$tahapan = trim($this->input->post('tahapan',TRUE));
		$bulan = trim($this->input->post('bulan',TRUE));
		$cetak = trim($this->input->post('cetak',TRUE));
		$status = FALSE;
		if(is_numeric($event)){
			if($event>0 AND $event<=12){
				$this->nativesession->set_flash_session('event','rekap_bulan');
				$this->nativesession->set_flash_session('month',$event);
				$status = TRUE;
			}
		}elseif($event=='tab'){
			$this->nativesession->set_flash_session('event','tab');
			$status = TRUE;
		}elseif($event=='graph'){
			$this->nativesession->set_flash_session('event','graph');
			$status = TRUE;
		}

		$this->nativesession->set_flash_session('idalurperkara',$idalur);

		if(is_numeric($tahun)){
			if($tahun>=0){
				$this->nativesession->set_flash_session('tahun',$tahun);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($bulan)){
			if($bulan>=0){
				$this->nativesession->set_flash_session('bulan',$bulan);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($type)){
			if($type>0 AND $type<=8){
				$this->nativesession->set_flash_session('type',$type);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($tahapan)){
			if($tahapan==10 OR $tahapan==20 OR $tahapan==30 OR $tahapan==40 OR $tahapan==50 OR $tahapan==60 OR $tahapan==88 OR $tahapan==99){
				$this->nativesession->set_flash_session('tahapan',$tahapan);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		if($status===TRUE){
			$this->nativesession->set_flash_session('view','view_rekap_perkara_bulan');
			echo json_encode(array('st'=>1,'msg'=>'Done'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Invalid Argument'));
		}
	}

	function laporan(){
		if(empty($_POST)){
			show_404();
		}

		$event = trim($this->input->post('month',TRUE));
		$jenis = trim($this->input->post('jenis',TRUE));
		$tahun = trim($this->input->post('tahun_opt',TRUE));
		$tahapan = trim($this->input->post('tahapan',TRUE));
		$lap_mediasi = trim($this->input->post('lap_mediasi',TRUE));
		$status = FALSE;
		if(is_numeric($event)){
			if($event>0 AND $event<=12){
				$this->nativesession->set_flash_session('event','laporan');
				$this->nativesession->set_flash_session('month',$event);
				$status = TRUE;
			}
		}

		if(is_numeric($lap_mediasi)){
			if($lap_mediasi==1 OR $lap_mediasi==2 OR $lap_mediasi==3 OR $lap_mediasi==4 OR $lap_mediasi==5){
				$this->nativesession->set_flash_session('lap_mediasi',$lap_mediasi);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}


		if(is_numeric($tahapan)){
			if($tahapan==10 OR $tahapan==20 OR $tahapan==30 OR $tahapan==40 OR $tahapan==50 OR $tahapan==60 OR $tahapan==88 OR $tahapan==99){
				$this->nativesession->set_flash_session('tahapan',$tahapan);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		$this->nativesession->set_flash_session('idalurperkara',$jenis);
		if(is_numeric($tahun)){
			if($tahun>=0){
				$this->nativesession->set_flash_session('tahun',$tahun);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}

		if($status===TRUE){
			$this->nativesession->set_flash_session('view','view_laporan');
			echo json_encode(array('st'=>1,'msg'=>'Silahkan Membuka Laporan Pada Tab'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Invalid Argument'));
		}
	}

	function view_rekap_perkara_bulan(){
		$idalurperkara = $this->nativesession->get_flash_session('idalurperkara');
		$tahun = $this->nativesession->get_flash_session('tahun');
		$bulan = $this->nativesession->get_flash_session('bulan');
		$type = $this->nativesession->get_flash_session('type');
		$tahapan = $this->nativesession->get_flash_session('tahapan');
		$data['bulan'] = $bulan;
		$bulan = ($bulan<10)? '0'.$bulan:$bulan;
		$periode = $tahun.'-'.$bulan;
		$this->load->model('report/report','report');
		$data['laporan'] = $this->report->get_stat_perkara_bln($periode,$idalurperkara);
		$data['tahun'] = $tahun;
		$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
		if($jenis_pengadilan==1)
			$idalurperkara = 1;
		elseif ($jenis_pengadilan==4)
			$idalurperkara = 15;
		else
			$idalurperkara = 1;
		$data['idalurperkara'] = $idalurperkara;
		//$data['perkara_nama'] = strtoupper($this->report->getJenisPerkara($idalurperkara));
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
		}
		$data['view_lap'] = 'laporan/view_laporan_perkara_bulan';
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}

	function view_rekap_perkara(){
		$idalurperkara = $this->nativesession->get_flash_session('idalur');
		$tahun = $this->nativesession->get_flash_session('tahun');
		$type = $this->nativesession->get_flash_session('type');
		$tahapan = $this->nativesession->get_flash_session('tahapan');
		if($type==1){
			$this->load->model('report/report_mediasi_hasil_tahunan','report');
			$data['view_lap'] = 'laporan/view_mediasi_hasil_tahunan';
			$data['perkara_nama'] = 'JUMLAH PERKARA MEDIASI DAN HASIL MEDIASI';
		}elseif($type==2){
			$this->load->model('report/report_mediasi_klasifikasi_tahunan','report');
			$data['view_lap'] = 'laporan/view_mediasi_klasifikasi_tahunan';
			$data['perkara_nama'] = 'MEDIASI BERDASARKAN KLASIFIKASI PERKARA';
			$data['nama_kolom'] = 'Klasifikasi Per Jenis Perkara';
		}elseif($type==3){
			$this->load->model('report/report_mediasi_klasifikasi_periode','report');
			$data['view_lap'] = 'laporan/view_mediasi_klasifikasi_periode';
			$data['perkara_nama'] = 'MEDIASI BERDASARKAN KLASIFIKASI PERKARA PER PERIODE';
			// $data['nama_kolom'] = 'Nama Mediator';
		}elseif($type==4){
			$this->load->model('report/report_rekapitulasi_mediator_tahunan','report');
			$data['view_lap'] = 'laporan/view_mediasi_klasifikasi_tahunan';
			$data['perkara_nama'] = 'REKAPITULASI MEDIASI BERDASARKAN MEDIATOR';
			$data['nama_kolom'] = 'Nama Mediator';
		}elseif($type==5){
			$this->load->model('report/report_rekapitulasi_mediator_periode','report');
			$data['view_lap'] = 'laporan/view_rekapitulasi_mediator_periode';
			$data['perkara_nama'] = 'REKAPITULASI MEDIASI BERDASARKAN MEDIATOR PER PERIODE';
			// $data['nama_kolom'] = 'Nama Mediator';
		}elseif($type==6){
			$this->load->model('report/report_mediasi_status_mediator_tahunan','report');
			$data['view_lap'] = 'laporan/view_mediasi_klasifikasi_tahunan';
			$data['perkara_nama'] = 'HASIL MEDIASI BERDASARKAN STATUS MEDIATOR';
			$data['nama_kolom'] = 'Status Mediator';
		}elseif($type==7){
			$this->load->model('report/report_mediasi_status_mediator_periode','report');
			$data['view_lap'] = 'laporan/view_mediasi_status_mediator_periode';
			$data['perkara_nama'] = 'LAPORAN HASIL MEDIASI BERDASARKAN STATUS MEDIATOR PER PERIODE';
			// $data['nama_kolom'] = 'Nama Mediator';
		}elseif($type==8){
			$this->load->model('report/report_rekapitulasi_mediator_tahunan','report');
			$data['view_lap'] = 'laporan/view_mediasi_klasifikasi_tahunan';
			$data['perkara_nama'] = 'JUMLAH MEDIASI BERDASARKAN MEDIATOR';
			$data['nama_kolom'] = 'Nama Mediator';
		}elseif($type==9){
			$this->load->model('report/report_rekapitulasi_mediasi_pihak','report');
			$data['view_lap'] = 'laporan/view_rekapitulasi_mediasi_pihak';
			$data['perkara_nama'] = 'JUMLAH MEDIASI BERDASARKAN PIHAK';
			// $data['nama_kolom'] = 'Nama Mediator';
		}elseif($type==10){
			$this->load->model('report/report_rekapitulasi_mediasi_perkara','report');
			$data['view_lap'] = 'laporan/view_rekapitulasi_mediasi_perkara';
			$data['perkara_nama'] = 'JUMLAH PERKARA MEDIASI';
			// $data['nama_kolom'] = 'Nama Mediator';
		}
		
		$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
		if($jenis_pengadilan==1)
			$idalurperkara = 1;
		elseif ($jenis_pengadilan==4)
			$idalurperkara = 15;
		else
			$idalurperkara = 1;
		$data['idalurperkara'] = $idalurperkara;

		$data['rekap'] = $this->report->get_rekap($idalurperkara,$tahun);
		$data['tahun'] = $tahun;
		
		
		
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
			if($row->id == 64){
				if(!empty($row->value)){
					$data['nama_ketua'] = $row->value;
				}
			}
			if($row->id == 65){
				if(!empty($row->value)){
					$data['nip_ketua'] = $row->value;
				}
			}
			if($row->id == 68){
				if(!empty($row->value)){
					$data['nama_pan'] = $row->value;
				}
			}
			if($row->id == 69){
				if(!empty($row->value)){
					$data['nip_pan'] = $row->value;
				}
			}
		}
		$data['lap_mediasi'] = $type;
		$data['jenis_lap_mediasi'] = 2;
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}

	function view_laporan_perkara(){
		$idalurperkara = $this->nativesession->get_flash_session('idalurperkara');
		$tahun = $this->nativesession->get_flash_session('tahun');
		$bulan = $this->nativesession->get_flash_session('month');
		$tahapan = $this->nativesession->get_flash_session('tahapan');
		$lap_mediasi = $this->nativesession->get_flash_session('lap_mediasi');
		$cetak = $this->nativesession->get_flash_session('cetak');
		if($tahapan==10 && $lap_mediasi==1){
			$this->load->model('report/report_mediasi_klasifikasi','report');
			$data['view_lap'] = 'laporan/view_mediasi_klasifikasi_tahunan';
			$data['perkara_nama'] = 'LAPORAN MEDIASI BERDASARKAN KLASIFIKASI PERKARA';
			$data['nama_kolom'] = 'Klasifikasi Per Jenis Perkara';
		}elseif($tahapan==10 && $lap_mediasi==2){
			$this->load->model('report/report_rekapitulasi_mediator','report');
			$data['view_lap'] = 'laporan/view_mediasi_klasifikasi_tahunan';
			$data['perkara_nama'] = 'LAPORAN MEDIASI BERDASARKAN MEDIATOR';
			$data['nama_kolom'] = 'Nama Mediator';
		}elseif($tahapan==10 && $lap_mediasi==3){
			$this->load->model('report/report_status_mediator','report');
			$data['view_lap'] = 'laporan/view_mediasi_klasifikasi_tahunan';
			$data['perkara_nama'] = 'LAPORAN MEDIASI BERDASARKAN STATUS MEDIATOR';
			$data['nama_kolom'] = 'Status Mediator';
		}elseif($tahapan==10 && $lap_mediasi==4){
			$this->load->model('report/report_rekapitulasi_mediator','report');
			$data['view_lap'] = 'laporan/view_mediasi_klasifikasi_tahunan';
			$data['perkara_nama'] = 'LAPORAN MEDIASI BERDASARKAN MEDIATOR';
		}elseif($tahapan==10 && $lap_mediasi==5){
			$this->load->model('report/report_mediasi_bulanan','report');
			$data['view_lap'] = 'laporan/view_laporan_mediasi_bulanan';
			$data['perkara_nama'] = 'LAPORAN MEDIASI BULANAN';
		}


		if($tahapan>=10 AND ($idalurperkara=='1,2' OR $idalurperkara=='3,4')){
			$data['perkara_nama'] ='PERDATA';
		}elseif($tahapan>=10 AND ($idalurperkara=='111,112,113,114')){
			$data['perkara_nama'] ='PIDANA';
		}
		$data['tahun'] = $tahun;
		$data['bulan'] = $bulan;
		$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
		if($jenis_pengadilan==1)
			$idalurperkara = 1;
		elseif ($jenis_pengadilan==4)
			$idalurperkara = 15;
		else
			$idalurperkara = 1;
		$data['idalurperkara'] = $idalurperkara;
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
			if($row->id == 64){
				if(!empty($row->value)){
					$data['nama_ketua'] = $row->value;
				}
			}
			if($row->id == 65){
				if(!empty($row->value)){
					$data['nip_ketua'] = $row->value;
				}
			}
			if($row->id == 68){
				if(!empty($row->value)){
					$data['nama_pan'] = $row->value;
				}
			}
			if($row->id == 69){
				if(!empty($row->value)){
					$data['nip_pan'] = $row->value;
				}
			}
		}
		$bln = ($bulan<10)? '0'.$bulan:$bulan;
		$data['bulanmed']=($bulan<10)? '0'.$bulan:$bulan;
		$period = $tahun.'-'.$bln;
		$data['laporan'] = $this->report->get_lap_perkara($period,$idalurperkara);
		$data['rekap'] = $this->report->get_lap_perkara($period,$idalurperkara);
		$data['stat'] = $this->report->get_stat_perkara($period,$idalurperkara);

		$data['idalurperkara'] = $idalurperkara;
		$data['tahun'] = $tahun;
		$data['bulan'] = $bulan;
		$data['tahapan'] = $lap_mediasi;
		$data['lap_mediasi'] = $lap_mediasi;
		$data['jenis_lap_mediasi'] = 1;
		$data['cetak'] = $cetak;

		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}


	function detil_mediator_thn(){
		$idalurperkara = $this->nativesession->get_flash_session('idalur');
		$tahun = $this->nativesession->get_flash_session('tahun');
		$type = $this->nativesession->get_flash_session('type');
		$tahapan = $this->nativesession->get_flash_session('tahapan');
		
		$segment = $this->uri->segment_array();
		$data['idmediator'] = $this->encrypt->decode(base64_decode($segment[3]));
		$data['tahun'] = $this->encrypt->decode(base64_decode($segment[4]));
		$data['idalurperkara'] = $this->encrypt->decode(base64_decode($segment[5]));
		$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
		if($jenis_pengadilan==1)
			$idalurperkara = 1;
		elseif ($jenis_pengadilan==4)
			$idalurperkara = 15;
		else
			$idalurperkara = 1;
		$data['idalurperkara'] = $idalurperkara;
		$data['nama_mediator'] = $this->encrypt->decode(base64_decode($segment[6]));

		$this->load->model('report/report_rekapitulasi_mediator_detil','report');
		$data['view_lap'] = 'laporan/view_rekapitulasi_mediator_detil';
		$data['perkara_nama'] = 'REKAPITULASI MEDIASI DETIL MEDIATOR';

		$data['rekap'] = $this->report->get_rekap($data['idmediator'],$data['idalurperkara'],$data['tahun']);
		
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
		}
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}

	function detil_mediator_bln(){
		$idalurperkara = $this->nativesession->get_flash_session('idalur');
		$tahun = $this->nativesession->get_flash_session('tahun');
		$type = $this->nativesession->get_flash_session('type');
		$tahapan = $this->nativesession->get_flash_session('tahapan');
		
		$segment = $this->uri->segment_array();
		$data['idmediator'] = $this->encrypt->decode(base64_decode($segment[3]));	
		$data['idalurperkara'] = $this->encrypt->decode(base64_decode($segment[5]));
		$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
		if($jenis_pengadilan==1)
			$idalurperkara = 1;
		elseif ($jenis_pengadilan==4)
			$idalurperkara = 15;
		else
			$idalurperkara = 1;
		$data['idalurperkara'] = $idalurperkara;
		$data['tahun'] = $this->encrypt->decode(base64_decode($segment[4]));
		$data['bulan'] = $this->encrypt->decode(base64_decode($segment[6]));
		$data['nama_mediator'] = $this->encrypt->decode(base64_decode($segment[7]));
		$periode=$data['tahun'].'-'.$data['bulan'];

		$this->load->model('report/report_rekapitulasi_mediator_detil_bln','report');
		$data['view_lap'] = 'laporan/view_rekapitulasi_mediator_detil_bln';
		$data['perkara_nama'] = 'REKAPITULASI MEDIASI DETIL MEDIATOR';

		$data['rekap'] = $this->report->get_rekap($data['idmediator'],$data['idalurperkara'],$periode);
		
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
		}
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}

	function detail_mediasi_perkara(){
		$segment = $this->uri->segment_array();
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($segment[3]));	
		$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
		if($jenis_pengadilan==1)
			$idalurperkara = 1;
		elseif ($jenis_pengadilan==4)
			$idalurperkara = 15;
		else
			$idalurperkara = 1;

		$this->load->model('report/report_mediasi_detail_perkara','report');
		$data['view_lap'] = 'laporan/view_mediasi_detail_perkara';
		$data['perkara_nama'] = 'REKAPITULASI MEDIASI DETAIL PERKARA';

		$perkara= $this->report->get_data('perkara',$data['perkara_id']);
		$data['perkara_pihak']= $this->report->get_data_pihak($data['perkara_id']);
		$data['perkara_mediator']= $this->report->get_data('perkara_mediator AS a LEFT JOIN mediator AS b ON a.mediator_id=b.id',$data['perkara_id']);
		$perkara_penetapan= $this->report->get_data('perkara_penetapan',$data['perkara_id']);
		$perkara_panitera_pn= $this->report->get_data('perkara_panitera_pn',$data['perkara_id']);
		$perkara_mediasi= $this->report->get_data('perkara_mediasi',$data['perkara_id']);
		if($perkara_mediasi->num_rows>0){
			$data['perkara_jadwal_mediasi']= $this->report->get_jadwal_mediasi($perkara_mediasi->result()[0]->mediasi_id);
		}

		if($perkara->num_rows()>0){
			$temp = $perkara->result();
			$data['nomor_perkara'] = $temp[0]->nomor_perkara;
			$data['jenis_perkara'] = $temp[0]->jenis_perkara_nama;
			if($temp[0]->alur_perkara_id==15&&$temp[0]->jenis_perkara_id==346){
				$data['sebagai_p'] = "Pemohon";
				$data['sebagai_t'] = "Termohon";
			}else{
				$data['sebagai_p'] = "Penggugat";
				$data['sebagai_t'] = "Tergugat";
			}

		}

		$pihak_perorangan = 0;
		$pihak_badan_hukum = 0;
		if($data['perkara_pihak']->num_rows()>0){
			foreach ($data['perkara_pihak']->result() as $row) {
				if($row->jenis_pihak_id==1){
					$pihak_perorangan = 1;
				}
				if($row->jenis_pihak_id>1){
					$pihak_badan_hukum = 1;
				}
			}
		}
		
		$data['kategori_pihak']='';
		
		if($pihak_perorangan==1){
			$data['kategori_pihak']='Personal';
		}

		if($pihak_badan_hukum==1){
			if($data['kategori_pihak']=='Personal'){
				$data['kategori_pihak'].="/";
			}
			$data['kategori_pihak'].="Badan Hukum";
		}

		foreach ($perkara_penetapan->result() as $row) {
			$data['majelis'] = $row->majelis_hakim_text;
			$data['pp'] = str_replace('Panitera Pengganti: ', '', $row->panitera_pengganti_text);
		}

		foreach ($perkara_mediasi->result() as $row) {
			$data['tgl_laporan_mediasi'] = $row->tgl_laporan_mediator;
			switch ($row->hasil_mediasi) {
				case 'Y1':
					$hasil_mediasi='Berhasil Dengan Kesepakatan';
					$tgl_akta = $row->akta_perdamaian;
					break;
				case 'Y2':
					$hasil_mediasi='Berhasil Dengan Pencabutan';
					$tgl_akta = $data['perkara_pihak']->result()[0]->tanggal_putusan;
					break;
				case 'S':
					$hasil_mediasi='Berhasil Sebagian';
					$tgl_akta = '-';
					break;
				case 'T':
					$hasil_mediasi='Tidak Berhasil';
					$tgl_akta = '-';
					break;
				case 'D':
					$hasil_mediasi='Tidak Dapat Dilaksanakan';
					$tgl_akta = '-';
					break;
			}
			if($tgl_akta==''){
				$tgl_akta='-';
			}
			if($tgl_akta!=''){
				$tgl_akta=$this->templatehelper->convertKeTglIndo($tgl_akta);
			}
			$data['hasil_mediasi'] = $hasil_mediasi;
			$data['tgl_kesepakatan_damai'] = $row->tgl_kesepakatan_perdamaian;
			$data['isi_kesepakatan_damai'] = $row->isi_kesepakatan_perdamaian;
			$data['tgl_akta'] = $tgl_akta;
			$data['isi_akta_perdamaian'] = $row->isi_akta_perdamaian;
		}

		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
		}
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}

}