<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class View_laporan_gugatan_sederhana extends CI_Controller {
	function rekap(){
		if(empty($_POST)){
			show_404();
		}

		$event = trim($this->input->post('events',TRUE));
		$th_name = trim($this->input->post('th_name',TRUE));
		$tahun = trim($this->input->post('tahun_opt',TRUE));
		$type = trim($this->input->post('jenis',TRUE));
		$idalur = trim($this->input->post('idalur',TRUE));
		$tahapan = trim($this->input->post('tahapan',TRUE));
		$status = FALSE;
		if(is_numeric($event)){
			if($event>0 AND $event<=12){
				$this->nativesession->set_flash_session('event','rekap_bulan');
				$this->nativesession->set_flash_session('month',$event);
				$status = TRUE;
			}
		}elseif($event=='tab'){
			$this->nativesession->set_flash_session('event','tab');
			$status = TRUE;
		}elseif($event=='graph'){
			$this->nativesession->set_flash_session('event','graph');
			$status = TRUE;
		}

		if(is_numeric($idalur)){
			if($idalur>=0){
				$this->nativesession->set_flash_session('idalur',$idalur);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}


		if(is_numeric($tahun)){
			if($tahun>=0){
				$this->nativesession->set_flash_session('tahun',$tahun);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($type)){
			if($type>0 AND $type<=6){
				$this->nativesession->set_flash_session('type',$type);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($tahapan)){
			if($tahapan==10 OR $tahapan==20 OR $tahapan==30 OR $tahapan==40 OR $tahapan==50 OR $tahapan==60 OR $tahapan==88 OR $tahapan==99){
				$this->nativesession->set_flash_session('tahapan',$tahapan);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		if($status===TRUE){
			$this->nativesession->set_flash_session('view','view_rekap_perkara');
			echo json_encode(array('st'=>1,'msg'=>'Done'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Invalid Argument'));
		}
	}

	function rekap_bulan(){
		if(empty($_POST)){
			show_404();
		}

		$event = trim($this->input->post('events',TRUE));
		$th_name = trim($this->input->post('th_name',TRUE));
		$tahun = trim($this->input->post('tahun_opt',TRUE));
		$idalur = trim($this->input->post('idalur',TRUE));
		$type = trim($this->input->post('jenis',TRUE));
		$tahapan = trim($this->input->post('tahapan',TRUE));
		$bulan = trim($this->input->post('bulan',TRUE));
		$status = FALSE;
		if(is_numeric($event)){
			if($event>0 AND $event<=12){
				$this->nativesession->set_flash_session('event','rekap_bulan');
				$this->nativesession->set_flash_session('month',$event);
				$status = TRUE;
			}
		}elseif($event=='tab'){
			$this->nativesession->set_flash_session('event','tab');
			$status = TRUE;
		}elseif($event=='graph'){
			$this->nativesession->set_flash_session('event','graph');
			$status = TRUE;
		}

		$this->nativesession->set_flash_session('idalurperkara',$idalur);

		if(is_numeric($tahun)){
			if($tahun>=0){
				$this->nativesession->set_flash_session('tahun',$tahun);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($bulan)){
			if($bulan>=0){
				$this->nativesession->set_flash_session('bulan',$bulan);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($type)){
			if($type>0 AND $type<=6){
				$this->nativesession->set_flash_session('type',$type);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($tahapan)){
			if($tahapan==10 OR $tahapan==20 OR $tahapan==30 OR $tahapan==40 OR $tahapan==50 OR $tahapan==60 OR $tahapan==88 OR $tahapan==99){
				$this->nativesession->set_flash_session('tahapan',$tahapan);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		if($status===TRUE){
			$this->nativesession->set_flash_session('view','view_rekap_perkara_bulan');
			echo json_encode(array('st'=>1,'msg'=>'Done'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Invalid Argument'));
		}
	}

	function laporan(){
		if(empty($_POST)){
			show_404();
		}
		$event = trim($this->input->post('month',TRUE));
		$jenis = trim($this->input->post('jenis',TRUE));
		$tahun = trim($this->input->post('tahun_opt',TRUE));
		$tahapan = trim($this->input->post('tahapan',TRUE));
		$lap_gugatan_sederhana = trim($this->input->post('lap_gugatan_sederhana',TRUE));
		$status = FALSE;
		if(is_numeric($event)){
			if($event>0 AND $event<=12){
				$this->nativesession->set_flash_session('event','laporan');
				$this->nativesession->set_flash_session('month',$event);
				$status = TRUE;
			}
		}

		if(is_numeric($lap_gugatan_sederhana)){
			if($lap_gugatan_sederhana==1 OR $lap_gugatan_sederhana==2 OR $lap_gugatan_sederhana==3 OR $lap_gugatan_sederhana==4){
				$this->nativesession->set_flash_session('lap_gugatan_sederhana',$lap_gugatan_sederhana);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}


		if(is_numeric($tahapan)){
			if($tahapan==10 OR $tahapan==20 OR $tahapan==30 OR $tahapan==40 OR $tahapan==50 OR $tahapan==60 OR $tahapan==88 OR $tahapan==99){
				$this->nativesession->set_flash_session('tahapan',$tahapan);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		$this->nativesession->set_flash_session('idalurperkara',$jenis);
		if(is_numeric($tahun)){
			if($tahun>=0){
				$this->nativesession->set_flash_session('tahun',$tahun);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}

		if($status===TRUE){
			$this->nativesession->set_flash_session('view','view_laporan');
			echo json_encode(array('st'=>1,'msg'=>'Silahkan Membuka Laporan Pada Tab'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Invalid Argument'));
		}
	}




	function index(){
		$act = $this->nativesession->get_flash_session('view');
		if($act==='view_rekap_perkara'){
			$this->view_rekap_perkara();
		}elseif($act==='view_laporan'){
			$this->view_laporan_perkara();
		}elseif($act==='view_rekap_perkara_bulan'){
			$this->view_rekap_perkara_bulan();
		}else{
			show_404();
		}
	}




	function view_rekap_perkara_bulan(){
		$idalurperkara = $this->nativesession->get_flash_session('idalurperkara');
		$tahun = $this->nativesession->get_flash_session('tahun');
		$bulan = $this->nativesession->get_flash_session('bulan');
		$type = $this->nativesession->get_flash_session('type');
		$tahapan = $this->nativesession->get_flash_session('tahapan');
		$data['bulan'] = $bulan;
		$bulan = ($bulan<10)? '0'.$bulan:$bulan;
		$periode = $tahun.'-'.$bulan;
		$this->load->model('report/report','report');
		$data['laporan'] = $this->report->get_stat_perkara_bln($periode,$idalurperkara);
		$data['tahun'] = $tahun;
		$data['idalurperkara'] = $idalurperkara;
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
		}
		$data['view_lap'] = 'laporan/view_laporan_perkara_bulan';
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}
	function view_rekap_perkara(){
		$idalurperkara = $this->nativesession->get_flash_session('idalur');
		$tahun = $this->nativesession->get_flash_session('tahun');
		$type = $this->nativesession->get_flash_session('type');
		$tahapan = $this->nativesession->get_flash_session('tahapan');
		if($type==1){
			$this->load->model('report/report_gugatan_sederhana_jumlah_perkara','report');
			$data['view_lap'] = 'laporan/view_laporan_gugatan_sederhana_jumlah_perkara';
			$data['perkara_nama'] = 'REKAPITULISASI PERKARA GUGATAN SEDERHANA';
		} else if ($type==2){
			$this->load->model('report/report_gugatan_sederhana_hakim','report');
			$data['view_lap'] = 'laporan/view_laporan_gugatan_sederhana_hakim';
			$data['perkara_nama'] = 'REKAPITULISASI PERKARA GUGATAN SEDERHANA';
		}else if ($type==3){
			$this->load->model('report/report_gugatan_sederhana_penyelesaian_perkara','report');
			$data['view_lap'] = 'laporan/view_laporan_gugatan_sederhana_penyelesaian_perkara';
			$data['perkara_nama'] = 'REKAPITULISASI RATA - RATA WAKTU PENYELESAIAN PERKARA GUGATAN SEDERHANA';
		}else if ($type==4){
			$this->load->model('report/report_gugatan_sederhana_persiapan_pendaftaran_panggilan','report');
			$data['view_lap'] = 'laporan/view_laporan_gugatan_sederhana_persiapan_pendaftaran_panggilan';
			$data['perkara_nama'] = 'REKAPITULISASI RATA - RATA WAKTU PERSIAPAN PERKARA GUGATAN SEDERHANA';
		}else if ($type==5){
			$this->load->model('report/report_gugatan_sederhana_penyelesaian_keberatan','report');
			$data['view_lap'] = 'laporan/view_laporan_gugatan_sederhana_penyelesaian_keberatan';
			$data['perkara_nama'] = 'REKAPITULISASI RATA - RATA WAKTU PENYELESAIAN PERKARA KEBERATAN';
		}else if ($type==6){
			$this->load->model('report/report_gugatan_sederhana_penyelesaian_keberatan_panggilan_keluar','report');
			$data['view_lap'] = 'laporan/view_laporan_gugatan_sederhana_penyelesaian_keberatan_panggilan_keluar';
			$data['perkara_nama'] = 'REKAPITULISASI RATA - RATA WAKTU PERSIAPAN PERKARA KEBERATAN';
		}
		
		$data['rekap'] = $this->report->get_rekap($idalurperkara,$tahun);
		$data['tahun'] = $tahun;
		
		$data['idalurperkara'] = $idalurperkara;
		
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
		}
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}

	function view_laporan_perkara(){
		
		$idalurperkara = $this->nativesession->get_flash_session('idalurperkara');
		$tahun = $this->nativesession->get_flash_session('tahun');
		$bulan = $this->nativesession->get_flash_session('month');
		$tahapan = $this->nativesession->get_flash_session('tahapan');
		$lap_gugatan_sederhana = $this->nativesession->get_flash_session('lap_gugatan_sederhana');
		//if($tahapan==10 && $lap_gugatan_sederhana==1){
			$this->load->model('report/report_gugatan_sederhana_klasifikasi_perkara','report');
			$data['view_lap'] = 'laporan/view_laporan_gugatan_sederhana_klasifikasi';
			$data['perkara_nama'] = 'LAPORAN GUGATAN SEDERHANA BERDASARKAN KLASIFIKASI PERKARA';
		//}else{
		//	print_r(DODON);
		//	show_404();
		//}


		if($tahapan>=10 AND ($idalurperkara=='1,2,8' OR $idalurperkara=='3,4')){
			$data['perkara_nama'] ='PERDATA';
		}elseif($tahapan>=10 AND ($idalurperkara=='111,112,113,114')){
			$data['perkara_nama'] ='PIDANA';
		}
		$data['tahun'] = $tahun;
		$data['bulan'] = $bulan;
		
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
		}
		$bln = ($bulan<10)? '0'.$bulan:$bulan;
		$period = $tahun.'-'.$bln;
		$data['laporan'] = $this->report->get_lap_perkara($period);
		$data['stat'] = $this->report->get_stat_perkara($period,$idalurperkara);
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}
}