<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class View_laporan_agama extends CI_Controller {
	function rekap(){
		if(empty($_POST)){
			show_404();
		}

		$event = trim($this->input->post('events',TRUE));
		$th_name = trim($this->input->post('th_name',TRUE));
		$tahun = trim($this->input->post('tahun_opt',TRUE));
		$type = trim($this->input->post('jenis',TRUE));
		$idalur = trim($this->input->post('idalur',TRUE));
		$tahapan = trim($this->input->post('tahapan',TRUE));
		$status = FALSE;
		if(is_numeric($event)){
			if($event>0 AND $event<=12){
				$this->nativesession->set_flash_session('event','rekap_bulan');
				$this->nativesession->set_flash_session('month',$event);
				$status = TRUE;
			}
		}elseif($event=='tab'){
			$this->nativesession->set_flash_session('event','tab');
			$status = TRUE;
		}elseif($event=='graph'){
			$this->nativesession->set_flash_session('event','graph');
			$status = TRUE;
		}

		//$this->nativesession->set_flash_session('idalurperkara',$idalur);

		if(is_numeric($idalur)){
			if($idalur>=0){
				$this->nativesession->set_flash_session('idalur',$idalur);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}


		if(is_numeric($tahun)){
			if($tahun>=0){
				$this->nativesession->set_flash_session('tahun',$tahun);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($type)){
			if($type>0 AND $type<=9){
				$this->nativesession->set_flash_session('type',$type);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($tahapan)){
			if($tahapan==10 OR $tahapan==20 OR $tahapan==30 OR $tahapan==40 OR $tahapan==50 OR $tahapan==60 OR $tahapan==88 OR $tahapan==99){
				$this->nativesession->set_flash_session('tahapan',$tahapan);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		if($status===TRUE){
			$this->nativesession->set_flash_session('view','view_rekap_perkara');
			echo json_encode(array('st'=>1,'msg'=>'Done'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Invalid Argument'));
		}
	}

	function rekap_bulan(){
		if(empty($_POST)){
			show_404();
		}

		$event = trim($this->input->post('events',TRUE));
		$th_name = trim($this->input->post('th_name',TRUE));
		$tahun = trim($this->input->post('tahun_opt',TRUE));
		$idalur = trim($this->input->post('idalur',TRUE));
		$type = trim($this->input->post('jenis',TRUE));
		$tahapan = trim($this->input->post('tahapan',TRUE));
		$bulan = trim($this->input->post('bulan',TRUE));
		$status = FALSE;
		if(is_numeric($event)){
			if($event>0 AND $event<=12){
				$this->nativesession->set_flash_session('event','rekap_bulan');
				$this->nativesession->set_flash_session('month',$event);
				$status = TRUE;
			}
		}elseif($event=='tab'){
			$this->nativesession->set_flash_session('event','tab');
			$status = TRUE;
		}elseif($event=='graph'){
			$this->nativesession->set_flash_session('event','graph');
			$status = TRUE;
		}

		$this->nativesession->set_flash_session('idalurperkara',$idalur);

		if(is_numeric($tahun)){
			if($tahun>=0){
				$this->nativesession->set_flash_session('tahun',$tahun);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($bulan)){
			if($bulan>=0){
				$this->nativesession->set_flash_session('bulan',$bulan);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($type)){
			if($type>0 AND $type<=8){
				$this->nativesession->set_flash_session('type',$type);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($tahapan)){
			if($tahapan==10 OR $tahapan==20 OR $tahapan==30 OR $tahapan==40 OR $tahapan==50 OR $tahapan==60 OR $tahapan==88 OR $tahapan==99){
				$this->nativesession->set_flash_session('tahapan',$tahapan);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		if($status===TRUE){
			$this->nativesession->set_flash_session('view','view_rekap_perkara_bulan');
			echo json_encode(array('st'=>1,'msg'=>'Done'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Invalid Argument'));
		}
	}

	function laporan(){
		if(empty($_POST)){
			show_404();
		}

		$event = trim($this->input->post('month',TRUE));
		$jenis = trim($this->input->post('jenis',TRUE));
		$tahun = trim($this->input->post('tahun_opt',TRUE));
		$tahapan = trim($this->input->post('tahapan',TRUE));
		$lap_agama = trim($this->input->post('lap_agama',TRUE));
		$status = FALSE;
		if(is_numeric($event)){
			if($event>0 AND $event<=12){
				$this->nativesession->set_flash_session('event','laporan');
				$this->nativesession->set_flash_session('month',$event);
				$status = TRUE;
			}
		}

		if(is_numeric($lap_agama)){
			if($lap_agama==1 OR $lap_agama==2 OR $lap_agama==3 OR $lap_agama==4 OR $lap_agama==5 OR $lap_agama==6 OR $lap_agama==7 OR $lap_agama==8 OR $lap_agama==9 OR $lap_agama==10 OR $lap_agama==11 
				OR $lap_agama==12 OR $lap_agama==13 OR $lap_agama==14 OR $lap_agama==15 OR $lap_agama==16 OR $lap_agama==17 OR $lap_agama==18 OR $lap_agama==19){
				$this->nativesession->set_flash_session('lap_agama',$lap_agama);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}


		if(is_numeric($tahapan)){
			if($tahapan==10 OR $tahapan==20 OR $tahapan==30 OR $tahapan==40 OR $tahapan==50 OR $tahapan==60 OR $tahapan==88 OR $tahapan==99){
				$this->nativesession->set_flash_session('tahapan',$tahapan);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		$this->nativesession->set_flash_session('idalurperkara',$jenis);
		if(is_numeric($tahun)){
			if($tahun>=0){
				$this->nativesession->set_flash_session('tahun',$tahun);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}

		if($status===TRUE){
			$this->nativesession->set_flash_session('view','view_laporan');
			echo json_encode(array('st'=>1,'msg'=>'Silahkan Membuka Laporan Pada Tab'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Invalid Argument'));
		}
	}

	function index(){
		$act = $this->nativesession->get_flash_session('view');
		if($act==='view_rekap_perkara'){
			$this->view_rekap_perkara();
		}elseif($act==='view_laporan'){
			$this->view_laporan_perkara();
		}elseif($act==='view_rekap_perkara_bulan'){
			$this->view_rekap_perkara_bulan();
		}else{
			show_404();
		}
	}

	function view_rekap_perkara_bulan(){
		$idalurperkara = $this->nativesession->get_flash_session('idalurperkara');
		$tahun = $this->nativesession->get_flash_session('tahun');
		$bulan = $this->nativesession->get_flash_session('bulan');
		$type = $this->nativesession->get_flash_session('type');
		$tahapan = $this->nativesession->get_flash_session('tahapan');
		$data['bulan'] = $bulan;
		$bulan = ($bulan<10)? '0'.$bulan:$bulan;
		$periode = $tahun.'-'.$bulan;
		$this->load->model('report/report','report');
		$data['laporan'] = $this->report->get_stat_perkara_bln($periode,$idalurperkara);
		$data['tahun'] = $tahun;
		$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
		if($jenis_pengadilan==1)
			$idalurperkara = 1;
		elseif ($jenis_pengadilan==4)
			$idalurperkara = 15;
		else
			$idalurperkara = 1;
		$data['idalurperkara'] = $idalurperkara;
		//$data['perkara_nama'] = strtoupper($this->report->getJenisPerkara($idalurperkara));
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
		}
		$data['view_lap'] = 'laporan/view_laporan_perkara_bulan';
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}

	function view_rekap_perkara(){
		$idalurperkara = $this->nativesession->get_flash_session('idalur');
		$tahun = $this->nativesession->get_flash_session('tahun');
		$type = $this->nativesession->get_flash_session('type');
		$tahapan = $this->nativesession->get_flash_session('tahapan');
		if($type==1){
			$this->load->model('report/report_mediasi_hasil_tahunan','report');
			$data['view_lap'] = 'laporan/view_mediasi_hasil_tahunan';
			$data['perkara_nama'] = 'JUMLAH PERKARA MEDIASI DAN HASIL MEDIASI';
		}elseif($type==2){
			$this->load->model('report/report_mediasi_klasifikasi_tahunan','report');
			$data['view_lap'] = 'laporan/view_mediasi_klasifikasi_tahunan';
			$data['perkara_nama'] = 'MEDIASI BERDASARKAN KLASIFIKASI PERKARA';
		}elseif($type==3){
			$this->load->model('report/report_mediasi_klasifikasi_periode','report');
			$data['view_lap'] = 'laporan/view_mediasi_klasifikasi_periode';
			$data['perkara_nama'] = 'MEDIASI BERDASARKAN KLASIFIKASI PERKARA PER PERIODE';
		}elseif($type==4){
			$this->load->model('report/report_rekapitulasi_mediator_tahunan','report');
			$data['view_lap'] = 'laporan/view_rekapitulasi_mediator_tahunan';
			$data['perkara_nama'] = 'REKAPITULASI MEDIASI BERDASARKAN MEDIATOR';
		}elseif($type==5){
			$this->load->model('report/report_rekapitulasi_mediator_periode','report');
			$data['view_lap'] = 'laporan/view_rekapitulasi_mediator_periode';
			$data['perkara_nama'] = 'REKAPITULASI MEDIASI BERDASARKAN MEDIATOR PER PERIODE';
		}elseif($type==6){
			$this->load->model('report/report_mediasi_status_mediator_tahunan','report');
			$data['view_lap'] = 'laporan/view_mediasi_status_mediator_tahunan';
			$data['perkara_nama'] = 'HASIL MEDIASI BERDASARKAN STATUS MEDIATOR';
		}elseif($type==7){
			$this->load->model('report/report_mediasi_status_mediator_periode','report');
			$data['view_lap'] = 'laporan/view_mediasi_status_mediator_periode';
			$data['perkara_nama'] = 'LAPORAN HASIL MEDIASI BERDASARKAN STATUS MEDIATOR PER PERIODE';
		}elseif($type==8){
			$this->load->model('report/report_rekapitulasi_mediator_pernama','report');
			$data['view_lap'] = 'laporan/view_rekapitulasi_mediator_pernama';
			$data['perkara_nama'] = 'JUMLAH MEDIASI BERDASARKAN MEDIATOR';
		}elseif($type==9){
			$this->load->model('report/report_rekapitulasi_mediasi_pihak','report');
			$data['view_lap'] = 'laporan/view_rekapitulasi_mediasi_pihak';
			$data['perkara_nama'] = 'JUMLAH MEDIASI BERDASARKAN PIHAK';
		}
		
		$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
		if($jenis_pengadilan==1)
			$idalurperkara = 1;
		elseif ($jenis_pengadilan==4)
			$idalurperkara = 15;
		else
			$idalurperkara = 1;
		$data['idalurperkara'] = $idalurperkara;
		
		$data['rekap'] = $this->report->get_rekap($idalurperkara,$tahun);
		$data['tahun'] = $tahun;
		
		
		
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
		}
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}

	function view_laporan_perkara(){
		$idalurperkara = $this->nativesession->get_flash_session('idalurperkara');
		$tahun = $this->nativesession->get_flash_session('tahun');
		$bulan = $this->nativesession->get_flash_session('month');
		$tahapan = $this->nativesession->get_flash_session('tahapan');
		$lap_agama = $this->nativesession->get_flash_session('lap_agama');
		if($tahapan==10 && $lap_agama==1){
			$this->load->model('report/report_lipa1','report');
			$data['view_lap'] = 'laporan/view_laporan_lipa1';
			$data['perkara_nama'] = 'LAPORAN KEADAAN PERKARA';
		}elseif($tahapan==20 && $lap_agama==2){
			$this->load->model('report/report_lipa2','report');
			$data['view_lap'] = 'laporan/view_laporan_lipa2';
			$data['perkara_nama'] = 'LAPORAN PERKARA YANG DIMOHONKAN BANDING';
		}elseif($tahapan==30 && $lap_agama==3){
			$this->load->model('report/report_lipa3','report');
			$data['view_lap'] = 'laporan/view_laporan_lipa3';
			$data['perkara_nama'] = 'LAPORAN PERKARA YANG DIMOHONKAN KASASI';
		}elseif($tahapan==40 && $lap_agama==4){
			$this->load->model('report/report_lipa4','report');
			$data['view_lap'] = 'laporan/view_laporan_lipa4';
			$data['perkara_nama'] = 'LAPORAN PERKARA YANG DIMOHONKAN PENINJAUAN KEMBALI';
		}elseif($tahapan==50 && $lap_agama==5){
			$this->load->model('report/report_lipa5','report');
			$data['view_lap'] = 'laporan/view_laporan_lipa5';
			$data['perkara_nama'] = 'LAPORAN PERKARA YANG DIMOHONKAN EKSEKUSI ';
		}elseif($tahapan==10 && $lap_agama==6){
			$this->load->model('report/report_lipa6','report');
			$data['view_lap'] = 'laporan/view_laporan_lipa6';
			$data['perkara_nama'] = 'LAPORAN KEGIATAN HAKIM';
		}elseif($tahapan==10 && $lap_agama==7){
			$this->load->model('report/report_lipa8','report');
			$data['view_lap'] = 'laporan/view_laporan_lipa8';
			$data['perkara_nama'] = 'LAPORAN PERKARA DITERIMA, DICABUT DAN DIPUTUS MENURUT JENIS PERKARA  ';
		}elseif($tahapan==10 && $lap_agama==8){
			$this->load->model('report/report_lipa9','report');
			$data['view_lap'] = 'laporan/view_laporan_lipa9';
			$data['perkara_nama'] = 'LAPORAN PERKARA KHUSUS PP. NO.10 TAHUN 1983 JO. PP. NO.45 TAHUN 1990';
		}elseif($tahapan==10 && $lap_agama==9){
			$this->load->model('report/report_lipa10','report');
			$data['view_lap'] = 'laporan/view_laporan_lipa10';
			$data['perkara_nama'] = 'LAPORAN PENYEBAB TERJADINYA PERCERAIAN';
		}elseif($tahapan==10 && $lap_agama==10){
			$this->load->model('report/report_lipa12','report');
			$data['view_lap'] = 'laporan/view_laporan_lipa12';
			$data['perkara_nama'] = 'LAPORAN MEDIASI';	
		}elseif($tahapan==10 && $lap_agama==11){
			$this->load->model('report/report_lipa13','report');
			$data['view_lap'] = 'laporan/view_laporan_lipa13';
			$data['perkara_nama'] = 'LAPORAN PENERBITAN AKTA CERAI';
		}elseif($tahapan==10 && $lap_agama==13){
			$this->load->model('report/report_lipa15','report');
			$data['view_lap'] = 'laporan/view_laporan_lipa15';
			$data['perkara_nama'] = 'LAPORAN PELAKSANAAN PEMBEBASAN BIAYA PERKARA';
		}elseif($tahapan==10 && $lap_agama==15){
			$this->load->model('report/report_lipa17','report');
			$data['view_lap'] = 'laporan/view_laporan_lipa17';
			$data['perkara_nama'] = 'LAPORAN PENERIMAAN HAK-HAK KEPANITERAAN (HHK)';
		}elseif($tahapan==10 && $lap_agama==16){
			$this->load->model('report/report_lipa18','report');
			$data['view_lap'] = 'laporan/view_laporan_lipa18';
			$data['perkara_nama'] = 'LAPORAN PENERIMAAN HAK-HAK KEPANITERAAN LAINNYA (HHKL)';	
		}elseif($tahapan==10 && $lap_agama==17){
			$this->load->model('report/report_lipa19','report');
			$data['view_lap'] = 'laporan/view_laporan_lipa19';
			$data['perkara_nama'] = 'LAPORAN MINUTASI PERKARA';
		}elseif($tahapan==10 && $lap_agama==18){
			$this->load->model('report/report_lipa20','report');
			$data['view_lap'] = 'laporan/view_laporan_lipa20';
			$data['perkara_nama'] = 'LAPORAN TINGKAT PENYELESAIAN PERKARA';
		}elseif($tahapan==10 && $lap_agama==19){
			$this->load->model('report/report_lipa21','report');
			$data['view_lap'] = 'laporan/view_laporan_lipa21';
			$data['perkara_nama'] = 'LAPORAN VERZET TERHADAP PUTUSAN VERSTEK';
		}



		if($tahapan>=10 AND ($idalurperkara=='1,2' OR $idalurperkara=='3,4')){
			$data['perkara_nama'] ='PERDATA';
		}elseif($tahapan>=10 AND ($idalurperkara=='111,112,113,114')){
			$data['perkara_nama'] ='PIDANA';
		}
		$data['tahun'] = $tahun;
		$data['bulan'] = $bulan;
		$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
		if($jenis_pengadilan==1)
			$idalurperkara = 1;
		elseif ($jenis_pengadilan==4)
			$idalurperkara = 15;
		else
			$idalurperkara = 1;
		$data['idalurperkara'] = $idalurperkara;
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
		}

		$query = $this->report->get_info_ketua();
		foreach ($query->result() as $row) {
			if($row->id == 64){
				if(!empty($row->value)){
					$data['ketua'] = $row->value;
				}
			}
		}

		$query = $this->report->get_info_nipketua();
		foreach ($query->result() as $row) {
			if($row->id == 65){
				if(!empty($row->value)){
					$data['nipketua'] = $row->value;
				}
			}
		}

		$query = $this->report->get_info_panses();
		foreach ($query->result() as $row) {
			if($row->id == 68){
				if(!empty($row->value)){
					$data['panses'] = $row->value;
				}
			}
		}

		$query = $this->report->get_info_nippanses();
		foreach ($query->result() as $row) {
			if($row->id == 69){
				if(!empty($row->value)){
					$data['nippanses'] = $row->value;
				}
			}
		}


		$bln = ($bulan<10)? '0'.$bulan:$bulan;
		$data['bulanmed']=($bulan<10)? '0'.$bulan:$bulan;
		$period = $tahun.'-'.$bln;
		$data['laporan'] = $this->report->get_lap_perkara($period,$idalurperkara);
		if($lap_agama==8)
			$data['data_tambahan'] = $this->report->get_rekap_izin_cerai($period);
		//$data['stat'] = $this->report->get_stat_perkara($period,$idalurperkara);
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}


	function detil_mediator_thn(){
		$idalurperkara = $this->nativesession->get_flash_session('idalur');
		$tahun = $this->nativesession->get_flash_session('tahun');
		$type = $this->nativesession->get_flash_session('type');
		$tahapan = $this->nativesession->get_flash_session('tahapan');
		
		$segment = $this->uri->segment_array();
		$data['idmediator'] = $this->encrypt->decode(base64_decode($segment[3]));
		$data['tahun'] = $this->encrypt->decode(base64_decode($segment[4]));
		$data['idalurperkara'] = $this->encrypt->decode(base64_decode($segment[5]));
		$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
		if($jenis_pengadilan==1)
			$idalurperkara = 1;
		elseif ($jenis_pengadilan==4)
			$idalurperkara = 15;
		else
			$idalurperkara = 1;
		$data['idalurperkara'] = $idalurperkara;
		$data['nama_mediator'] = $this->encrypt->decode(base64_decode($segment[6]));

		$this->load->model('report/report_rekapitulasi_mediator_detil','report');
		$data['view_lap'] = 'laporan/view_rekapitulasi_mediator_detil';
		$data['perkara_nama'] = 'REKAPITULASI MEDIASI DETIL MEDIATOR';

		$data['rekap'] = $this->report->get_rekap($data['idmediator'],$data['idalurperkara'],$data['tahun']);
		//$data['tahun'] = $tahun;
		
		//$data['idalurperkara'] = $idalurperkara;
		
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
		}
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}

	function detil_mediator_bln(){
		$idalurperkara = $this->nativesession->get_flash_session('idalur');
		$tahun = $this->nativesession->get_flash_session('tahun');
		$type = $this->nativesession->get_flash_session('type');
		$tahapan = $this->nativesession->get_flash_session('tahapan');
		
		$segment = $this->uri->segment_array();
		$data['idmediator'] = $this->encrypt->decode(base64_decode($segment[3]));	
		$data['idalurperkara'] = $this->encrypt->decode(base64_decode($segment[5]));
		$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
		if($jenis_pengadilan==1)
			$idalurperkara = 1;
		elseif ($jenis_pengadilan==4)
			$idalurperkara = 15;
		else
			$idalurperkara = 1;
		$data['idalurperkara'] = $idalurperkara;
		$data['tahun'] = $this->encrypt->decode(base64_decode($segment[4]));
		$data['bulan'] = $this->encrypt->decode(base64_decode($segment[6]));
		$data['nama_mediator'] = $this->encrypt->decode(base64_decode($segment[7]));
		$periode=$data['tahun'].'-'.$data['bulan'];

		$this->load->model('report/report_rekapitulasi_mediator_detil_bln','report');
		$data['view_lap'] = 'laporan/view_rekapitulasi_mediator_detil_bln';
		$data['perkara_nama'] = 'REKAPITULASI MEDIASI DETIL MEDIATOR';

		$data['rekap'] = $this->report->get_rekap($data['idmediator'],$data['idalurperkara'],$periode);
		//$data['tahun'] = $tahun;
		
		//$data['idalurperkara'] = $idalurperkara;
		
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
		}
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}

}