<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Users_list extends CI_Controller {
	function index(){
		if($this->session->userdata('is_logged_in')===FALSE){					
			redirect('login');
		}

		if($this->authorization->isAuthorized('users_list',$this->nativesession->get('AuthorizationForm'))==FALSE){
			redirect('login');
		}
		
		if ($this->session->userdata('idgroup')){
			if($this->session->userdata('idgroup')>2){
				show_404();
			}else{
				$functions = $this->nativesession->get_flash_session('function');
				if($functions == 'sort'){
					$col = $this->nativesession->get_flash_session('col');
					$keyword = $this->nativesession->get_flash_session('keyword');
					$this->sort($col,$keyword);
				}elseif($functions == 'page'){
					$page = $this->nativesession->get_flash_session('page');
					$keyword = $this->nativesession->get_flash_session('keyword');
					$column_sorted = $this->nativesession->get_flash_session('col');
					$this->showData($keyword,$column_sorted,$page);
				}elseif($functions == 'search'){
					$keyword ='';
					$keyword = $this->nativesession->get_flash_session('keyword');
					$this->session->set_userdata('keyword',$keyword);
					$page = $this->nativesession->get_flash_session('page');
					$this->session->set_userdata('total_rows',-1);
					$this->showData($keyword);
				}else{
					$this->session->set_userdata('asc_desc','ASC');
					$this->session->set_userdata('total_rows',-1);
					$this->showData();
				}
			}
		}else{
			show_404();
		}
	}

	function search(){
		if ($this->session->userdata('idgroup')){
			if($this->session->userdata('idgroup')>2){
				show_404();
			}else{
				$this->session->set_userdata('total_rows',-1);
				$keyword = $this->input->post('search',TRUE);
				if(!empty($keyword)){
					$this->nativesession->set_flash_session('keyword', $keyword);
				}
				$this->showData($keyword);
			}
		}else{
			show_404();
		}
	}

	function sort($col=null,$keyword=null){
		if($this->session->userdata('asc_desc')){
			if($this->session->userdata('asc_desc')=="ASC"){
				$this->session->set_userdata('asc_desc','DESC');
			}else{
				$this->session->set_userdata('asc_desc','ASC');
			}
		}else{
			$this->session->set_userdata('asc_desc','ASC');
		}
		$this->showData($keyword,$col);
	}

	function showData($keyword='',$col='',$start_page=0){
		$segment = $this->uri->segment_array();
		if($this->nativesession->is_flash_session('keyword') AND empty($keyword)){
			$keyword = $this->nativesession->get_flash_session('keyword');
		}
			
		$asc_desc = $this->session->userdata('asc_desc');
		$this->load->model('users/users');
		if($start_page>0){
			$begin_limit = ($start_page-1)*50;
		}else{
			$begin_limit = 0;
			$start_page = $col;
		}
		$query = $this->users->get_user_list($col,$asc_desc,$begin_limit,$keyword);
		$data['users_list'] = $query;

		if($this->session->userdata('total_rows')){
			if($this->session->userdata('total_rows')==-1){
				$data['total_rows'] = $this->users->fecth_data_num();
				$this->session->set_userdata('total_rows',$data['total_rows']);
			}else{
				$data['total_rows'] = $this->session->userdata('total_rows');
			}
		}else{
			$data['total_rows'] = $this->users->fecth_data_num();
			$this->session->set_userdata('total_rows',$data['total_rows']);
		}
		
		$data['page_active'] = $begin_limit;
		$data['page_title'] = 'DAFTAR USER ';
		
		$data['main_body'] = 'users/users_list';
		$data['enc'] = "";
		
		$data['page_number'] = $start_page;
		$data['page_url'] = 'users_list';
		$data['keyword'] = $keyword;
		$data['column_sorted'] = $col;
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body');
	}
}

?>