<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Update_delegasi extends CI_Controller {
	function index(){
		#the user should only access the page through menu
		if($this->session->userdata('is_logged_in')===FALSE){
			redirect('login');
		}
		$this->show_data();
	}

	function show_data(){
		$idalur=$this->encrypt->decode(base64_decode($this->nativesession->get_flash_session('idalur'),TRUE));
		$iddelegasi=$this->encrypt->decode(base64_decode($this->nativesession->get_flash_session('encDelegasi'),TRUE));
		$idpnasal=$this->encrypt->decode(base64_decode($this->nativesession->get_flash_session('idpnasal'),TRUE));
		$idpntujuan=$this->encrypt->decode(base64_decode($this->nativesession->get_flash_session('idpntujuan'),TRUE));
		$edit=$this->nativesession->get_flash_session('command');

		$this->load->model('perkara/delegasi','delegasi');
		$idpt='';
		$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
		$data['delegasi_detil'] = $this->delegasi->get_detil_delegasi($idalur,$iddelegasi,$idpnasal,$idpntujuan);
		$data['delegasi_proses'] = $this->delegasi->get_detil_proses($idalur,$iddelegasi,$idpnasal,$idpntujuan);
		$data['data_jurusita'] = $this->delegasi->getDataJurusita($idalur,$iddelegasi,$idpnasal,$idpntujuan);
		$data['list_pt'] = $this->delegasi->get_list_pt('',$jenis_pengadilan);
		$data['list_pn'] = $this->delegasi->get_list_pn($idpt);
		$data['jenis_delegasi'] = $this->delegasi->getJenisDelegasi();
		$data['data_pn_asal']=$this->delegasi->identitasPN();
		
			if ($data['delegasi_detil']->num_rows>=1) {
				foreach ($data['delegasi_detil']->result() as $row) {
						$data['delegasi_id']=$row->id;	
						$data['perkara_id']=$row->perkara_id;
						$data['p_perkara_id']=$row->perkara_id;
						$data['nomor_perkara']=$row->nomor_perkara;
						$data['pihak']=$row->pihak;
						$data['id_pn_asal']=$row->id_pn_asal;
						$data['kode_satker_asal']=$row->kode_satker_asal;
						$data['pn_asal_text']=$row->pn_asal_text;
						$data['id_pn_tujuan']=$row->id_pn_tujuan;
						$data['kode_satker_tujuan']=$row->kode_satker_tujuan;
						$data['pn_tujuan_text']=$row->pn_tujuan_text;
						$data['tgl_delegasi']=$this->tanggalhelper->convertDayDate($row->tgl_delegasi);
						$data['id_jenis_delegasi']=$row->id_jenis_delegasi;
						$data['jenis_delegasi_text']=$row->jenis_delegasi_text;
						$data['tgl_surat']=$this->tanggalhelper->convertDayDate($row->tgl_surat);
						$data['tgl_pengiriman']=$this->tanggalhelper->convertDayDate($row->tgl_pengiriman);
						$data['nomor_surat']=$row->nomor_surat;
						$data['namadokumen']=$row->namadokumen;
						$data['document']=$row->document;
						$data['document_size']=$row->document_size;
						$data['document_mime']=$row->document_mime;
						$data['tgl_sidang']=$this->tanggalhelper->convertDayDate($row->tgl_sidang);
						$data['tgl_resi']=$this->tanggalhelper->convertDayDate($row->tgl_resi);
						$data['nomor_resi']=$row->nomor_resi;
						$data['biaya']=$row->biaya;
						$data['catatan']=$row->catatan;
				}
			}else{
						$data['delegasi_id']='';
						$data['perkara_id']='';
						$data['nomor_perkara']='';
						$data['pihak']='';
						$data['id_pn_asal']='';
						$data['kode_satker_asal']='';
						$data['pn_asal_text']='';
						$data['id_pn_tujuan']='';
						$data['kode_satker_tujuan']='';
						$data['pn_tujuan_text']='';
						$data['tgl_delegasi']='';
						$data['id_jenis_delegasi']='';
						$data['jenis_delegasi_text']='';
						$data['tgl_sidang']='';
						$data['tgl_surat']='';
						$data['tgl_pengiriman']='';
						$data['nomor_surat']='';
						$data['namadokumen']='';
						$data['document']='';
						$data['document_size']='';
						$data['document_mime']='';
						$data['tgl_resi']='';
						$data['nomor_resi']='';
						$data['biaya']='';
						$data['catatan']='';
			}
			if ($data['delegasi_proses']->num_rows>=1) {
				foreach ($data['delegasi_proses']->result() as $row) {
						$data['p_delegasi_id']=$row->delegasi_id;
						$data['p_tgl_surat_diterima']=$this->tanggalhelper->convertToInputDate($row->tgl_surat_diterima);
						
						$data['p_jurusita_id']=$row->jurusita_id;
						$data['p_tgl_penunjukan_jurusita']=$this->tanggalhelper->convertDayDate($row->tgl_penunjukan_jurusita);
						$data['p_jurusita_nama']=$row->jurusita_nama;
						$data['p_id_pn_asal']=$row->id_pn_asal;
						$data['p_pn_asal_text']=$row->pn_asal_text;
						$data['p_kode_satker_asal']=$row->kode_satker_asal;
						$data['p_id_pn_tujuan']=$row->id_pn_tujuan;
						$data['p_pn_tujuan_text']=$row->pn_tujuan_text;
						$data['p_kode_satker_tujuan']=$row->kode_satker_tujuan;
						$data['p_tgl_relaas']=$this->tanggalhelper->convertToInputDate($row->tgl_relaas);
						$data['p_nomor_relaas']=$row->nomor_relaas;
						$data['p_tgl_pengiriman_relaas']=$this->tanggalhelper->convertToInputDate($row->tgl_pengiriman_relaas);
						$data['p_nomor_surat_pengantar_relaas']=$row->nomor_surat_pengantar_relaas;
						$data['p_id_status_delegasi']=$row->id_status_delegasi;
						$data['p_status_delegasi']=$row->status_delegasi;
						$data['p_namadokumen']=$row->namadokumen;
						$data['p_document']=$row->document;
						$data['p_document_size']=$row->document_size;
						$data['p_document_mime']=$row->document_mime;
						$data['p_tgl_resi']=$this->tanggalhelper->convertToInputDate($row->tgl_resi);
						$data['p_nomor_resi']=$row->nomor_resi;
						$data['p_biaya']=$row->biaya;
						$data['p_catatan']=$row->catatan;
					}
			}else{
						$data['p_delegasi_id']='';
						$data['p_tgl_surat_diterima']='';
						$data['p_perkara_id']='';
						$data['p_jurusita_id']='';
						$data['p_tgl_penunjukan_jurusita']='';
						$data['p_jurusita_nama']='';
						$data['p_id_pn_asal']='';
						$data['p_pn_asal_text']='';
						$data['p_kode_satker_asal']='';
						$data['p_id_pn_tujuan']='';
						$data['p_pn_tujuan_text']='';
						$data['p_kode_satker_tujuan']='';
						$data['p_tgl_relaas']='';
						$data['p_nomor_relaas']='';
						$data['p_tgl_pengiriman_relaas']='';
						$data['p_nomor_surat_pengantar_relaas']='';
						$data['p_id_status_delegasi']='';
						$data['p_status_delegasi']='';
						$data['p_namadokumen']='';
						$data['p_document']='';
						$data['p_document_size']='';
						$data['p_document_mime']='';
						$data['p_tgl_resi']='';
						$data['p_nomor_resi']='';
						$data['p_biaya']='';
						$data['p_catatan']='';
			}
	
		$data['page_title'] = "PELAKSANAAN DELEGASI MASUK";
		$data['judul']="Proses";
		$data['main_body'] = 'delegasi/update_pelaksanaan';	

		$data['jenis_pengadilan'] = $this->session->userdata('jenis_pengadilan');

		$data['history'] = $this->nativesession->get_flash_session('main_url_requested');
		$data['iddelegasi']=$iddelegasi;
		$data['idalur']=$idalur;
		$data['idpnasal']=$idpnasal;
		$data['idpntujuan']=$idpntujuan;
		$data['edit']=$edit;
		
		$data['statusDelegasi']=array('Telah Dilaksanakan','Tidak dapat dilaksanakan');
		$data['diterimaOleh']=array('Langsung','Tidak Langsung');
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}


	//============================================================

	function fetchData(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Page'));
			return;
		}

		$nomor_perkara=trim($this->input->post('val',TRUE));
		
		if(empty($nomor_perkara)){
			echo json_encode(array('st'=>0,'msg'=>'Nomor Perkara Masih Kosong.'));
			return;
		}

		$this->load->model('perkara/delegasi','delegasi_masuk');
		$dataPerkara = $this->delegasi_masuk->fetchData($nomor_perkara);

		if($dataPerkara->num_rows>0){
			foreach ($dataPerkara->result() as $row) {
				$perkara_id = $row->perkara_id;
				$jenis_perkara_nama= $row->jenis_perkara_nama;
			}

			echo json_encode(array(
			'st'=>1,
			'enc'=>base64_encode($this->encrypt->encode($perkara_id)),
			'perkara_nama'=>$jenis_perkara_nama,
			'msg'=>'Perkara Ditemukan.'
			));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
	}

	function simpanproses(){
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$user=$this->session->userdata('fullname');
		$this->form_validation->set_rules('nomor_relaas', 'Nomor Relaas', 'required');
		$this->form_validation->set_rules('tgl_relaas', 'Tanggal Pengiriman Kembali', 'required');
		$this->form_validation->set_rules('p_tgl_resi', 'Tanggal Resi Pengiriman', 'trim|xss_clean|required');
		$this->form_validation->set_rules('id_status_delegasi_txt', 'Status Delegasi', 'trim|xss_clean|required');
		$this->form_validation->set_rules('biaya', 'biaya', 'trim|xss_clean');
		$this->form_validation->set_rules('nomor_resi', 'nomor_resi', 'trim|xss_clean');

		$edit=$this->input->post('edit',TRUE);

		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil'.validation_errors()));
		return;
		}

		$this->load->model('perkara/delegasi','delegasi');


		//$biaya = str_replace('.','',$this->input->post('biaya',TRUE));
		$biaya = str_replace(',','',$this->input->post('biaya',TRUE));
		if (intval($biaya)==0) {
			$biaya=0;
		}
		$catatan=$this->input->post('catatan_proses',TRUE);
		$id_delegasi=$this->input->post('delegasi_id',TRUE);
		$jurusita_id=$this->input->post('id_jurusita_txt',TRUE);
		$id_pn_asal=$this->input->post('id_pn_asal_txt',TRUE);
		$id_pn_tujuan=$this->input->post('id_pn_tujuan_txt',TRUE);
		$nomor_relaas=$this->input->post('nomor_relaas',TRUE);
		$nomor_resi=$this->input->post('nomor_resi',TRUE);
		$nomor_surat_pengantar_relaas=$this->input->post('nomor_surat_pengantar_relaas',TRUE);
		$jurusita_nama=$this->input->post('jurusita_nama_txt',TRUE);
		$id_status_delegasi=$this->input->post('id_status_delegasi_txt',TRUE);
		$status_delegasi=$this->input->post('status_delegasi_txt',TRUE);
		$tgl_pengiriman_relaas=$this->input->post('tgl_pengiriman_relaas',TRUE);
		$tgl_relaas=$this->input->post('tgl_relaas',TRUE);
		$tgl_resi=$this->input->post('p_tgl_resi',TRUE);
		$tgl_surat_diterima=$this->input->post('tgl_surat_diterima',TRUE);
		$id_perkara=$this->input->post('perkara_id',TRUE);
		
		$identitasPNTujuan= $this->delegasi->getDataPN($id_pn_tujuan);
		foreach ($identitasPNTujuan->result() as $row) {
			$kode_satker_tujuan=$row->kode;
			$pn_tujuan_txt=$row->nama;
		}
		$identitasPNAsal= $this->delegasi->getDataPN($id_pn_asal);
		foreach ($identitasPNAsal->result() as $row) {
			$kode_satker_asal=$row->kode;
			$pn_asal_txt=$row->nama;
		}
		$datainsert = array(
				'tgl_surat_diterima'=>$this->tanggalhelper->convertToMysqlDate($tgl_surat_diterima),
				'perkara_id'=>$id_perkara,
				'jurusita_id'=>$jurusita_id,
				'jurusita_nama'=>$jurusita_nama,
				'id_pn_asal'=>$id_pn_asal,
				'pn_asal_text'=>$pn_asal_txt,
				'kode_satker_asal'=>$kode_satker_asal,
				'id_pn_tujuan'=>$id_pn_tujuan,
				'pn_tujuan_text'=>$pn_tujuan_txt,
				'kode_satker_tujuan'=>$kode_satker_tujuan,
				'tgl_relaas'=>$this->tanggalhelper->convertToMysqlDate($tgl_relaas),
				'nomor_relaas'=>$nomor_relaas,
				'tgl_pengiriman_relaas'=>$this->tanggalhelper->convertToMysqlDate($tgl_pengiriman_relaas),
				'nomor_surat_pengantar_relaas'=>$nomor_surat_pengantar_relaas,
				'id_status_delegasi'=>$id_status_delegasi,
				'status_delegasi'=>$status_delegasi,
				'diinput_oleh'=>$user,
				'diinput_tanggal'=>date('Y-m-d'),
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time()),
				'catatan'=>$catatan,
				'tgl_resi'=>$this->tanggalhelper->convertToMysqlDate($tgl_resi),
				'biaya'=>$biaya,
				'nomor_resi'=>$nomor_resi);


			$this->delegasi->update_delegasi_proses(TRUE,$id_delegasi,$id_pn_asal,$id_pn_tujuan,$datainsert);
			
			if($this->delegasi->update_delegasi_proses(TRUE,$id_delegasi,$id_pn_asal,$id_pn_tujuan,$datainsert)){
			 	echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan!'));
			 	return;
			 }else{
			 	echo json_encode(array('st'=>0,'msg'=>'Data Tidak Berhasil Disimpan !!'));
			 	return;
			}
	}


	function simpanFileproses(){
			$this->load->model('perkara/delegasi','delegasi');
			$edit="edit";
			$id_delegasi=$this->input->post('delegasi_id',TRUE);
			$id_pn_asal=$this->input->post('id_pn_asal_txt',TRUE);
			$id_pn_tujuan=$this->input->post('id_pn_tujuan_txt',TRUE);

			
	
			$config['allowed_types'] = 'gif|jpg|png|blob|pdf';
			$filename=$_FILES['filedokumen']['name'];
			$mime=$_FILES['filedokumen']['type'];
			$size=$_FILES['filedokumen']['size'];		
			$datafile=file_get_contents($_FILES['filedokumen']['tmp_name']);

			$datainsert=array(
							'namadokumen'=>$filename,
							'document'=>$datafile,
							'document_size'=>$size,
							'document_mime'=>$mime
							);
			
			$this->delegasi->update_delegasi_proses($edit,$id_delegasi,$id_pn_asal,$id_pn_tujuan,$datainsert);
	}

	function downloadFile(){
			$segment = $this->uri->segment_array();
			$idalur=$this->encrypt->decode(base64_decode($segment[3]));
			$iddelegasi=$this->encrypt->decode(base64_decode($segment[4]));
			$idpnasal=$this->encrypt->decode(base64_decode($segment[5]));
			$idpntujuan=$this->encrypt->decode(base64_decode($segment[6]));

			$this->load->model('perkara/delegasi','delegasi');
			$datautama = $this->delegasi->get_detil_delegasi($idalur,$iddelegasi,$idpnasal,$idpntujuan);
			$datafile=$datautama->result();
				$data['filename']=$datafile[0]->namadokumen;
				$data['content']=$datafile[0]->document;
		       	$data['type']=$datafile[0]->document_mime;
		       	$data['size']=$datafile[0]->document_size;
	       	
	       	$this->output->set_header('Content-type: '.$data['type']);
			$this->output->set_output($data['content']);
			
	       	//$this->load->vars($data);
			//$this->load->view('delegasi/downloadfile',$data,FALSE);
	}
	

	function downloadFileProses(){
			$segment = $this->uri->segment_array();
			$idalur=$this->encrypt->decode(base64_decode($segment[3]));
			$iddelegasi=$this->encrypt->decode(base64_decode($segment[4]));
			$idpnasal=$this->encrypt->decode(base64_decode($segment[5]));
			$idpntujuan=$this->encrypt->decode(base64_decode($segment[6]));

			$this->load->model('perkara/delegasi','delegasi');
			$datautama = $this->delegasi->get_detil_proses($idalur,$iddelegasi,$idpnasal,$idpntujuan);

			$datafile=$datautama->result();
				$data['filename']=$datafile[0]->namadokumen;
				$data['content']=$datafile[0]->document;
		       	$data['type']=$datafile[0]->document_mime;
		       	$data['size']=$datafile[0]->document_size;
	       	
	       	$this->output->set_header('Content-type: '.$data['type']);
			$this->output->set_output($data['content']);
			
	       	//$this->load->vars($data);
			//$this->load->view('delegasi/downloadfile',$data,FALSE);
	}

	function validateDelete(){
		if(empty($_POST)){
			show_404();
		}
		
		$iddelegasi=$this->encrypt->decode(base64_decode($this->input->post('delegasi_id',TRUE)));
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$this->load->model('perkara/delegasi','delegasi');
			$delData = $this->delegasi->del_data($iddelegasi);
		if($delData==TRUE){
			echo json_encode(array('st'=>1,'msg'=>'Data delegasi keluar berhasil dihapus.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Something Bad Happen. Error Code = 189.'));
			return;
		}
	}

	function popup_penunjukan_jurusita() {
		$this->load->model('perkara/delegasi','delegasi');
		$segment = $this->uri->segment_array();
		if 	($segment[3]!=''){
			$data['idalur']=$segment[3];
		}else {
			$data['idalur']=$this->encrypt->decode(base64_decode($this->nativesession->get_flash_session('idalur'),TRUE));
		}
		
		$data['iddelegasi']=$segment[4];
		$data['idpnasal']=$segment[5];
		$data['idpntujuan']=$segment[6];

		if (count($segment)<=6){
			$judul="Penunjukan";
			$data['edit']=0;
		}else{
			$data['edit']=$segment[7];
    		$judul="Edit Penunjukan";
		}
    	$data['delegasi_proses']=$this->delegasi->get_detil_proses($data['idalur'],$segment[4],$segment[5],$segment[6]);

		foreach ($data['delegasi_proses']->result() as $row) {
			$data['p_jurusita_id']=$row->jurusita_id;
			$data['p_tgl_penunjukan_jurusita']=$this->tanggalhelper->convertToInputDate($row->tgl_penunjukan_jurusita);
			$data['p_jurusita_nama']=$row->jurusita_nama;
		}


		$data['judul']=$judul;
		$data['data_jurusita'] = $this->delegasi->getDataJurusita();
		$this->load->view('delegasi/edit_jurusita',$data);
	}


	function simpan_jurusita(){
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$user=$this->session->userdata('fullname');

		$this->form_validation->set_rules('id_jurusita_txt', 'Jurusita', 'trim|xss_clean|required');
		$this->form_validation->set_rules('jurusita_nama_txt', 'Jurusita', 'trim|xss_clean|required');

		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil'.validation_errors()));
		return;
		}

		$this->load->model('perkara/delegasi','delegasi');
		$edit=$this->input->post('edit',TRUE);
		
		$id_delegasi=$this->input->post('iddelegasi',TRUE);
		$id_pn_asal=$this->input->post('idpnasal',TRUE);
		$id_pn_tujuan=$this->input->post('idpntujuan',TRUE);
		$jurusita_id=$this->input->post('id_jurusita_txt',TRUE);
		$jurusita_nama=$this->input->post('jurusita_nama_txt',TRUE);
		$tgl_jurusita=$this->input->post('tgl_jurusita',TRUE);

		$dataPerkara = $this->delegasi->get_detil_delegasi('1',$id_delegasi,$id_pn_asal,$id_pn_tujuan);
		foreach ($dataPerkara->result() as $key => $valdetil) {
			$$key=$valdetil;
		}
		foreach ($valdetil as $key => $val){
				$$key=$val;	
		}
		$id_perkara=$perkara_id;
		if ($edit==TRUE) {
		$datainsert = array(
				'perkara_id'=>$id_perkara,
				'jurusita_id'=>$jurusita_id,
				'tgl_penunjukan_jurusita'=>$this->tanggalhelper->convertToMysqlDate($tgl_jurusita),
				'jurusita_nama'=>$jurusita_nama,
				'id_pn_asal'=>$id_pn_asal,
				'id_pn_tujuan'=>$id_pn_tujuan);
		}else{
		$datainsert = array(
				'delegasi_id'=>$id_delegasi,
				'perkara_id'=>$id_perkara,
				'jurusita_id'=>$jurusita_id,
				'tgl_penunjukan_jurusita'=>$this->tanggalhelper->convertToMysqlDate($tgl_jurusita),
				'jurusita_nama'=>$jurusita_nama,
				'id_pn_asal'=>$id_pn_asal,
				'id_pn_tujuan'=>$id_pn_tujuan);
		}

			if($this->delegasi->update_delegasi_proses($edit,$id_delegasi,$id_pn_asal,$id_pn_tujuan,$datainsert)){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan!'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Data Tidak Berhasil Disimpan !!'));
				return;
			}
	}


}